//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Simple object to draw some ceneterd text
//----------------------------------------------------------------------------
// Constructor
centerd_text_object::centerd_text_object (const char* tex)
   :text_object(tex)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
   set_w(text_length(font,(unsigned char*)text)/2);
   set_h(text_height(font));
   }
//----------------------------------------------------------------------------
// Destructor
centerd_text_object::~centerd_text_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Draw the bitmap maybe
void centerd_text_object::msg_draw (void)
	{
   int fg = color ? color->fore() : degui_fore_color;
   if(disabled()==true) fg = color ? color->disable() : degui_disable_color;
   text_mode(color ? color->back() : degui_back_color);
   degui_textout(screen, (unsigned char*)text, x(), y(), fg, TRUE);
   _redraw = false;
	}

//----------------------------------------------------------------------------

