//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for the hidden list object
//----------------------------------------------------------------------------
// Draw the marker to mark a hidden list object
// This shoule be used in conjunction with the _draw_edittext_object function
void _draw_hidden_list_marker (const int x, const int y, const int w, const int h,
                               const int disabled, const int has_focus,
                               const int fore,
                               const int mid,
                               const int deselect,
                               const int disable,
                               const int light_shad, const int dark_shad)
   {
   int y1 = y + (h/2) - text_height(font)/2 - 2;
   int y2 = y1 + text_height(font) + 5;

   int f = mid;
   if(has_focus) f = fore;
   if(disabled) f = disable;

   // Draw the frame on the screen
   draw_3d_frame(screen,x,y1,x+w,y2,deselect,dark_shad,light_shad);

   // Put the cute little marker
   vline(screen,x+w/2,y1+2,y2-2,f);
   vline(screen,x+w/2+1,y1+2,y2-2,f);
   }
//----------------------------------------------------------------------------

