//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include <stdio.h>
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for drawing a progress bar
//----------------------------------------------------------------------------
void _draw_progressbar (const int x, const int y, const int w, const int h,
                        const int drawtext,
                        const float progress,
                        const float scale,
                        const int disabled,
                        const int fore,
                        const int select,
                        const int deselect,
                        const int disable,
                        const int light_shad, const int dark_shad)
   {
   char text[50];
   BITMAP *buffer = NULL;
   int f = fore;

   if(disabled) f = disable;

   // Create a double buffering bitmap
   buffer = create_bitmap(w+1,h+1);
   if(buffer==NULL) return;

   // Draw background
   draw_3d_frame(buffer,0,0,w,h,deselect,dark_shad,light_shad);

   // Draw the bar
   draw_3d_frame(buffer,2,2,2+((w-4)*progress)/scale,h-2,select,light_shad,dark_shad);

   // Draw the text
   if(drawtext)
      {
      sprintf(text,"%.0f%%",(progress/scale)*100.);
      text_mode(-1);
      degui_textout(buffer,text,w/2,1+(h/2)-text_height(font)/2,f,TRUE);
      }

   // Show the buffer
   blit(buffer,screen,0,0,x,y,w+1,h+1);

   // Free up stuff
   destroy_bitmap(buffer);
   }
//----------------------------------------------------------------------------

