//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for drawing a scrollbar
//----------------------------------------------------------------------------
void _draw_scrollbar (const int x, const int y, const int w, const int h,
                      const int listsize,
                      const int offset,
                      const int height,
                      const int has_focus,
                      const int mid, const int back,
                      const int deselect,
                      const int light_shad, const int dark_shad)
   {
   int barcolor, topshade, botshade;
   int scrolltop, scrollbot;

   draw_3d_frame(screen,x,y,x+w,y+h,-1,dark_shad,light_shad);

   rectfill(screen,x+1,y+1,x+w-1,y+h-1,deselect);

   scrolltop = y+2;
   if(offset>0) scrolltop += (((h-4) * offset) + listsize/2) / listsize;
   scrollbot = scrolltop + ((h-4) * height + listsize/2) / listsize;
   if(scrollbot>(y+h-2)) scrollbot = y+h-2;

   barcolor = mid;
   topshade = light_shad;
   botshade = dark_shad;

   if(!has_focus)
      {
      barcolor = back;
      topshade = dark_shad;
      botshade = light_shad;
      }
   draw_3d_frame(screen,x+2,scrolltop,x+w-2,scrollbot,barcolor,topshade,botshade);
   }
//----------------------------------------------------------------------------

