//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Object is a window that can contain other objects
//----------------------------------------------------------------------------
// Constructor
window_object::window_object (const char *t, const int n)
   :dialog(n),
   text(t)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
	set_w(100);
   set_h(100);
   }
//----------------------------------------------------------------------------
// Destructor
window_object::~window_object (void)
   {
   }
//----------------------------------------------------------------------------
// General manipulation functions
//----------------------------------------------------------------------------
// Add an object to the dialog
void window_object::add (dialog_object &obj, const int x, const int y, const int w, const int h)
   {
   dialog::add(obj,x,y,w,h);
   obj._window = this;

   // Make sure we are big enough
   ensure_containment();
	}
//----------------------------------------------------------------------------
void window_object::add (dialog &dia)
   {
   dialog::add(dia);
   dia._window = this;
	}
//----------------------------------------------------------------------------
// Remove an object to the dialog
void window_object::remove (dialog_object &obj)
   {
   dialog::remove(obj);
   obj._window = NULL;
   }
//----------------------------------------------------------------------------
// Remove another dialog from us
void window_object::remove (dialog &dia)
   {
   dialog::remove(dia);
   dia._window = NULL;
   }
//----------------------------------------------------------------------------
// Force the objects to fit into the window
void window_object::ensure_containment (void)
   {
   // Make sure that the objects are contained in the window
   int minx = MAXINT;
   int maxx = -MAXINT;
   int miny = MAXINT;
   int maxy = -MAXINT;
   find_extrema(0,number,minx,miny,maxx,maxy);

   // Possibly adjust sizes
   if(x()>minx) set_x(minx);
   if(y()>miny) set_y(miny);
   if(x2()<maxx) set_w(maxx-x());
   if(y2()<maxy) set_h(maxy-y());
   }
//----------------------------------------------------------------------------
// Basic message passing functions
//----------------------------------------------------------------------------
// Draw the screen clear
void window_object::msg_draw (void)
   {
   // Draw the background
   show_mouse(NULL);
   draw_3d_frame(screen,
                 x(),y(),x2(),y2(),
                 color ? color->back() : degui_back_color,
                 color ? color->light_shad() : degui_light_shad_color,
                 color ? color->dark_shad() : degui_dark_shad_color);

   // Find the proper text colors
   if(text!=NULL)
      {
      int fg = color ? color->fore() : degui_fore_color;
      int bg = color ? color->deselect() : degui_deselect_color;

      if(selected()==true) bg = color ? color->select() : degui_select_color;
      if(disabled()==true) fg = color ? color->disable() : degui_disable_color;

      // Put up the text
      rectfill(screen,x()+1,y()+1,x2()-1,y()+1+text_height(font),bg);
      text_mode(-1);
      textout_centre(screen,font,(unsigned char*)text,x()+w()/2,y()+1,fg);
      show_mouse(screen);

      // Put up interior objects
      if(number>0) dialog_message(MSG_DRAW,0);
      }

   dialog_object::_redraw = false;
   }
//----------------------------------------------------------------------------
// Move the objects and it's sub-objects
void window_object::msg_click (void)
   {
   int last_mousex = mouse_x;
   int last_mousey = mouse_y;

   // While the button is down
   while(mouse_b)
      {
      // Check if it has moved
      if((mouse_x!=last_mousex)||(mouse_y!=last_mousey))
         {
         int diffx = mouse_x - last_mousex;
         int diffy = mouse_y - last_mousey;

         // Move the object
         set_x(x()+diffx);
         set_y(y()+diffy);

         // Move the sub-objects
         for(int i=0;i<number;i++)
            {
            dialog_object* obj = (dialog_object*)_dialog[i].dp;

            if(obj!=NULL)
               {
               // Put back the sub objects original position
               obj->set_x(obj->x()+diffx);
               obj->set_y(obj->y()+diffy);
               }
            }
         last_mousex = mouse_x;
         last_mousey = mouse_y;

         parent()->redraw(true);
         }
      }
   }
//----------------------------------------------------------------------------

