// This is the stuff for Half-Life
#ifndef HLMDL_H
#define HLMDL_H

#ifdef __cplusplus
extern "C" {
#endif


#define TYPE_MODEL		0
#define TYPE_SKIN			1
#define TYPE_SCRIPT		2
//#define TYPE_UNKNOWN		3
#define MAX_TEXTURES		100
#define MAX_VERT        30      // maximum vertices in every polygon
#define MAX_POLY			400     // mais vale mais que menos (isto tem que depois sair)


//#define XTEX_CONV			512
//#define YTEX_CONV			512


typedef struct
{
	long id;             // 0x49445354 (IDST) or 0x49445354 (IDSQ)
   long version;        // 0x0A
   char path[64];       // path name
   long filesize;       // size of the MDL file
   char origin[3];      // origin, scale or something ?

   char nhac;
   long t[15];

   // this block is always zero for skin files
   long numchunks;      // number of chunks
   long chunkstart;     // position in the file where the chunk headers begin (always 0xF4)
   long option1;        // 0, 1 or 2
   long startblank;
   long opt1;
   long startblank2;
   long opt2;
   long startidle;      // position in the file where the "idle" block begins ???
   long opt3;
   long startdefault;   // position in the file where the "default" block begins ???

   // sometimes this block is zero for models (then there must exist a skin file "T")
   long numskins;       // number of skins in file
   long skinheaderstart;// position in the file where the skin headers begin
   long skinstart;      // position in the file where the skins begin
   long numskins2;      // number of effective skins ???
   long skindiff;       // if(numskins!=0) skindiff = numskins - numskins2 + 1;
   long skinheaderend;  // position in the file where the skin headers end

   // this block is always zero for skin files
   long t12;            // this is important stuff, but what is it?
   long canstart;       // position in the file where the can begins
   long option2;        // 0, 1, 2, 3 or 4
   long t2;
   long zero[5];        // these are always 0
   long t3;

} hheader_t __attribute__ ((packed));


typedef struct
{
   char name[32];       // name of a chunk ???
   long f0[8];          // this is almost allways the same FFFFFFFF 00000000 FFF...
   long t[12];


} hchunk_t __attribute__ ((packed));


// skin header
typedef struct
{
	char bitmapname[64];
   long zero;           // zero (3 if skinwidth=skinheight=64)
   long skinwidth;      // width of the bitmap (trocar o width e o height ???)
   long skinheight;     // height of the bitmap
   long skinpos;        // start of the bitmap in the file

} hskinheader_t __attribute__ ((packed));

typedef struct
{
	char name[32];       // this is "idle"
	long t1,t2,t3,t4,t5;
   long startdefault;   // the position of the "default" block (again)
   long option1;
   long t6;
   long startdefault2;  // the position of the "default" block (and again)
   long tmp1[13];
   long option2;
   long t7;
   long tmp2[12];

} hidle_t __attribute__ ((packed));

typedef struct
{
	char name[32];       // this is "default" but is it 32 ???
	long t1[18];
   char str[32];        // is this 32 ???
   long t2[8];
   long op1;
   long op2;
   long startnext;      // position of next thingy

} hdefault_t __attribute__ ((packed));


typedef struct
{
	char name[32];       // name of template (32 or 64) ???
   long t1[10];
   long numpolyblocks;  // number of blocks of polygons (number of hpolyheader_t to read)
   long startpolyheader;// position of the header os the poly header list
   long numverts;       // number of 3D points ???
   long startnext;      // position of next thingy
   long start3next;     // position of third next thingy
   long num2;
   long start2next;     // position of second next thingy
   long start4next;     // position of forth next thingy
   long t2, t3;

} htemplate_t __attribute__ ((packed));

typedef struct
{
	long size1;
   long startpoly;      // start of poly list ???
   long zero1;
   long size2;
   long zero2;

} hpolyheader_t __attribute__ ((packed));


// a polygon vertex
typedef struct
{
	short pos;           // index of the 3D position of this polygon vertice
   short index;         // index of this polygon ???
   short u;             // u texture coord
   short v;             // v texture coord

} hpolyvert_t __attribute__ ((packed));



typedef struct
{
   short num;           // number of vertex in the poly
	hpolyvert_t vs[MAX_VERT];      // vertex poly (this should be dynamic)
   long texidx;         // index of the texture bitmap

} hpoly_t;


typedef struct
{
	long vertex[3];              // Index of 3 triangle vertices
   long u[3];                   // texture coordenates of each vertice
   long v[3];                   //
   long tex;                    // texture index for this triangle

} htriangle_t;


typedef struct
{
	hheader_t header;    // header of the mdl file
   hchunk_t *chunk;     // chunks
	hskinheader_t *skinh;// skin header list
	hidle_t idle;        // idle block
   hdefault_t def;      // default block
   htemplate_t temp;    // template block
	hpolyheader_t *polyh;// poly header
   hpoly_t *poly;       // polygon list



	V3D_f *pos;          // list of 3d points
   V3D_f *rpos;         // list of rotated 3d points
   unsigned char *skin[MAX_TEXTURES]; // skin list (size is [numskin][skinwidth*skinheight])
   PALETTE skinpal[MAX_TEXTURES];     // palettes for each skin
   unsigned char type;  // model, skin or script
   htriangle_t *trigs;  // all the triangles are treated as equals
   long *trigorder;     // order to draw the triangles
   float *dist2;        // distance to average of triangle
   char *drawtrig;      // decide if the triangle is front or back


   // allegro specific stuff
   BITMAP *textures[MAX_TEXTURES];

   // patch
   long numtrigs;
	long numpolys;

} hlmdl_t;




#ifdef __cplusplus
}
#endif

#endif HLMDL_H
