// Minor changes by Dim Zegebart (zager@post.comstar.ru) to run with Palantir
// This file is part of Palantir v0.5
// Patched by Sergey Kirpa


/* ASM code for the lwp package.  This is where the nitty gritty shtuff is */
/****************************************************************************
*  Copyright (C) 1997 Paolo De Marino
*
*  Original code by Sengan Short (sengan.short@durham.ac.uk) and Josh Turpen
*  (snarfy@goodnet.com).
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version,
*  with the only exception that all the people in the THANKS file must
*  receive credit.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; see the file COPYING.LIB.
*  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
*  Cambridge, MA 02139, USA.
*
*  For contacting the author send electronic mail to
*     paolodemarino@usa.net
*
*  Or paper mail to
*
*     Paolo De Marino
*     Via Donizetti 1/E
*     80127 Naples
*     Italy
*
*  History: see history.txt
****************************************************************************/
.globl __lwp_pm_old_handler
;//.globl __lwp_pm_irq8_timer_hook
;//.globl __lwp_pm_irq0_timer_hook
.globl __hw_count
.globl __lwpasm_start
.globl __lwpasm_end
.globl _lwp_yield
.globl __lwp_scheduler
.globl _lwp_thread_enable
.globl _lwp_thread_disable
.globl __init_fpu
.globl __lwp_pcount
tmp1: .long 0
tmp2: .long 0
tmp3: .long 0
.globl tmp1
.globl tmp2
.globl tmp3

.align 4
.text

__lwpasm_start:

;// __lwp_pm_old_handler: .long 0,0    ;/* __dpmi_paddr */
/* DZ
 ;//DZ we never need IRQ8 handler, since SIGILL raised in Allegro's
;//timer handler
__lwp_pm_irq8_timer_hook:
        pushl %eax
        pushl %ds
        .byte 0x2E   ;// CS:
        movw ___djgpp_ds_alias, %ds

        cmp $0, __lwp_interrupt_pending
        jne L2

        movl $1, __lwp_interrupt_pending

        cmp $0, __lwp_enable
        jne  L1

        movb $0x99,%al
        call ___djgpp_hw_exception
        jmp L2

L1:     movl $0, __lwp_interrupt_pending

L2:
*/
/*
movb $0x0C, %al
        outb %al, $0x70
        inb  $0x71, %al  ;// ACK int in RTC
        movb $0x20, %al
        outb %al, $0xa0 ;// ACK int in slave int controller
        outb %al, $0x20 ;// ACK int in master int controller
        popl %ds
        popl %eax
        sti
        iret
*/
/*
#if 0

;// We remove the ACK section, as we'll chain to the old handlers
        movb $0x0C, %al
        outb %al, $0x70
        inb  $0x71, %al  ;// ACK int in RTC
        movb $0x20, %al
        outb %al, $0xa0 ;// ACK int in slave int controller
        outb %al, $0x20 ;// ACK int in master int controller

        popl %ds
        popl %eax
        sti
        iret  ;// Should CHAIN!
#else
                  popl %ds
                  popl %eax
                  ljmp %cs:__lwp_pm_old_handler
#endif
*/

/* DZ
__lwp_pm_irq0_timer_hook:
        pushl %eax
        pushl %ds

        .byte 0x2E  ;// CS:/
        movw ___djgpp_ds_alias, %ds
        cmp $0, __lwp_interrupt_pending
        jne L4

        movl $1, __lwp_interrupt_pending
        cmp $0, __lwp_enable
        jne  L3

        movb $0x99,%al
        call ___djgpp_hw_exception
        jmp L4

L3:     movl $0, __lwp_interrupt_pending
L4:
#if 0
                  movl $0x20, %eax
        outb %eax, $0x20

        popl %ds
        popl %eax
        sti
        iret
#else
                  popl %ds
                  popl %eax
                  ljmp %cs:__lwp_pm_old_handler
#endif
*/

.align 4

__lwp_scheduler:
        movl  ___djgpp_exception_state_ptr, %edi
        cmpl $0, %edi
        je raised    ;// SIGILL was raise()'d, not by interrupt

;//     From lwp 2.0
        cmpl $0x99, 56(%edi) ; ;// our exception or real exception?
        jne raised
;// End from lwp 2.0

;//     get reg values from __djgpp_exception_state
        movl 0(%edi), %eax
        pushl %eax
        movl 4(%edi), %ebx
        movl 8(%edi), %ecx
        movl 12(%edi), %edx
        movl 16(%edi), %esi
        movl 24(%edi), %ebp
        movl 28(%edi), %eax
        movl %eax, tmp1       ;// esp
        movl 32(%edi), %eax
        movl %eax, tmp2       ;// eip
        movl 36(%edi), %eax
        movl %eax, tmp3       ;// eflags

        movl 20(%edi), %eax   ;// edi

        movw 44(%edi), %es
        movw 46(%edi), %fs
        movw 48(%edi), %gs
        movw 42(%edi), %ds ;// From this line, referencing ds is deadly
                           ;// dangerous

        movl %eax, %edi    ;// Here di is placed

        popl %eax          ;// Get eax from the first load
        .byte 0x2e
        movl tmp1, %esp    ;// stack switched to exception state stack
        .byte 0x2e
        pushl tmp2         ;// push exeception state ret address

;//now it's setup to look just like a yield happened in the code

        pushal
        pushl %ds ;// Save segment registers
        pushl %es
        pushl %fs
        pushl %gs

        .byte 0x2e ;//NEW
        movw ___djgpp_ds_alias,%ds ;//NEW

        .byte 0x2e
        pushl tmp3   ;// eflags

        incl __lwp_hw_count ;//DZ
        decl __lwp_pcount       ;// Decrement priority counter
        cmp $0,__lwp_pcount     ;// If > 0
        ja P1                   ;// Skip this section

        subl $108, %esp
        fwait
        fnsave (%esp) ;// FPU pushal ;)
;//        fwait         No need to wait for completion!

        movl __lwp_cur, %esi
        movl %esp, 12(%esi)

        call _lwp_findnext

        movl __lwp_cur, %esi

        movl 12(%esi), %esp

        cli
        fwait
        frstor (%esp) ;//FPU popal ;)
;//        fwait            No need to wait for completion!
        addl $108, %esp

        popl %eax
        andb $0xfe, %ah   ;// mask off debug flag
        pushl %eax

P1:     popfl
        popl %gs  ;// Restore segment registers
        popl %fs
        popl %es
        popl %ds

        fwait  ;// We must wait HERE!
        sti
        popal
raised:
                  pushl %ds
        .byte 0x2E  ;// CS:
        movw ___djgpp_ds_alias, %ds
        movl $0, __lwp_interrupt_pending
        popl %ds
        ret


/*
 * _lwp_yield is imperative! It doesn't care about priorities: if a threads
 * asks for it, it must be IMMEDIATELY performed.
*/
/*
.align 4
_lwp_yield:
;//        pushl %ds                                        ;//JT
;//        .byte 0x2e                                       ;//JT
;//        movw ___djgpp_ds_alias, %ds                      ;//JT

        movl $1, __lwp_interrupt_pending
;//        popl %ds                                          ;//JT

        pushal
        pushl %ds     ;// Save segment registers
        pushl %es
        pushl %fs
        pushl %gs
        pushfl

;//        fwait  - No need to fwait here, can multiprocess!

;//        .byte 0x2e                                    ;//JT
;//        movw ___djgpp_ds_alias, %ds                   ;//JT
        movl __lwp_cur, %esi

//        fwait
//        fnsave 20(%esi)  ;// DZ fpu_pushal ;)
//        finit

        movl %esp, 12(%esi)
        call _lwp_findnext
        movl __lwp_cur, %esi ;//goto next thread
        movl 12(%esi), %esp

//        fwait
//        frstor 20(%esi) ;// DZ fpu_popal

        popl %eax
        andb $0xfe, %ah   ;// mask off debug flag before poping
        pushl %eax        ;// the flags

        cli
        popfl
        popl %gs          ;// Restore segment registers
        popl %fs
        popl %es
        popl %ds
        popal
        sti

;//        pushl %ds
;//        .byte 0x2E  ;// CS:
;//        movw ___djgpp_ds_alias, %ds
        movl $0, __lwp_interrupt_pending
;//        popl %ds
        ret
*/

.align 4
_lwp_yield:
        pushl %ds                     ; //JT
        .byte 0x2e                    ; //JT
        movw ___djgpp_ds_alias, %ds   ; //JT
        movl $1, __lwp_interrupt_pending
       movl $0, __lwp_enable         ; //SK

        popl %ds                      ;//JT

        pushal
        pushl %ds    ;// Save segment registers
        pushl %es
        pushl %fs
        pushl %gs
        pushfl

        subl $108, %esp
        fwait
        fnsave (%esp)   ;// FPU pushal ;)
;//        fwait  - No need to fwait here, can multiprocess!

        .byte 0x2e                             ;//JT
        movw ___djgpp_ds_alias, %ds            ;//JT
        movl __lwp_cur, %esi
        movl %esp, 12(%esi)

        call _lwp_findnext
        movl __lwp_cur, %esi

        movl 12(%esi), %esp

        cli
        fwait
        frstor (%esp)   ;//FPU popal ;)
        addl $108, %esp

        popl %eax
        andb $0xfe, %ah   ;// mask off debug flag before poping
        pushl %eax        ;// the flags
        popfl

        popl %gs          ;//Restore segment registers
        popl %fs
        popl %es
        popl %ds

        fwait             ;//Here we must wait for the coprocessor
        sti

        popal
                  pushl %ds
        .byte 0x2E  ;// CS:
        movw ___djgpp_ds_alias, %ds
        movl $0, __lwp_interrupt_pending
        popl %ds

        ret

__init_fpu:
        pushl %eax
        movl $__fpu_init_state, %eax
        finit
        fwait
        fnsave (%eax)
        popl %eax   ;/* HERE we MUST fwait - we don't know what the stack */
        fwait       ;/* will do! */
        ret

_lwp_thread_enable:     movl $0, __lwp_enable
                        ret
_lwp_thread_disable:    movl $1, __lwp_enable
                        ret
__lwpasm_end:
