#include "textpage.h"
#include <assert.h>
#include <iostream.h>
#include <conio.h>
#include "keyboard.h"

text_page::text_page() {
   set_fill_char( DEFAULT_PAGE_CHAR, DEFAULT_PAGE_COLOUR );
   _cursor.x = _cursor.y = 0;
   move_to( 0, 0 );
   }

text_page::text_page( const text_page & model ) {
   operator=( model );
   }

text_page::text_page( const char * file_name ) {
   set_fill_char( DEFAULT_PAGE_CHAR, DEFAULT_PAGE_COLOUR );
   read_file( file_name );
   _cursor.x = _cursor.y = 0;
   move_to( 0, 0 );
   }

text_page::text_page( const string_array & model ) {
   set_fill_char( DEFAULT_PAGE_CHAR, DEFAULT_PAGE_COLOUR );
   operator=( model );
   _cursor.x = _cursor.y = 0;
   move_to( 0, 0 );
   }

text_page & text_page::
operator=( const text_page & model )
{
   set_fill_char( model.character(), model.colour() );
   text = model.text;
   refresh_text();
   cursor_to( model.cursor().x, model.cursor().y );
   return *this;
}

text_page & text_page::
operator=( const string_array & model )
{
   text = model;
   refresh_text();
   return *this;
}


bool text_page::
read_file( const char * file_name )
{
   bool error = text.read_file( file_name );
   if( error )
      return true;

   rectangle::resize( text.width(), text.height() );

   if( _image )
      delete [] _image;
   _image = new screen_line[height()]( fill_char(), left(), 0 );

   int i = 0;
   while( i < height() ) {
      _image[i] = text[i];
      i++;
      }
   return false;
}

bool text_page::
write_file( const char * file_name )
{
   return text.write_file( file_name );
}

void text_page::
refresh_text()
{
   int copy_height = text.height();
   if( copy_height != height() )
      resize( copy_height );

   int y = 0;
   while( y < copy_height )
   {
      _image[y] = text[y];
      y++;
   }
   rectangle::resize( text.width(), height() );
}

void text_page::
refresh_line( int y )
{
   _image[y] = text[y];
}


void text_page::
cursor_to( int x, int y )
{
   x = bigger_of( x, 0 );
   y = bigger_of( y, 0 );
   y = smaller_of( y, height() - 1 );
   _cursor.x = x;
   _cursor.y = y;
}

void text_page::cursor_left( int amount ) {
   cursor_to( _cursor.x - amount, _cursor.y );
}
void text_page::cursor_right( int amount ) {
   cursor_to( _cursor.x + amount, _cursor.y );
}
void text_page::cursor_up( int amount ) {
   cursor_to( _cursor.x, _cursor.y - amount );
}
void text_page::cursor_down( int amount ) {
   cursor_to( _cursor.x, _cursor.y + amount );
}

void text_page::
insert_at( char character, int x, int y )
{
   if( y < 0 || y >= height() )
      return;

   text.insert_at( character, x, y );
   _image[y].insert_at( character, x );

   if( _image[y].length() > width() )
      rectangle::resize( _image[y].length(), height() );
}

void text_page::
delete_at( int x, int y )
{
   if( y < 0 || y >= height() )
      return;

   text.delete_at( x, y );
   _image[y].delete_at( x );
}

void text_page::
resize( int new_height )
{
   if( _image ) delete [] _image;
   _image = 0;

   if( new_height > 0 )
   {
      _image = new screen_line[new_height]( fill_char(), left(), 0 );
      rectangle::resize( text.width(), new_height );
   }
   else
      rectangle::resize( 0, 0 );
}


void text_page::
resize_and_keep( int new_height )
{
   if( new_height <= 0 )
   {
      if( _image )
      {
         delete [] _image;
         _image = 0;
      }
      rectangle::resize( 0, 0 );
      return;
   }
   screen_line * old_image = _image;
   int old_height = height();

   _image = new screen_line[new_height]
                                ( fill_char(), left(), 0 );

   rectangle::resize( text.width(), new_height );

   if( old_image )
   {
      int copy_height = smaller_of( new_height, old_height );
      int y = 0;
      while( y < copy_height )
      {
         _image[y] = old_image[y];
         y++;
      }
      delete [] old_image;
   }
}

void text_page::
insert_line( const char * new_line, int y )
{
   if( y < 0 || y > height() )
      y = height();

   resize_and_keep( height() + 1 );
   int line_number = height() - 1;
   while( line_number > y )
   {
      (*this)[line_number] = (*this)[line_number-1];
      line_number--;
   }
   (*this)[y] = new_line;
   text.insert_line_at( new_line, y );
}

void text_page::
delete_line( int y )
{
   if( y < 0 || y >= height() )
      return;

   text.delete_line_at( y );
   refresh_text();
}


