#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# TTILE.S: This file is part of the BETATRON library and can be used
#          and/or distributed only under the terms of the GNU Library
#          General Public License. See doc/readme.1st for details.
#




.extern _pl_a000h
.globl	_drawttile

#/*
#----------------------------------------------------------------------------
# extern "C" void drawttile(char *tile,unsigned char tilex,unsigned char tiley,unsigned short pageofs);
#
# drawttile =  draw thru tile
# 坜  椞 ⤘ tile,  妬  ᩜ 夘 1616
# tile:    填  ⤘ array[256] of byte
# tilex:    ⤞ ( 16ᛜ pixel) ᤠ  tile
# tiley:    ⤞ ....
# pageofs:  矬 ᡨ   video memory
#	    ᤠ  modex   㡦  352 pixel
#	   , 88 礩  video ram
#	    tile ਜ嫘   , 槦 ᨮ
#	   飘 0 夘 .
#----------------------------------------------------------------------------
#*/


.equ	    savedebp8 ,  0
.equ	    retadr8   ,  4
.equ	    tile8     ,  8
.equ	    tilex8    ,  12
.equ	    tiley8    ,  16
.equ	    pageofs8  ,  20


_drawttile:

	pushl	%ebp
	movl	%esp,%ebp

	pusha
	pushw %es
	mov _pl_a000h,%ax
	mov %ax,%es

	movl	tile8(%ebp),%esi     # //tile

	xorl	%edi,%edi

	movw	$352,%ax
	movb	tiley8(%ebp),%bl      # //tiley
	xorb	%bh,%bh
	mulw	%bx
	movb	tilex8(%ebp),%bl      # //tilex
	addw	%bx,%ax
	shlw	$2,%ax		      #  //ax = (tiley*16*22*16 + tilex*16) / 4

	movw	pageofs8(%ebp),%di    # //pageofs

	addw	%ax,%di 	# // o di  矬   tile  video ram

	movw	$0x03c4,%dx	# //sequencer controller  bitplane masking


	xorb	%cl,%cl 	# //proto bitplane

nextplane:

	movw	$16,%bx 	# // bx: , 16 grammes /tile

	movb	$0x02,%al	# // map mask register
	movb	$0x01,%ah	#
	shlb	%cl,%ah 	# // epelekse to katallilo bitplane
	outw	%ax,%dx

nextline:

	lodsb
	testb	%al,%al
	jz	dontplotit0
	movb	%al,%es:(%edi)
dontplotit0:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit1
	movb	%al,%es:(%edi)
dontplotit1:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit2
	movb	%al,%es:(%edi)
dontplotit2:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit3
	movb	%al,%es:(%edi)
dontplotit3:
	incw	%di

	addw	$84,%di #//  di 室  棜 

	decw	%bx
	jnz	nextline

	subw	$16*88,%di	# // o di na ksanadeiksei sthn arxh toy tile

	incb	%cl
	cmpb	$4,%cl	# // ftasame sto 4o bitplane
	jne	nextplane      # // an oxi proxora sto epomeno

	popw	%es
	popa
	popl	%ebp

	ret

.END
