/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** LAYTILE.CC: This file is part of the BETATRON library and can be used
 **             and/or distributed only under the terms of the GNU Library
 **             General Public License. See doc/readme.1st for details.
 */



#include "world.h"
#include "plvga.h"
#include <string.h>

static char atile[256];

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

	short TOworld::setbackprior(unsigned char pno)
	{
	 if (pno>=PRIORITIESNO) return ERR_OUTOFRANGE;
	 backprior=pno;
	 if (foreprior<pno) foreprior=pno;
	 return ERR_NOERR;
	};


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

	short TOworld::setforeprior(unsigned char pno)
	{
	  if ((pno>=PRIORITIESNO) ) return ERR_OUTOFRANGE;
	  foreprior=pno;
	  if (pno<backprior) backprior=pno;
	  return ERR_NOERR;
	};


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------


void TOworld::tilestoRAW()
{
  char *tmp=atile;

  for (int i=0;i<tilesno;i++)
  {
    if (!Ptiles[i]) continue;
    pl_tile4planes2raw(Ptiles[i],tmp);// atile!=NULL,so it wont change
    memcpy(Ptiles[i],tmp,256);
  }

}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

void TOworld::tilesto4PLANES()
{
  char *tmp=atile;

  for (int i=0;i<tilesno;i++)
  {
    if (!Ptiles[i]) continue;
    pl_tilerawto4planes(Ptiles[i],tmp); // atile!=NULL,so it wont change
    memcpy(Ptiles[i],tmp,256);
  }

}


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

void TOworld::puttilexy(unsigned short layerid,unsigned short bx,unsigned short by,
		       unsigned short newvalue)
{
 long tx,ty;
 unsigned short oldvalue;
 unsigned short *lay;

 if (layerid>1) return;

 lay=layers[layerid]+by*length+bx;
 oldvalue = *lay; if (oldvalue==newvalue) return;
 *lay = newvalue;
 tx=bx;
 ty=by;

// elegkse an einai mesa sti thea
 if ( (tx>=wx) && (tx< wx+Xtiles) && (ty>=wy) && (ty<wy+Ytiles) )
 {
  tilechanged = 1; // exoume allagi sta tiles pou einai sto energo parathiro
  // to (wx0,wy0) antistoixei sto tilerefresh[1][1]

  tilerefresh[1+ty-wy0][1+tx-wx0]=1; // enimerose ton pinaka ananeosis gia tin allagi
 }
}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::setlayer(unsigned short layerid,unsigned short *newlayer)
{
  if (layerid>=LAYERSNO) return ERR_OUTOFRANGE;
  destroylayer(layerid);
  layers[layerid]=newlayer;
  return ERR_NOERR;
}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::setdimensions(unsigned short len0,unsigned short hei0)
{ int i;

  for (i=0;i<LAYERSNO;i++) if (internallays[i]) return ERR_LAYEREXISTS;
  if ( long(len0)*long(hei0)*sizeof(short) > MAXLAYERSIZE) return ERR_LAYERTOBIG;
  if ( (len0<Xtiles) || (hei0<Ytiles)) return ERR_TOOSMALLDIM; // poli mikres diastaseis
  length=len0;
  height=hei0;
  return ERR_NOERR;
}




//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::destroylayer(unsigned char layerid)
{
  if (layerid>=LAYERSNO) return ERR_OUTOFRANGE;
  if (!internallays[layerid]) return ERR_LAYERNOTMADE;
  free(layers[layerid]);
  internallays[layerid]=0;  // svistike o layer
  layers[layerid]=NULL;
  return ERR_NOERR;
}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::makelayer(unsigned char layerid)
{
 if (layerid>=LAYERSNO) return ERR_OUTOFRANGE;
 if (internallays[layerid]) return ERR_LAYERMADE;
 if ( !(layers[layerid]=(unsigned short * ) malloc(length*height*sizeof(short))) )
 return ERR_OUTOFMEM;
 internallays[layerid]=1;     // dimiourgithike o layer

 if (layerid==LAY_ATTR2)      // einai Pbackattr2 layer
  pl_memsetw(Pbackattr2,SURFBITSMASK,length*height);	   // arxikopoiise ton katallila
 else
 if (layerid==LAY_FORE)
  pl_memsetw(Pforelayer,0xffff,length*height);


 return ERR_NOERR;
};


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::maketiles(unsigned short tilesno0)
{
  if (Ptiles) return ERR_TILESMADE;
  if (!tilesno0) return ERR_ZEROMEMALLOC;
  if ( !(Ptiles=(char **) malloc(tilesno0*sizeof(char *))) )
   return ERR_OUTOFMEM;

  tilesno=tilesno0;
  for (int i=0;i<tilesno;i++) Ptiles[i]=NULL; // arxikopoiisi deikton
  return ERR_NOERR;
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
short TOworld::destroytiles()
{
  if (!Ptiles) return ERR_TILESNOTMADE;
  if (internaltilesloader) // ean esoterikos fortotis apodesmeuse ti mnimi
    for (int i=0;i<tilesno;i++) if (Ptiles[i]) free(Ptiles[i]);

  free(Ptiles);
  Ptiles=NULL;
  internaltilesloader=0;
  tilesno=0;
  return ERR_NOERR;
}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

char *TOworld::settile(unsigned short tileno0,char *tiledata)
{
 char *tmp;

 if (!Ptiles) return NULL;  // ERR_TILESNOTMADE
 if (tileno0>=tilesno) return NULL;  // ERR_OUTOFRANGE
 tmp=Ptiles[tileno0];
 Ptiles[tileno0]=tiledata;
 return tmp;
};

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void TOworld::undoll(FILE *f)	// undo load level
{
  fclose(f);
  for (int j=0;j<LAYERSNO;j++) destroylayer(j);

  internaltilesloader=1;
  destroytiles();

  internalsurfacesloader=1;
  destroysurfaces();
}


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

#define      LL_HEADERSIZE	   256

#define      LL_SIGNATURE	    0
#define      LL_FSIZE		    4
#define      LL_WLEN		    8
#define      LL_WHEI		   10
#define      LL_USERLAYSNO         28
#define      LL_TILESNO 	   88
#define      LL_TILEFORMAT	   90
#define      LL_TILEDATA	   92
#define      LL_SURFNO		   96
#define      LL_SURFDATA	   98
#define      LL_BACKDATA	   16
#define      LL_FOREDATA	   20
#define      LL_ATTRDATA           24
#define      LL_USERBASE           30
#define      LL_PALETTE 	   84



#undef	getfield
#define getfield( arr, pos, type)	 ( (type) ( *( (type *)((arr)+(pos)) )) )

short TOworld::loadlevel(char *filename)
{
 FILE *f;
 unsigned long fsize,computedsize;
 char signature[]={'W','D','D',26,0};
 unsigned short i,j;
 unsigned short length0,height0;
 static char header[LL_HEADERSIZE];
 long l;    // position in the file
 short usersno,err;
 short layerid;
 short surfsno;
 short sx,sy,sl;
 short *sdata;

 if ( (f=fopen(filename,"rb")) == NULL ) return ERR_FOPEN;

#define level_ret(val) { fclose(f);  return val; }

 // 暠  ⚜  妬
 fseek(f,0,SEEK_END);
 if ( (fsize=ftell(f)) == -1L) level_ret(ERR_FTELL);

 //   ⧜  夘 ᮠ 256 bytes
 //  ⚜ 驫  ⮜ in epikefalida.

 if (fsize<LL_HEADERSIZE) level_ret(ERR_INVFILEFORMAT);
 fseek(f,0,SEEK_SET);
 if ( fread(header,LL_HEADERSIZE,1,f)!=1 ) level_ret(ERR_FREAD);

 // 뢜    ⮜  ੫ .

 if ( strncmp(signature,&header[LL_SIGNATURE],4) ) level_ret(ERR_INVFILEFORMAT);
 if ( getfield(header,LL_FSIZE,long) != fsize) level_ret(ERR_INVFILEFORMAT);

 // ᙘ 㡦,篦  橣   tile  橣

#undef	level_ret
#define level_ret(val) { undoll(f); return val; }

 tilesno=getfield(header,LL_TILESNO,unsigned short);

 // ⩣ 㣞  ᙘ  tiles   
 if ( err=maketiles(tilesno) ) level_ret(err);

 if ( (l=getfield(header,LL_TILEDATA,long)) >= fsize) level_ret(ERR_INVFILEFORMAT);
 fseek(f,l,SEEK_SET);

 for (i=0;i<tilesno;i++)
 {
  if ( ! (Ptiles[i]= (char *) malloc(256)) ) level_ret(ERR_OUTOFMEM);
  if ( fread(Ptiles[i],256,1,f)!=1)  level_ret(ERR_OUTOFMEM);
 }

 tileformat=getfield(header,LL_TILEFORMAT,short);
 internaltilesloader=1;

 // ⩣ 㣞   3 layers  ᙘ  圪.
 for (i=0;i<LAYERSNO;i++) destroylayer(i);

 length0=getfield(header,LL_WLEN,unsigned short);
 height0=getfield(header,LL_WHEI,unsigned short);

 setdimensions(length0,height0);
 if ( err=makelayer(LAY_BACK) ) level_ret(err);
 if ( err=makelayer(LAY_FORE) ) level_ret(err);

 if ( (l=getfield(header,LL_BACKDATA,long)) >= fsize) level_ret(ERR_INVFILEFORMAT);
 fseek(f,l,SEEK_SET);

 if ( fread(Pbacklayer,height*length*2,1,f)!=1) level_ret(ERR_FREAD);

 if ( (l=getfield(header,LL_FOREDATA,long)) >= fsize) level_ret(ERR_INVFILEFORMAT);
 fseek(f,l,SEEK_SET);

 if ( fread(Pforelayer,height*length*2,1,f)!=1) level_ret(ERR_FREAD);

 if ( (l=getfield(header,LL_ATTRDATA,long)) >= fsize) level_ret(ERR_INVFILEFORMAT);
 if (l!=0)
 {
   if ( err=makelayer(LAY_ATTR) ) level_ret(err);
   fseek(f,l,SEEK_SET);
   if ( fread(Pbackattr,height*length*2,1,f)!=1) level_ret(ERR_FREAD);
 }


//--------------------------

// etoimasou na diavaseis olous tous attribute layers
 usersno=getfield(header,LL_USERLAYSNO,short);
 for (i=0;i<usersno;i++)
 {
   layerid=getfield(header,LL_USERBASE+i*6, short);
   if (layerid <= 3 || layerid >= LAYERSNO) level_ret(ERR_INVFILEFORMAT);
   if ( err=makelayer(layerid) ) level_ret(err);

   l=getfield(header,LL_USERBASE+i*6+2,long);
   if (l >= fsize) level_ret(ERR_INVFILEFORMAT);
   fseek(f,l,SEEK_SET);

   if ( fread(layers[layerid],height*length*2,1,f)!=1) level_ret(ERR_FREAD);
 }

//-------------------------
 l=getfield(header,LL_PALETTE,long);
 if (l>0)   // is there any palette data
 {
   if ( l >= fsize) level_ret(ERR_INVFILEFORMAT);
   fseek(f,l,SEEK_SET);
   if (fread(palette,768,1,f)!=1) level_ret(ERR_FREAD);
 }
//-------------------------

// leipoun ta surfaces pros to paron

 surfsno=getfield(header,LL_SURFNO,short);
 if (surfsno)  // there are surfaces
 if (Pbacklayer)
 {
   if ( err=makelayer(LAY_ATTR2) ) level_ret(err);

   l=getfield(header,LL_SURFDATA,long);
   if (l+4 >= fsize) level_ret(ERR_INVFILEFORMAT);
   fseek(f,l+4,SEEK_SET);
   if ( err=makesurfaces(surfsno)) level_ret(err);

   for (i=0;i<surfacesno;i++)
   {
     if (fread(&sx,2,1,f)!=1) level_ret(ERR_FREAD);
     if (fread(&sy,2,1,f)!=1) level_ret(ERR_FREAD);
     if (fread(&sl,2,1,f)!=1) level_ret(ERR_FREAD);
     if ( !(sdata=(short *)malloc(sl*sizeof(short))) ) level_ret(ERR_OUTOFMEM);
     if (fread(sdata,sl*sizeof(short),1,f)!=1) level_ret(ERR_FREAD);
     setsurface(i,(unsigned short *)sdata,sl,sx,sy);
   }

  internalsurfacesloader=1;
 }

 fclose(f);
 return ERR_NOERR;
};



