/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** guyele.h:   This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */

#ifndef _guyele_h
#define _guyele_h

struct TOguy:public TOsprite
{
    // checks if the guy is on an elevator
   char elevatorcheck(unsigned short x1,unsigned short x2,
                      unsigned short x1,unsigned short x2,char eleon);

   void incy(char dy0) { y+=dy0;}     
   char onelevator;                 // TRUE if the guy is on an elevator
   unsigned short savedbase;        // the framebase, TOguy expects 18
                                    // sprite frames starting from framebase

   TPaction nextaction2;            // action pointer for the chained call
                                    // (see action guygeneral() )

   void init(unsigned char id0,unsigned short x0,unsigned short y0,
             unsigned short framebase0);
};



// the (vertical) elevator class
struct TOele:public TOsprite
   {
      TOguy *pguy;		 // a pointer to our guy
      char onelevator;		 // TRUE if the guy is on this elevator
      unsigned short uplimit;
      unsigned short downlimit;  // y-coordinates that specify the limits
				 // in which the elevator moves.

   void init(unsigned char id0,unsigned short x0,
             unsigned short y0, signed short framenow0,
             signed char dy0, TOguy *pguy0,
             unsigned short uplimit0,
             unsigned short downlimit0);
};



#endif
