/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** DEFINES.H: This file is part of the BETATRON library and can be used
 **            and/or distributed only under the terms of the GNU Library
 **            General Public License. See doc/readme.1st for details.
 */


#ifndef pl_defines_h
#define pl_defines_h

#define ERRORSTRINGSNO              38

// always x must be a negative number
#define ERRSTRING(x) pl_errorstrings[ ( (-(x))>ERRORSTRINGSNO?ERRORSTRINGSNO:(-(x)) )]

// If x<0 prints the error code x and exits
#define  CHECK(x)  { long ___err; if ((___err=(x))<0) { printf("ERR: %d, line %d, check '",___err,__LINE__); printf(#x); printf("'\nERR: '%s'\n",ERRSTRING(___err)); exit(1);}}


#define swaplongs(a,b)\
{  long ____w;	____w=(a); (a)=(b); (b)=____w; }


// these values represent the scrolling limit in each direction
// in powers of 2 and can take the values  2,3,4. Currently they are
// set to 4 which mean 16 pixels/frame scrolling limit in each direction
// A lower limit means lower overhead when a new part of the world has to
// be drawn due to scrolling.
#define SCROLLCOLLEN2                      4
#define SCROLLROWHEI2                      4
#define SCROLLCOLLEN                       (1<<SCROLLCOLLEN2)
#define SCROLLROWHEI                       (1<<SCROLLROWHEI2)


#define SURFBITSNO                          9
#define SURFBITSMASK                     ( (1<<SURFBITSNO)-1 )

#define PRIORITIESNO			  15
#define LISTSNO                           15

#define VIS_FULL                         0xf0
#define VIS_INVISIBLE			 0x0f
#define VIS_PARTIAL 			 0xff

#define MAXLAYERSIZE			 1000000L


#define DRFR_SRAW		 0
#define DRFR_S4PLANES            1
#define DRFR_TRAW		 2
#define DRFR_RLE		 3

#define DR_SOLID	  1
#define DR_THRU 	  0
#define DR_RLE		  2

#define FR_RAW		  0
#define FR_4PLANES	  1
#define FR_RLE		  2




#define ERR_NOERR                         0
#define ERR_FOPEN                        -1
#define ERR_INVFILEFORMAT		 -2
#define ERR_LAYERTOBIG			 -3
#define ERR_OUTOFMEM			 -4
#define ERR_LAYERMADE                    -5
#define ERR_LAYERNOTMADE                 -6
#define ERR_TILESMADE			 -7
#define ERR_TILESNOTMADE		 -8
#define ERR_OUTOFRANGE			 -9
#define ERR_FTELL                        -10
#define ERR_FREAD                        -11
#define ERR_BITMAPSNOTMADE		 -12
#define ERR_BITMAPSMADE 		 -13
#define ERR_DESCRSMADE			 -14
#define ERR_DESCRSNOTMADE		 -15
#define ERR_NULLDESCR			 -16
#define ERR_SUBBITMAPRANGE		 -17
#define ERR_NOTNULLDESCR		 -18
#define ERR_TOOSMALLDIM 		 -19
#define ERR_ZEROMEMALLOC		 -20
#define ERR_NULLOBJ 			 -21
#define ERR_NULLBITMAP			 -22
#define ERR_BITMAPNOTFIT		 -23
#define ERR_LAYEREXISTS                  -24
#define ERR_NULLTILE                     -25
#define ERR_SURFACESNOTMADE              -26
#define ERR_SURFACESMADE                 -27
#define ERR_ZEROSIZE                     -28
#define ERR_VESANOTINIT                  -29
#define ERR_VESANOTVALIDMODE             -30
#define ERR_VESACALL                     -31
#define ERR_VESANOTVER2                  -32
#define ERR_VESANOTENOUGHMEM             -33
#define ERR_VESANOTLINEAR                -34
#define ERR_DPMICALL                     -35
#define ERR_VESASETMODE                  -36
#define ERR_MODENOTAVAIL                 -37



#define LAY_BACK				 0
#define LAY_FORE				 1
#define LAY_ATTR				 2
#define LAY_ATTR2				 3


#define Pbacklayer				 layers[LAY_BACK]
#define Pforelayer				 layers[LAY_FORE]
#define Pbackattr				 layers[LAY_ATTR]
#define Pbackattr2				 layers[LAY_ATTR2]

#define LAYERSNO                        6
#define MAXGRIDSNO                      6


#define  MACROcmplace(x11,y11,x12,y12,	x21,y21,x22,y22, res) \
		   if ( (x11) >x21) x21= (x11);\
		   if ( (y11) >y21) y21= (y11);\
		   if ( (x12) <x22) x22= (x12);\
		   if ( (y12) <y22) y22= (y12);\
		   res=( (x21<=x22) && (y21<=y22) )

//	res2: 1: the second box is totally inside the first
//		  0: otherwise

#define MACROcmplace2(x11,y11,x12,y12,	x21,y21,x22,y22, res,res2)\
		   (res2)=1;\
		   if ( (x11) >x21) { x21= (x11); (res2)=0; };\
		   if ( (y11) >y21) { y21= (y11); (res2)=0; };\
		   if ( (x12) <x22) { x22= (x12); (res2)=0; };\
		   if ( (y12) <y22) { y22= (y12); (res2)=0; };\
		   res=( (x21<=x22) && (y21<=y22) )


#endif
