/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** WINLINE.H: This file is part of the BETATRON library and can be used
 **            and/or distributed only under the terms of the GNU Library
 **            General Public License. See doc/readme.1st for details.
 */


#ifndef world_inline_h
#define world_inline_h


	short TOworld::scrollR(signed char dx)
	{
		if (curmode==gmMODEX320x200) return scrollRmx(dx);
		return scrollRvesa(dx);
	}

	short TOworld::scrollD(signed char dy)
	{
		if (curmode==gmMODEX320x200) return scrollDmx(dy);
		return scrollDvesa(dy);
	}



	void TOworld::zerotimer()
	{
		hitimerpart=lotimerpart=oldtimerticks=timerticks=0;
		dticks=0;
	}



	void TOworld::rgbset(unsigned char i,unsigned char r,unsigned char g,unsigned char b)
	{ char *t=&palette[i*3]; t[0]=r; t[1]=g; t[2]=b; palettechanged=1; }


        void TOworld::M2Vthru(char *data,unsigned short vx, unsigned short vy,
			  unsigned short cliplen,unsigned short cliphei,
			  unsigned short startx, unsigned short starty,
			  unsigned short totallen)
	{
		 M2Vthruproc(data,showofs, x-(wx<<4)+vx, y-(wy<<4)+vy,
					 cliplen,cliphei,startx,starty,totallen);


	}

        void TOworld::M2Vsolid(char *data,unsigned short vx, unsigned short vy,
			   unsigned short cliplen,unsigned short cliphei,
			   unsigned short startx, unsigned short starty,
			   unsigned short totallen,unsigned short totalhei)
	{
		 M2Vsolidproc(data,showofs, x-(wx<<4)+vx, y-(wy<<4)+vy,
			 cliplen,cliphei,startx,starty,totallen,totalhei);
	};




// prosoxi den elegxei an to layerid einai mesa sta oria
	unsigned short TOworld::getlayervalue(char layerid,register unsigned short lx,register unsigned short ly)
	{
	  register unsigned short *lay=layers[layerid];
	  if (lay) return lay[ly*length+lx];
	}

// oute auti elegxei
	unsigned short TOworld::setlayervalue(char layerid,register unsigned short lx,register unsigned short ly
											 ,register unsigned short newvalue)
	{
	  register unsigned short *lay=layers[layerid];
	  if (lay) lay[ly*length+lx]=newvalue;
	}

	void TOworld::pageswap() { swaplongs(drawofs,showofs);}
	void TOworld::sethpel() { pl_sethorpel(hpel); }
	void TOworld::setsadr() { startaddrproc(showofs+sadr); }

	void TOworld::refreshpal()
	{
	 if (palettechanged)
	 {
	 pl_setpal(palette); palettechanged=0;
	 }
	}


#endif
