/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** WORLD.H: This file is part of the BETATRON library and can be used
 **          and/or distributed only under the terms of the GNU Library
 **          General Public License. See doc/readme.1st for details.
 */


#ifndef world_h
#define world_h

#include <stdio.h>
#include "plvga.h"
#include "ctc.h"
#include "grid.h"
#include "modinf.h"

#include "defines.h"
#include "plasm.h"
#include "sprite.h"


extern char *pl_errorstrings[];


void pl_makecolidmask(char *pdata,short sprlen, short sprhei,char *mask);


struct Tbitmap
	   {
		  unsigned short len;
		  unsigned short hei;
		  unsigned char drawmethod;
		  unsigned char format;
		  char *data;	// to allaksa
	   };


struct Tsurface
	 {
	   unsigned short sx,sy,sl;
	   unsigned short *data;
	 };


struct Tdxy
	{  short dx,dy;
	   char fall;
	};



typedef Tbitmap *TPbitmap;


struct Tframedescr
	   {
		 unsigned short len;
	 unsigned short hei;
	 unsigned char xdispl;
	 unsigned char ydispl;
	 unsigned short bitmapsno;
	 char  *colidemask;
	 char data[16000];
	  };

typedef Tframedescr *TPframedescr;

struct TOworld
  {
//--------------------------------------------------------------------------
/////	   mode specific information
	unsigned short curmode; 	  // currentmode
	short Xtiles,Ytiles;
	short Xres,Yres;

private:
	short Xlen,Ylen;		 // megethos selidas se pixels
	long  drawofslimit;
	long  modesize; 		 // megethos tou video buffer / 4
	Pstartaddr startaddrproc;
	PM2Vsolid  M2Vsolidproc;
	PM2Vthru  M2Vthruproc;
	PM2Vrle   M2Vrleproc;
	short horborder;	 // Xlen - Xres
	short verborder;	 // Ylen - Yres

	long  vesamem;			 // posi mnimi einai diathesimi
	char selectorallocated;  // no selector allocated
	char mappingenabled;	 // exei ginei physical mapping
	long  linearaddr;		 // grammiki dieuthinsi tou videoselector

	char setmodevalues(unsigned short mode,long xres,long yres);
	void shutdownmode();

public:
	short initmode(unsigned short mode);
	short setmode();
//--------------------------------------------------------------------------


	unsigned short length,height;		// world dimensions in tiles
	unsigned short x,y; 				// (x,y) of upper-left corner in pixels
	unsigned short tilesno; 			// how many tiles in the world
	char **Ptiles;						// array of tiles
	char tileformat;					// 0:RAW  1:4PLANES
	unsigned short	*layers[LAYERSNO];	// oi layers monodiastatoi pinakes
	char windowsbit;					// TRUE if running under windows
	char exitbit;						// set it TRUE to make animate exit
	char palettechanged;				// TRUE if an RGB triplet changed
	Tbitmap  *bitmaps;					// the array of the bitmaps
	unsigned short bitmapsno;			// how many bitmaps
	TOobject *objs[LISTSNO];			// object lists
	TOobject *priorities[PRIORITIESNO]; // priority lists
	char palette[768];					// the palette array
	unsigned char backprior,foreprior;	// priorities of tiles with high bit 1
	TPframedescr  *framesdescr; 		// array of the frame descriptors
	unsigned short framedescrno;		// how many frame descriptors
	short (*Pkernelproc)(TOworld *w);	// pointer to an external kernel
	char *Pframeready;					// points to a user variable which
										// is set 1 when a cycle has finished

//--------------------------------------------------------------------------
	Tsurface *surfaces; 				// surface templates
	unsigned short surfacesno;			// how many surfaces
	short makesurfaces(unsigned short surfacesno0);
	short destroysurfaces();
	unsigned short *setsurface(unsigned short i,unsigned short *surf,unsigned short sl0,
					 unsigned short sx0,unsigned short sy0);
	unsigned short *TOworld::unsetsurface(unsigned short no);

//--------------------------------------------------------------------------

private:
	unsigned long hitimerpart,lotimerpart; // 64bit timer counter
	unsigned long oldtimerticks;
public:
	unsigned long timerticks;		  // timer ticks since zerotimer()
	unsigned long dticks;			  // timerticks-oldtimerticks
	unsigned short retraceticks;

        void inittimer();
	inline void zerotimer();
//--------------------------------------------------------------------------
		// min ksexaseis na mideniseis tous deiktes
   private:
		short makegrid(unsigned char gridno); // private
		Tclustergrid *grids[MAXGRIDSNO];
   public:
		short setgridparameters(unsigned char gridno,unsigned char l20,
					   unsigned char h20,unsigned short maxobjsno0);
		short definegridlists(unsigned char gridno,long first,...);
		short destroygrid(unsigned char gridno);
		TOobject *gridcollision(unsigned char gridno,TOobject *o);
		short getgridarea(unsigned char gridno,TOobject *o,
						 unsigned short &x1,unsigned short &y1,
						 unsigned short &x2,unsigned short &y2);
		TOobject *getgridfirst(unsigned char gridno,
							   unsigned short gridx,unsigned short gridy);
		TOobject *getgridnext(unsigned char gridno);

//--------------------------------------------------------------------------
private:
	inline void cleartilerefresh(void);
	inline void clearforerefresh(void);

public:
	short destroybitmaps();
	char *setbitmap(unsigned short i,char *newmap, unsigned short l,
					 unsigned short h, char drfr);
	short makebitmaps(unsigned short bitmapsno0);
	short makeframesdescrs(unsigned short framesdescrno0);
	short destroyframesdescrs();
	short setsubbitmap(unsigned short descrno,unsigned short descrsubbitmapno,unsigned short bitmapno,
			   unsigned short bitx, unsigned short bity );
	short freedescrmem(unsigned short descrno);
	short getdescrmem(unsigned short descrno,unsigned short len0,unsigned short hei0,
				  unsigned short subbitmapsno,unsigned char xdisplacement=0,
					  unsigned char ydisplacement=0);
	short make1bitmapdescr(unsigned short descrno, unsigned short bitmapno, char colidmask,
						   unsigned char xdispl=0, unsigned char ydispl=0);
	short makeframecolidmask(unsigned short descrno);
	short dprintf(unsigned short descrno,char *st,...);
	short setframedisplacement(unsigned short frameno,unsigned char dx,unsigned char dy);

	short setbackprior(unsigned char pno);
	short setforeprior(unsigned char pno);

	short addobj(unsigned char listno,TOobject *obj,unsigned char priority);
	TOobject *removelistobj(unsigned char listno,unsigned short id0);
	TOobject *removeobjid(unsigned short id0);
	short removeobj(TOobject *obj);
	TOobject *getlistobjpointer(unsigned char listno,unsigned short id0);
	TOobject *getobjpointer(unsigned short id0);
	char collision(TOobject *spr1,TOobject *spr2);

	short howfarU(TOobject *spr,unsigned short howmany);
	short howfarD(TOobject *spr,unsigned short howmany);
	short howfarL(TOobject *spr,unsigned short howmany);
	short howfarR(TOobject *spr,unsigned short howmany);
	short howfarSD(TOobject *spr,unsigned short howmany);
	Tdxy  howfarSR(TOobject *spr,unsigned short howmany);
	Tdxy  howfarSL(TOobject *spr,unsigned short howmany);


	short makelayer(unsigned char layerid);
	short destroylayer(unsigned char layerid);
	short setdimensions(unsigned short len0,unsigned short hei0);
	short setlayer(unsigned short layerid,unsigned short *newlayer);
	short loadlevel(char *filename);

	short maketiles(unsigned short tilesno0);
	short destroytiles();
        void tilestoRAW();
        void tilesto4PLANES();
	char *settile(unsigned short tileno0,char *tiledata);

	inline void rgbset(unsigned char i,unsigned char r,unsigned char g,unsigned char b);

        inline void M2Vthru(char *data,unsigned short vx, unsigned short vy,
			  unsigned short cliplen,unsigned short cliphei,
			  unsigned short startx, unsigned short starty,
			  unsigned short totallen);

        inline void M2Vsolid(char *data,unsigned short vx, unsigned short vy,
			   unsigned short cliplen,unsigned short cliphei,
			   unsigned short startx, unsigned short starty,
			   unsigned short totallen,unsigned short totalhei);

	TOworld();
	~TOworld();
	short jumpto(unsigned short newx,unsigned short newy);
	void refresh();


	inline unsigned short getlayervalue(char layerid,register unsigned short lx,
										register unsigned short ly);
	inline unsigned short setlayervalue(char layerid,register unsigned short lx,register unsigned short ly
									   ,register unsigned short newvalue);

	void puttilexy(unsigned short layerid,unsigned short bx,
				   unsigned short by,unsigned short newvalue);

	inline void pageswap();
	inline void sethpel();
	inline void setsadr();
	inline void refreshpal();

	short animate();
	inline short scrollR(signed char dx);
	inline short scrollD(signed char dy);

private:
	short scrollRmx(signed char dx);
	short scrollDmx(signed char dy);

	short scrollRvesa(signed char dx);
	short scrollDvesa(signed char dy);

	unsigned short wx,wy;
	char internaltilesloader;
	TOobject  *worldlist;
	char objdeleted;
	char refreshbit;
	long showofs;
	long drawofs;
	long backofs;
	long bufofs;

	unsigned char hpel;
	signed char vadr;
	signed char hadr;
	signed char huplim,hdownlim;
	signed char vuplim,vdownlim;
	short scrollrow,scrollcol;
	unsigned short sadr;
	char verupdate;
	char horupdate;
	unsigned char forerefresh[MAXYTILES][MAXXTILES];
	unsigned char tilerefresh[MAXYTILES+2][MAXXTILES+2];
	signed long wx0,wy0;
	unsigned char tilechanged;
	char internalbitmapsloader; 	 // not used at the moment
	char internalsurfacesloader;
	char internallays[LAYERSNO];

	char *setcolidemask(unsigned short descrno,char *mask);
	void callactionfunctions();
	void drawsprites(unsigned char low,unsigned char high);

	void erasesprites();
	void erasespritesvesa();

	void drawbackground(unsigned short layer);
	void drawbackgroundvesa(unsigned short layer);
	void undoll(FILE *f);

	void refreshtiles1();
	void refreshtiles2();

	void  drawall(unsigned short pageofs);
	void  drawcol(unsigned char col,unsigned short pageofs);
	void  drawrow(unsigned char row, unsigned short pageofs);

	void  drawcolvesa(unsigned short startx);
	void  drawrowvesa(unsigned short starty);
	void  drawallvesa();
	void  refreshtiles1vesa();
	void  refreshtiles2vesa();



};


#include "winline.h"


#endif
