// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef ModelClass
#define ModelClass

#include <Lib3d/Vector.H>
#include <Lib3d/Matrix.H>   
#include <Lib3d/Viewport.H>
#include <Lib3d/Node.H>
#include <Lib3d/internals/Polygon.H>

// An object is created for all the polygons, their vertices and
// normals in a single display list.  Initially material and texture
// related issues are ignored. 

class Pipeline;
class Material;
class BoundingObject;

class Model : public Node
{
friend class ModelBuilder;
friend class Pipeline;

public:
    ~Model();
    const char *getName() const { return "Model"; }
    uint getNrPolygons() const { return nrPolygons; }
    void usePipeline( Pipeline &p );

protected:
    Model(uint nrPolygons, Polygon *polygons,
	  uint nrVertices, Vertex *vertices,
	  uint nrVertexNormals, Normal *vertexNormals,
	  uint nrPolygonNormals, Normal *polygonNormals,
	  uint nrMaterials, Material *materials,
	  Texture *texture,
	  BoundingObject *box);

    void render( Viewport &, const Light *, uint nrLights, uint flags );
    void recalculateTransforms( const Matrix34 & );
    ostream &print( ostream & ) const;

protected:
    uint nrPolygons;
    uint nrVertices;
    uint nrVertexNormals;
    uint nrPolygonNormals;
    uint nrMaterials;
    Polygon  *polygons;
    Vertex   *vertices;
    Normal   *vertexNormals;
    Normal   *polygonNormals;
    Material *materials;
    Texture  *texture;
    BoundingObject *box;
    Pipeline *pipeline;

    Matrix4  objectToDevice;  // Derived object to device space tranform
    Vector3  objectViewPos;   // Derived camera position in object space
    Matrix34 objectToCvv_T;   // Derived transformation for lighting.
};


#endif

      
	 


















