// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef WorldClass
#define WorldClass

#include <Lib3d/Node.H>

class Camera;
class Light;

class World : public Node
{
public:
    World();
    ~World();

    void renderHierarchy( Viewport & );
    const char *getName() const { return "World"; }

    // Temporarily public:
    void setActiveCamera( Camera & );
    void registerLight( Light & );
    void unRegisterLight( Light & );

protected:
    void checkRemovedLight( const Light& l );
    void checkNewLight( const Light& l );

protected:
    uint nrLights;
    Light *lights;
    Camera *active;
    uint flags;
};


#endif
