// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef ArrayClass
#define ArrayClass

#include <Lib3d/internals/types.H>
#include <stdlib.h>

class voidArray
{
public:
    voidArray( uint elemSize, uint init );
    virtual ~voidArray();

    uint getNr() const { return nr; }
    void truncate( uint idx );

    void sort(int (*compar)(const void *, const void *));
    
protected:
    voidArray() {}		// Disabled.

          char *deref( uint idx )       { return block + (idx * elemSize); }
    const char *deref( uint idx ) const { return block + (idx * elemSize); }

    char *expand( uint idx );
    char *next( uint &idx );
    char *next();
    char *duplicate();

protected:
    uint elemSize;
    uint max;
    uint nr;
    char *block;
};

inline void *operator new(size_t, char *pos) { return (void *)pos; }

template <class T> 
class Array : public voidArray
{
public:
    Array( uint size ) : voidArray(sizeof(T), size) {}
    ~Array() {}
    
    T *getStorage() { return (T *)block; }
    T *export() { return (T *)duplicate(); }

          T &operator[](uint i)       { return *(T *)deref(i); }
    const T &operator[](uint i) const { return *(T *)deref(i); }

    T &nextFree( uint &i ) { return *(new(next(i)) T); }
    T &nextFree() { return *(new(next()) T); }

    void sort(int (*compar)(const T *, const T *)) {
	voidArray::sort((int (*)(const void *, const void *))compar);
    }
};

template <class T> 
class PointerArray : public voidArray
{
public:
    PointerArray( uint size ) : voidArray(sizeof(T *), size) {}
    ~PointerArray() {}
    
    T **getStorage() { return (T **)block; }
    T **export() { return (T **)duplicate(); }

          T *&operator[](uint i)       { return *(T **)(deref(i)); }
    const T *&operator[](uint i) const { return *(T **)(deref(i)); }

    T *&nextFree( uint &i ) { return *(T **)next(i); }
    T *&nextFree() { return *(T **)next(); }

    void sort(int (*compar)(const T **, const T **)) {
	voidArray::sort((int (*)(const void *, const void *))compar);
    }
};
   
#endif







