#include <Lib3d/Scene.H>
#include "arch/arch.H"

Scene::Scene( Device &device, Viewport &viewport, World &world, Camera &camera)
    : device(device),
      viewport(viewport),
      world(world),
      camera(camera)
{
}

Scene::~Scene()
{
}

void 
Scene::render()
{
    device.clearBuffer();
    viewport.clearZBuffer();

    setup_fpu();	// use low precision arith.

    world.renderHierarchy( viewport );

    restore_fpu();

    device.swapBuffers();
}

void 
Scene::notifyResize()
{
    device.notifyResize();
    viewport.notifyResize();
    camera.notifyResize();    
}

void 
Scene::notifyExpose(uint xmin, uint ymin, uint xmax, uint ymax)
{
    device.notifyExpose(xmin, ymin, xmax, ymax);
}





