/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbstring.h,v 1.7 1996/08/01 08:03:45 jack Exp $ */

#ifndef __mbstring_h__
#define __mbstring_h__

/* include for test */
#include <mbctype.h>
/* include for macros */
#include <mbprvt.h>
/* include for size_t */
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

#define _MBC_SINGLE (0)
#define _MBC_LEAD (1)
#define _MBC_TRAIL (2)
#define _MBC_ILLEGAL (-1)

/* functions */
extern int _ismbcalnum (int c);
extern int _ismbcalpha (int c);
extern int _ismbcdigit (int c);
extern int _ismbcgraph (int c);
extern int _ismbchira (int c);
extern int _ismbckata (int c);
extern int _ismbcl0 (int c);
extern int _ismbcl1 (int c);
extern int _ismbcl2 (int c);
extern int _ismbclegal (int c);
extern int _ismbclower (int c);
extern int _ismbcprint (int c);
extern int _ismbcpunct (int c);
extern int _ismbcspace (int c);
extern int _ismbcsymbol (int c);
extern int _ismbcupper (int c);

extern int _mbccmp (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbccpy (unsigned char *ud, const unsigned char *us);
extern size_t _mbclen (const unsigned char *us);
extern unsigned char *_mbcset (unsigned char *us, int c);
extern int _mbctohira (int c);
extern int _mbctokata (int c);
extern int _mbctolower (int c);
extern int _mbctoupper (int c);

extern int _mbbtombc (int c);
extern int _mbbtype (unsigned char uc, int type);
extern int _mbctombb (int c);
extern int _mbsbtype (const unsigned char *us, size_t n);
extern unsigned char *_mbscat (unsigned char *ud, const unsigned char *us);
extern unsigned char *_mbschr (const unsigned char *us, int c);
extern int _mbscmp (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbscpy (unsigned char *ud, const unsigned char *us);
extern size_t _mbscspn (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbsdec (const unsigned char *us, const unsigned char *up);
extern unsigned char *_mbsdup (const unsigned char *us);
extern int _mbsicmp (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbsinc (const unsigned char *us);
extern size_t _mbslen (const unsigned char *us);
extern unsigned char *_mbslwr (unsigned char *us);
extern size_t _mbsnbcnt (const unsigned char *us, size_t n);
extern unsigned char *_mbsncat (unsigned char *ud, const unsigned char *us, size_t n);
extern size_t _mbsnccnt (const unsigned char *us, size_t n);
extern int _mbsncmp (const unsigned char *us1, const unsigned char *us2, size_t n);
extern unsigned char *_mbsncpy (unsigned char *ud, const unsigned char *us, size_t n);
extern int _mbsnextc (const unsigned char *us);
extern int _mbsnicmp (const unsigned char *us1, const unsigned char *us2, size_t n);
extern unsigned char *_mbsninc (const unsigned char *us, size_t n);
extern unsigned char *_mbsnset (unsigned char *us, int c, size_t n);
extern unsigned char *_mbspbrk (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbsrchr (const unsigned char *us, int c);
extern unsigned char *_mbsrev (unsigned char *us);
extern unsigned char *_mbsset (unsigned char *us, int c);
extern size_t _mbsspn (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbsspnp (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbsstr (const unsigned char *us1, const unsigned char *us2);
extern unsigned char *_mbstok (unsigned char *us, const unsigned char *udlm);
extern unsigned char *_mbsupr (unsigned char *us);


/* inline macros */
#define _ismbcalnum(c) (_ismbcalpha (c) || _ismbcdigit(c))
#define _ismbcalpha(c) (_ismbclower (c) || _ismbcupper (c))
#define _ismbcdigit(c) ((c) >= _MBC_DIGIT_BEGIN && (c) <= _MBC_DIGIT_END)
#define _ismbcgraph(c) (_ismbcprint (c) && ! _ismbcspace(c))
#define _ismbchira(c) ((c) >= _MBC_HIRA_BEGIN && (c) <= _MBC_HIRA_END)
#define _ismbckata(c) ((c) >= _MBC_KATA_BEGIN && (c) <= _MBC_KATA_END && (c) != _MBC_KATA_EXCEPT)
#define _ismbcl0(c) (_ismbclegal (c) && (c) >= _MBC_LEVEL0_BEGIN && (c) <= _MBC_LEVEL0_END)
#define _ismbcl1(c) (_ismbclegal (c) && (c) >= _MBC_LEVEL1_BEGIN && (c) <= _MBC_LEVEL1_END)
#define _ismbcl2(c) (_ismbclegal (c) && (c) >= _MBC_LEVEL2_BEGIN && (c) <= _MBC_LEVEL2_END)
#define _ismbclegal(c) ((c) <= 0xffffU && _ismbblead ((c) >> 8) && _ismbbtrail (c))
#define _ismbclower(c) ((c) >= _MBC_LOWER_BEGIN && (c) <= _MBC_LOWER_END)
#define _ismbcprint(c) (_ismbclegal (c))
#define _ismbcpunct(c) ((c) >= _MBC_PUNCT_BEGIN && (c) <= _MBC_PUNCT_END && (c) != _MBC_PUNCT_EXCEPT)
#define _ismbcspace(c) ((c) == _MBC_SPACE)
#define _ismbcsymbol(c) ((c) >= _MBC_SYMBOL_BEGIN && (c) <= _MBC_SYMBOL_END && (c) != _MBC_SYMBOL_EXCEPT)
#define _ismbcupper(c) ((c) >= _MBC_UPPER_BEGIN && (c) <= _MBC_UPPER_END)

#define _mbctohira(c) (((c) >= _MBC_KATA_BEGIN && (c) < _MBC_KATA_EXCEPT) ? \
		       (c) - _MBC_KANA_DIFF : \
		       ((c) > _MBC_KATA_EXCEPT && (c) <= _MBC_KATA_END) ? \
		       (c) - _MBC_KANA_DIFF - 1 : (c))
#define _mbctokata(c) (((c) >= _MBC_HIRA_BEGIN && (c) < _MBC_HIRA_BOUND) ? \
		       (c) + _MBC_KANA_DIFF : \
		       ((c) >= _MBC_HIRA_BOUND && (c) <= _MBC_HIRA_END) ? \
		       (c) + _MBC_KANA_DIFF + 1 : (c))
#define _mbctolower(c) (_ismbcupper (c) ? (c) + _MBC_ALPHA_DIFF : (c))
#define _mbctoupper(c) (_ismbclower (c) ? (c) - _MBC_ALPHA_DIFF : (c))

/* inline functions */
extern inline int
_mbccmp (const unsigned char *us1, const unsigned char *us2)
{
  int c1, c2;

  c1 = *us1++;
  if (_ismbblead (c1) && *us1 != '\0')
    c1 = (c1 << 8) + *us1;
  c2 = *us2++;
  if (_ismbblead (c2) && *us2 != '\0')
    c2 = (c2 << 8) + *us2;
  return c1 - c2;
}

extern inline unsigned char *
_mbccpy (unsigned char *ud, const unsigned char *us)
{
  if (_ismbblead (us[0]) && us[1] != '\0')
    *ud++ = *us++;
  *ud++ = *us++;
  return ud;
}

extern inline size_t
_mbclen (const unsigned char *us)
{
  if (_ismbblead (us[0]) && us[1] != '\0')
    return 2;
  return 1;
}

extern inline unsigned char *
_mbcset (unsigned char *us, int c)
{
  unsigned char high, low;

  high = (unsigned char) (c >> 8);
  low = (unsigned char) c;
  if (high)
    {
      if (low == '\0')
	low = high;
      else
	*us++ = high;
    }
  *us++ = low;
  return us;
}

#ifdef __cplusplus
}
#endif

#endif /* !__mbstring_h__ */
