#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc/libtheora/html

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"codec_8h.html                   : c8h.html"
"codec_8h_source.html            : c8h_source.html"
"functions.html                  : fctns.html"
"functions_vars.html             : fctns_vars.html"
"globals.html                    : glbs.html"
"globals_defs.html               : glbs_defs.html"
"globals_enum.html               : glbs_enum.html"
"globals_eval.html               : glbs_eval.html"
"globals_func.html               : glbs_func.html"
"globals_type.html               : glbs_type.html"
"globals_vars.html               : glbs_vars.html"
"group__basefuncs.html           : grp__basefuncs.html"
"group__decfuncs.html            : grp__decfuncs.html"
"group__encfuncs.html            : grp__encfuncs.html"
"group__oldfuncs.html            : grp__oldfuncs.html"
"structtheora__comment.html      : stha__comment.html"
"structtheora__info.html         : stha__info.html"
"structtheora__state.html        : stha__state.html"
"structth__huff__code.html       : sth_huff__code.html"
"structth__comment.html          : sth_comment.html"
"structth__img__plane.html       : sth_img__plane.html"
"structth__info.html             : sth_info.html"
"structth__quant__info.html      : sth_qu_info.html"
"structth__quant__ranges.html    : sth_qu_ranges.html"
"structth__stripe__callback.html : sth_stripe__callback.html"
"theora_8h.html                  : th8h.html"
"theora_8h_source.html           : th8h_source.html"
"theoradec_8h.html               : thdec8h.html"
"theoradec_8h_source.html        : thdec8h_source.html"
"theoraenc_8h.html               : thenc8h.html"
"theoraenc_8h_source.html        : thenc8h_source.html"
"structyuv__buffer.html          : syuv__buffer.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust doc/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^html_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed Makefile.*
