/**
 ** colortbl.c ---- Define some useful color tables
 **
 ** Copyright (C) 2019 Mariano Alvarez Fernandez
 ** [e-mail: malfer at telefonica.net]
 **
 ** This file is part of the GRX graphics library.
 **
 ** The GRX graphics library is free software; you can redistribute it
 ** and/or modify it under some conditions; see the "copying.grx" file
 ** for details.
 **
 ** This library is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **
 **/

#include "libgrx.h"
#include "mgrxcolr.h"

GrColorTableDef GrEgaColorTable[NUM_EGA_COLORS] = {
    {"BLACK", EGAR_BLACK, 0},
    {"BLUE", EGAR_BLUE, 0},
    {"GREEN", EGAR_GREEN, 0},
    {"CYAN", EGAR_CYAN, 0},
    {"RED", EGAR_RED, 0},
    {"MAGENTA", EGAR_MAGENTA, 0},
    {"BROWN", EGAR_BROWN, 0},
    {"LIGHTGRAY", EGAR_LIGHTGRAY, 0},
    {"DARKGRAY", EGAR_DARKGRAY, 0},
    {"LIGHTBLUE", EGAR_LIGHTBLUE, 0},
    {"LIGHTGREEN", EGAR_LIGHTGREEN, 0},
    {"LIGHTCYAN", EGAR_LIGHTCYAN, 0},
    {"LIGHTRED", EGAR_LIGHTRED, 0},
    {"LIGHTMAGENTA", EGAR_LIGHTMAGENTA, 0},
    {"YELLOW", EGAR_YELLOW, 0},
    {"WHITE", EGAR_WHITE, 0}};

GrColorTableDef GrWebColorTable[NUM_WEB_COLORS] = {
    {"ALICEBLUE", WEBR_ALICEBLUE, 0},
    {"ANTIQUEWHITE", WEBR_ANTIQUEWHITE, 0},
    {"AQUAMARINE", WEBR_AQUAMARINE, 0},
    {"AZURE", WEBR_AZURE, 0},
    {"BEIGE", WEBR_BEIGE, 0},
    {"BISQUE", WEBR_BISQUE, 0},
    {"BLACK", WEBR_BLACK, 0},
    {"BLANCHEDALMOND", WEBR_BLANCHEDALMOND, 0},
    {"BLUE", WEBR_BLUE, 0},
    {"BLUEVIOLET", WEBR_BLUEVIOLET, 0},
    {"BROWN", WEBR_BROWN, 0},
    {"BURLYWOOD", WEBR_BURLYWOOD, 0},
    {"CADETBLUE", WEBR_CADETBLUE, 0},
    {"CHARTREUSE", WEBR_CHARTREUSE, 0},
    {"CHOCOLATE", WEBR_CHOCOLATE, 0},
    {"CORAL", WEBR_CORAL, 0},
    {"CORNFLOWERBLUE", WEBR_CORNFLOWERBLUE, 0},
    {"CORNSILK", WEBR_CORNSILK, 0},
    {"CRIMSON", WEBR_CRIMSON, 0},
    {"CYAN", WEBR_CYAN, 0},
    {"DARKBLUE", WEBR_DARKBLUE, 0},
    {"DARKCYAN", WEBR_DARKCYAN, 0},
    {"DARKGOLDENROD", WEBR_DARKGOLDENROD, 0},
    {"DARKGRAY", WEBR_DARKGRAY, 0},
    {"DARKGREEN", WEBR_DARKGREEN, 0},
    {"DARKKHAKI", WEBR_DARKKHAKI, 0},
    {"DARKMAGENTA", WEBR_DARKMAGENTA, 0},
    {"DARKOLIVEGREEN", WEBR_DARKOLIVEGREEN, 0},
    {"DARKORANGE", WEBR_DARKORANGE, 0},
    {"DARKORCHID", WEBR_DARKORCHID, 0},
    {"DARKRED", WEBR_DARKRED, 0},
    {"DARKSALMON", WEBR_DARKSALMON, 0},
    {"DARKSEAGREEN", WEBR_DARKSEAGREEN, 0},
    {"DARKSLATEBLUE", WEBR_DARKSLATEBLUE, 0},
    {"DARKSLATEGRAY", WEBR_DARKSLATEGRAY, 0},
    {"DARKTURQUOISE", WEBR_DARKTURQUOISE, 0},
    {"DARKVIOLET", WEBR_DARKVIOLET, 0},
    {"DEEPPINK", WEBR_DEEPPINK, 0},
    {"DEEPSKYBLUE", WEBR_DEEPSKYBLUE, 0},
    {"DIMGRAY", WEBR_DIMGRAY, 0},
    {"DODGERBLUE", WEBR_DODGERBLUE, 0},
    {"FIREBRICK", WEBR_FIREBRICK, 0},
    {"FLORALWHITE", WEBR_FLORALWHITE, 0},
    {"FORESTGREEN", WEBR_FORESTGREEN, 0},
    {"GAINSBORO", WEBR_GAINSBORO, 0},
    {"GHOSTWHITE", WEBR_GHOSTWHITE, 0},
    {"GOLD", WEBR_GOLD, 0},
    {"GOLDENROD", WEBR_GOLDENROD, 0},
    {"GRAY", WEBR_GRAY, 0},
    {"GREEN", WEBR_GREEN, 0},
    {"GREENYELLOW", WEBR_GREENYELLOW, 0},
    {"HONEYDEW", WEBR_HONEYDEW, 0},
    {"HOTPINK", WEBR_HOTPINK, 0},
    {"INDIANRED", WEBR_INDIANRED, 0},
    {"INDIGO", WEBR_INDIGO, 0},
    {"IVORY", WEBR_IVORY, 0},
    {"KHAKI", WEBR_KHAKI, 0},
    {"LAVENDER", WEBR_LAVENDER, 0},
    {"LAVENDERBLUSH", WEBR_LAVENDERBLUSH, 0},
    {"LAWNGREEN", WEBR_LAWNGREEN, 0},
    {"LEMONCHIFFON", WEBR_LEMONCHIFFON, 0},
    {"LIGHTBLUE", WEBR_LIGHTBLUE, 0},
    {"LIGHTCORAL", WEBR_LIGHTCORAL, 0},
    {"LIGHTCYAN", WEBR_LIGHTCYAN, 0},
    {"LIGHTGOLDENRODYELLOW", WEBR_LIGHTGOLDENRODYELLOW, 0},
    {"LIGHTGRAY", WEBR_LIGHTGRAY, 0},
    {"LIGHTGREEN", WEBR_LIGHTGREEN, 0},
    {"LIGHTPINK", WEBR_LIGHTPINK, 0},
    {"LIGHTSALMON", WEBR_LIGHTSALMON, 0},
    {"LIGHTSEAGREEN", WEBR_LIGHTSEAGREEN, 0},
    {"LIGHTSKYBLUE", WEBR_LIGHTSKYBLUE, 0},
    {"LIGHTSLATEGRAY", WEBR_LIGHTSLATEGRAY, 0},
    {"LIGHTSTEELBLUE", WEBR_LIGHTSTEELBLUE, 0},
    {"LIGHTYELLOW", WEBR_LIGHTYELLOW, 0},
    {"LIME", WEBR_LIME, 0},
    {"LIMEGREEN", WEBR_LIMEGREEN, 0},
    {"LINEN", WEBR_LINEN, 0},
    {"MAGENTA", WEBR_MAGENTA, 0},
    {"MAROON", WEBR_MAROON, 0},
    {"MEDIUMAQUAMARINE", WEBR_MEDIUMAQUAMARINE, 0},
    {"MEDIUMBLUE", WEBR_MEDIUMBLUE, 0},
    {"MEDIUMORCHID", WEBR_MEDIUMORCHID, 0},
    {"MEDIUMPURPLE", WEBR_MEDIUMPURPLE, 0},
    {"MEDIUMSEAGREEN", WEBR_MEDIUMSEAGREEN, 0},
    {"MEDIUMSLATEBLUE", WEBR_MEDIUMSLATEBLUE, 0},
    {"MEDIUMSPRINGGREEN", WEBR_MEDIUMSPRINGGREEN, 0},
    {"MEDIUMTURQUOISE", WEBR_MEDIUMTURQUOISE, 0},
    {"MEDIUMVIOLETRED", WEBR_MEDIUMVIOLETRED, 0},
    {"MIDNIGHTBLUE", WEBR_MIDNIGHTBLUE, 0},
    {"MINTCREAM", WEBR_MINTCREAM, 0},
    {"MISTYROSE", WEBR_MISTYROSE, 0},
    {"MOCCASIN", WEBR_MOCCASIN, 0},
    {"NAVAJOWHITE", WEBR_NAVAJOWHITE, 0},
    {"NAVY", WEBR_NAVY, 0},
    {"OLDLACE", WEBR_OLDLACE, 0},
    {"OLIVE", WEBR_OLIVE, 0},
    {"OLIVEDRAB", WEBR_OLIVEDRAB, 0},
    {"ORANGE", WEBR_ORANGE, 0},
    {"ORANGERED", WEBR_ORANGERED, 0},
    {"ORCHID", WEBR_ORCHID, 0},
    {"PALEGOLDENROD", WEBR_PALEGOLDENROD, 0},
    {"PALEGREEN", WEBR_PALEGREEN, 0},
    {"PALETURQUOISE", WEBR_PALETURQUOISE, 0},
    {"PALEVIOLETRED", WEBR_PALEVIOLETRED, 0},
    {"PAPAYAWHIP", WEBR_PAPAYAWHIP, 0},
    {"PEACHPUFF", WEBR_PEACHPUFF, 0},
    {"PERU", WEBR_PERU, 0},
    {"PINK", WEBR_PINK, 0},
    {"PLUM", WEBR_PLUM, 0},
    {"POWDERBLUE", WEBR_POWDERBLUE, 0},
    {"PURPLE", WEBR_PURPLE, 0},
    {"RED", WEBR_RED, 0},
    {"ROSYBROWN", WEBR_ROSYBROWN, 0},
    {"ROYALBLUE", WEBR_ROYALBLUE, 0},
    {"SADDLEBROWN", WEBR_SADDLEBROWN, 0},
    {"SALMON", WEBR_SALMON, 0},
    {"SANDYBROWN", WEBR_SANDYBROWN, 0},
    {"SEAGREEN", WEBR_SEAGREEN, 0},
    {"SEASHELL", WEBR_SEASHELL, 0},
    {"SIENNA", WEBR_SIENNA, 0},
    {"SILVER", WEBR_SILVER, 0},
    {"SKYBLUE", WEBR_SKYBLUE, 0},
    {"SLATEBLUE", WEBR_SLATEBLUE, 0},
    {"SLATEGRAY", WEBR_SLATEGRAY, 0},
    {"SNOW", WEBR_SNOW, 0},
    {"SPRINGGREEN", WEBR_SPRINGGREEN, 0},
    {"STEELBLUE", WEBR_STEELBLUE, 0},
    {"TAN", WEBR_TAN, 0},
    {"TEAL", WEBR_TEAL, 0},
    {"THISTLE", WEBR_THISTLE, 0},
    {"TOMATO", WEBR_TOMATO, 0},
    {"TURQUOISE", WEBR_TURQUOISE, 0},
    {"VIOLET", WEBR_VIOLET, 0},
    {"WHEAT", WEBR_WHEAT, 0},
    {"WHITE", WEBR_WHITE, 0},
    {"WHITESMOKE", WEBR_WHITESMOKE, 0},
    {"YELLOW", WEBR_YELLOW, 0},
    {"YELLOWGREEN", WEBR_YELLOWGREEN, 0}};

int GrGenEgaColorTable(void)
{
    int i;
    
    if (GrNumColors() < 16) return -1;
    
    // set first black & white in case we run out of cells
    GrEgaColorTable[0].color = GrBlack();
    GrEgaColorTable[NUM_EGA_COLORS-1].color = GrWhite();

    for (i=1; i<NUM_EGA_COLORS-1; i++)
        GrEgaColorTable[i].color = GrAllocColor2(GrEgaColorTable[i].rgbcolor);
    
    return 0;
}

int GrGenWebColorTable(void)
{
    int i;
    
    if (GrNumColors() < 256) return -1;
    
    for (i=0; i<NUM_WEB_COLORS; i++)
        GrWebColorTable[i].color = GrAllocColor2(GrWebColorTable[i].rgbcolor);
    
    return 0;
}
