//  Demonstrates use of independent processes to draw a series of bouncing
//  blobs. Written by
//  Josh Turpen (snarfy@goodnet.com) and
//  Sengan Short(sengan.short@durham.ac.uk)
//  Minor modification by Paolo De Marino (paolodemarino@usa.net)
//  This demo file is FREEWARE - you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "lwp.h"
#include "lwpconio.h"
#include "lwpstdio.h"
#include <dpmi.h>
#include <dos.h>
#include <stdlib.h>
#include <math.h>
#include <sys/farptr.h>
#include <time.h>
#include <go32.h>

volatile int plot_count = 0;
void putpixel (int x, int y, char col);
void blob_proc (void *);
int done = 0;

int
main ()
{
  int i;
  __dpmi_regs regs;

  regs.x.ax = 0x13;
  __dpmi_int (0x10, &regs);

  setbuf(stdout,NULL);

  srandom( time( 0 ) );

  if (lwp_init (8, RTC128))     /* doesn't really matter since each task yields */
    {
        lwp_spawn (blob_proc, (void*)0,8192, 1);

        plot_count = 1;
        while (!done)
        {
          lwp_pulse_false(&plot_count);
          lwp_yield();
          if(kbhit())
             if(getch() == '+')
                {
                  lwp_spawn (blob_proc, (void*)0,8192, 1);
                } else
                {
                  done = 1;
						_lwp_heavy_dbg = 1;	/* Begin heavy tracing! */
					 }
        }
    }
  lwp_thread_disable ();
  regs.x.ax = 0x3;
  __dpmi_int (0x10, &regs);
  lwp_thread_enable ();

  return 0;
}

void
blob_proc (void *unused)
{
  int x, y, xspeed, yspeed;
  char col;


  lwp_thread_disable();
  x = random () % 320;
  y = random () % 200;
  col = random () & 0xF0;
  xspeed = (random () & 1) ? 1 : -1 ;
  yspeed = (random () & 1) ? 1 : -1 ;
  lwp_thread_enable();

  while (1)
    {
      putpixel (x, y, 0);
      x += xspeed;
      if (x >= 319)
        {
          xspeed = -xspeed;
          x = 319;
        }
      if (x <= 0)
        {
          xspeed = -xspeed;
          x = 0;
        }
      y += yspeed;
      if (y >= 199)
        {
          yspeed = -yspeed;
          y = 199;
        }
      if (y <= 0)
        {
          yspeed = -yspeed;
          y = 0;
        }
      putpixel (x, y, col);
                lwp_wait_false(&plot_count);
    }
}

void
putpixel (int x, int y, char col)
{
  lwp_thread_disable ();
  _farsetsel(_go32_conventional_mem_selector());
  _farnspokeb (0xA0000 + x + y*320 , col);
  lwp_thread_enable ();
}
/*
void waitVBL(void)
{
        lwp_thread_disable();
        while(!(inportb(0x3DA) & 8));
        while(inportb(0x3DA) & 8);
        lwp_thread_enable();
}
*/
