// Associated include file : Drivers/Dir.H

#include "common/common.h"
#include "drivers/time.h"
#include "drivers/dir.h"

#include <dirent.h>
#include <sys/stat.h>
#include <time.h>

#ifdef _TURBOC_
  #include <dir.h>
#endif

// Local vars

struct TDirInfo
{ char  SearchPath[260];
  DIR  *dirp;
};

//

void *OpenDirList(char *Path)
{ TDirInfo *DirInfo=new TDirInfo;

  strcpy(DirInfo->SearchPath,Path);
  DirInfo->dirp=opendir(Path);
  if (DirInfo->dirp==NULL)
  { delete DirInfo;
    Error=erCantOpenPathForDirList;
    return NULL;
  }
  return (void*)DirInfo;
}

boolean ReadDirEntry(TDirEntry& Entry, void *Handle)
{ struct dirent *direntp;
  TDirInfo      *DirInfo=(TDirInfo*)Handle;
  // Find one entry. If necessary, jump over "." and ".." entries
  Try:
    direntp=readdir(DirInfo->dirp);
    if (direntp==NULL) return TRUE;
    if ( (strcmp(direntp->d_name,".")==0) ||
         (strcmp(direntp->d_name,"..")==0)) goto Try;
#ifdef _MSDOS_
  strlwr(direntp->d_name);
#endif
  // Extract datas from entry
  GetFileInformations(DirInfo->SearchPath,direntp->d_name,Entry);
  return FALSE;
}

void CloseDirList(void *Handle)
{ TDirInfo *DirInfo=(TDirInfo*)Handle;
  closedir(DirInfo->dirp);
  delete DirInfo;
}

boolean GetFileInformations(char *Path, char *FName, TDirEntry& Entry)
{ char           Tmp[500];
  struct stat    statbuf;
  // Name and Path
  strcpy(Entry.Path,Path);
  strcpy(Entry.FName,FName);
  // Is it a directory ??
  sprintf(Tmp,"%s/%s",Path,FName);
  if (stat(Tmp,&statbuf)<0) return TRUE;
  if (statbuf.st_mode & S_IFDIR) Entry.Directory=TRUE;
                            else Entry.Directory=FALSE;
  // Time and Date
  Entry.Time.SetFromSystemTime(statbuf.st_atime);
  return FALSE;
}

boolean FileExist(char *Path, char *FName)
{ TDirEntry Entry;
  return !GetFileInformations(Path,FName,Entry);
}

void MakeDir(char *Path)
{
#ifdef _TURBOC_
  mkdir(Path);
#else
  mkdir(Path,S_IRWXU | S_IRWXG | S_IRWXO);
#endif
}
