// Associated include file : Graphics/Scroller.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- TScroller object

DEFINE(TScroller);

DEFINE_EVENTS_TABLE(TScroller,TZone)
  COMMAND(cmLiftHorizMoved,doLiftHorizMoved)
  COMMAND(cmLiftVertMoved, doLiftVertMoved)
END_EVENTS_TABLE

short RegTScroller;
char *IdentTScroller = "TScroller";

TScroller::TScroller()
{ Defaults();
//Init(100,100,NULL,NULL);
}

TScroller::TScroller(int X, int Y, int L, int H, int WL, int WH, TLift *_Horiz, TLift *_Vert)
{ Defaults();
  Init(X,Y,L,H,WL,WH,_Horiz,_Vert);
}

TScroller::TScroller(TRect R, int WL, int WH, TLift *_Horiz, TLift *_Vert)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),WL,WH,_Horiz,_Vert);
}

void TScroller::Defaults()
{ // Object identification
  Register=RegTScroller;
  Ident=IdentTScroller;
  // Other default values
  SetOptions(opCSHiX | opCSHiY);
  WideL=WideH=100;
  Horiz=Vert=NULL;
}

void TScroller::Init(int X, int Y, int L, int H, int WL, int WH, TLift *_Horiz, TLift *_Vert)
{ Horiz=_Horiz;
  Vert=_Vert;
  WideL=WL;
  WideH=WH;
  // Herited constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  if (Horiz!=NULL) Horiz->SetConnectedObject(this);
  if (Vert!=NULL)  Vert->SetConnectedObject(this);
  DecX=0;
  DecY=0;
  StepX=5;
  StepY=5;
  SizeChanged();
}

void TScroller::SizeChanged(void)
{ if (Horiz)
  { Horiz->SetRealPos(0,WideL-1,FALSE);
    Horiz->SetViewPos(DecX,DecX+Where.Width()-1);
    Horiz->SetIncStep(StepX);
  }
  if (Vert)
  { Vert->SetRealPos(0,WideH-1,FALSE);
    Vert->SetViewPos(DecY,DecY+Where.Height()-1);
    Vert->SetIncStep(StepY);
  }
}

boolean TScroller::doLiftHorizMoved(void)
{ int Dummy,OldDec;
  int LTrans;
  if (CurrentEvent.InfoPtr==this)
  { GrSetClipBox(0,0,GrMaxX(),GrMaxY());
    OldDec=DecX;
    Horiz->GetViewPos(DecX,Dummy);
    if (DecX>OldDec)
    { LTrans=OldDec+Where.Width()-DecX;
      if (LTrans>0)
      { GrBitBlt(NULL,Corner.X(),Corner.Y(),
                 NULL,Corner.X()+DecX-OldDec,Corner.Y(),
                 Corner.X()+Where.Width()-1,Corner.Y()+Where.Height()-1,GrWRITE);
        Invalidate(LTrans,0,Where.Width()-1,Where.Height()-1);
      }
      else Invalidate();
    }
    if (DecX<OldDec)
    { LTrans=DecX+Where.Width()-OldDec;
      if (LTrans>0)
      { GrBitBlt(NULL,Corner.X()+OldDec-DecX,Corner.Y(),
                 NULL,Corner.X(),Corner.Y(),
                 Corner.X()+LTrans-1,Corner.Y()+Where.Height()-1,GrWRITE);
        Invalidate(0,0,OldDec-DecX-1,Where.Height()-1);
      }
      else Invalidate();
    }
    ShowDrawingNow();
    return TRUE;
  }
  return FALSE;
}

boolean TScroller::doLiftVertMoved(void)
{ int Dummy,OldDec;
  int LTrans;
  if (CurrentEvent.InfoPtr==this)
  { GrSetClipBox(0,0,GrMaxX(),GrMaxY());
    OldDec=DecY;
    Vert->GetViewPos(DecY,Dummy);
    if (DecY>OldDec)
    { LTrans=OldDec+Where.Height()-DecY;
      if (LTrans>0)
      { GrBitBlt(NULL,Corner.X(),Corner.Y(),
                 NULL,Corner.X(),Corner.Y()+DecY-OldDec,
                 Corner.X()+Where.Width()-1,Corner.Y()+Where.Height()-1,GrWRITE);
        Invalidate(0,LTrans,Where.Width()-1,Where.Height()-1);
      }
      else Invalidate();
    }
    if (DecY<OldDec)
    { LTrans=DecY+Where.Height()-OldDec;
      if (LTrans>0)
      { GrBitBlt(NULL,Corner.X(),Corner.Y()+OldDec-DecY,
                 NULL,Corner.X(),Corner.Y(),
                 Corner.X()+Where.Width()-1,Corner.Y()+LTrans-1,GrWRITE);
        Invalidate(0,0,Where.Width()-1,OldDec-DecY-1);
      }
      else Invalidate();
    }
    ShowDrawingNow();
    return TRUE;
  }
  return FALSE;
}

void TScroller::Draw(TRect Clip)
{ TZone::Draw(Clip);
  char Temp[100];
  SetSysColor(Black);
  Bar(0,0,Where.Width()-1,Where.Height()-1);
  SetSysColor(LightGray);
  FontSystem->BackColor(LightGray);
  sprintf(Temp,"Wide Size.. : (%3d-%3d)",WideL,WideH);
  PutStr(10,10,Temp,FontListing);
  sprintf(Temp,"Real Size.. : (%3d-%3d)",Where.Width(),Where.Height());
  PutStr(10,30,Temp,FontListing);
  sprintf(Temp,"Pos........ : (%3d-%3d)",DecX,DecY);
  PutStr(10,50,Temp,FontListing);
  FontSystem->BackColor(NoColor);
}
