// Associated include file : Graphics/StatText.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// ----- TStaticText

DEFINE(TStaticText);

short RegTStaticText;
char *IdentTStaticText = "TStaticText";

// Constructors

TStaticText::TStaticText()
{ Defaults();
}

TStaticText::TStaticText(int X, int Y, int L, int H, char* _Text)
{ Defaults();
  Init(X,Y,L,H,_Text);
}

TStaticText::TStaticText(TRect R, char* _Text)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Text);
}

void TStaticText::Defaults()
{ // Object identification
  Register=RegTStaticText;
  Ident=IdentTStaticText;
  // Other default values
  Text=NULL;
}

void TStaticText::Init(int X, int Y, int L, int H, char* _Text)
{ // Herited constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  if (_Text!=NULL)
  { Text=strdup(_Text);
    FontSystem->TruncStr(Where.Width(),_Text,Text);
    Yt=(Where.Height()-FontSystem->HeightStr(Text))/2;
  }
}

void TStaticText::Done(void)
{ // Herited destructions
  TZone::Done();
  // New destructions
  if (Text!=NULL) free(Text);
}

// Graphics

void TStaticText::Draw(TRect )
{ SetSysColor(FaceGray);
  Bar(0,0,Where.Width()-1,Where.Height()-1);
  SetSysColor(Black);
  if (Text!=NULL) PutStr(0,Yt,Text,FontSystem);
}

// Objects streams

void TStaticText::Read(TDisk *file)
{ TZone::Read(file);
  ReadString(file,&Text);
}

void TStaticText::Write(TDisk *file)
{ TZone::Write(file);
  WriteString(file,Text);
}
