#include "Common/Common.H"
#include "Drivers/Drivers.H"

typedef unsigned char byte;

// ----- Local variables

int Palette_13c[13][3] =
  { {   0,   0,   0 },
    {   0,   0, 191 },
    {   0, 170, 170 },
    {  85, 255, 255 },
    {  40, 117,  36 },
    {  60, 182,  60 },
    {  85, 255,  85 },
    { 153,  44,  44 },
    { 198,  60,  60 },
    { 250,  80,  80 },
    {  90,  90,  90 },
    { 170, 170, 170 },
    { 255, 255, 255 } };

#ifdef __TURBOC__
  #define rbits    4
  #define gbits    4
  #define bbits    4
  #define accurate 2
  #define tot      4
  #define tr       16
  #define tg       16
  #define tb       16
  int Grid[4] = { 0, 3, 2, 1 };
#else
  #define rbits    5
  #define gbits    5
  #define bbits    5
  #define accurate 4
  #define tot      16
  #define tr       32
  #define tg       32
  #define tb       32
  int Grid[16] = { 0,12, 3,15, 8, 4,11, 7, 2,14, 1,13,10, 6, 9, 5 };
#endif

#define V_Table(r,g,b,n) Table[(n)+tot*((b)+tb*((g)+tg*(r)))]

float  Palette[4][256];
int    NumColor;

// ----- Object TDither : Used when in True Color (do nothing)

struct TDither
{ // Constructor / Destructor
  TDither() {}
  virtual ~TDither() {}
  // Usefull method
  virtual int GetRGBColor(int X, int Y, int R, int G, int B);
};

int TDither::GetRGBColor(int, int, int R, int G, int B)
{ return ((R<<16) + (G<<8) + (B));
}

// ----- Object TGosselinkDither : Used when in 16 or 256 colors

struct TGosselinkDither : TDither
{ byte *Table;
  // Constructor / Destructor
  TGosselinkDither();
  virtual ~TGosselinkDither();
  // Usefull method
  virtual int GetRGBColor(int X, int Y, int R, int G, int B);
};

int CompBytes(const void *E1, const void *E2)
{ float v1=Palette[3][*((int*)E1)];
  float v2=Palette[3][*((int*)E2)];
  if (v1<v2) return -1;
  if (v1>v2) return 1;
  return 0;
}

TGosselinkDither::TGosselinkDither()
{ int   i,j;
  int   ir,ig,ib;
  float fr,fg,fb;
  float sr,sg,sb;
  float a,d,f;
  int   Bytes[tot],c;
  // Kepp memory space for the Table and other arrays
  Table=new byte[tr*tb*tg*tot];
  // Calculations for the Table
  for(ir=0;ir<tr;ir++)
  { fr=(float)ir/(tr-1);
    printf("R=%f\n",fr);
    for(ig=0;ig<tg;ig++)
    { fg=(float)ig/(tg-1);
      for(ib=0;ib<tb;ib++)
      { fb=(float)ib/(tb-1);
        sr=fr;
        sg=fg;
        sb=fb;
        for(i=0;i<tot;i++)
        { // Seek the color in the palette the closest from (sr,sg,sb)
          a=1E30;
          for(j=0;j<NumColor;j++)
          { d=(Palette[0][j]-sr)*(Palette[0][j]-sr)+
              (Palette[1][j]-sg)*(Palette[1][j]-sg)+
              (Palette[2][j]-sb)*(Palette[2][j]-sb);
            if (d<a) { a=d; c=j; }
          }
          // The color found is c. Keep this reference
          Bytes[i]=c;
          // Diffuses the error made to next color
          if (i<tot-1)
          { f=tot-1-i;
            sr+=(sr-Palette[0][c])/f;
            sg+=(sg-Palette[1][c])/f;
            sb+=(sb-Palette[2][c])/f;
			 }
        }
        // Sort all the colors found in the grey order
        qsort(Bytes,tot,sizeof(int),CompBytes);
        // Move the result of calculations into the table
        for(i=0;i<tot;i++) V_Table(ir,ig,ib,i)=Bytes[Grid[i]];
      }
    }
  }
}

TGosselinkDither::~TGosselinkDither()
{ delete Table;
}

int TGosselinkDither::GetRGBColor(int X, int Y, int R, int G, int B)
{ return V_Table( ( R >> (8-rbits)) & (tr-1),
			( G >> (8-gbits)) & (tg-1),
			( B >> (8-bbits)) & (tb-1),
			(X & (accurate-1)) + (Y & (accurate-1))*accurate  );
}

// -----

TDither *Dither;

// ----- Global functions

int main(char , char *argv[])
{ int i,j,Rep;
  // Initialise le systme
  ShortVersion="Color Tables computing";
  LongVersion ="Color Tables computing. Copyright (C) 1993-1996 The SWORD Group";
  InitCommon(argv[0]);
  InitDrivers();
  // Warning
  printf("\n\nDON'T USE THIS PROGRAM IF YOU ARE NOT WELL AWARE OF WHAT IT DOES\n\n"
			"  1. Continue\n"
			"  2. Abort\n"
			"  ->");
  scanf("%d",&Rep);
  if (Rep==1)
  { // Demande ce qu'il y a  calculer
#ifdef __TURBOC__
	 NumColor=13;
	 printf("\nTURBO C mode\n");
#else
	 printf("\nGNU mode\n"
           "You want to compute the colors table for : \n"
           "  1. GNU    16c\n"
           "  2. GNU    256c\n\n"
           "  ->");
    scanf("%d",&Rep);
    switch(Rep)
    { case 1 :  NumColor=13;  break;
      case 2 :  NumColor=252; break;
    }
#endif
    // Get the palette for calculations
    if (NumColor==13)
    { for(i=0;i<13;i++)
      { Palette[0][i]=Palette_13c[i][0];
        Palette[1][i]=Palette_13c[i][1];
        Palette[2][i]=Palette_13c[i][2];
      }
    }
    else
    { for(i=0;i<252;i++)
      { Palette[0][i]=((i/42) % 6)*255/5;
        Palette[1][i]=((i/ 6) % 7)*255/6;
        Palette[2][i]= (i     % 6)*255/5;
      }
    }
    for(i=0;i<NumColor;i++)
    { Palette[3][i]=(Palette[0][i]*30+Palette[1][i]*59+Palette[2][i]*11)/100;
      for(j=0;j<4;j++) Palette[j][i]/=255;
    }
    Dither=new TGosselinkDither();
    char   FileName[200];
    TDisk *FileOut;
    strcpy(FileName,SwordPath);
#ifdef __TURBOC__
    strcat(FileName,"\\DATAS\\TURBO16.COL");
#else
    switch(Rep)
    { case 1 : strcat(FileName,"/DATAS/GNU16.COL");   break;
      case 2 : strcat(FileName,"/DATAS/GNU256.COL");  break;
    }
#endif
    FileOut=new TDisk(FileName,stCreate);
    FileOut->Write(((TGosselinkDither*)Dither)->Table,tr*tg*tb*tot);
    delete FileOut;
    delete Dither;
  }
  else
  { printf("\nAborted.\n");
  }
  DoneDrivers();
  DoneCommon();
  return 0;
}