/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Little usefull graphical objects
	File      : Include/Gadgets/TitleBar.H
	Author    : Eric NICOLAS
	Overview  : TTitleBar object
	UpDate    : Apr 01, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_TITLEBAR_H_
#define _GADGETS_TITLEBAR_H_

class TTitleBar;

// --- Object TTitleBar

extern short RegTTitleBar;
extern char *IdentTTitleBar;

class TTitleBar : public TZone
{ DECLARE(TTitleBar);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    char *Title;
  // --- Functions
  public:
  // Public constructors
          TTitleBar(void);
			 TTitleBar(int X, int Y, int L, int H, char *_Title);
			 TTitleBar(TRect R, char *_Title);
  // Construction / Destruction
			 void     Defaults(void);
			 void     Init(int X, int Y, int L, int H, char *_Title);
			 void     Done(void);
  // Events
			 boolean  MouseLDown(TPoint Where, int Buttons);
          boolean  doChangeSelect(void);
  // Graphics
  virtual void     Draw(TRect Clip);
  virtual void     ShrinkInside(TRect& InsideFather);
  // Linked lists
			 TWindow *Father(void);
};

// Inline functions

inline TWindow* TTitleBar::Father(void)
{ return (TWindow*)(TZone::Father());
}

#endif // _GADGETS_TITLEBAR_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
