/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Screen graphics management
	CommandNos : 2100..2199
	File       : Include/Graphics/Shell.H
	Author     : Eric NICOLAS
	Overview   : Basic object : creation of events, mouse management, ScreenSaver
	UpDate     : Apr 01, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_SHELL_H_
#define _GRAPHICS_SHELL_H_

// Defines

#define mbLeft   0x0001
#define mbRight  0x0002
#define mbMiddle 0x0004
#define mbTest   0x0008

#define MaxEventStock 50

#define cmDrawCursor     2100
#define cmReDrawScreen   2101
#define cmUpdateMouse    2102
#define cmDestroyWindow  2103
#define cmMinimizeWindow 2104
#define cmMaximizeWindow 2105

class TShell;
class TScreenSaver;

//

extern long DelayDblClick;
extern long LastClickTime;

// Objet TShell

extern short RegTShell;
extern char *IdentTShell;

class TShell : public TObject
{ DECLARE(TShell);
  // -- Datas
  protected:
    TEvent    EventStock[MaxEventStock];
    int       NbEventStock;
    TObject  *ModalObject;
    TTimeDate Time;
  // -- Functions
  public:
  // Public constructor
          TShell(void);
  // Creation / Destruction
          void Defaults(void);
          void Init(void);
  // Selections
  virtual boolean  Focus(void);
  // Events
  // :: Generation
          void     GetKeyMouseEvent(TEvent *Event);
			 void     GetTimeEvent(TEvent *Event);
  virtual void     GetEvent(TEvent *Event);
  virtual void     SetEvent(TEvent *Event);
          long     EventsLoop(TObject *O);
          void     ScreenSaverReset(int Delay);  // Delay in seconds
  // :: Handling
          boolean  doUpdateMouse(void);
  // Overridables
  virtual TScreenSaver *ScreenSaverCreation();
  DECLARE_EVENTS_TABLE;
};

extern TShell *Application;

// Object Screen Saver

class TScreenSaver
{ // -- Datas
  protected:
    TShell *TheShell;
    int     NoStep;
    long    MouseChangeTime;
  // -- Functions
  public:
    // Constructor
    TScreenSaver(TShell *Shell);
    // Standard actions
    boolean NoUserAction(void);
    void Execute(void);
  protected:
    // Overridables
    virtual void Init(void);
    virtual void Step(void);
    virtual void Done(void);
};

extern TScreenSaver *ScreenSaver;
extern long          ScreenSaverDelay;   // Inactivity delay before Screen
                                         // saver ON (in seconds)

// Usefull functions

void SetAlarm(long Comm, long Delay, void *Ptr); // Delay in 1/100 s
void BeginDrag();
void EndDrag();

#endif // _GRAPHICS_SHELL_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   28/02/96 :EN: Defaults() method. Possibility to change Screen Saver
**   03/03/96 :EN: Adding evTime event managment
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
** ------------------------------------------------------------------------*/
