/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Demonstration
	Commands  : Group: 10000
	File      : Image/Image.CC
	Author    : Eric NICOLAS
	Overview  : Image Viewer demo program
	UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "sword.H"
#include "ToolBox/image/image.h"

#ifdef __TURBOC__
  #error This demo program will not work with TurboC because of memory limitations
#endif

// --- Define commands IDs for the menu

#define cmReadJPEG  10000
#define cmReadGIF   10001
#define cmReadBMP   10002
#define cmReadTGA   10003
#define cmReadPPM   10004

// --- Application object

class TMyApp : public TApp
{ DECLARE(TMyApp);
  DECLARE_EVENTS_TABLE;
  // --- Functions
  public:
  // Public Constructors
            TMyApp(void);
            TMyApp(char *argv0);
  // Overridables
    virtual void      CreateMenuChoices(TMenu *Menu);
    virtual TDesktop *DesktopCreation(void);
  // Handling menu messages
            boolean   doReadJPEG(void);
            boolean   doReadGIF(void);
            boolean   doReadBMP(void);
            boolean   doReadTGA(void);
            boolean   doReadPPM(void);
            void      CreateImageViewer(char *FileName);
};

DEFINE(TMyApp)

DEFINE_EVENTS_TABLE(TMyApp,TApp)
  COMMAND(cmReadJPEG, doReadJPEG)
  COMMAND(cmReadGIF,  doReadGIF)
  COMMAND(cmReadBMP,  doReadBMP)
  COMMAND(cmReadTGA,  doReadTGA)
  COMMAND(cmReadPPM,  doReadPPM)
END_EVENTS_TABLE

TMyApp::TMyApp(void)
{ Defaults();
}

TMyApp::TMyApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TMyApp::CreateMenuChoices(TMenu *Menu)
{ TMenu *MenuImage;
  // Create Sub Menu "Open Image"
  MenuImage=new TMenu("Open Image");
    MenuImage->Insert(new TMenuChoice("&JPEG test image",0,cmReadJPEG));
    MenuImage->Insert(new TMenuChoice("&GIF test image",0,cmReadGIF));
    MenuImage->Insert(new TMenuChoice("&BMP test image",0,cmReadBMP));
    MenuImage->Insert(new TMenuChoice("&TGA test image",0,cmReadTGA));
    MenuImage->Insert(new TMenuChoice("&PPM test image",0,cmReadPPM));
  // Create Menu Choices for Main Menu
  Menu->Insert(new TMenuChoice("&Open Image",MenuImage));
  Menu->Insert(new TMenuChoice("&Edition",0,10,sfDisabled));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
}

void TMyApp::CreateImageViewer(char *FileName)
{ // Create the TImage object, and then load the image from disk
  TImage *Image=new TImage(0,0);
  Image->Load(FileName);
  if (Error)
  {
    delete Image;
    return;
  }
  // Create the ImageViewer object to see the image
  Desktop->Insert(new TImageViewer(100,100,400,400,"Image Viewer",Image));
}

TDesktop *TMyApp::DesktopCreation(void)
{ char      FName[50];
  TDesktop *D;
  // Get the screen resolution and compute the name of
  // the image to load as the desktop background
  sprintf(FName,"backgrds/bkg_%d.jpg",GrMaxX()+1);
  // Create the desktop with image
  D=new TBkgDesktop(FName);
  if (Error) FatalError();
  return D;
}

boolean TMyApp::doReadJPEG(void)
{ CreateImageViewer("Images/Image.JPG");
  return TRUE;
}

boolean TMyApp::doReadGIF(void)
{ CreateImageViewer("Images/Kenya.GIF");
  return TRUE;
}

boolean TMyApp::doReadBMP(void)
{ CreateImageViewer("Images/A029.BMP");
  return TRUE;
}

boolean TMyApp::doReadTGA(void)
{ CreateImageViewer("Images/Drums.TGA");
  return TRUE;
}

boolean TMyApp::doReadPPM(void)
{ CreateImageViewer("Images/Myst4.PPM");
  return TRUE;
}

// ==== Main Program

int main(char , char *argv[])
{ TMyApp *MyApp;

  // Application identification
  ShortVersion="Image";
  LongVersion ="Image Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Create, run and destroy the Application object
  MyApp=new TMyApp(argv[0]);
  MyApp->Run();
  delete MyApp;

  return 0;
}
