#if !defined(__ENH2__) && !defined(__GTR3__) && !defined(__VPL3__) && !defined(VPL3) && !defined(__FLN1__) && !defined(__SPY3__)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef GTR3_GATORS_H
#define GTR3_GATORS_H
/*****************************************************************Includes*/
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <time.h>
#include <dir.h>
#define LSW1_All
#include <swing.h>
#include <vpl3.h>
/****************************************************************defines*/
// version definitions
#define GTR3_program      "RLSystems Gators"
#define GTR3_version      "V3.20S"
#define GTR3_author       "Dlanor Blytkerchan <dlanor@dds.nl>"
#define GTR3_hexVersion   0x0320
// // ships
#define firecloud            56     // Firecloud class cruiser
#define largeFreighter       17     // Large DS Freighter
#ifndef compatibleVersion
#define compatibleVersion    0x0208 // V3 is compatible with V2.08 and later..
#endif // compatibleVersion
#define maxGators            99     // Maximal number of Gators (because J?? can't go higher than J99)
#define GTR3_UFOParentNumber 1421   // ID to be used in the UFO database -- assigned to this add-on
/*******************************************************************Macros*/
#ifndef rnd
  #define rnd(lowMargin,highMargin) ((random() % ((highMargin) - (lowMargin))) + (lowMargin))
#endif // rnd

#ifndef sqr
  #define sqr(x) ((x) * (x))
#endif // sqr

#ifndef lhypot
  #define lhypot(x1, y1, x2, y2) (lsqrt(sqr((x1) - (x2)) + sqr((y1) - (y2))))
#endif // lhypot
/******************************************************************Globals*/
extern bool rc;
extern char *basePath, *gamePath;
extern int thisRun;
/**********************************************Mathematical helper methods*/
long long lsqrt(long long X);
/******************************************************Houskeeping methods*/
bool initErrorList(void);
/**************************************************************************/
#endif // GTR3_GATORS_H
