#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>
#include "Manager.h"

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Manager *manager;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[[GTKApplication alloc] initWithArgc:&argc argv:&argv] autorelease];
    [GTKApp rcParse:@"p.rc"];

    manager = [[Manager new] autorelease];
    if (argc > 1) [manager loadFromFile:[NSString stringWithCString:argv[1]]];

    [GTKApp run];
    [pool release];
    return 0;
}
