#ifndef GTOOLKIT_GTKPREVIEW_H
#define GTOOLKIT_GTKPREVIEW_H

#include <GToolKit/GTKWidget.h>
#include <gtk/gtkpreview.h>

@interface GTKPreview : GTKWidget
+ (guint) getType;
+ (void) uninit;
+ previewWithType:(GtkPreviewType) type;
- initWithType:(GtkPreviewType) type;
- (void) size:(gint) width height:(gint) height;
- (void) put:(GdkWindow *) window gc:(GdkGC *) gc srcx:(gint) srcx srcy:(gint) srcy destx:(gint) destx desty:(gint) desty width:(gint) width height:(gint) height;
- (void) putRow:(guchar *) src dest:(guchar *) dest x:(gint) x y:(gint) y w:(gint) w;
- (void) drawRow:(guchar *) data x:(gint) x y:(gint) y w:(gint) w;
- (void) setExpand:(gint) expand;
+ (void) setGamma:(double) gamma;
+ (void) setColorCube:(guint) nred_shades ngreenShades:(guint) ngreen_shades nblueShades:(guint) nblue_shades ngrayShades:(guint) ngray_shades;
+ (void) setInstallCmap:(gint) install_cmap;
+ (void) setReserved:(gint) nreserved;
+ (GdkVisual*) getVisual;
+ (GdkColormap*) getCmap;
+ (GtkPreviewInfo*) getInfo;
+ (void) reset;
@end

#endif
