/* LocaleInformation_hu.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_hu extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jord\u00e1niai d\u00edn\u00e1r|Bol\u00edviai mvdol|Arany|Fer\u00f6er-szigeteki korona|Libanoni font|Euro|Vietn\u00e1mi dong|Tanz\u00e1niai shilling|Bol\u00edviai peso|Kambodzsai riel|Asian Monetary Unit|Boliviano (1863-1962)|Kambodzsai r\u00e9gi riel|Zambiai font|Ausztr\u00e1l font|CFA frank BEAC|M\u00e1ltai font|Gh\u00e1nai \u00fajra\u00e9rt\u00e9kelt cedi|Zambiai kwacha|Asian Dinar Unit of Account|Gh\u00e1nai font|Boliviano|Gh\u00e1nai r\u00e9gi cedi|M\u00e1ltai l\u00edra|Ausztr\u00e1l doll\u00e1r|USA doll\u00e1r (aznapi)|Olasz l\u00edra|USA doll\u00e1r (k\u00f6vetkez\u0151 napi)|Gh\u00e1nai cedi|Szingap\u00fari doll\u00e1r|Panamai balboa|Laoszi kip|Kirgiziszt\u00e1ni szom|Sv\u00e1jci frank|Osztr\u00e1k schilling|USA doll\u00e1r|Eti\u00f3piai doll\u00e1r|Brunei doll\u00e1r|Jamaikai font|Eti\u00f3piai birr|Alg\u00e9riai kezdeti frank|Alg\u00e9riai \u00faj frank|Alg\u00e9riai d\u00edn\u00e1r|Paraguayi guarani|L\u00edbiai font|Jamaikai doll\u00e1r|Izlandi korona|Spanyol peseta|Bermudai font|L\u00edbiai d\u00edn\u00e1r|L\u00edbiai brit katonai fennhat\u00f3s\u00e1gi l\u00edra|Bermudai doll\u00e1r|Holland forint|Maurit\u00e1niai ouguiya|Ir\u00e1ni rial|Sv\u00e9d korona|Eritreai nakfa|Kenyai shilling|K\u00f6z\u00e9p-afrikai CFA frank|Peso|Argent\u00edn peso (1983-1985)|Argent\u00edn peso moneda nacional|Tajvani \u00faj doll\u00e1r|Szud\u00e1ni font|Gr\u00faz lari|Gr\u00faz kupon larit|Martiniquei frank|Falkland-szigeteki font|Argent\u00edn austral|Szud\u00e1ni d\u00edn\u00e1r|Iraki d\u00edn\u00e1r|Tuvalui doll\u00e1r|Seychelle-szigeteki r\u00fapia|Lett rubel|Fidzsi font|Lett lats|Kong\u00f3i zaire|Kong\u00f3i k\u00f6zt\u00e1rsas\u00e1gi frank|Kong\u00f3i frank|Fidzsi doll\u00e1r|Nikaraguai cordoba oro|Macaoi pataca|Nikaraguai arany cordoba|Nikaraguai cordoba|COMECON Transferable Ruble|Finn markka (1860-1962)|Finn markka|Salamon-szigeteki doll\u00e1r|Luxemburgi frank|Trinidad \u00e9s tobagoi r\u00e9gi doll\u00e1r|Angolai escudo|Angolai kwanza reajustado (1995-1999)|Mong\u00f3liai tugrik|Magyar forint|Burundi frank|Angolai \u00faj kwanza (1990-2000)|Angolai kwanza (1977-1990)|Trinidad \u00e9s tobagoi doll\u00e1r|Szv\u00e1zif\u00f6ldi lilangeni|\u00daj-hebrid\u00e1ki CFP frank|Brit font sterling|Sza\u00fadi szuver\u00e9n riyal|Sza\u00fadi riyal|Litv\u00e1niai talonas|Portug\u00e1l escudo|Angolai kwanza|Portug\u00e1l conto|Litv\u00e1niai litas|Kazahszt\u00e1ni tenge|Kazahszt\u00e1ni rubel|Brit virgin-szigeteki doll\u00e1r|Nig\u00e9riai font|Mianmari doll\u00e1r konvertibilis valuta|Nig\u00e9riai naira|Haiti gourde|Sz\u00edriai font|Palesztin font|Bahreini din\u00e1r|Mianmari kyat|Holland-antilla forint|Cseh korona|Man-szigeti font sterling|Bolg\u00e1r leva konvertibilis valuta|Lesothoi loti|Gaboni CFA frank|Bolg\u00e1r leva (1879-1952)|Bolg\u00e1r \u00faj leva|Bolg\u00e1r szocialista leva|Kanadai doll\u00e1r|Bolg\u00e1r kem\u00e9ny leva|T\u00f6r\u00f6k l\u00edra|Kajm\u00e1n-szigeteki doll\u00e1r|Ciprusi font|Izraeli \u00faj s\u00e9kel|Guyanai doll\u00e1r|Dram|Izraeli font|Mali frank|Izraeli s\u00e9kel|Venezuelai bol\u00edvar|Alb\u00e1n doll\u00e1r konvertibilis valuta|Lib\u00e9riai doll\u00e1r|Alb\u00e1n lek valuta|Horv\u00e1t kuna|R\u00e9unioni frank|Horv\u00e1t d\u00edn\u00e1r|Alb\u00e1n lek|Jersey font sterling|Alb\u00e1n lek (1946-1961)|Macedon d\u00edn\u00e1r (1992-1993)|\u00c9szak-vietn\u00e1mi viet minh piastre dong viet|\u00c9szak-vietn\u00e1mi \u00faj dong|Macedon d\u00edn\u00e1r|\u00c9szak-vietn\u00e1mi piastre dong viet|Timori pataca|CFP frank|Belga frank (p\u00e9nz\u00fcgyi)|Guinea-Bissaui peso|Kuvaiti d\u00edn\u00e1r|Portug\u00e1l guinea mil reis|Belga frank|Timori escudo|Belga frank (konvertibilis)|Portug\u00e1l guinea escudo|Salvadori col\u00f3n|Curacaoi forint|Bangladesi taka|Tongai font sterling|CFA frank BCEAO|Szovjet rubel|Szovjet \u00faj rubel|\u00daj-kaled\u00f3niai frank kezdeti|Cape Verdei escudo|French Antilles CFA Franc|D\u00e9l-afrikai rand|Dominikai peso|Kubai konvertibilis valuta|D\u00e9l-afrikai font|D\u00e9l-afrikai rand (p\u00e9nz\u00fcgyi)|Tun\u00e9ziai d\u00edn\u00e1r|Kubai peso|Francia Guyanai frank guiana|Ugandai shilling|Ceyloni r\u00fapia|Affars and Issas Franc|Vatik\u00e1ni l\u00edra|Sao tome-i \u00e9s principe-i escudo|Ugandai shilling (1966-1987)|Sao tome-i \u00e9s principe-i dobra|Marshall-szigeteki doll\u00e1r|\u00daj-z\u00e9landi font|Nyugat-szamoai tala|Nyugat-szamoai font|Hodurasi lempira|French Metropolitan Nouveau Franc|T\u00fcrkmeniszt\u00e1ni manat|Guatemalai quetzal|\u00daj-z\u00e9landi doll\u00e1r|Sk\u00f3t font|Barbadosi doll\u00e1r|Nam\u00edbiai doll\u00e1r|Madagaszk\u00e1ri frank|Madagaszk\u00e1ri ariary|Egyiptomi font|Brit-hondurasi doll\u00e1r|Lengyel zloty (1950-1995)|Bosznia-hercegovinai \u00faj d\u00edn\u00e1r|Lengyel USA doll\u00e1r konvertibilis valuta|Bozsnia-hercegovinai konvertibilis m\u00e1rka|Belizei doll\u00e1r|Bosznia-hercegovinai d\u00edn\u00e1r|Lengyel zloty|Jemeni rial|Suriname-i gulden|Csehszlov\u00e1k kem\u00e9ny korona|D\u00e9l-koreai won|Feh\u00e9rorosz rubel|Jemeni imadi riyal|Feh\u00e9rorosz rubel (1992-1994)|Csehszlov\u00e1k korona|D\u00e9l-koreai r\u00e9gi won|D\u00e9l-koreai hwan|Feh\u00e9rorosz \u00faj rubel (1994-1999)|Szom\u00e1lf\u00f6ldi shilling|G\u00f6r\u00f6g \u00faj drachma|Pakiszt\u00e1ni r\u00fapia|Afghani|Zimbabwei doll\u00e1r|Sri Lankai r\u00fapia|G\u00f6r\u00f6g drachma|\u00cdr font|Afghani (1927-2002)|Jemeni d\u00edn\u00e1r|Ruandai frank|Costa Ricai colon|T\u00e1dzsikiszt\u00e1ni somoni|T\u00e1dzsikiszt\u00e1ni rubel|\u00c9szt korona|Egyenl\u00edt\u0151i-guineai peseta guineana|Moldov\u00e1n rubel kupon|Hongkongi doll\u00e1r|D\u00e1n korona|Moldov\u00e1n lei|Egyenl\u00edt\u0151i-guineai franco|Egyenl\u00edt\u0151i-guineai ekwele guineana|Indon\u00e9z r\u00fapia|EAE dirham|\u00c9szak-koreai won|Indon\u00e9z \u00faj r\u00fapia|Botswanai pula|Moldov\u00e1n lei kupon|Indon\u00e9z j\u00e1va r\u00fapia|\u00c9szak-koreai n\u00e9pi won|Indon\u00e9z nica guilder|Vanuatui vatu|Iszl\u00e1m d\u00edn\u00e1r|Szom\u00e1li shilling|Andorrai peseta|Orosz rubel (1991-1998)|Guadeloupei frank|Dzsibuti frank|Andorrai d\u00edn\u00e1r|Monacoi frank kezdeti|Monacoi frank \u00faj|Ecuadori Unidad de Valor Constante (UVC)|Ecuadori sucre|Liechtensteini frank|Orosz rubel|F\u00fcl\u00f6p-szigeteki peso|\u00dczbegiszt\u00e1ni szum|Kolumbiai peso|Thai baht|\u00c9szak\u00edr font|Burmai r\u00fapia|Kong\u00f3i CFA frank|Burmai kyat|Kolumbiai pap\u00edr peso|\u00dczbegiszt\u00e1ni kupon som|Ukr\u00e1n karbovanec|Katari rial|Ukr\u00e1n hrivnya|Guineai syli|K\u00ednai j\u00fcan renminbi|Mozambik metical|K\u00ednai USA doll\u00e1r konvertibilis valuta|Uruguay-i peso uruguayo|Guineai frank (1960-1972)|San Marinoi l\u00edra|K\u00ednai jen min piao j\u00fcan|Mozambik escudo|Guineai frank|Om\u00e1ni rial saidi|P\u00e1pua \u00faj-guineai kina|Om\u00e1ni rial|Uruguay-i peso (1975-1993)|Francia UIC-frank|Bhut\u00e1ni r\u00fapia|Zairei zaire|Marokk\u00f3i frank|Marokk\u00f3i dirham|Bhut\u00e1ni ngultrum|Francia arany frank|Uruguay-i peso fuerte|Malajziai ringgit|Zairei \u00faj zaire|Azerbajdzs\u00e1ni manat|Gambiai font|Comorei frank|Sierra Leonei leone|Gambiai dalasi|European Currency Unit|Bahamai font|Cameruni CFA frank|Mexik\u00f3i Unidad de Inversion (UDI)|CFA frank BCEAEC|Bahamai doll\u00e1r|Mexik\u00f3i ez\u00fcst peso (1861-1992)|Mexik\u00f3i peso|Perui sol|Gr\u00f6nlandi korona|Brazil cruzeiro (1942-1967)|Perui sol nuevo|Chilei peso|Szlov\u00e1k korona|Perui inti|Brazil cruzeiro|Special Drawing Rights|Francia frank kezdeti/Frank poincare|Francia frank|Brazil cruzado novo|Chilei unidades de fomento|Chilei escudo|Brazil real|Chilei condor|Brazil cruzeiro (1990-1993)|German Sperrmark|Malawi font|Brazi cruzado|Brazi cruzeiro novo (1967-1986)|Malawi kwacha|Transzdnyeszteri rubel|N\u00e9met m\u00e1rka|Cs\u00e1di CFA frank|Transzdnyeszteri \u00faj rubel|Transzdnyeszteri rubel kupon|Nep\u00e1li r\u00fapia|Cook-szigeteki doll\u00e1r|Jap\u00e1n jen|Mald\u00edv-szigeteki rufiyaa|CFA \u00faj frank|Mald\u00edv-szigeteki r\u00fapia|Kelet-karibi doll\u00e1r|Szlov\u00e9n tolar|Jugoszl\u00e1v reform d\u00edn\u00e1r|Arubai forint|Jugoszl\u00e1v okt\u00f3beri d\u00edn\u00e1r|Kelet-N\u00e9met m\u00e1rka|Jugoszl\u00e1v konvertibilis d\u00edn\u00e1r|Jugoszl\u00e1v \u00faj d\u00edn\u00e1r|Turks \u00e9s caicosi korona|Jugoszl\u00e1v 1994-es d\u00edn\u00e1r|Jugoszl\u00e1v sz\u00f6vets\u00e9gi d\u00edn\u00e1r|Rom\u00e1n \u00faj lej|Jugoszl\u00e1v kem\u00e9ny d\u00edn\u00e1r|Rom\u00e1n lej|Szlov\u00e9n tolar bons|Norv\u00e9g korona|Mauritiusi r\u00fapia|European Unit of Account (XBD)|Gibralt\u00e1ri font|Vietn\u00e1mi nemzeti dong|European Unit of Account (XBC)|Vietn\u00e1mi k\u00f6zt\u00e1rsas\u00e1gi dong|European Monetary Unit|European Composite Unit|Kiribati doll\u00e1r|Saint Helena font|Vietn\u00e1mi \u00faj dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|MZE|CNP|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan.",
    "febr.",
    "m\u00e1rc.",
    "\u00e1pr.",
    "m\u00e1j.",
    "j\u00fan.",
    "j\u00fal.",
    "aug.",
    "szept.",
    "okt.",
    "nov.",
    "dec.",
    null,
  };

  private static final String[] months = {
    "janu\u00e1r",
    "febru\u00e1r",
    "m\u00e1rcius",
    "\u00e1prilis",
    "m\u00e1jus",
    "j\u00fanius",
    "j\u00falius",
    "augusztus",
    "szeptember",
    "okt\u00f3ber",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "V",
    "H",
    "K",
    "Sze",
    "Cs",
    "P",
    "Szo",
  };

  private static final String[] weekdays = {
    null,
    "vas\u00e1rnap",
    "h\u00e9tf\u0151",
    "kedd",
    "szerda",
    "cs\u00fct\u00f6rt\u00f6k",
    "p\u00e9ntek",
    "szombat",
  };

  private static final String[] eras = {
    "i.e.",
    "i.u.",
  };

  private static final String[] ampms = {
    "DE",
    "DU",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Kelet-Timor|Tokelau|Tadzsikiszt\u00e1n|Thaif\u00f6ld|Togo|Francia D\u00e9li Ter\u00fcletek|Guyana|Cs\u00e1d|T\u00f6r\u00f6k \u00e9s Caicos Szigetek|Guinea-Bissau|Guam|Guatemala|D\u00e9l-Georgia \u00e9s D\u00e9l-Sandwich Szigetek|G\u00f6r\u00f6gorsz\u00e1g|Egyenl\u00edt\u010fi Guinea|Guadeloupe|Szv\u00e1zif\u00f6ld|Sz\u00edriai Arab K\u00f6zt\u00e1rsas\u00e1g|Guinea|Gambia|Gr\u00f6nland|El Salvador|Saint Tome \u00e9s Principe|Gibralt\u00e1r|Ghana|Suriname|Francia Guyana|Serbia|Gr\u00fazia|Szom\u00e1lia|Grenada|Szeneg\u00e1l|San Marino|Egyes\u00fclt Kir\u00e1lys\u00e1g|Sierra Leone|Gabon|Szlov\u00e1kia|Svalbard \u00e9s Jan Mayen|Szlov\u00e9nia|Saint Helena|Szingap\u00far|Sv\u00e9dorsz\u00e1g|Szud\u00e1n|Seychelles|Salamon-szigetek|Szaud-Ar\u00e1bia|Franciaorsz\u00e1g|Fer\u00f6er-szigetek|Mikron\u00e9zia, Sz\u00f6vets\u00e9gi \u00c1llamok|Ruanda|Falkland-szigetek|Orosz K\u00f6zt\u00e1rsas\u00e1g|Fidzsi|Finnorsz\u00e1g|Rom\u00e1nia|Reunion (francia)|Eti\u00f3pia|Spanyolorsz\u00e1g|Eritrea|Nyugat Szahara|Egyiptom|\u00c9sztorsz\u00e1g|Ecuador|Alg\u00e9ria|Katar|Dominikai K\u00f6zt\u00e1rsas\u00e1g|Paraguay|Dominika|Palau|D\u00e1nia|Dzsibuti|Portug\u00e1lia|Paleszt\u00edn Ter\u00fclet|Puerto Rico|N\u00e9metorsz\u00e1g|Pitcairn-sziget|Saint Pierre \u00e9s Miquelon|Lengyelorsz\u00e1g|Pakiszt\u00e1n|F\u00fcl\u00f6p-szigetek|P\u00e1pua \u00daj-Guinea|Polin\u00e9zia (francia)|Cseh K\u00f6zt\u00e1rsas\u00e1g|Peru|Ciprus|Kar\u00e1csony-szigetek|Z\u00f6ld-foki K\u00f6zt\u00e1rsas\u00e1g|Panama|Kuba|Costa Rica|Kolumbia|K\u00edna|Kamerun|Chile|Cook-szigetek|Elef\u00e1ntcsontpart|Sv\u00e1jc|Kong\u00f3|K\u00f6z\u00e9p-afrikai K\u00f6zt\u00e1rsas\u00e1g|Kong\u00f3, Demokratikus k\u00f6zt\u00e1rsas\u00e1g|K\u00f3kusz (Keeling)-szigetek|Om\u00e1n|Kanada|Beliz|Feh\u00e9roroszorsz\u00e1g|Botswana|Bouvet-sziget|Bhut\u00e1n|Baham\u00e1k|Braz\u00edlia|\u00daj-Z\u00e9land|Bol\u00edvia|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulg\u00e1ria|Burkina Faso|Nep\u00e1l|Belgium|Norv\u00e9gia|Banglades|Barbados|Zimbabwe|Hollandia|Bosznia-Hercegovina|Nicaragua|Nig\u00e9ria|Norfolk-sziget|Azerbajdzs\u00e1n|Niger|\u00daj Kaled\u00f3nia (francia)|Aruba|Zambia|Nam\u00edbia|Ausztr\u00e1lia|Ausztria|Amerikai Szamoa|Argent\u00edna|Antarktisz|Mozambik|Angola|Malajzia|Holland Antill\u00e1k|Mexik\u00f3|\u00d6rm\u00e9nyorsz\u00e1g|Malawi|Alb\u00e1nia|Mald\u00edv-szigetek|D\u00e9l-Afrika|Mauritius|M\u00e1lta|Anguilla|Montserrat|Maurit\u00e1nia|Antigua \u00e9s Barbuda|Martinique (francia)|Afganiszt\u00e1n|\u00c9szaki Mariana-szigetek|Egyes\u00fclt Arab Emir\u00e1tus|Macao S.A.R., China|Andorra|Mong\u00f3lia|Mianmar|Mali|Maced\u00f3nia, K\u00f6zt\u00e1rsas\u00e1g|Jugoszl\u00e1via|Mayotte|Marshall-szigetek|Madagaszk\u00e1r|Mold\u00e1v K\u00f6zt\u00e1rsas\u00e1g|Monaco|Marokk\u00f3|Jemen|L\u00edbiai Arab Jamahiriya|Lettorsz\u00e1g|Luxemburg|Litv\u00e1nia|Lesotho|Lib\u00e9ria|Sri Lanka|Liechtenstein|Saint Lucia|Libanon|Laoszi N\u00e9pi Demokratikus K\u00f6zt\u00e1rsas\u00e1g|Kazahszt\u00e1n|Kajm\u00e1n-szigetek|Kuwait|Korea, D\u00e9l|Korea, \u00c9szak|Saint Kitts \u00e9s Nevis|Comore-szigetek|Kiribati|Szamoa|Kambodzsa|Kirgiziszt\u00e1n|Kenya|Wallis \u00e9s Futuna Szigetek|Jap\u00e1n|Jord\u00e1nia|Jamaica|Vanuatu|Vietn\u00e1m|U.S. Virgin-szigetek|Brit Virgin-szigetek|Venezuela|Saint Vincent \u00e9s Grenadines|Vatik\u00e1n|Olaszorsz\u00e1g|Izland|Ir\u00e1n|Irak|\u00dczbegiszt\u00e1n|Brit Indiai Oce\u00e1n|Uruguay|India|Izrael|Egyes\u00fclt \u00c1llamok|\u00cdrorsz\u00e1g|Indon\u00e9zia|United States Minor Outlying Islands|Uganda|Ukrajna|Magyarorsz\u00e1g|Haiti|Horv\u00e1torsz\u00e1g|Tanz\u00e1nia|Honduras|Heard \u00e9s McDonald Szigetek|Taiwan|Tuvalu|Hong Kong S.A.R., China|Trinidad \u00e9s Tobago|T\u00f6r\u00f6korsz\u00e1g|Tonga|Tun\u00e9zia|T\u00fcrkmeniszt\u00e1n";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "spanyol|kurd|eszperant\u00f3|kasm\u00edri|angol|g\u00f6r\u00f6g|kecsua|koreai|kannada|kambodzsai|gr\u00f6nlandi|kazah|volof|gr\u00faz|but\u00e1ni|j\u00e1vai|portug\u00e1l|pastu (afg\u00e1n)|n\u00e9met|lengyel|d\u00e1n|volap\u00fck|jap\u00e1n|vietn\u00e1mi|walesi|pandzs\u00e1bi|cseh|inuktitut|olasz|korzikai|izlandi|\u00fczb\u00e9g|orija|inupiak|urdu|orom\u00f3i|katal\u00e1n|interlingue|indon\u00e9z|ukr\u00e1n|interlingua|okszit\u00e1n|ujgur|\u00f6rm\u00e9ny|breton|magyar|tibeti|beng\u00e1li|horv\u00e1t|bislama|tui|bihari|bolg\u00e1r|tat\u00e1r|norv\u00e9g|belorusz|conga|hindi|t\u00f6r\u00f6k|holland|zulu|bask\u00edr|tonga|h\u00e9ber|szecsu\u00e1ni|tagalog|t\u00fcrkm\u00e9n|hausza|nep\u00e1li|azerbajdzs\u00e1ni|tigrinya|ajmara|thai|tadzsik|naurui|telugu|k\u00ednai|assz\u00e1mi|arab|tamil|gudzsar\u00e1ti|burmai|amhara|zsuang|m\u00e1ltai|mal\u00e1j|guarani|szuah\u00e9li|marati|sv\u00e9d|gal\u00edciai|szundan\u00e9z|afrikai|szeszot\u00f3|moldvai|sziszuati|mongol|szerb|alb\u00e1n|malajalam|abh\u00e1z|maced\u00f3n|afar|szom\u00e1li|sona|maori|sk\u00f3t (gael)|szamoai|szlov\u00e9n|madagaszk\u00e1ri|szlov\u00e1k|\u00edr|joruba|szingal\u00e9z|szerb-horv\u00e1t|sango|zsid\u00f3|szindi|fr\u00edz|szanszkrit|francia|lett|litv\u00e1n|fer\u00f6eri|kiruanda|orosz|laoszi|fidzsi|lingala|finn|rom\u00e1n|kirundi|r\u00e9torom\u00e1n|perzsa|latin|hosza|baszk|kirgiz|\u00e9szt";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yyyy.MM.dd." },
    { "mediumDateFormat", "yyyy.MM.dd." },
    { "longDateFormat", "yyyy. MMMM d." },
    { "fullDateFormat", "yyyy. MMMM d." },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
