/* LocaleInformation_ar.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ar extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "LBP\u00A6KWD\u00A6TND\u00A6MAD\u00A6AED\u00A6BHD\u00A6QAR\u00A6DZD\u00A6LYD\u00A6SYP\u00A6JOD\u00A6IQD\u00A6YER\u00A6EGP\u00A6OMR\u00A6SAR\u00A6SDP";

  private static final String currenciesDisplayNameValues = "LBP\u00A6KWD\u00A6TND\u00A6MAD\u00A6AED\u00A6BHD\u00A6QAR\u00A6DZD\u00A6LYD\u00A6SYP\u00A6JOD\u00A6IQD\u00A6YER\u00A6EGP\u00A6OMR\u00A6SAR\u00A6SDP";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "LBP\u00A6KWD\u00A6TND\u00A6MAD\u00A6AED\u00A6BHD\u00A6QAR\u00A6DZD\u00A6LYD\u00A6SYP\u00A6JOD\u00A6IQD\u00A6YER\u00A6EGP\u00A6OMR\u00A6SAR\u00A6SDP";

  private static final String currenciesSymbolValues = "\u0644.\u0644.\u200f\u00A6\u062f.\u0643.\u200f\u00A6\u062f.\u062a.\u200f\u00A6\u062f.\u0645.\u200f\u00A6\u062f.\u0625.\u200f\u00A6\u062f.\u0628.\u200f\u00A6\u0631.\u0642.\u200f\u00A6\u062f.\u062c.\u200f\u00A6\u062f.\u0644.\u200f\u00A6\u0644.\u0633.\u200f\u00A6\u062f.\u0623.\u200f\u00A6\u062f.\u0639.\u200f\u00A6\u0631.\u064a.\u200f\u00A6\u062c.\u0645.\u200f\u00A6\u0631.\u0639.\u200f\u00A6\u0631.\u0633.\u200f\u00A6\u062c.\u0633.\u200f";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u064a\u0646\u0627\u064a\u0631",
    "\u0641\u0628\u0631\u0627\u064a\u0631",
    "\u0645\u0627\u0631\u0633",
    "\u0623\u0628\u0631\u064a\u0644",
    "\u0645\u0627\u064a\u0648",
    "\u064a\u0648\u0646\u064a\u0648",
    "\u064a\u0648\u0644\u064a\u0648",
    "\u0623\u063a\u0633\u0637\u0633",
    "\u0633\u0628\u062a\u0645\u0628\u0631",
    "\u0623\u0643\u062a\u0648\u0628\u0631",
    "\u0646\u0648\u0641\u0645\u0628\u0631",
    "\u062f\u064a\u0633\u0645\u0628\u0631",
    null,
  };

  private static final String[] months = {
    "\u064a\u0646\u0627\u064a\u0631",
    "\u0641\u0628\u0631\u0627\u064a\u0631",
    "\u0645\u0627\u0631\u0633",
    "\u0623\u0628\u0631\u064a\u0644",
    "\u0645\u0627\u064a\u0648",
    "\u064a\u0648\u0646\u064a\u0648",
    "\u064a\u0648\u0644\u064a\u0648",
    "\u0623\u063a\u0633\u0637\u0633",
    "\u0633\u0628\u062a\u0645\u0628\u0631",
    "\u0623\u0643\u062a\u0648\u0628\u0631",
    "\u0646\u0648\u0641\u0645\u0628\u0631",
    "\u062f\u064a\u0633\u0645\u0628\u0631",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u062d",
    "\u0646",
    "\u062b",
    "\u0631",
    "\u062e",
    "\u062c",
    "\u0633",
  };

  private static final String[] weekdays = {
    null,
    "\u0627\u0644\u0623\u062d\u062f",
    "\u0627\u0644\u0627\u062b\u0646\u064a\u0646",
    "\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621",
    "\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621",
    "\u0627\u0644\u062e\u0645\u064a\u0633",
    "\u0627\u0644\u062c\u0645\u0639\u0629",
    "\u0627\u0644\u0633\u0628\u062a",
  };

  private static final String[] eras = {
    "\u0642.\u0645",
    "\u0645",
  };

  private static final String[] ampms = {
    "\u0635",
    "\u0645",
  };


  private static final String territoriesKeys = "TJ\u00A6TH\u00A6TG\u00A6GY\u00A6TD\u00A6GW\u00A6GT\u00A6GR\u00A6GQ\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6SV\u00A6ST\u00A6GH\u00A6SR\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SI\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FM\u00A6RW\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6DE\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6CZ\u00A6PE\u00A6CY\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CH\u00A6CG\u00A6CF\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6AZ\u00A6NE\u00A6ZM\u00A6AU\u00A6NA\u00A6AT\u00A6AR\u00A6MZ\u00A6AO\u00A6MY\u00A6MX\u00A6AM\u00A6MW\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MR\u00A6AG\u00A6AF\u00A6AE\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6TW\u00A6TV\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "\u062a\u0627\u062c\u064a\u0643\u0633\u062a\u0627\u0646\u00A6\u062a\u0627\u064a\u0644\u0646\u062f\u00A6\u062a\u0648\u063a\u0648\u00A6\u063a\u0648\u0627\u064a\u0627\u0646\u0627\u00A6\u062a\u0634\u0627\u062f\u00A6\u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648\u00A6\u063a\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627\u00A6\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u00A6\u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0627\u0633\u062a\u0648\u0627\u0626\u064a\u0629\u00A6\u0633\u0648\u0627\u0632\u064a\u0644\u0627\u0646\u062f\u00A6\u0633\u0648\u0631\u064a\u0629\u00A6\u063a\u064a\u0646\u064a\u0627\u00A6\u063a\u0627\u0645\u0628\u064a\u0627\u00A6\u0627\u0644\u0633\u0644\u0641\u0627\u062f\u0648\u0631\u00A6\u0633\u0627\u0646 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a\u00A6\u063a\u0627\u0646\u0627\u00A6\u0633\u0648\u0631\u064a\u0646\u0627\u0645\u00A6\u062c\u0648\u0631\u062c\u064a\u0627\u00A6\u0627\u0644\u0635\u0648\u0645\u0627\u0644\u00A6\u063a\u0631\u064a\u0646\u0627\u062f\u0627\u00A6\u0627\u0644\u0633\u0646\u063a\u0627\u0644\u00A6\u0633\u0627\u0646 \u0645\u0627\u0631\u064a\u0646\u0648\u00A6\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629\u00A6\u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646\u00A6\u063a\u0627\u0628\u0648\u0646\u00A6\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627\u00A6\u0633\u0644\u0648\u0641\u064a\u0646\u064a\u0627\u00A6\u0633\u0646\u063a\u0627\u0641\u0648\u0631\u0629\u00A6\u0627\u0644\u0633\u0648\u064a\u062f\u00A6\u0627\u0644\u0633\u0648\u062f\u0627\u0646\u00A6\u0633\u064a\u0634\u0644\u00A6\u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646\u00A6\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629\u00A6\u0641\u0631\u0646\u0633\u0627\u00A6\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0627\u00A6\u0631\u0648\u0627\u0646\u062f\u0627\u00A6\u0631\u0648\u0633\u064a\u0627\u00A6\u0641\u064a\u062c\u064a\u00A6\u0641\u0646\u0644\u0646\u062f\u0627\u00A6\u0631\u0648\u0645\u0627\u0646\u064a\u0627\u00A6\u0627\u062b\u064a\u0648\u0628\u064a\u0627\u00A6\u0627\u0633\u0628\u0627\u0646\u064a\u0627\u00A6\u0627\u0631\u062a\u064a\u0631\u064a\u0627\u00A6\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629\u00A6\u0645\u0635\u0631\u00A6\u0627\u0633\u062a\u0648\u0646\u064a\u0627\u00A6\u0627\u0643\u0648\u0627\u062f\u0648\u0631\u00A6\u0627\u0644\u062c\u0632\u0627\u0626\u0631\u00A6\u0642\u0637\u0631\u00A6\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u064a\u0629\u00A6\u0628\u0627\u0631\u0627\u063a\u0648\u0627\u064a\u00A6\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627\u00A6\u0628\u0627\u0644\u0627\u0648\u00A6\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643\u00A6\u062c\u064a\u0628\u0648\u062a\u064a\u00A6\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u00A6\u0627\u0644\u0645\u0627\u0646\u064a\u0627\u00A6\u0628\u0648\u0644\u0646\u062f\u0627\u00A6\u0627\u0644\u0628\u0627\u0643\u0633\u062a\u0627\u0646\u00A6\u0627\u0644\u0641\u064a\u0644\u0628\u064a\u0646\u00A6\u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629\u00A6\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062a\u0634\u064a\u0643\u00A6\u0628\u064a\u0631\u0648\u00A6\u0642\u0628\u0631\u0635\u00A6\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0627\u062e\u0636\u0631\u00A6\u0628\u0646\u0645\u0627\u00A6\u0643\u0648\u0628\u0627\u00A6\u0643\u0648\u0633\u062a\u0627\u0631\u064a\u0643\u0627\u00A6\u0643\u0648\u0644\u0648\u0645\u0628\u064a\u0627\u00A6\u0627\u0644\u0635\u064a\u0646\u00A6\u0627\u0644\u0643\u0627\u0645\u064a\u0631\u0648\u0646\u00A6\u062a\u0634\u064a\u0644\u064a\u00A6\u0633\u0648\u064a\u0633\u0631\u0627\u00A6\u0627\u0644\u0643\u0648\u0646\u063a\u0648\u00A6\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649\u00A6\u0639\u0645\u0627\u0646\u00A6\u0643\u0646\u062f\u0627\u00A6\u0628\u0644\u064a\u0632\u00A6\u0631\u0648\u0633\u064a\u0627 \u0627\u0644\u0628\u064a\u0636\u0627\u0621\u00A6\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627\u00A6\u0628\u0648\u062a\u0627\u0646\u00A6\u0627\u0644\u0628\u0647\u0627\u0645\u0627\u00A6\u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644\u00A6\u0632\u064a\u0644\u0646\u062f\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629\u00A6\u0628\u0648\u0644\u064a\u0641\u064a\u0627\u00A6\u0628\u0631\u0648\u0646\u0627\u064a\u00A6\u0628\u0646\u064a\u0646\u00A6\u0628\u0648\u0631\u0648\u0646\u062f\u064a\u00A6\u0627\u0644\u0628\u062d\u0631\u064a\u0646\u00A6\u0646\u0627\u0648\u0631\u0648\u00A6\u0628\u0644\u063a\u0627\u0631\u064a\u0627\u00A6\u0628\u0648\u0631\u0643\u064a\u0646\u0627 \u0641\u0627\u0633\u0648\u00A6\u0627\u0644\u0646\u064a\u0628\u0627\u0644\u00A6\u0628\u0644\u062c\u064a\u0643\u0627\u00A6\u0627\u0644\u0646\u0631\u0648\u064a\u062c\u00A6\u0628\u0646\u063a\u0644\u0627\u062f\u064a\u0634\u00A6\u0628\u0631\u0628\u0627\u062f\u0648\u0633\u00A6\u0632\u064a\u0645\u0628\u0627\u0628\u0648\u064a\u00A6\u0647\u0648\u0644\u0646\u062f\u0627\u00A6\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643\u00A6\u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627\u00A6\u0646\u064a\u062c\u064a\u0631\u064a\u0627\u00A6\u0622\u0630\u0631\u0628\u064a\u062c\u0627\u0646\u00A6\u0627\u0644\u0646\u064a\u062c\u0631\u00A6\u0632\u0627\u0645\u0628\u064a\u0627\u00A6\u0627\u0633\u062a\u0631\u0627\u0644\u064a\u0627\u00A6\u0646\u0627\u0645\u064a\u0628\u064a\u0627\u00A6\u0627\u0644\u0646\u0645\u0633\u0627\u00A6\u0627\u0644\u0627\u0631\u062c\u0646\u062a\u064a\u0646\u00A6\u0645\u0648\u0632\u0645\u0628\u064a\u0642\u00A6\u0627\u0646\u063a\u0648\u0644\u0627\u00A6\u0645\u0627\u0644\u064a\u0632\u064a\u0627\u00A6\u0627\u0644\u0645\u0643\u0633\u064a\u0643\u00A6\u0627\u0631\u0645\u064a\u0646\u064a\u0627\u00A6\u0645\u0644\u0627\u0648\u064a\u00A6\u0645\u0627\u0644\u062f\u064a\u0641\u00A6\u062c\u0646\u0648\u0628 \u0627\u0641\u0631\u064a\u0642\u064a\u0627\u00A6\u0645\u0648\u0631\u064a\u0634\u0648\u0633\u00A6\u0645\u0627\u0644\u0637\u0629\u00A6\u0627\u0644\u0628\u0627\u0646\u064a\u0627\u00A6\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627\u00A6\u0627\u0646\u062a\u064a\u063a\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062f\u0627\u00A6\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646\u00A6\u0627\u0644\u0627\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629\u00A6\u0627\u0646\u062f\u0648\u0631\u0627\u00A6\u0645\u0646\u063a\u0648\u0644\u064a\u0627\u00A6\u0645\u064a\u0627\u0646\u0645\u0627\u0631\u00A6\u0645\u0627\u0644\u064a\u00A6\u0645\u0642\u062f\u0648\u0646\u064a\u0627\u00A6\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0631\u0634\u0627\u0644\u00A6\u0645\u062f\u063a\u0634\u0642\u0631\u00A6\u0645\u0648\u0644\u062f\u0648\u0641\u0627\u00A6\u0645\u0648\u0646\u0627\u0643\u0648\u00A6\u0627\u0644\u0645\u063a\u0631\u0628\u00A6\u0627\u0644\u064a\u0645\u0646\u00A6\u0644\u064a\u0628\u064a\u0627\u00A6\u0644\u0627\u062a\u0641\u064a\u0627\u00A6\u0644\u0648\u0643\u0633\u0648\u0645\u0628\u0631\u063a\u00A6\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0627\u00A6\u0644\u064a\u0633\u0648\u062a\u0648\u00A6\u0644\u064a\u0628\u064a\u0631\u064a\u0627\u00A6\u0633\u0631\u064a \u0644\u0627\u0646\u0643\u0627\u00A6\u0644\u064a\u062e\u062a\u0646\u0634\u062a\u0627\u064a\u0646\u00A6\u0633\u0627\u0646\u062a \u0644\u0648\u0633\u064a\u0627\u00A6\u0644\u0628\u0646\u0627\u0646\u00A6\u0644\u0627\u0648\u0633\u00A6\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646\u00A6\u0627\u0644\u0643\u0648\u064a\u062a\u00A6\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629\u00A6\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629\u00A6\u0633\u0627\u0646\u062a \u0643\u064a\u062a\u0633 \u0648\u0646\u064a\u0641\u064a\u0633\u00A6\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631\u00A6\u0643\u064a\u0631\u064a\u0628\u0627\u062a\u064a\u00A6\u0633\u0627\u0645\u0648\u0627\u00A6\u0643\u0645\u0628\u0648\u062f\u064a\u0627\u00A6\u0642\u064a\u0631\u063a\u064a\u0632\u0633\u062a\u0627\u0646\u00A6\u0643\u064a\u0646\u064a\u0627\u00A6\u0627\u0644\u064a\u0627\u0628\u0627\u0646\u00A6\u0627\u0644\u0627\u0631\u062f\u0646\u00A6\u062c\u0627\u0645\u0627\u064a\u0643\u0627\u00A6\u0641\u0627\u0646\u0648\u0622\u062a\u0648\u00A6\u0641\u064a\u062a\u0646\u0627\u0645\u00A6\u0641\u0646\u0632\u0648\u064a\u0644\u0627\u00A6\u0633\u0627\u0646\u062a \u0641\u0646\u0633\u0646\u062a \u0648\u062c\u0632\u0631 \u063a\u0631\u064a\u0646\u0627\u062f\u064a\u0646\u00A6\u0627\u0644\u0641\u0627\u062a\u064a\u0643\u0627\u0646\u00A6\u0627\u064a\u0637\u0627\u0644\u064a\u0627\u00A6\u0627\u064a\u0633\u0644\u0646\u062f\u0627\u00A6\u0627\u064a\u0631\u0627\u0646\u00A6\u0627\u0644\u0639\u0631\u0627\u0642\u00A6\u0627\u0632\u0628\u0643\u0633\u062a\u0627\u0646\u00A6\u0627\u0631\u0648\u063a\u0648\u0627\u064a\u00A6\u0627\u0644\u0647\u0646\u062f\u00A6\u0627\u0633\u0631\u0627\u0626\u064a\u0644\u00A6\u0627\u0644\u0627\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629 \u0627\u0644\u0627\u0645\u0631\u064a\u0643\u064a\u0629\u00A6\u0627\u064a\u0631\u0644\u0646\u062f\u0627\u00A6\u0627\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0627\u00A6\u0627\u0648\u063a\u0646\u062f\u0627\u00A6\u0627\u0648\u0643\u0631\u0627\u0646\u064a\u0627\u00A6\u0647\u0646\u063a\u0627\u0631\u064a\u0627\u00A6\u0647\u0627\u064a\u062a\u064a\u00A6\u0643\u0631\u0648\u0627\u062a\u064a\u0627\u00A6\u062a\u0627\u0646\u0632\u0627\u0646\u064a\u0627\u00A6\u0647\u0646\u062f\u0648\u0631\u0627\u0633\u00A6\u062a\u0627\u064a\u0648\u0627\u0646\u00A6\u062a\u0648\u0641\u0627\u0644\u0648\u00A6\u062a\u0631\u064a\u0646\u064a\u062f\u0627\u062f \u0648\u062a\u0648\u0628\u0627\u063a\u0648\u00A6\u062a\u0631\u0643\u064a\u0627\u00A6\u062a\u0648\u0646\u063a\u0627\u00A6\u062a\u0648\u0646\u0633\u00A6\u062a\u0631\u0643\u0645\u0627\u0646\u0633\u062a\u0627\u0646";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es\u00A6ku\u00A6eo\u00A6ks\u00A6en\u00A6el\u00A6ko\u00A6km\u00A6dz\u00A6smi\u00A6dv\u00A6syr\u00A6pt\u00A6ps\u00A6de\u00A6pl\u00A6da\u00A6cop\u00A6ja\u00A6vi\u00A6cy\u00A6pa\u00A6cs\u00A6it\u00A6ce\u00A6ur\u00A6ca\u00A6id\u00A6uk\u00A6ug\u00A6egy\u00A6hy\u00A6bs\u00A6hu\u00A6ht\u00A6bo\u00A6bn\u00A6hr\u00A6bg\u00A6ang\u00A6tt\u00A6be\u00A6hi\u00A6tr\u00A6nl\u00A6he\u00A6tl\u00A6bal\u00A6ne\u00A6az\u00A6th\u00A6zh\u00A6ar\u00A6gu\u00A6my\u00A6ira\u00A6mt\u00A6ms\u00A6sw\u00A6sv\u00A6af\u00A6mn\u00A6sr\u00A6sq\u00A6ab\u00A6aa\u00A6fr\u00A6lv\u00A6lt\u00A6ru\u00A6afa\u00A6fj\u00A6fi\u00A6ro\u00A6ber\u00A6arc\u00A6fa\u00A6la\u00A6et";

  private static final String languagesValues = "\u0627\u0644\u0627\u0633\u0628\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0643\u0631\u062f\u064a\u0629\u00A6\u0627\u0633\u0628\u0631\u0627\u0646\u062a\u0648\u00A6\u0627\u0644\u0643\u0627\u0634\u0645\u064a\u0631\u064a\u0629\u00A6\u0627\u0644\u0627\u0646\u062c\u0644\u064a\u0632\u064a\u0629\u00A6\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0643\u0648\u0631\u064a\u0629\u00A6\u0627\u0644\u062e\u0645\u064a\u0631\u064a\u0629\u00A6\u0627\u0644\u0632\u0648\u0646\u062e\u0627\u064a\u0629\u00A6\u0627\u0644\u0644\u063a\u0627\u062a \u0627\u0644\u0633\u0627\u0645\u064a\u0629\u00A6\u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641\u064a\u0629\u00A6\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629\u00A6\u0627\u0644\u0628\u0634\u062a\u0648\u0646\u064a\u0629\u00A6\u0627\u0644\u0627\u0644\u0645\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0628\u0648\u0644\u0648\u0646\u064a\u0629\u00A6\u0627\u0644\u062f\u0627\u0646\u0645\u0627\u0631\u0643\u064a\u0629\u00A6\u0642\u0628\u0637\u064a\u0629\u00A6\u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0641\u064a\u062a\u0646\u0627\u0645\u064a\u0629\u00A6\u0627\u0644\u0648\u0644\u0632\u064a\u0629\u00A6\u0627\u0644\u0628\u0646\u062c\u0627\u0628\u064a\u0629\u00A6\u0627\u0644\u062a\u0634\u064a\u0643\u064a\u0629\u00A6\u0627\u0644\u0627\u064a\u0637\u0627\u0644\u064a\u0629\u00A6\u0627\u0644\u0634\u064a\u0634\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0627\u0631\u062f\u064a\u0629\u00A6\u0627\u0644\u0643\u0627\u062a\u0627\u0644\u0648\u064a\u0646\u064a\u0629\u00A6\u0627\u0644\u0627\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0629\u00A6\u0627\u0644\u0627\u0648\u0643\u0631\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0627\u063a\u0648\u0631\u064a\u0629\u00A6\u0645\u0635\u0631\u064a\u0629\u060c \u0642\u062f\u064a\u0645\u0629\u00A6\u0627\u0644\u0627\u0631\u0645\u0646\u064a\u0629\u00A6\u0627\u0644\u0628\u0648\u0633\u0646\u064a\u0629\u00A6\u0627\u0644\u0647\u0646\u063a\u0627\u0631\u064a\u0629\u00A6\u0627\u0644\u0647\u0627\u064a\u062a\u064a\u0629\u00A6\u0627\u0644\u062a\u0628\u062a\u064a\u0629\u00A6\u0627\u0644\u0628\u0646\u063a\u0627\u0644\u064a\u0629\u00A6\u0627\u0644\u0643\u0631\u0648\u0627\u062a\u064a\u0629\u00A6\u0627\u0644\u0628\u0644\u063a\u0627\u0631\u064a\u0629\u00A6\u0627\u0646\u0643\u0644\u064a\u0632\u064a\u0629\u060c \u0642\u062f\u064a\u0645\u00A6\u0627\u0644\u062a\u062a\u0631\u064a\u0629\u00A6\u0627\u0644\u0628\u064a\u0644\u0648\u0631\u0648\u0633\u064a\u0629\u00A6\u0627\u0644\u0647\u0646\u062f\u064a\u0629\u00A6\u0627\u0644\u062a\u0631\u0643\u064a\u0629\u00A6\u0627\u0644\u0647\u0648\u0644\u0646\u062f\u064a\u0629\u00A6\u0627\u0644\u0639\u0628\u0631\u064a\u0629\u00A6\u0627\u0644\u062a\u0627\u063a\u0627\u0644\u0648\u063a\u064a\u0629\u00A6\u0627\u0644\u0628\u0644\u0648\u0634\u064a\u0629\u00A6\u0627\u0644\u0646\u064a\u0628\u0627\u0644\u064a\u0629\u00A6\u0627\u0630\u0631\u064a\u0629\u00A6\u0627\u0644\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a\u0629\u00A6\u0627\u0644\u0635\u064a\u0646\u064a\u0629\u00A6\u0627\u0644\u0639\u0631\u0628\u064a\u0629\u00A6\u0627\u0644\u063a\u0648\u062c\u0627\u0631\u0627\u062a\u064a\u0629\u00A6\u0627\u0644\u0628\u0648\u0631\u0645\u064a\u0629\u00A6\u0627\u0644\u0627\u064a\u0631\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0645\u0627\u0644\u0637\u064a\u0629\u00A6\u0644\u063a\u0629 \u0627\u0644\u0645\u0644\u0627\u064a\u0648\u00A6\u0627\u0644\u0633\u0648\u0627\u062d\u0644\u064a\u0629\u00A6\u0627\u0644\u0633\u0648\u064a\u062f\u064a\u0629\u00A6\u0627\u0644\u0627\u0641\u0631\u064a\u0642\u064a\u0629\u00A6\u0627\u0644\u0645\u0646\u063a\u0648\u0644\u064a\u0629\u00A6\u0627\u0644\u0635\u0631\u0628\u064a\u0629\u00A6\u0627\u0644\u0627\u0644\u0628\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0627\u0628\u062e\u0627\u0632\u064a\u0629\u00A6\u0627\u0644\u0627\u0641\u0627\u0631\u064a\u0629\u00A6\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629\u00A6\u0627\u0644\u0644\u0627\u062a\u0641\u064a\u0629\u00A6\u0627\u0644\u0644\u062a\u0648\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0631\u0648\u0633\u064a\u0629\u00A6\u0627\u0641\u0631\u0648-\u0627\u0633\u064a\u0648\u064a\u0629\u00A6\u0627\u0644\u0641\u064a\u062c\u064a\u0629\u00A6\u0627\u0644\u0641\u0646\u0644\u0646\u062f\u064a\u0629\u00A6\u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629\u00A6\u0627\u0644\u0628\u0631\u0628\u0631\u064a\u0629\u00A6\u0627\u0644\u0627\u0631\u0627\u0645\u064a\u0629\u00A6\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629\u00A6\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629\u00A6\u0627\u0633\u062a\u0648\u0646\u064a\u0629";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "percent", "\u066a" },
    { "zeroDigit", "\u0660" },
    { "decimalSeparator", "\u066b" },
    { "groupingSeparator", "\u066c" },
    { "currencyFormat", "\u00a4 #,##0.00;\u00a4 #,##0.00-" },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "firstDayOfWeek", "sat" },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "d/M/yyyy" },
    { "mediumDateFormat", "dd/MM/yyyy" },
    { "longDateFormat", "d MMMM, yyyy" },
    { "fullDateFormat", "EEEE, d MMMM, yyyy" },
    { "shortTimeFormat", "h:mm a" },
    { "mediumTimeFormat", "h:mm:ss a" },
    { "longTimeFormat", "h:mm:ss a" },
    { "fullTimeFormat", "z h:mm:ss a" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
