;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2019 Ivan Petkov <ivanppetkov@gmail.com>
;;; Copyright © 2019, 2020, 2021 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2019, 2020, 2021 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2019 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2019, 2020 John Soo <jsoo1@asu.edu>
;;; Copyright © 2019, 2020 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 Leo Famulari <leo@famulari.name>
;;; Copyright © 2020 Gabriel Arazas <foo.dogsquared@gmail.com>
;;; Copyright © 2020 André Batista <nandre@riseup.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2021 aecepoglu <aecepoglu@fastmail.fm>
;;; Copyright © 2021 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2021 Alexandru-Sergiu Marton <brown121407@posteo.ro>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages crates-io)
  #:use-module (guix build-system cargo)
  #:use-module (guix download)
  #:use-module (guix git-download)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix utils)
  #:use-module (gnu packages)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages crates-graphics)
  #:use-module (gnu packages crates-gtk)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages jemalloc)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages nettle)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages python)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg))

;;;
;;; Please: Try to add new module packages in alphabetic order.
;;;

(define-public rust-ab-glyph-rasterizer-0.1
  (package
    (name "rust-ab-glyph-rasterizer")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ab_glyph_rasterizer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zzz78231w849xslz9s0pwjj6gp02wfbbxdpysqhwwq1vqr5xznr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/alexheretic/ab-glyph")
    (synopsis "Coverage rasterization for lines, quadratic & cubic beziers")
    (description
     "This package provides coverage rasterization for lines, quadratic and
cubic beziers.")
    (license license:asl2.0)))

(define-public rust-abomonation-0.7
  (package
    (name "rust-abomonation")
    (version "0.7.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "abomonation" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1cjg3hjf028n447pdj7zcdgrkngx30as8ndxlxx947wvr49jkrsn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-recycler" ,rust-recycler-0.1))))
    (home-page "https://github.com/TimelyDataflow/abomonation")
    (synopsis "High performance and very unsafe serialization library")
    (description
     "This package provides a high performance and very unsafe serialization
library in Rust.")
    (license license:expat)))

(define-public rust-actix-0.10
  (package
    (name "rust-actix")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q6cd08d0xikilj9l3gfsyhva5b91y55lfxy7yd7w7ivizw43qhv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;doc test fails
       #:cargo-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-derive" ,rust-actix-derive-0.5)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.19)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.19))))
    (home-page "https://actix.rs")
    (synopsis "Actor framework for Rust")
    (description "This package provides Actix actor framework for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-codec-0.3
  (package
    (name "rust-actix-codec")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w7506qd2f8q83z6l5lqx1363ks0ysx8f7qgvy8fknrq70xq7lbq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3))))
    (home-page "https://actix.rs")
    (synopsis "Codec utilities for working with framed protocols")
    (description
     "This package provides codec utilities for working with framed
protocols.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-codec-0.2
  (package
    (inherit rust-actix-codec-0.3)
    (name "rust-actix-codec")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100k0n155fnnjqjz2s1gnwim2fp7s1mw942x0famg89cbh55zr89"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.2))))))

(define-public rust-actix-connect-2
  (package
    (name "rust-actix-connect")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-connect" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1p6hh5rj9zpx4wx0h87d56ahk68hmhpw2gmfsfl5pwb312hkfy0p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.19)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.19)
        ("rust-webpki" ,rust-webpki-0.21))))
    (home-page "https://actix.rs")
    (synopsis "TCP connector service for Actix ecosystem")
    (description
     "This package provides a TCP connector service for Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-connect-1
  (package
    (inherit rust-actix-connect-2)
    (name "rust-actix-connect")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-connect" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v77m394gzbrrzg12xkqgli11vwhig0zcxy3yhmq1s91j9bcjp69"))))
    (arguments
     ;; XXX: The crate fails to't build with: "error[E0432]: unresolved import
     ;; `trust_dns_resolver::Background`".  I assume it really expects
     ;; trust-dns-resolver at version 0.18-alpha.2, which we do not provide.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.18)
        ("rust-trust-dns-resolver" ,rust-trust-dns-resolver-0.18)
        ("rust-webpki" ,rust-webpki-0.21))
       #:cargo-development-inputs
       (("rust-actix-testing" ,rust-actix-testing-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-version-requirements
           (lambda _
             (substitute* "Cargo.toml"
               (("0.18.0-alpha.2")
                ,(package-version rust-trust-dns-proto-0.18)))
             #t)))))))

(define-public rust-actix-derive-0.5
  (package
    (name "rust-actix-derive")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k1kg4gkp2jhi5fgdfd0cq2qfbyy3gfgwqjrvzq1hzrjmynwwnmr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;bootsrapping issues with rust-actix
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       ;; #:cargo-development-inputs
       ;; (("rust-actix" ,rust-actix-0.8))
       ))
    (home-page "https://github.com/actix/actix-derive/")
    (synopsis "Proc macros for Actix Rust actor framework")
    (description
     "This package provides proc macros for the Rust actor framework Actix.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-http-2
  (package
    (name "rust-actix-http")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x78h9lzqdhp06v1kf4dhbiqp8sc911w4lqfj5rmdbhpg3l9j8j5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix" ,rust-actix-0.10)
        ("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-connect" ,rust-actix-connect-2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-2)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-cookie" ,rust-cookie-0.14)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-pin-project" ,rust-pin-project-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://actix.rs")
    (synopsis "HTTP primitives for the Actix ecosystem")
    (description
     "This package provides HTTP primitives for the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-http-1
  (package
    (inherit rust-actix-http-2)
    (name "rust-actix-http")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06chrs9asbxmxzgiw5sw7ky97yrin9g88nmd6w407a6y9z668rn1"))))
    ;; XXX: The crate fails to't build with with the same error as
    ;; rust-actix-connect.  Skip build for now.
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-connect" ,rust-actix-connect-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-brotli2" ,rust-brotli2-0.3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-ring" ,rust-ring-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1))
       #:cargo-development-inputs
       (("rust-actix-http-test" ,rust-actix-http-test-1))))))

(define-public rust-actix-http-test-1
  (package
    (name "rust-actix-http-test")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-http-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06z6iy9ffsjcw3g8zwwghky5zpyg7c1z823x35lgc4y1yjzxfizq"))))
    (build-system cargo-build-system)
    (arguments
     ;; XXX: The crate fails to't build with with the same error as
     ;; rust-actix-connect.  Skip build for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-connect" ,rust-actix-connect-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-awc" ,rust-awc-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-sha1" ,rust-sha1-0.6)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-time" ,rust-time-0.1))
       #:cargo-development-inputs
       (("rust-actix-http" ,rust-actix-http-1))))
    (home-page "https://actix.rs")
    (synopsis "Helpers for Actix applications to use during testing")
    (description
     "This package provides various helpers for Actix applications to use
during testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-macros-0.1
  (package
    (name "rust-actix-macros")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mfnprr8gy1gb5xcr18iwsv781hysvh7sr5xxg6ghyi61gh8rjml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix runtime macros")
    (description "This package provides Actix runtime macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-router-0.2
  (package
    (name "rust-actix-router")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-router" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0df2626hk4n4yki6j88v3k0gcm8pi5hdnm1mldyvyi8nvbdzgldv"))))
    (build-system cargo-build-system)
    (arguments
     ;; Tests fail with "error[E0432]: unresolved import `serde_derive`".
     `(#:tests? #false
       #:cargo-inputs
       (("rust-bytestring" ,rust-bytestring-0.1)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://actix.rs")
    (synopsis "Resource path matching library")
    (description "This package provides resource path matching library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-rt-1
  (package
    (name "rust-actix-rt")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-rt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09xj7pxy0ng13rd6hya1md98dhk0586p4bsfrwmxxlg028lwqgql"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-copyless" ,rust-copyless-0.1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://actix.rs")
    (synopsis "Actix runtime")
    (description "This package provides Actix runtime.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-server-1
  (package
    (name "rust-actix-server")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-server" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13khzd6pz9pqksxmw2syipfwq2gi5v9warx6pa24g8iccxp7wh25"))))
    (build-system cargo-build-system)
    (arguments
     ;; Tests fail with "error[E0432]: unresolved import `bytes`" error.
     `(#:tests? #false
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-socket2" ,rust-socket2-0.3))))
    (home-page "https://actix.rs")
    (synopsis "General purpose TCP server built for the Actix ecosystem")
    (description
     "This package provides a general purpose TCP server built for the Actix
ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-service-1
  (package
    (name "rust-actix-service")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-service" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fw2b1cpxrpqk778mpvxv0cazj0pwjyb6khzs4syhnqvb1fl6lh0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-pin-project" ,rust-pin-project-0.4))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://actix.rs")
    (synopsis
     "Service trait and combinators for asynchronous request/response")
    (description
     "This package provides a service trait and combinators for representing
asynchronous request/response operations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-testing-1
  (package
    (name "rust-actix-testing")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-testing" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "073r3rlnz9km7w7zfhpj6snb453hhp7d354adbp79awrhyirq8s7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-socket2" ,rust-socket2-0.3))))
    (home-page "https://actix.rs")
    (synopsis "Actix testing utils")
    (description "This package provides Actix testing utils.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-threadpool-0.3
  (package
    (name "rust-actix-threadpool")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-threadpool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c0frk19ml94d01mvgv5g60mhq86gfi34c3lsfpvjm18016z02fj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix thread pool for sync code")
    (description "This package provides Actix thread pool for sync code.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-tls-2
  (package
    (name "rust-actix-tls")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yqmlyn02c72a1rrmjkfx5hnz286130y3sq4ll1mbkv1fdyrny14"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.20))))
    (home-page "https://actix.rs")
    (synopsis "TLS acceptor services for Actix ecosystem")
    (description
     "This package provides TLS acceptor services for Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-tls-1
  (package
    (inherit rust-actix-tls-2)
    (name "rust-actix-tls")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a4m96jz6vzmknpk5m803c337c6dillnqq4w71nrlphhmzxb9rd4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-openssl" ,rust-tokio-openssl-0.4)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))
       #:cargo-development-inputs
       (("rust-actix-testing" ,rust-actix-testing-1))))))

(define-public rust-actix-utils-2
  (package
    (name "rust-actix-utils")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nkby6wpwcmjr3zcghd962l2hyjry0aayncyjzbx2ck6qpg2541f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-either" ,rust-either-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-slab" ,rust-slab-0.4))))
    (home-page "https://actix.rs")
    (synopsis "Network related services and utilities for the Actix ecosystem")
    (description
     "This package provides various network related services and utilities for
the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-utils-1
  (package
    (inherit rust-actix-utils-2)
    (name "rust-actix-utils")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kkz2hfz8r2k1gxcjk2qq1h1qxlb487g023q4v1dw6ph3dizby7w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-either" ,rust-either-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-slab" ,rust-slab-0.4))))))

(define-public rust-actix-web-3
  (package
    (name "rust-actix-web")
    (version "3.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11kv8y1p9dw78lnhrw3rqavhmazmy7s0z8j14a3a1yp7fahx8hg6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-http" ,rust-actix-http-2)
        ("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-router" ,rust-actix-router-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-2)
        ("rust-actix-utils" ,rust-actix-utils-2)
        ("rust-actix-web-codegen" ,rust-actix-web-codegen-0.4)
        ("rust-awc" ,rust-awc-2)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-pin-project" ,rust-pin-project-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-time" ,rust-time-0.2)
        ("rust-tinyvec" ,rust-tinyvec-1)
        ("rust-url" ,rust-url-2))))
    (home-page "https://actix.rs")
    (synopsis "Powerful, pragmatic, and fast web framework for Rust")
    (description
     "Actix Web is a powerful, pragmatic, and fast web framework for
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-web-2
  (package
    (inherit rust-actix-web-3)
    (name "rust-actix-web")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dgnn7xiw2yhvrx7l7b57gwra7yfqawka5xz1lpq4h0h8qifhn1i"))))
    (arguments
     ;; XXX: The crate fails to't build with with the same error as
     ;; rust-actix-connect.  Skip build for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-http" ,rust-actix-http-1)
        ("rust-actix-macros" ,rust-actix-macros-0.1)
        ("rust-actix-router" ,rust-actix-router-0.2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-server" ,rust-actix-server-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-actix-testing" ,rust-actix-testing-1)
        ("rust-actix-threadpool" ,rust-actix-threadpool-0.3)
        ("rust-actix-tls" ,rust-actix-tls-1)
        ("rust-actix-utils" ,rust-actix-utils-1)
        ("rust-actix-web-codegen" ,rust-actix-web-codegen-0.2)
        ("rust-awc" ,rust-awc-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-2))))))

(define-public rust-actix-web-codegen-0.4
  (package
    (name "rust-actix-web-codegen")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ys3f6q0hgflqvp271s49q88m41db3iynm7ydxy0wgikjdqgf9md"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://actix.rs")
    (synopsis "Actix web proc macros")
    (description "This package provides Actix web proc macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-actix-web-codegen-0.2
  (package
    (inherit rust-actix-web-codegen-0.4)
    (name "rust-actix-web-codegen")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "actix-web-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rjpzwsm51nfjqsz269jwbkiic9d454bnsk9ng882wp0rdsz86x7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-web" ,rust-actix-web-2))))))

(define-public rust-adaptive-barrier-0.1
  (package
    (name "rust-adaptive-barrier")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adaptive-barrier" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "003ygsiqsd85v0p846q1ym23dbp4iagn89p7k6yrvbg9di1mbjqc"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/vorner/adaptive-barrier")
    (synopsis "Barrier with adaptable number of thread subsciptions")
    (description
     "This is a Barrier synchronization primitive, similar to
@code{std::sync::Barrier}, but one that adjusts the expected number of
threads.  This makes it robust in face of panics (it won't make your program
deadlock, like the standard Barrier).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-addr2line-0.14
  (package
    (name "rust-addr2line")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "addr2line" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xs5bsi40zpyxbbylyaysya5h36ykcbg91i82415sxw5wk7q4px5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.3)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-gimli" ,rust-gimli-0.23)
        ("rust-object" ,rust-object-0.22)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-smallvec" ,rust-smallvec-1))))
    (home-page "https://github.com/gimli-rs/addr2line")
    (synopsis "Symbolication library written in Rust, using gimli")
    (description
     "This package provides a cross-platform symbolication library written in
Rust, using gimli.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-addr2line-0.11
  (package
    (inherit rust-addr2line-0.14)
    (name "rust-addr2line")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "addr2line" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0sk5g8cb2yynlcm0wcqff9l9c9ml69rqgfrrbii0ybgdc236jkhw"))))
    (arguments
     `(#:tests? #f      ; Not all test files included.
       #:cargo-inputs
       (("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-object" ,rust-object-0.17)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.2)
        ("rust-gimli" ,rust-gimli-0.20)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-lazycell" ,rust-lazycell-1))
       #:cargo-development-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-clap" ,rust-clap-2)
        ("rust-findshlibs" ,rust-findshlibs-0.5)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-rustc-test" ,rust-rustc-test-0.3))))))

(define-public rust-addr2line-0.9
  (package
    (inherit rust-addr2line-0.11)
    (name "rust-addr2line")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "addr2line" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17rlf04nx3g3rcy661v24ksnmpk6vqn680g5b5sp8lk20iih2xnx"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cpp-demangle" ,rust-cpp-demangle-0.2)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-gimli" ,rust-gimli-0.18)
        ("rust-intervaltree" ,rust-intervaltree-0.2)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-object" ,rust-object-0.12)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-smallvec" ,rust-smallvec-0.6))
       #:cargo-development-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-clap" ,rust-clap-2)
        ;("rust-findshlibs" ,rust-findshlibs-0.4)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-rustc-test" ,rust-rustc-test-0.3))))))

(define-public rust-adler-0.2
  (package
    (name "rust-adler")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adler" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zpdsrfq5bd34941gmrlamnzjfbsx0x586afb7b0jqhr8g1lwapf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/jonas-schievink/adler")
    (synopsis "Implementation of the Adler-32 checksum")
    (description
     "This crate provides a simple implementation of the Adler-32
checksum, used in the zlib compression format.")
    (license
     (list license:expat
           license:asl2.0
           (license:non-copyleft "https://spdx.org/licenses/0BSD.html")))))

(define-public rust-adler32-1
  (package
    (name "rust-adler32")
    (version "1.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "adler32" version))
        (file-name
          (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0bgks405vz823bphgwhj4l9h6vpfh900s0phfk4qqijyh9xhfysn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/remram44/adler32-rs")
    (synopsis "Implementation of the Adler32 rolling hash algorithm")
    (description
     "This library is an implementation of the Adler32 rolling hash algorithm in
the Rust programming language.")
    (license (list license:bsd-3
                   license:zlib))))

(define-public rust-aead-0.3
  (package
    (name "rust-aead")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aead" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c8388alvivcj4qkxgh4s4l6fbczn3p8wc0pnar6crlfvcdmvjbz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.3)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-heapless" ,rust-heapless-0.5))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for Authenticated Encryption with Associated Data (AEAD)
algorithms")
    (description "This package provides traits for Authenticated Encryption
with Associated Data (AEAD) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aead-0.2
  (package
    (inherit rust-aead-0.3)
    (name "rust-aead")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aead" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r3ijikx9h117q0xgkc56yb0501kifjr3gsfp5bvnrz7asdipw2c"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.12)
        ("rust-heapless" ,rust-heapless-0.5))))))

(define-public rust-aes-0.4
  (package
    (name "rust-aes")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xgsp2bn5llsppald60iw4497gaspslg0a8hknhniiz4zmki607p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aes-soft" ,rust-aes-soft-0.4)
        ("rust-aesni" ,rust-aesni-0.7)
        ("rust-block-cipher" ,rust-block-cipher-0.7))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Facade for AES (Rijndael) block ciphers implementations")
    (description "This package provides a facade for AES (Rijndael) block
ciphers implementations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aes-0.3
  (package
    (inherit rust-aes-0.4)
    (name "rust-aes")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j90iwpax0y1dqq14i8y9xgpcnnlgnljwkxg3mhzrralwf7ivssl"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aes-soft" ,rust-aes-soft-0.3)
        ("rust-aesni" ,rust-aesni-0.6)
        ("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6))))))

(define-public rust-aes-gcm-0.6
  (package
    (name "rust-aes-gcm")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-gcm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lga8my3zlc0b1nhcpc1hrbykfm014fqs6d64bwrjqii05w01xc6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aead" ,rust-aead-0.3)
        ("rust-aes" ,rust-aes-0.4)
        ("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-ghash" ,rust-ghash-0.3)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-criterion-cycles-per-byte"
         ,rust-criterion-cycles-per-byte-0.1)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/RustCrypto/AEADs")
    (synopsis "AES-GCM (Galois/Counter Mode) Authenticated Encryption")
    (description "This package provides a pure Rust implementation of the
AES-GCM (Galois/Counter Mode) Authenticated Encryption with Associated
Data (AEAD) Cipher with optional architecture-specific hardware
acceleration.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-aes-gcm-0.5
  (package
    (inherit rust-aes-gcm-0.6)
    (name "rust-aes-gcm")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-gcm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f66b5bmyj38r1hj55wzamlzw3y1aql34lgwr2vxn93073d6njl3"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aead" ,rust-aead-0.2)
        ("rust-aes" ,rust-aes-0.3)
        ("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-ghash" ,rust-ghash-0.2)
        ("rust-subtle" ,rust-subtle-2)
        ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-aes-soft-0.4
  (package
    (name "rust-aes-soft")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-soft" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19szsg0qqxq42k7bj5p3svb147n8wxy9a20n4g7mcl2fwrz689a9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Bit-sliced implementation of AES (Rijndael) block ciphers")
    (description "This package provides a bit-sliced implementation of
AES (Rijndael) block ciphers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aes-soft-0.3
  (package
    (inherit rust-aes-soft-0.4)
    (name "rust-aes-soft")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aes-soft" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "039si7yjp0wcd750sgq52c60sh2ikaxwd7rq7g0ba7ws7ypfgmyg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))))))

(define-public rust-aesni-0.7
  (package
    (name "rust-aesni")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aesni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0r6j0mjkyqnwvgib01cvrwfw8rlx1biw75234niv723n1fdx6l6h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.4))
       #:cargo-development-inputs
       (("rust-block-cipher" ,rust-block-cipher-0.7)
        ("rust-stream-cipher" ,rust-stream-cipher-0.4))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "AES (Rijndael) block ciphers implementation using AES-NI")
    (description "This package provides an implementation of AES (Rijndael)
block ciphers using AES-NI.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aesni-0.6
  (package
    (inherit rust-aesni-0.7)
    (name "rust-aesni")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aesni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "007imgcfl82nilfpamj5dik83pkcmkzvbkxp384p7r3iz6sscw1g"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.6)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.3))))))

(define-public rust-afl-0.8
  (package
    (name "rust-afl")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "afl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rw11hycfjhqbc7z1smn75m0sczq519msjwimxh7b8s6n4pzk5r7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-xdg" ,rust-xdg-2))))
    (home-page "https://github.com/rust-fuzz/afl.rs")
    (synopsis
     "Fuzzing Rust code with american-fuzzy-lop")
    (description
     "Fuzz Rust code with american-fuzzy-lop.")
    (license license:asl2.0)))

(define-public rust-afl-0.5
  (package
    (inherit rust-afl-0.8)
    (name "rust-afl")
    (version "0.5.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "afl" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0azpi917l8nhvx25n2v670nvkxkrhcwmddfi85qnr6kchmi6y946"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-cc" ,rust-cc-1)
        ("rust-xdg" ,rust-xdg-2)
        ("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-xdg" ,rust-xdg-2))))))

(define-public rust-afl-0.4
  (package
    (inherit rust-afl-0.5)
    (name "rust-afl")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "afl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0g2chc18ji7qxi0d03n2ai140qdcww958v5si6rcjnnhmri1vyfb"))))))

(define-public rust-ahash-0.4
  (package
    (name "rust-ahash")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06bxygcis4pfx0axi1ld0lclg8mf4plywdy7fnkyw2hrhcb74rkd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))
    (home-page "https://github.com/tkaitchuck/ahash")
    (synopsis "Non-cryptographic hash function using AES-NI")
    (description "This package provides a non-cryptographic hash function
using AES-NI for high performance.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ahash-0.3
  (package
    (inherit rust-ahash-0.4)
    (name "rust-ahash")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05qjnr0wccch0gg2kghg0xyh8qd5gfqd15q9dd6r1lamcs375zg8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-aho-corasick-0.7
  (package
    (name "rust-aho-corasick")
    (version "0.7.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aho-corasick" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rb8gzhljl8r87dpf2n5pnqnkl694casgns4ma0sqzd4zazzw13l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))
    (home-page "https://github.com/BurntSushi/aho-corasick")
    (synopsis "Fast multiple substring searching")
    (description "This package provides a fast multiple substring searching.")
    (license (list license:unlicense license:expat))))

(define-public rust-aho-corasick-0.6
  (package
    (inherit rust-aho-corasick-0.7)
    (name "rust-aho-corasick")
    (version "0.6.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "aho-corasick" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19f8v503ibvlyr824g5ynicrh1lsmp2i0zmpszr8lqay0qw3vkl1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-1)
        ("rust-docopt" ,rust-docopt-1)
        ("rust-memmap" ,rust-memmap-0.6)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-aho-corasick-0.5
  (package
    (inherit rust-aho-corasick-0.6)
    (name "rust-aho-corasick")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aho-corasick" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rnvdmlajikq0i4zdy1p3pv699q6apvsxfc7av7byhppllp2r5ya"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-0.1))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-0.14)
        ("rust-docopt" ,rust-docopt-0.6)
        ("rust-memmap" ,rust-memmap-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))))

(define-public rust-alacritty-config-derive-0.1
  (package
    (name "rust-alacritty-config-derive")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alacritty_config_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dn3cg233jyi06xz8q1vfgjikdpcjdid36kqnl0yawdqpm2lq13p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/alacritty/alacritty")
    (synopsis "Failure resistant deserialization derive")
    (description
     "This package provides a failure resistant deserialization derive.")
    (license (list license:expat license:asl2.0))))

(define-public rust-alacritty-terminal-0.12
  (package
    (name "rust-alacritty-terminal")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alacritty_terminal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q7sm7rm5yny4lka8w4vji2v2crkkbwj3y8l5qnq01qlwmkjmkfd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-alacritty-config-derive" ,rust-alacritty-config-derive-0.1)
        ("rust-base64" ,rust-base64-0.12)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-dirs" ,rust-dirs-2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-anonymous-pipes" ,rust-mio-anonymous-pipes-0.1)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-nix" ,rust-nix-0.18)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-regex-automata" ,rust-regex-automata-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vte" ,rust-vte-0.10)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/alacritty/alacritty")
    (synopsis "Library for writing terminal emulators")
    (description
     "This package provides a library for writing terminal emulators.")
    (license license:asl2.0)))

(define-public rust-alga-0.9
  (package
    (name "rust-alga")
    (version "0.9.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wl4z8ini9269x04g8wwdz1nn3hmmvaaysq4jwhymikyg81kv0jg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-decimal" ,rust-decimal-2)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-alga-derive" ,rust-alga-derive-0.9)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Abstract algebra for Rust")
    (description "Alga aims to provide solid mathematical abstractions to
algebra-focused applications.  It defines and organizes through trait
inheritance the basic building blocks of general algebraic structures.
Specific implementations of algebraic structure traits are left to other
crates.  Higher-level traits for specialized domains of algebra (like linear
algebra) are also provided and will prove useful for applications that include
code that is generic with regard to the algebraic entity types.")
    (license license:asl2.0)))

(define-public rust-alga-derive-0.9
  (package
    (name "rust-alga-derive")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga-derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0a2594j6blczz18vfg85agr7vsjrbq6900d3xwxw0zzbqj9j2adz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-edit-distance" ,rust-edit-distance-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Dutomatic deriving of abstract algebra traits")
    (description "Derive attribute for implementing algebraic traits from the
@code{alga} crate.")
    (license license:asl2.0)))

(define-public rust-alloc-no-stdlib-2
  (package
    (name "rust-alloc-no-stdlib")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-no-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19lhmi73fii1b6vrzh23vvp5yjqm33cb94h9yz17pn25b51yr4ji"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "Dynamic allocator that may be used with or without the stdlib")
    (description "This package provides a dynamic allocator that may be used
with or without the stdlib.  This allows a package with nostd to allocate
memory dynamically and be used either with a custom allocator, items on the
stack, or by a package that wishes to simply use Box<>.  It also provides
options to use calloc or a mutable global variable for pre-zeroed memory.")
    (license license:bsd-3)))

(define-public rust-alloc-stdlib-0.2
  (package
    (name "rust-alloc-stdlib")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hj3r1x88aajnvigdck0diygj2isc90wa271kkj1swgiq3nxfzk9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2))))
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "A dynamic allocator example that may be used with the stdlib")
    (description "This package provides a dynamic allocator example that may
be used with the stdlib.")
    (license license:bsd-3)))

(define-public rust-android-glue-0.2
  (package
    (name "rust-android-glue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android-glue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01y495x4i9vqkwmklwn2xk7sqg666az2axjcpkr4iwngdwi48100"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tomaka/android-rs-glue")
    (synopsis "Glue for the Android JNI")
    (description "This package provides the glue for the Android JNI.")
    (license license:expat)))

(define-public rust-android-log-sys-0.1
  (package
    (name "rust-android-log-sys")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0klq7cp4lm74gjf9p12zdjcr159blbicrfvadmaqvfxbi8njw1dq"))))
    (arguments `(#:skip-build? #true))  ;XXX: Android only
    (build-system cargo-build-system)
    (home-page "https://github.com/nercury/android_log-sys-rs")
    (synopsis "FFI bindings to Android log Library")
    (description "This package provides FFI bindings to Android log Library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-logger-0.8
  (package
    (name "rust-android-logger")
    (version "0.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kj8i03fqqwxd803hrk27j2399v27ajjj9zxi2nnyml0s4nm9gcc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-android-log-sys" ,rust-android-log-sys-0.1)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/Nercury/android_logger-rs")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This library is a drop-in replacement for @code{env_logger}.  Instead,
it outputs messages to Android's logcat.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ansi-parser-0.6
  (package
    (name "rust-ansi-parser")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-parser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "152idb8a6gwdxzj6m099h3xgx8vw0sjc6skgw94nm2k3y5swc6kn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-heapless" ,rust-heapless-0.5)
        ("rust-nom" ,rust-nom-4))))
    (home-page "https://gitlab.com/DavidBittner/ansi-parser")
    (synopsis "Library using nom for parsing ANSI escape codes")
    (description
     "This package provides a library using nom for parsing ANSI
escape codes.")
    (license license:mpl2.0)))

(define-public rust-antidote-1
  (package
    (name "rust-antidote")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "antidote" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "19g2sw2qa2ibnh4x7j1snk46593jgx6y7rnvva496ynq61af5z9l"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-antidote")
    (synopsis "Poison-free Mutex and RwLock types")
    (description
     "These types expose identical APIs to the standard library @code{Mutex} and
@code{RwLock} except that they do not return @code{PoisonError}s.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-anyhow-1
  (package
    (name "rust-anyhow")
    (version "1.0.37")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyhow" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11kaqp25lchr2ckyc46zm6blzndnw0w2w8qv0sp8z4xcxqgw2rzf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/anyhow")
    (synopsis "Flexible concrete Error type")
    (description "This package provides a flexible concrete Error type built on
@code{std::error::Error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-app-dirs2-2
  (package
    (name "rust-app-dirs2")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "app_dirs2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04v2q3jkqr32mwqs4niqfyhbkvvgrcsw0dajwqaz83nc5hs1igsm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jni" ,rust-jni-0.18)
        ("rust-ndk-glue" ,rust-ndk-glue-0.2)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-test-case" ,rust-test-case-1))))
    (home-page "https://lib.rs/app_dirs2")
    (synopsis "Put app's data in the right place on every platform")
    (description
     "This package helps you to put your app's data in the right place
on every platform.")
    (license license:expat)))

(define-public rust-approx-0.3
  (package
    (name "rust-approx")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hx580xjdxl3766js9b49rnbnmr8gw8c060809l43k9f0xshprph"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/brendanzab/approx")
    (synopsis
     "Approximate floating point equality comparisons and assertions")
    (description
     "Approximate floating point equality comparisons and assertions.")
    (license license:asl2.0)))

(define-public rust-approx-0.1
  (package
    (inherit rust-approx-0.3)
    (name "rust-approx")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "153awzwywmb61xg857b80l63b1x6hifx2pha7lxf6fck9qxwraq8"))))
    (arguments '())))

(define-public rust-arbitrary-0.4
  (package
    (name "rust-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sa55cynafwzvlhyhfpm3vmi2fydj3ipdj5yfbaif7l56cixfmfv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-arbitrary" ,rust-derive-arbitrary-0.4))))
    (home-page "https://github.com/nagisa/rust_arbitrary")
    (synopsis "Trait for generating structured data from unstructured data")
    (description
     "The @code{Arbitrary} crate lets you construct arbitrary instance of
a type.

This crate is primarily intended to be combined with a fuzzer like
@code{libFuzzer} and @code{cargo-fuzz} or AFL, and to help you turn the raw,
untyped byte buffers that they produce into well-typed, valid, structured
values.  This allows you to combine structure-aware test case generation with
coverage-guided, mutation-based fuzzers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arbitrary-0.2
  (package
    (inherit rust-arbitrary-0.4)
    (name "rust-arbitrary")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "arbitrary" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1i3fhcdyjq4isn22xx2svmpfr5hwyzi0wavbm07fs8i2dv5pdkv4"))))))

(define-public rust-arboard-1
  (package
    (name "rust-arboard")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arboard" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wpyv732fxkplmiwik1sbgdlnbk748w1aqpkc71gn5lm2ns9w545"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clipboard-win" ,rust-clipboard-win-4)
        ("rust-core-graphics" ,rust-core-graphics-0.21)
        ("rust-image" ,rust-image-0.23)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-objc-id" ,rust-objc-id-0.1)
        ("rust-scopeguard" ,rust-scopeguard-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-xcb" ,rust-xcb-0.9))))
    (home-page "https://github.com/ArturKovacs/arboard")
    (synopsis "Image and text handling for the OS clipboard")
    (description
     "This package provides image and text handling for the OS clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arc-swap-1
  (package
    (name "rust-arc-swap")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arc-swap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwdvayqa07grw4ljvb6plbw0wdg78jcdg3hwnlq2yqljlrxdmyl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-adaptive-barrier" ,rust-adaptive-barrier-0.1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-proptest" ,rust-proptest-0.10))))
    (home-page "https://github.com/vorner/arc-swap")
    (synopsis "Atomically swappable Arc")
    (description "This package provides an atomically swappable Arc.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-arc-swap-0.4
  (package
    (inherit rust-arc-swap-1)
    (name "rust-arc-swap")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arc-swap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zwswfi9n7n3hiq51w1xv34572k2diazx680rrxlc9w07c9akf6p"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-model" ,rust-model-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-proptest" ,rust-proptest-0.8)
        ("rust-version-sync" ,rust-version-sync-0.8))))))

(define-public rust-arg-enum-proc-macro-0.3
  (package
    (name "rust-arg-enum-proc-macro")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "arg_enum_proc_macro" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "021rr6j3n031ynfbm7kwb3j3bxvbsz40n0nqi78k47d3p92rihcv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/lu-zero/arg_enum_proc_macro")
    (synopsis "Procedural macro compatible with clap arg_enum")
    (description
     "This package provides a procedural macro compatible with clap's
@code{arg_enum}.")
    (license license:expat)))

(define-public rust-argon2rs-0.2
  (package
    (name "rust-argon2rs")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argon2rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "14mkgkrjd4b4zy92pflz6yb4j1wn2chbd8jczxknxbkdm2vb0rrz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blake2-rfc" ,rust-blake2-rfc-0.2)
        ("rust-scoped-threadpool" ,rust-scoped-threadpool-0.1))
       #:cargo-development-inputs
       (("rust-cargon" ,rust-cargon-0.0))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-cargo-toml
           (lambda _
             (substitute* "Cargo.toml"
               (("\\{ path =.*,") "{"))
             #t)))))
    (home-page "https://github.com/bryant/argon2rs")
    (synopsis "Rust password hashing library that runs on Argon2")
    (description "This package provides a pure Rust password hashing library
that runs on Argon2.")
    (license license:expat)))

(define-public rust-arrayref-0.3
  (package
    (name "rust-arrayref")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayref" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0i6m1l3f73i0lf0cjdf5rh3xpvxydyhfbakq7xx7bkrp5qajgid4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6))))
    (home-page "https://github.com/droundy/arrayref")
    (synopsis "Macros to take array references of slices")
    (description
     "Macros to take array references of slices.")
    (license license:bsd-2)))

(define-public rust-arrayvec-0.5
  (package
    (name "rust-arrayvec")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12q6hn01x5435bprwlb7w9m7817dyfq55yrl4psygr78bp32zdi3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/bluss/arrayvec")
    (synopsis "Vector with fixed capacity")
    (description
     "This package provides a vector with fixed capacity, backed by an
array (it can be stored on the stack too).  Implements fixed capacity
ArrayVec and ArrayString.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arrayvec-0.4
  (package
    (inherit rust-arrayvec-0.5)
    (name "rust-arrayvec")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fdiv5m627gh6flp4mpmi1mh647imm9x423licsr11psz97d97yd"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nodrop" ,rust-nodrop-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-as-slice-0.1
  (package
    (name "rust-as-slice")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as-slice" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rmhdfj11va424163d6r79wbgf2043i2p37s59ky6x2v8wiiqkdv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array-0.14" ,rust-generic-array-0.14)
        ("rust-generic-array-0.13" ,rust-generic-array-0.13)
        ("rust-generic-array-0.12" ,rust-generic-array-0.12)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/japaric/as-slice")
    (synopsis "AsSlice and AsMutSlice traits")
    (description "This package provides @code{AsSlice} and @code{AsMutSlice}
traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ascii-1
  (package
    (name "rust-ascii")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ascii" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0281gc828q4j692gb66jfdr5k16gyszgqflylh0pp30rllv63xdv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tomprogrammer/rust-ascii")
    (synopsis "ASCII-only equivalents to `char`, `str` and `String`.")
    (description
     "A rust library that provides ASCII-only string and character types,
equivalent to the @code{char}, @code{str} and @code{String} types in the
standard library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ascii-0.9
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0km3zzkhrr22drf9p1zcblqirlxkdc7zra25acpi0h8qax5c1cga"))))
    (arguments
     `(#:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-ascii-0.8
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "051gh2bgjq90s0f0i0hd9p4z4fpg5k82b570d1223jj7rhd8kglp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-assert-cli-0.6
  (package
    (name "rust-assert-cli")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-cli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jc1bh3cvnl66bl7s5gr1xnm0hl8d2l3gmil0pmhp5v2xp0bg6m2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; requires `printenv`, but installing coreutils doesn't help
       #:cargo-inputs
       (("rust-colored" ,rust-colored-1)
        ("rust-difference" ,rust-difference-2)
        ("rust-environment" ,rust-environment-0.1)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))
    (home-page "https://github.com/assert-rs/assert_cli")
    (synopsis "Test CLI Applications")
    (description "This package helps testing CLI Applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-1
  (package
    (name "rust-assert-cmd")
    (version "1.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "assert-cmd" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15h3wfxn1q7sfcrin4z35x9hgf539f2dhkwz2mq4zswlrmc5nizj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-predicates" ,rust-predicates-1)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2))
       #:cargo-development-inputs
       (("rust-escargot" ,rust-escargot-0.5))))
    (home-page "https://github.com/assert-rs/assert_cmd")
    (synopsis "Test CLI Applications")
    (description "Test CLI Applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-0.9
  (package
    (inherit rust-assert-cmd-1)
    (name "rust-assert-cmd")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-cmd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02gq7j9qzjkbyq4hk18cih3kylk3dyxwa2gc5k7lah9kdwkhrdn5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-escargot" ,rust-escargot-0.3)
        ("rust-predicates" ,rust-predicates-0.9)
        ("rust-predicates-core" ,rust-predicates-core-0.9)
        ("rust-predicates-tree" ,rust-predicates-tree-0.9))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))))

(define-public rust-assert-fs-0.11
  (package
    (name "rust-assert-fs")
    (version "0.11.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "assert-fs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1h1q90qskbylv4g3jyizdanj73835q7vvq7q10y555x4gnavmrjc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-globwalk" ,rust-globwalk-0.5)
        ("rust-predicates" ,rust-predicates-1)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-tempfile" ,rust-tempfile-3))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))
    (home-page "https://github.com/assert-rs/assert_fs")
    (synopsis "File system fixtures and assertions for testing")
    (description
     "File system fixtures and assertions for testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-json-diff-1
  (package
    (name "rust-assert-json-diff")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-json-diff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h2w4n8f8a1n9sc8snka0arzw5x95ky5k8i7603z3lhkcplwnna2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-extend" ,rust-extend-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/davidpdrsn/assert-json-diff")
    (synopsis "Easily compare two JSON values and get great output")
    (description
     "This crate includes macros for comparing two serializable values
by diffing their JSON representations.  It is designed to give much
more helpful error messages than the standard @code{assert_eq!}.  It
basically does a diff of the two objects and tells you the exact
differences.  This is useful when asserting that two large JSON
objects are the same.")
    (license license:expat)))

(define-public rust-assert-matches-1
  (package
    (name "rust-assert-matches")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_matches" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rar61v00gz2aniid0mylxcr4q98s6l77c3hvbszmg57kj10msvx"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/murarth/assert_matches")
    (synopsis "Asserts that a value matches a pattern")
    (description
     "This package asserts that a value matches a pattern in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aster-0.41
  (package
    (name "rust-aster")
    (version "0.41.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aster" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q704kn23wnwnrxml7w1mxw6a3xb6386x5wgys6ibnyramrxzksc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-compiletest-rs" ,rust-compiletest-rs-0.2)
        ("rust-syntex-syntax" ,rust-syntex-syntax-0.58))))
    (home-page "https://github.com/serde-rs/aster")
    (synopsis "Libsyntax ast builder")
    (description "This package provides a libsyntax ast builder.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-attributes-1
  (package
    (name "rust-async-attributes")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08w41342hybxhln7j7hjsf7v04p3r9d6qdczfwp8d53xj5bd3lzg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-0.99))))
    (home-page "https://github.com/async-rs/async-attributes")
    (synopsis "Experimental language-level polyfills for Async Rust")
    (description
     "This package provides experimental language-level polyfills for Async
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-channel-1
  (package
    (name "rust-async-channel")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ffn42ig82az8ndgjb545imifarcavwxs9dff6psbdkdjj1hsx2r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-blocking" ,rust-blocking-0.6)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/stjepang/async-channel")
    (synopsis "Async multi-producer multi-consumer channel")
    (description
     "Async multi-producer multi-consumer channel")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-compression-0.3
  (package
    (name "rust-async-compression")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-compression" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dwm5zgi560m1xy30k3a4sg96mlfkjdk8jl6a1dk4d72ah8iyb5p"))))
    (build-system cargo-build-system)
    (arguments
     ;; FIXME: Tests fail with "error[E0432]: unresolved import `syn::export`"
     ;; when compiling ntest_test_cases v0.3.4.
     `(#:tests? #false
       #:cargo-inputs
       (("rust-brotli" ,rust-brotli-3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-bzip2" ,rust-bzip2-0.4)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-xz2" ,rust-xz2-0.1)
        ("rust-zstd" ,rust-zstd-0.6)
        ("rust-zstd-safe" ,rust-zstd-safe-3))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-test" ,rust-futures-test-0.3)
        ("rust-ntest" ,rust-ntest-0.3)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-proptest-derive" ,rust-proptest-derive-0.1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-timebomb" ,rust-timebomb-0.1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio-util" ,rust-tokio-util-0.4)
        ("rust-tokio-util" ,rust-tokio-util-0.6))))
    (home-page "https://github.com/Nemo157/async-compression")
    (synopsis "Adaptors between compression crates and Rust's modern asynchronous IO types")
    (description "This package provides adaptors between compression crates
and Rust's modern asynchronous IO types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-datagram-3
  (package
    (name "rust-async-datagram")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-datagram" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k4kiy67d24ay8l7xrfjpsa4zkmhxv97ddj0f16rcv61qkky3i4f"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rustasync/async-datagram")
    (synopsis "Async datagram traits")
    (description "This package provides asynchronous datagram traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-dup-1
  (package
    (name "rust-async-dup")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-dup" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z3grxarv9wpck6jm31qayib9barf12a47gvii9934n0ilms29vl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-simple-mutex" ,rust-simple-mutex-1))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-smol" ,rust-smol-0.1))))
    (home-page "https://github.com/stjepang/async-dup")
    (synopsis "Duplicate an async I/O handle")
    (description
     "This crate provides two tools, Arc and Mutex.  Arc implements
AsyncRead, AsyncWrite, and AsyncSeek if a reference to the inner type
does.  A reference to Mutex implements AsyncRead, AsyncWrite, and
AsyncSeek if the inner type does.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-executor-1
  (package
    (name "rust-async-executor")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ilivvzc082ynr096xxghc8hdmlmacxilcpn738ylh5lqxq7k1zb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-task" ,rust-async-task-4)
        ("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-vec-arena" ,rust-vec-arena-1))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-easy-parallel" ,rust-easy-parallel-3))))
    (home-page "https://github.com/stjepang/async-executor")
    (synopsis "Async executor")
    (description "This library provides async executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-global-executor-2
  (package
    (name "rust-async-global-executor")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-global-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xjacr43sbz2zk0zygpd9k14n95wa61x8n9i8mcdwdkz659fr1lm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-executor" ,rust-async-executor-1)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-async-mutex" ,rust-async-mutex-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3))))
    (home-page "https://github.com/async-rs/async-global-executor")
    (synopsis "Global executor built on top of @code{async-executor} and
@code{async-io}")
    (description
     "This package provides a global executor built on top of
@code{async-executor} and @code{async-io}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-global-executor-1
  (package
    (inherit rust-async-global-executor-2)
    (name "rust-async-global-executor")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-global-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "017s1lik153s587l6q9x5bf9i1n7gxqcg3zn2mdgvf16rm4rn1vk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-executor" ,rust-async-executor-1)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))))

(define-public rust-async-h1-2
  (package
    (name "rust-async-h1")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-h1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1p6ls50p1ixnxrhmx4sdb5d2kqrl1kfhcb0lkqlhzzqjz1sqmip5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-dup" ,rust-async-dup-1)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-byte-pool" ,rust-byte-pool-0.2)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-http-types" ,rust-http-types-2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-pin-project" ,rust-pin-project-1))))
    (home-page "https://github.com/http-rs/async-h1")
    (synopsis "Asynchronous HTTP 1.1 parser")
    (description
     "This package provides an asynchronous HTTP 1.1 parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-io-1
  (package
    (name "rust-async-io")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zg0bvb58615qar6ih3ddr1cyjh0fsrfdhpy90z1qxjnfpqgh5ck"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-nb-connect" ,rust-nb-connect-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking" ,rust-parking-2)
        ("rust-polling" ,rust-polling-2)
        ("rust-vec-arena" ,rust-vec-arena-1)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-net" ,rust-async-net-1)
        ("rust-inotify" ,rust-inotify-0.8)
        ("rust-nix" ,rust-nix-0.18)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-timerfd" ,rust-timerfd-1)
        ("rust-uds-windows" ,rust-uds-windows-0.1))))
    (home-page "https://github.com/stjepang/async-io")
    (synopsis "Async I/O and timers")
    (description
     "This crate provides two tools: Async, an adapter for standard networking
types (and many other types) to use in async programs, and Timer, a future
that expires at a point in time.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-lock-2
  (package
    (name "rust-async-lock")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yrvnshs94aiimvprqkhcg1z7x9abzsja8f4ifcakr5x6abn15hr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2))))
    (home-page "https://github.com/stjepang/async-lock")
    (synopsis "Async synchronization primitives")
    (description "This package provides Async synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-log-1
  (package
    (name "rust-async-log")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16ymra7f8169br9ss9m9n4l6rjcav9ns6r9mv4nr4r9i9wq37fpm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-log-attributes" ,rust-async-log-attributes-1)
        ("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/async-rs/async-log")
    (synopsis "Async tracing capabilities for the @code{log} crate")
    (description
     "This crate provides extension types and hooks to @code{log} to enable
asynchronous logging.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-log-attributes-1
  (package
    (name "rust-async-log-attributes")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b9nysb5yxf772cinl5rsyhl2zazj2qfhbckv1kjz9qr3gkgi5ys"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/rustasync/runtime")
    (synopsis
     "Proc Macro attributes for the async-log crate.")
    (description
     "This package provides proc macro attributes for the @code{async-log}
crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-macros-1
  (package
    (name "rust-async-macros")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fib4wxiym9f045xqb8a2gyfa8yym3hb62g4jqjfmzn14jdxa8g4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))
       #:cargo-development-inputs
       (("rust-futures-preview" ,rust-futures-preview-0.3))))
    (home-page "https://github.com/async-rs/async-macros")
    (synopsis "Macros for async-std")
    (description "Macros for async-std.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-mutex-1
  (package
    (name "rust-async-mutex")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-mutex" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vhmsscqx48dmxw0yir6az0pbwcq6qjvcv2f43vdpn95vd9bi7a7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true      ;XXX: enable when rust-async-std-1 is packaged
       #:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2))
       #:cargo-development-inputs
       (;("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-intrusive" ,rust-futures-intrusive-0.3)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-smol" ,rust-smol-0.1)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/stjepang/async-lock")
    (synopsis "Async synchronisation primitives")
    (description "This crate provides the following async synchronisation
primitives:

@itemize
@item Barrier: enables tasks to synchronize all together at the same time.
@item Mutex: a mutual exclusion lock.
@item RwLock: a reader-writer lock, allowing any number of readers or a single writer.
@item Semaphore: limits the number of concurrent operations.
@end itemize")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-native-tls-0.3
  (package
    (name "rust-async-native-tls")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cwv4vbrvcbv58b51y1azfbszzgzhrzxx92q5nl6hk6kkf97m7ly"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true       ;XXX: build when rust-async-std-1 is packaged
       #:cargo-inputs
       (;;("rust-async-std" ,rust-async-std-1)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://docs.rs/crate/async-native-tls/")
    (synopsis "Native TLS using futures")
    (description "Native TLS using futures")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-net-1
  (package
    (name "rust-async-net")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-net" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rgvvqb1l86hawl1j0jfyzq35yracbbh29109131izmghmf4gph6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/stjepang/async-net")
    (synopsis "Async networking primitives for TCP/UDP/Unix communication")
    (description
     "Async networking primitives for TCP/UDP/Unix communication")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-process-1
  (package
    (name "rust-async-process")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-process" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nmvqwqxzy0gv7n8agknaijns9dsxqj81bxms4bs647vq44ym32c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=set_current_dir_works"
                            "--skip=signal_reported_right"
                            "--skip=stdin_works")
       #:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/stjepang/async-process")
    (synopsis "Async interface for working with processes")
    (description
     "This crate is an async version of @code{std::process}.  A background
thread named @code{async-process} is lazily created on first use, which waits
for spawned child processes to exit and then calls the @code{wait()} syscall
to clean up the ``zombie'' processes.

This is unlike the process API in the standard library, where dropping
a running Child leaks its resources.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-ready-3
  (package
    (name "rust-async-ready")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-ready" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09xw34q0k48r1bvs3s1l2a1mglz98l7zjbkdcy861k8zsyfwfw4l"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rustasync/async-ready")
    (synopsis "Async readiness traits")
    (description
     "This package provides Async readiness traits.  Those can be useful when
implementing async state machines that can later be wrapped in dedicated
futures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-recursion-0.3
  (package
    (name "rust-async-recursion")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-recursion" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18npixkwglnpvjgp89fpcyzf820ngx3a1hxp4hqbkw81p9b8dmyp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/dcchut/async-recursion")
    (synopsis "Recursion for async functions")
    (description
     "This package provides a procedural macro for recursive async
functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-std-1
  (package
    (name "rust-async-std")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h834fni3npsggjqin8386d2fn11m2z42dr1ymq0aknppa2ndw6r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-attributes" ,rust-async-attributes-1)
        ("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-global-executor" ,rust-async-global-executor-2)
        ("rust-async-io" ,rust-async-io-1)
        ("rust-async-lock" ,rust-async-lock-2)
        ("rust-async-process" ,rust-async-process-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-gloo-timers" ,rust-gloo-timers-0.2)
        ("rust-kv-log-macro" ,rust-kv-log-macro-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-surf" ,rust-surf-2)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4))))
    (home-page "https://async.rs")
    (synopsis "Async version of the Rust standard library")
    (description
     "This crate provides an async version of @code{std}.  It provides all the
interfaces you are used to, but in an async version and ready for Rust's
@code{async/await} syntax.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-std-0.99
  (package
    (inherit rust-async-std-1)
    (name "rust-async-std")
    (version "0.99.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k34181r1xzalyf7alka0ibnbqll6s5l435ycydm7fv1g6gill24"))))
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=io_timeout")
       #:cargo-inputs
       (("rust-async-attributes" ,rust-async-attributes-1)
        ("rust-async-macros" ,rust-async-macros-1)
        ("rust-async-task" ,rust-async-task-1)
        ("rust-broadcaster" ,rust-broadcaster-0.2)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-timer" ,rust-futures-timer-1)
        ("rust-kv-log-macro" ,rust-kv-log-macro-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.1)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-femme" ,rust-femme-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-async-stream-0.3
  (package
    (name "rust-async-stream")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p19qn5igblb86d35lda72q8vimk2iw8hk7r07wjj5y0rdqdyw1n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-stream-impl" ,rust-async-stream-impl-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-test" ,rust-tokio-test-0.2)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Asynchronous streams using async & await notation")
    (description
     "This package provides asynchronous streams using async & await
notation.")
    (license license:expat)))

(define-public rust-async-stream-impl-0.3
  (package
    (name "rust-async-stream-impl")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream-impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w0aif9aw103b5wrm1svkqdh7aaihjywa21819d8m3lzzj78nm53"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=try_stream"
                            "--skip=stream")
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Proc macros for async-stream crate")
    (description
     "This package provides proc macros for @code{rust-async-stream}
crate.")
    (license license:expat)))

(define-public rust-async-task-4
  (package
    (name "rust-async-task")
    (version "4.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w0a1c8jim6s5bvcyiiwg9m4bdv3xnd4hbjm97ndgmphmgg32679"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-flume" ,rust-flume-0.10))))
    (home-page "https://github.com/stjepang/async-task")
    (synopsis "Task abstraction for building executors")
    (description
     "This package provides a task abstraction for building executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-task-3
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lrm7cm9dpashmkbqa8mvglbf85gadviqil7qnnrm0pjdqap4xy1"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-task-1
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p88087z43zvv924my16a17qd65kdlv1r59h80h73rvrn0bc1hha"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-tls-0.10
  (package
    (name "rust-async-tls")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "126by0la2wvfadazfnmw7b6ch07dk9ggny94a3vvzgk2qdpqn3fx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-rustls" ,rust-rustls-0.19)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.21))))
    (home-page "https://github.com/async-std/async-tls")
    (synopsis "Asynchronous TLS/SSL streams using Rustls")
    (description
     "This package provides asynchronous TLS/SSL streams using Rustls.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-trait-0.1
  (package
    (name "rust-async-trait")
    (version "0.1.42")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gd13pqgw5m6l4bqwjkickq13c4v0jxzxs5i4dwmldrlgvklafld"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-attributes" ,rust-tracing-attributes-0.1)
        ("rust-tracing-futures" ,rust-tracing-futures-0.2)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/async-trait")
    (synopsis "Type erasure for async trait methods")
    (description "This package provides type erasure for async trait
methods.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atom-0.3
  (package
    (name "rust-atom")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qig9fcdqf07mzzpkicm5wgxv0zpr28njdsqf708wxq27yf6k1iw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/slide-rs/atom")
    (synopsis "A safe abstraction around AtomicPtr")
    (description "This package provides a safe abstraction around AtomicPtr.")
    (license license:asl2.0)))

(define-public rust-atomic-waker-1
  (package
    (name "rust-atomic-waker")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-waker" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ansiq5vlw684fhks2x4a4is2rqlbv50q5mi8x0fxxvx5q2p8lq6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3))))
    (home-page "https://github.com/stjepang/atomic-waker")
    (synopsis "Synchronization primitive for task wakeup")
    (description
     "This package provides a synchronization primitive for task wakeup.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-atty-0.2
  (package
    (name "rust-atty")
    (version "0.2.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atty" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32
         "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hermit-abi" ,rust-hermit-abi-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/softprops/atty")
    (synopsis "Simple interface for querying atty")
    (description
     "This package provides a simple interface for querying atty.")
    (license license:expat)))

(define-public rust-autocfg-1
  (package
    (name "rust-autocfg")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "autocfg" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cuviper/autocfg")
    (synopsis
     "Automatic cfg for Rust compiler features")
    (description
     "Automatic cfg for Rust compiler features.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-autocfg-0.1
  (package
    (inherit rust-autocfg-1)
    (name "rust-autocfg")
    (version "0.1.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "autocfg" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1chwgimpx5z7xbag7krr9d8asxfqbh683qhgl9kn3hxk2l0djj8x"))))
    (arguments '(#:skip-build? #t))))

(define-public rust-automod-1
  (package
    (name "rust-automod")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "automod" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1z8kdbvvz0k8mfs45mvs16lr9xj59cdcp0sm45fawfh93gai4mhg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       ;; Tests not included in tar.
       #:tests? #f))
    (home-page "https://github.com/dtolnay/automod")
    (synopsis "Pull in every source file in a directory as a module")
    (description "Pull in every source file in a directory as a module.")
    (license (list license:expat license:asl2.0))))

(define-public rust-average-0.10
  (package
    (name "rust-average")
    (version "0.10.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "average" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1dmsxqcr1n0i20qr9g2g6j89kkx8dy6w18dbqzx1wi42wj1chgvh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.2)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-distr" ,rust-rand-distr-0.2)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))
    (home-page "https://github.com/vks/average")
    (synopsis "Calculate statistics iteratively")
    (description "This crate provides for calculating statistics iteratively
in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-av-metrics-0.6
  (package
    (name "rust-av-metrics")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "av-metrics" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g4k2q3226246jad3jl8pny7aphq8i03x4qyilzj4zgp27350hsz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.8)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lab" ,rust-lab-0.8)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-v-frame" ,rust-v-frame-0.2))))
    (home-page "https://github.com/rust-av/av-metrics")
    (synopsis "Collection of algorithms for measuring audio/video metrics")
    (description
     "This package provides a collection of algorithms for measuring
audio/video metrics.")
    (license license:expat)))

(define-public rust-average-0.9
  (package
    (inherit rust-average-0.10)
    (name "rust-average")
    (version "0.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "average" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f8ya00bv6qki9m7b4lb3bn845rj473mx02qpm7wgy5qc1yp75xs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))))

(define-public rust-awc-2
  (package
    (name "rust-awc")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "awc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14g6m53zmxw3f1sf990l7ps3w2fq2c29n1slpizc7kxhwy8f90dk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.3)
        ("rust-actix-http" ,rust-actix-http-2)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7))))
    (home-page "https://actix.rs")
    (synopsis "Async HTTP and WebSocket client library")
    (description
     "This package provides async HTTP and WebSocket client library
built on the Actix ecosystem.")
    (license (list license:expat license:asl2.0))))

(define-public rust-awc-1
  (package
    (inherit rust-awc-2)
    (name "rust-awc")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "awc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1idacmq7n3irmdjkbxc5kdwspxk9w1gip94pcmfk7wky3m6isq6p"))))
    ;; XXX: The crate fails to't build with with the same error as
    ;; rust-actix-connect.  Skip build for now.
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-actix-codec" ,rust-actix-codec-0.2)
        ("rust-actix-http" ,rust-actix-http-1)
        ("rust-actix-rt" ,rust-actix-rt-1)
        ("rust-actix-service" ,rust-actix-service-1)
        ("rust-base64" ,rust-base64-0.11)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.6))
       #:cargo-development-inputs
       (("rust-actix-http-test" ,rust-actix-http-test-1)
        ("rust-actix-web" ,rust-actix-web-2)
        ("rust-brotli" ,rust-brotli-3))))))

(define-public rust-az-1
  (package
    (name "rust-az")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "az" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0sb51w9pjcqb315dg6zv9wwqj1q2fldcc3xmfv0bhkmajiyx9g79"))))
    (build-system cargo-build-system)
    (home-page "https://gitlab.com/tspiteri/az")
    (synopsis "Casts and checked casts")
    (description "This crate provides casts and checked casts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-backtrace-0.3
  (package
    (name "rust-backtrace")
    (version "0.3.56")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g716jmrik0fx29va3js4gw8hwk5jlsmvqaa9ryp1c9qyh07c4cx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-addr2line" ,rust-addr2line-0.14)
        ("rust-backtrace-sys" ,rust-backtrace-sys-0.1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.4)
        ("rust-object" ,rust-object-0.23)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/rust-lang/backtrace-rs")
    (synopsis "Acquire a stack trace (backtrace) at runtime in a Rust program")
    (description
     "This package provides a library to acquire a stack
trace (backtrace) at runtime in a Rust program.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-backtrace-0.3.35
  (package
    (inherit rust-backtrace-0.3)
    (name "rust-backtrace")
    (version "0.3.35")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mfwbb6832rh1za304w8x37bvs9fjbybpmmz0iksqfzsaf108w8k"))))))

(define-public rust-backtrace-sys-0.1
  (package
    (name "rust-backtrace-sys")
    (version "0.1.37")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "backtrace-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "16a3igz22q9lnnjjr77f4k8ci48v8zdwrs67khx3h7wx3jzfpyqq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/rust-lang/backtrace-rs")
    (synopsis "Bindings to the libbacktrace gcc library")
    (description
     "This package provides bindings to the libbacktrace gcc library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-base58-0.1
  (package
    (name "rust-base58")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base58" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10xfw6v7jzn9i682mkw9nqybzafrvl3i2wawwgp5a8gh2n0fw92h"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/debris/base58")
    (synopsis "Tiny and fast base58 encoding")
    (description
     "Encode to base58 using only Rust.  This package is based on
@url{https://github.com/trezor/trezor-crypto/blob/master/base58.c} at commit
c6e7d37.  However, this package works only up to 128 bytes.")
    (license license:expat)))

(define-public rust-base64-0.13
  (package
    (name "rust-base64")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z82g23mbzjgijkpcrilc7nljpxpvpf7zxf6iyiapkgka2ngwkch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-structopt" ,rust-structopt-0.3))))
    (home-page "https://github.com/marshallpierce/rust-base64")
    (synopsis "Encodes and decodes base64 as bytes or utf8")
    (description
     "This package encodes and decodes base64 as bytes or utf8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-base64-0.12
  (package
    (inherit rust-base64-0.13)
    (name "rust-base64")
    (version "0.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zq33had71xh48n17g4kqs96szhx3yh7qibzwi4fk217n3vz0h9l"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; 'doctest' isn't stable until rust-1.40
           (substitute* "src/lib.rs"
             (("\\(doctest") "(test"))
           #t))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-base64-0.11
  (package
    (inherit rust-base64-0.12)
    (name "rust-base64")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1iqmims6yvr6vwzyy54qd672zw29ipjj17p8klcr578c9ajpw6xl"))))))

(define-public rust-base64-0.10
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13k6bvd3n6dm7jqn9x918w65dd9xhx454bqphbnv0bkd6n9dj98b"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-base64-0.9
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hs62r35bgxslawyrn1vp9rmvrkkm76fqv0vqcwd048vs876r7a8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-safemem" ,rust-safemem-0.3))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))))

(define-public rust-base64-0.6
  (package
    (inherit rust-base64-0.13)
    (name "rust-base64")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ja3c7wlzp3sb14f2ksp27x1mk8ycgh1391nnd7fvw01fnc4yhwn"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-safemem" ,rust-safemem-0.2))))))

(define-public rust-base-x-0.2
  (package
    (name "rust-base-x")
    (version "0.2.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "base-x" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1hfy0wv7j5ynd73yk1vyr32pqa77rp15lkrc54f8ky9c6hcbc80v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-json" ,rust-json-0.11)
        ("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/OrKoN/base-x-rs")
    (synopsis "Encode/decode any base")
    (description "This library provides for encoding and decoding any base.")
    (license license:expat)))

(define-public rust-beef-0.5
  (package
    (name "rust-beef")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "beef" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02blba0j192l0374kqwn8rjsc8aifj43xi26v142ijpjim1f4dk7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/maciejhirsz/beef")
    (synopsis "Faster, more compact implementation of Cow")
    (description "This package provides faster, more compact implementation of
Cow.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bencher-0.1
  (package
    (name "rust-bencher")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bencher" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1x8p2xblgqssay8cdykp5pkfc0np0jk5bs5cx4f5av097aav9zbx"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/bencher/")
    (synopsis "Port of the libtest benchmark runner to Rust stable")
    (description "This package provides a port of the libtest (unstable Rust)
benchmark runner to Rust stable releases.  Supports running benchmarks and
filtering based on the name.  Benchmark execution works exactly the same way
and no more (caveat: black_box is still missing!).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-better-panic-0.2
  (package
    (name "rust-better-panic")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "better-panic" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0xl48v6pd9ys7wp0ni62i6q73xpd1nhf92z09sjc9n3lrj0ac4ix"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-console" ,rust-console-0.9)
        ("rust-syntect" ,rust-syntect-3))))
    (home-page "https://github.com/mitsuhiko/better-panic")
    (synopsis "Pretty backtraces inspired by Python's tracebacks")
    (description
     "This package provides pretty panic backtraces inspired by Python's
tracebacks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bigdecimal-0.2
  (package
    (name "rust-bigdecimal")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fd5chyy76y4qb043w1bbgz1v22f9hw5703f5r90ac5hwqk3qh6c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/akubera/bigdecimal-rs")
    (synopsis "Arbitrary precision decimal numbers")
    (description "This package provides arbitrary precision decimal numbers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bigdecimal-0.1
  (package
    (inherit rust-bigdecimal-0.2)
    (name "rust-bigdecimal")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bigdecimal" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0i32g88sin9dzr4jn41wgg3pyx2xxm0m1a9s5vh9lpyj5lg1jx0k"))))
    (arguments
      `(#:cargo-inputs
        (("rust-num-bigint" ,rust-num-bigint-0.2)
         ("rust-num-integer" ,rust-num-integer-0.1)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bincode-1
  (package
    (name "rust-bincode")
    (version "1.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bincode" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vc9pjh6hfp9vfq752sa88rxwg93ydhm0dvvy58rcvx2p8wkl3gk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-serde-bytes" ,rust-serde-bytes-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/servo/bincode")
    (synopsis
     "Binary serialization/deserialization strategy")
    (description
     "This package provides a binary serialization/deserialization strategy
that uses Serde for transforming structs into bytes and vice versa!")
    (license license:expat)))

(define-public rust-bincode-0.8
  (package
    (inherit rust-bincode-1)
    (name "rust-bincode")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bincode" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0nbj0lwykwa1a7sa4303rxgpng9p2hcz9s5d5qcrckrpmcxjsjkf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-num-traits" ,rust-num-traits-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-bytes" ,rust-serde-bytes-0.10)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-bindgen-0.57
  (package
    (name "rust-bindgen")
    (version "0.57.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g96ypnck6n60p3cz9k3y3jnxi4z7jfv2pha5bxsm8269806aj7x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))))
    (home-page "https://rust-lang.github.io/rust-bindgen/")
    (synopsis "Generate Rust FFI bindings to C and C++ libraries.")
    (description "This package can be used to automatically generate Rust FFI
bindings to C and C++ libraries.")
    (license license:bsd-3)))

(define-public rust-bindgen-0.55
  (package
    (inherit rust-bindgen-0.57)
    (name "rust-bindgen")
    (version "0.55.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hxlvy9q9984rr3rqaxwmgxjrd9wh11mcc161hv3shz6b7jkrcbm"))))
    (inputs
     `(("clang" ,clang)))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-bindgen-0.54
  (package
    (inherit rust-bindgen-0.55)
    (name "rust-bindgen")
    (version "0.54.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0dn7dlwa0abjlqbl2kvwfdy6k6kgcqg6ixcjmk6pc3dpps09pm7l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; not all test files included
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.29)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs
     `(("clang" ,clang)))))

(define-public rust-bindgen-0.53
  (package
    (inherit rust-bindgen-0.54)
    (name "rust-bindgen")
    (version "0.53.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1rc9grfd25bk5b2acmqljhx55ndbzmh7w8b3x6q707cb4s6rfan7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.29)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.52
  (package
    (inherit rust-bindgen-0.53)
    (name "rust-bindgen")
    (version "0.52.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0mzy2gjiaggl602yn4a11xzrxfj18kl7pwqa5yv32njkxd257j7i"))))
    (arguments
     `(#:cargo-inputs
       (("rust-shlex" ,rust-shlex-0.1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.51
  (package
    (inherit rust-bindgen-0.52)
    (name "rust-bindgen")
    (version "0.51.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x9gndlnwmxsihxvsc3izyyss7g8b2djn0daafshj1gcy69i7mzb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-shlex" ,rust-shlex-0.1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs `())))

(define-public rust-bindgen-0.50
  (package
    (inherit rust-bindgen-0.51)
    (name "rust-bindgen")
    (version "0.50.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fp98x0k4cawil3rqxsfrb58pq3mb5mn37rp745zxfmjfigml3nb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.47
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.47.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b9fyq3h4lz5xfy6gv5h8v6j3hzyqcarlylvw9zc715pas1pz09a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.26)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-hashbrown" ,rust-hashbrown-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))))))

(define-public rust-bindgen-0.46
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.46.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qclvj5pydn5camw396b0r3nz4nn3p5wpxg4fgg1favp043pyzwg"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.26)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-hashbrown" ,rust-hashbrown-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))) )

(define-public rust-bindgen-0.37
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.37.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "08f2cyzr8fc027mzj2lhmn5j3w318g2ql7yfw5ngxa3yhy1an98v"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-peeking-take-while"
         ,rust-peeking-take-while-0.1)
        ("rust-cexpr" ,rust-cexpr-0.2)
        ("rust-clang-sys" ,rust-clang-sys-0.23)
        ("rust-proc-macro2" ,rust-proc-macro2-0.3)  ; 0.3.5
        ("rust-log" ,rust-log-0.4)
        ("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-quote" ,rust-quote-0.5)
        ("rust-which" ,rust-which-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.49
  (package/inherit rust-bindgen-0.50
    (name "rust-bindgen")
    (version "0.49.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vjacbvashvds5rbrlqvq5fy55wmp50iia3mnczvycap7mzhh1sc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.28)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.33
  (package
    (inherit rust-bindgen-0.50)
    (name "rust-bindgen")
    (version "0.33.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vnw5fb74gl9pgnimgbrkac1xgwrjz86pqilx20rbkia77cdhgk0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cexpr" ,rust-cexpr-0.2)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.22)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-quote" ,rust-quote-0.3)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-which" ,rust-which-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bit-field-0.10
  (package
    (name "rust-bit-field")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-field" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "192rsg8g3ki85gj8rzslblnwr53yw5q4l8vfg6bf1lkn4cfdvdnw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/phil-opp/rust-bit-field")
    (synopsis "Methods for operating on individual bits and ranges of bits")
    (description
     "This is a simple crate which provides the BitField trait, which provides
methods for operating on individual bits and ranges of bits on Rust's integral
types.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.5
  (package
    (name "rust-bit-set")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "100ac8867bvbx9kv634w4xjk98b71i8nq4wdcvpf3cf4ha4j6k78"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bit-vec" ,rust-bit-vec-0.5))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/contain-rs/bit-set")
    (synopsis "Set of bits")
    (description
     "This package provides a set of bits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.4
  (package
    (inherit rust-bit-set-0.5)
    (name "rust-bit-set")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0320hhcbr73yzjpj2237vw2zq728yg7vmzb8dardg04ff4263gyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bit-vec" ,rust-bit-vec-0.4))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bit-vec-0.5
  (package
    (name "rust-bit-vec")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fyh8221s6cxlmng01v8v2ljhavzawqqs8r1xjc66ap5sjavx6zm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/contain-rs/bit-vec")
    (synopsis "Vector of bits")
    (description
     "This package provides a vector of bits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bit-vec-0.4
  (package
    (inherit rust-bit-vec-0.5)
    (name "rust-bit-vec")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pw902a8ail0k64a7092a8vngfzsq7xkj2r22hz6q1z62s5zzd02"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bitflags-1
  (package
    (name "rust-bitflags")
    (version "1.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitflags" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bitflags/bitflags")
    (synopsis "Macro to generate structures which behave like bitflags")
    (description "This package provides a macro to generate structures which
behave like a set of bitflags.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-bitflags-0.9
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitflags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19dk39gfwmhi3iy1x0wgml1fv1bkb525ywy25zwihbm063i05zaf"))))))

(define-public rust-bitflags-0.8
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1x5z8hmirpnapkx6sww8gkc6x0q8ppni0lbsigm3mrba5byfjw0k"))))))

(define-public rust-bitflags-0.7
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v8hh6wdkpk9my8z8442g4hqrqf05h0qj53dsay6mv18lqvqklda"))))))

(define-public rust-bitflags-0.5
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08qdq5w1nd3hzwsrxk0dxzqv4g8wbwj6v2193njskwzdd09r6rsg"))))))

(define-public rust-bitflags-0.2
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09yk0lk3vjsrvfcnzljmgvz9inpjs0idykvni7kij38l5vn807x4"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))))

(define-public rust-bitstream-io-1
  (package
    (name "rust-bitstream-io")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitstream-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01pyk3pipwcbaghi7f0lmp3izjl902cv21yf4b1v5nipkrrrqlq3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/tuffy/bitstream-io")
    (synopsis "Read/write un-aligned values from big or little-endian streams")
    (description
     "This package is a library for reading/writing un-aligned values from/to
streams in big-endian and little-endian formats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitstream-io-0.8
  (package
    (inherit rust-bitstream-io-1)
    (name "rust-bitstream-io")
    (version "0.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitstream-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00a6wy54s1dmadm5xz8k2cbsd7ixvm48mlc45bk0fdy0pbra6jk1"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-bitvec-0.19
  (package
    (name "rust-bitvec")
    (version "0.19.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitvec" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "10bz751jbsy8fj203ibjwil07p2fwfzvx7b326wfssaravlkbfm7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1)
        ("rust-radium" ,rust-radium-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://myrrlyn.net/crates/bitvec")
    (synopsis "Manipulate memory, bit by bit")
    (description
     "This package provides a crate for manipulating memory, bit by bit.")
    (license license:expat)))

(define-public rust-blake2-0.8
  (package
    (name "rust-blake2")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c4k11j04kqhkci6i9b7lz6p13kpcv228pdqixgrawvavaq0gjwl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8)
        ("rust-hex-literal" ,rust-hex-literal-0.1))))
    (home-page "https://github.com/RustCrypto/hashes")
    (synopsis "BLAKE2 hash functions")
    (description "This package provides BLAKE2 hash functions in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blake2-rfc-0.2
  (package
    (name "rust-blake2-rfc")
    (version "0.2.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2-rfc" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0034g47hyq2bzmk40895ill1mbnpmmjakdq3dmm9clidvl5m6vax"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.4)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-constant-time-eq" ,rust-constant-time-eq-0.1))
       #:cargo-development-inputs
       (("rust-data-encoding" ,rust-data-encoding-2))))
    (home-page "https://github.com/cesarb/blake2-rfc")
    (synopsis "Rust implementation of BLAKE2 based on RFC 7693")
    (description
     "This package provides a pure Rust implementation of BLAKE2 based on RFC
7693.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blake2b-simd-0.5
  (package
    (name "rust-blake2b-simd")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blake2b-simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12icvk8ixlivv3jv5nyrg01sajp4s279zb1kmif0nfja4ms2vyyq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayref" ,rust-arrayref-0.3)
        ("rust-arrayvec" ,rust-arrayvec-0.5)
        ("rust-constant-time-eq" ,rust-constant-time-eq-0.1))))
    (home-page "https://github.com/oconnor663/blake2_simd")
    (synopsis "Pure Rust BLAKE2b implementation with dynamic SIMD")
    (description
     "This package provides a pure Rust implementation of the BLAKE2b and
BLAKE2bp hash functions.")
    (license license:expat)))

(define-public rust-blas-sys-0.7
  (package
    (name "rust-blas-sys")
    (version "0.7.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "blas-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0h14zjycwc76v15h8qll9z1xiryvmpvsb5gam97pqpdjrrwv5c8k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/blas-lapack-rs/blas-sys")
    (synopsis "Bindings to BLAS (Fortran)")
    (description
     "This package provides bindings to BLAS (Fortran).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-blobby-0.3
  (package
    (name "rust-blobby")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1s2f3a7lx5rd26554d9940basff7qpyf1y8gkc309cgc8csmalpw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.3))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Iterator over simple binary blob storage")
    (description "This package provides an iterator over simple binary blob
storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blobby-0.1
  (package
    (inherit rust-blobby-0.3)
    (name "rust-blobby")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xicpf3s2mi5xqnx8ps5mdych4ib5nh2nfsbrsg8ar8bjk1girbg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-hex" ,rust-hex-0.3))))))

(define-public rust-block-0.1
  (package
    (name "rust-block")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16k9jgll25pzsq14f244q22cdv0zb4bqacldg3kx6h89d7piz30d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-objc-test-utils" ,rust-objc-test-utils-0.0))))
    (home-page "https://github.com/SSheldon/rust-block")
    (synopsis "Rust interface for Apple's C language extension of blocks")
    (description "This package provides a rust interface for Apple's C language
extension of blocks.")
    (license license:expat)))

(define-public rust-block-buffer-0.9
  (package
    (name "rust-block-buffer")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-buffer" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r4pf90s7d7lj1wdjhlnqa26vvbm6pnc33z138lxpnp9srpi2lj1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.2)
        ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Fixed size buffer for block processing of data")
    (description
     "Fixed size buffer for block processing of data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-buffer-0.8
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-buffer" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0c9x5b8pk25i13bajqjkzf03bm5hx2y8pi9llfvjpy3nhr295kyv"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.1)
        ("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-generic-array" ,rust-generic-array-0.14))))))

(define-public rust-block-buffer-0.7
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12v8wizynqin0hqf140kmp9s38q223mp1b0hkqk8j5pk8720v560"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.1)
        ("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-generic-array" ,rust-generic-array-0.12))))))

(define-public rust-block-buffer-0.3
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1axki8f4rhnxvk6hlli4i53sgmi7c15ffryrv4757nzcp6cc4xm0"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayref" ,rust-arrayref-0.3)
        ("rust-byte-tools" ,rust-byte-tools-0.2))))))

(define-public rust-block-buffer-0.2
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "055q90a6vk80j85i3fixjd5ci0dznrm9lkdd6xbjk7sx5w2a2f8k"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.2)
        ("rust-generic-array" ,rust-generic-array-0.8))))))

(define-public rust-block-cipher-0.7
  (package
    (name "rust-block-cipher")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "043zgfz1x4sxkdcsyabrcr440fcwhfpcqqa54jm7zp35wx4n84zs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for description of block ciphers")
    (description "This package provides traits for description of block
ciphers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-cipher-trait-0.6
  (package
    (name "rust-block-cipher-trait")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x273w6fwka0i48nrv428birdrs2jz6jdnmc0dhc1rq9pm4lv4hw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.12))))
    (home-page "https://github.com/RustCrypto/block-ciphers")
    (synopsis "Block cipher algorithms")
    (description "This package provides a collection of block cipher
algorithms.  This package is deprecated.  Please use block-cipher instead.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-cipher-trait-0.4
  (package
    (inherit rust-block-cipher-trait-0.6)
    (name "rust-block-cipher-trait")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-cipher-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10qmg8vphqmfllb9a2yx6s7r66jh1wh33clhsawq7ikg2wgz2p6q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.8))))))

(define-public rust-block-padding-0.2
  (package
    (name "rust-block-padding")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-padding" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x6b2dgink7rc3755r8jl4kmndydy5563h3wz7z9jqrb25ygv2y9"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Padding and unpadding of messages divided into blocks")
    (description
     "Padding and unpadding of messages divided into blocks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-padding-0.1
  (package
    (inherit rust-block-padding-0.2)
    (name "rust-block-padding")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-padding" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02fz9wx5dmgpc79ndrb9xfxqlrkk7lg5wki2blz2zqg27spw6kbd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byte-tools" ,rust-byte-tools-0.3))))))

(define-public rust-blocking-1
  (package
    (name "rust-blocking")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s9myg9gqmwzrbc38p23bh4vkc8w4pbpddqrcrrl1xz1xpdp1qf5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-task" ,rust-async-task-4)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/stjepang/blocking")
    (synopsis "Thread pool for isolating blocking I/O in async programs")
    (description
     "This package provides a thread pool for isolating blocking I/O in async
programs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blocking-0.6
  (package
    (inherit rust-blocking-1)
    (name "rust-blocking")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13g1xlsd1ardf9wxkj1d03baxfy8f8kvgjz55l6zi1q4jn5f0c1z"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-blocking-0.4
  (package
    (inherit rust-blocking-0.6)
    (name "rust-blocking")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0av1h5p6lb5bpzghmzsksx31icvdwrpxxzkq6r56n1l5pzvqyinj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-futures-lite" ,rust-futures-lite-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking" ,rust-parking-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-boxfnonce-0.1
  (package
    (name "rust-boxfnonce")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "boxfnonce" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09ilf4zyx92hyhkxlsxksfyprzr9iwq5gqqb22aaqr32c8fwp22r"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/stbuehler/rust-boxfnonce")
    (synopsis "Safe FnOnce boxing for Rust")
    (description "This package provides a safe FnOnce boxing for Rust.")
    (license license:expat)))

(define-public rust-bresenham-0.1
  (package
    (name "rust-bresenham")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bresenham" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mvg3zcyll0m3z79jwbg183ha4kb7bw06rd286ijwvgn4mi13hdz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mbr/bresenham-rs")
    (synopsis
     "Iterator-based integer-only implementation of Bresenham's line algorithm")
    (description
     "This package provides a fast, iterator-based integer-only implementation of
Bresenham's line algorithm.")
    (license license:expat)))

(define-public rust-broadcaster-0.2
  (package
    (name "rust-broadcaster")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "broadcaster" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1848lwapy955rs8kbiv87adj68vdlh6vlj8n4wq10vx541j49887"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-futures-executor-preview" ,rust-futures-executor-preview-0.3))))
    (home-page "https://github.com/leo60228/broadcaster")
    (synopsis "Broadcasting futures mpmc channel")
    (description
     "This package provides a wrapper for any Stream and Sink implementing the
@code{mpsc} pattern to enable broadcasting items.")
    (license (list license:expat license:asl2.0))))

(define-public rust-brotli-3
  (package
    (name "rust-brotli")
    (version "3.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gk1g3fx1vps2ic8kh5n32gzq9h5w1j3ff6lvjm171ph428r2abz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2)
        ("rust-alloc-stdlib" ,rust-alloc-stdlib-0.2)
        ("rust-brotli-decompressor" ,rust-brotli-decompressor-2)
        ("rust-packed-simd" ,rust-packed-simd-0.3)
        ("rust-sha2" ,rust-sha2-0.8))))
    (home-page "https://github.com/dropbox/rust-brotli")
    (synopsis "Brotli compressor and decompressor")
    (description "This package provides a brotli compressor and decompressor
with no dependency on the rust stdlib.  This makes it suitable for embedded
devices and kernels.")
    (license (list license:bsd-3 license:expat))))

(define-public rust-brotli-decompressor-2
  (package
    (name "rust-brotli-decompressor")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli-decompressor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v7l1sa63ix1aq8h0k1ijvxvb5w796hz154b9aw0xn6lp31y2lhh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2)
        ("rust-alloc-stdlib" ,rust-alloc-stdlib-0.2))))
    (home-page "https://github.com/dropbox/rust-brotli-decompressor")
    (synopsis "Brotli decompressor")
    (description "This package provides a brotli decompressor with no
dependency on the rust stdlib.  This makes it suitable for embedded devices
and kernels.")
    (license (list license:bsd-3 license:expat))))

(define-public rust-brotli-sys-0.3
  (package
    (name "rust-brotli-sys")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kdfdbcba6zwa13xpjwgiplblkdf6vigxjbwwp6l2ascbylxwia4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/alexcrichton/brotli2-rs")
    (synopsis "Raw bindings to libbrotli")
    (description "This package provides raw bindings to libbrotli.")
    (license (list license:expat license:asl2.0))))

(define-public rust-brotli2-0.3
  (package
    (name "rust-brotli2")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "brotli2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13jnhpmfkqy2xar4lxrsk3rx3i12bgnarnsxq4arhc6yxb1kdc0c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-brotli-sys" ,rust-brotli-sys-0.3)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.4))))
    (home-page "https://github.com/alexcrichton/brotli2-rs")
    (synopsis "Rust bindings to compression library libbrotli")
    (description
     "This package provides bindings to libbrotli to provide brotli
decompression and compression to Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bs58-0.2
  (package
    (name "rust-bs58")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bs58" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "125i962x0m0ggdif6ds51wfif2lypiicy469dj5j2l6rm6xycpn9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-sha2" ,rust-sha2-0.8))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-base58" ,rust-base58-0.1)
        ("rust-rust-base58" ,rust-rust-base58-0.0))))
    (home-page "https://github.com/mycorrhiza/bs58-rs")
    (synopsis "Another Base58 codec implementation")
    (description
     "Another Base58 codec implementation.  Compared to the base58 crate this
is significantly faster at decoding (about 2.4x as fast when decoding 32
bytes), almost the same speed for encoding (about 3% slower when encoding 32
bytes), doesn't have the 128 byte limitation and supports a configurable
alphabet.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bson-0.14
  (package
    (name "rust-bson")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bson" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "000wqyb4icy32h74wl5wb6iw2flzwwlrpgq51xgcw91g2b87w5rw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-decimal" ,rust-decimal-2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-linked-hash-map" ,rust-linked-hash-map-0.5)
        ("rust-md5" ,rust-md5-0.6)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/mongodb/bson-rust")
    (synopsis "Encoding and decoding support for BSON in Rust")
    (description
     "This package provides encoding and decoding support for BSON in Rust.")
    (license license:expat)))

(define-public rust-bstr-0.2
  (package
    (name "rust-bstr")
    (version "0.2.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bstr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gca4v6448clsssll3y787jgw542c9mw9phqdi7419g1jfnlf2x4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex-automata" ,rust-regex-automata-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-ucd-parse" ,rust-ucd-parse-0.1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/BurntSushi/bstr")
    (synopsis
     "String type that is not required to be valid UTF-8")
    (description
     "This package provides a string type that is not required to be valid
UTF-8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bstr-0.1
  (package
    (inherit rust-bstr-0.2)
    (name "rust-bstr")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bstr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0nzi9vqhl56ws8gq39f3aj4qjrr4l3g5lbkkcj8xq1x4cb74wq2r"))))))

(define-public rust-buf-redux-0.8
  (package
    (name "rust-buf-redux")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buf_redux" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zy0p4vd2kjk7z5m4m8kdwhs5cmx1z02n7v36njhgfs8fs4aclxr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-memchr" ,rust-memchr-2)
        ("rust-safemem" ,rust-safemem-0.3)
        ("rust-slice-deque" ,rust-slice-deque-0.2))))
    (home-page "https://github.com/abonander/buf_redux")
    (synopsis "Drop-in replacements for buffered I/O in @code{std::io}")
    (description
     "This package provides drop-in replacements for buffered I/O in
@code{std::io}, with extra features.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buffered-reader-0.9
  (package
    (name "rust-buffered-reader")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffered-reader" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05rklfiia1k4c4ifpim08l22i0q0l3j9xdg2yh3njrp6w58z6z13"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bzip2" ,rust-bzip2-0.3)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://sequoia-pgp.org/")
    (synopsis "Super-powered Reader")
    (description
     "Like the @code{BufRead} trait, the @code{BufferedReader} trait has an
internal buffer that is directly exposed to the user.  This design enables two
performance optimizations.  First, the use of an internal buffer amortizes
system calls.  Second, exposing the internal buffer allows the user to work
with data in place, which avoids another copy.")
    (license license:gpl3)))

(define-public rust-bugreport-0.3
  (package
    (name "rust-bugreport")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bugreport" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1n5f1nkqbc5yf9bckjap49pwnqnvdczm6x9y23caaghpgw0n4rqi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-snailquote" ,rust-snailquote-0.3)
        ("rust-sys-info" ,rust-sys-info-0.7))))
    (home-page "https://github.com/sharkdp/bugreport")
    (synopsis "Collect system and environment information for bug reports")
    (description
     "bugreport is a Rust library that helps application developers to
automatically collect information about the system and the environment that
users can send along with a bug report.")
    (license (list license:expat license:asl2.0))))

(define-public rust-build-const-0.2
  (package
    (name "rust-build-const")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "build_const" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0faz882spx9474cszay2djmb0lghbwq51qayabcar1s7g4r2l29r"))))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/build_const")
    (synopsis "Create importable constants from build.rs or a script")
    (description "This package provides a library for creating importable
constants from build.rs or a script.")
    (license license:expat)))

(define-public rust-bumpalo-3
  (package
    (name "rust-bumpalo")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bumpalo" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11silgpsnfv6ir7j2nh7a69564f92vq20k9ha7zcbynpiav9vbhj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; cargo_readme_up_to_date test fails
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/fitzgen/bumpalo")
    (synopsis "Fast bump allocation arena for Rust")
    (description
     "This package provides a fast bump allocation arena for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bumpalo-2
  (package
    (inherit rust-bumpalo-3)
    (name "rust-bumpalo")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bumpalo" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "020psxs5dlm0gdbs83rx2rcavibdshdr0fpzk3mmw65zq8ppz05d"))))
    (arguments
     `(#:tests? #f      ; cargo_readme_up_to_date test fails
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))))

(define-public rust-byte-pool-0.2
  (package
    (name "rust-byte-pool")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-pool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yh96ral0pni02bzm3fhvicp1ixz1hz3c5m03hsyq66mk61fjf0y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-queue" ,rust-crossbeam-queue-0.2)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://crates.io/crates/byte-pool")
    (synopsis "Pool of byte slices, for efficient memory usage")
    (description
     "This package provides a pool of byte slices, for efficient
memory usage.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-byte-tools-0.3
  (package
    (name "rust-byte-tools")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-tools" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mqi29wsm8njpl51pfwr31wmpzs5ahlcb40wsjyd92l90ixcmdg3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Bytes related utility functions")
    (description "Bytes related utility functions.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-byte-tools-0.2
  (package
    (inherit rust-byte-tools-0.3)
    (name "rust-byte-tools")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-tools" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h2zxygfnn46akmgh8cdp4x6xy4kb0b45rzmj76rxa0j99bk432n"))))))

(define-public rust-byte-unit-4
  (package
    (name "rust-byte-unit")
    (version "4.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-unit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lxi11qf6h1rqr0yhsh7i6755l325qrkv9r4bgismyik531mi1qw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-utf8-width" ,rust-utf8-width-0.1))))
    (home-page "https://magiclen.org/byte-unit")
    (synopsis "Library for interaction with units of bytes.")
    (description
     "This package provides a library for interaction with units of bytes.")
    (license license:expat)))

(define-public rust-bytecount-0.6
  (package
    (name "rust-bytecount")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecount" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vplsx73zncb7mz8x0fs3k0p0rz5bmavj09vjk5nqn4z6fa7h0dh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/llogiq/bytecount")
    (synopsis "Count occurrences of a given byte")
    (description
     "Count occurrences of a given byte, or the number of UTF-8 code points,
in a byte slice, fast.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bytecount-0.5
  (package
    (inherit rust-bytecount-0.6)
    (name "rust-bytecount")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecount" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0z6a280kiy4kg5v3qw97pbyvwycr17fsm41804i8zpq7nmads3xy"))))
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-bytecount-0.4
  (package
    (inherit rust-bytecount-0.5)
    (name "rust-bytecount")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytecount" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "13qpy38z5wx0rzcdvr2h0ixbfgi1dbrif068il3hwn3k2mah88mr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-bytemuck-1
  (package
    (name "rust-bytemuck")
    (version "1.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "071043n73hwi55z9c55ga4v52v8a7ri56gqja8r98clkdyxns14j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck-derive" ,rust-bytemuck-derive-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Crate for mucking around with piles of bytes")
    (description
     "This package provides a crate for mucking around with piles of bytes.")
    (license license:zlib)))

(define-public rust-bytemuck-derive-1
  (package
    (name "rust-bytemuck-derive")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck-derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1k59b6g2d87nf32qwhp73vng3al0zklxg64iiwf0pkxy74xf5ni8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-bytemuck" ,rust-bytemuck-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Derive proc-macros for @code{bytemuck}")
    (description
     "This package derives proc-macros for the @code{bytemuck} crate.")
    (license
      (list license:zlib license:asl2.0 license:expat))))

(define-public rust-byteorder-1
  (package
    (name "rust-byteorder")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0srh0h0594jmsnbvm7n0g8xabhla8lwb3gn8s0fzd7d1snix2i5f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/BurntSushi/byteorder")
    (synopsis "Reading/writing numbers in big-endian and little-endian")
    (description
     "This library is used for reading or writing numbers in big-endian and
little-endian.")
    (license (list license:expat license:unlicense))))

(define-public rust-byteorder-0.5
  (package
    (inherit rust-byteorder-1)
    (name "rust-byteorder")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ma8pkyz1jbglr29m1yzlc9ghmv6672nvsrn7zd0yn5jqs60xh8g"))))
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bytes-1
  (package
    (name "rust-bytes")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h6h1c8g3yj2b4k8g25gr3246mq985y0kl3z685cs784fr1ww05p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tokio-rs/bytes")
    (synopsis "Types and traits for working with bytes")
    (description "This package is a utility library for working with bytes.")
    (license license:expat)))

(define-public rust-bytes-0.6
  (package
    (inherit rust-bytes-1)
    (name "rust-bytes")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05ivrcbgl4f7z2zzm9hbsi8cy66spi70xlm6fp16zsq4ylsvrp70"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.3)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.5
  (package
    (inherit rust-bytes-0.6)
    (name "rust-bytes")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f5s7xq6qzmdh22ygsy8v0sp02m51y0radvq4i4y8cizy1lfqk0f"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))))))

(define-public rust-bytes-0.4
  (package/inherit rust-bytes-0.5
    (name "rust-bytes")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0768a55q2fsqdjsvcv98ndg9dq7w2g44dvq1avhwpxrdzbydyvr0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-either" ,rust-either-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.3
  (package
    (inherit rust-bytes-0.4)
    (name "rust-bytes")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytes" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09vcp9kh12pva2xn2ir79k90v1a0id8f4sdv1abn5ifw2bqsyaf1"))))
    (arguments
     `(#:tests? #f      ; Tests not distributed in crate.
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bytestring-0.1
  (package
    (name "rust-bytestring")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytestring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qzkncgky5p5vsdb9msmfg6d92dcs9idcjcr5nk7inkja7x0az7w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://actix.rs")
    (synopsis "UTF-8 encoded string with Bytes as a storage")
    (description
     "This package provides a UTF-8 encoded string with Bytes as a storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bzip2-0.4
  (package
    (name "rust-bzip2")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gpwm7qj8adi0zffm8r17vkv6f98d1q9glvpjk28v0wb6kz88p97"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bzip2-sys" ,rust-bzip2-sys-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))
    (home-page "https://github.com/alexcrichton/bzip2-rs")
    (synopsis
     "Rust bindings to libbzip2 for bzip2 compression and decompression")
    (description
     "Bindings to @code{libbzip2} for @code{bzip2} compression and decompression
exposed as Reader/Writer streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bzip2-0.3
  (package
    (inherit rust-bzip2-0.4)
    (name "rust-bzip2")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fvfwanp42j1zpig880jhb5mc0na50bijmwd6211p77sy35w7ds2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bzip2-sys" ,rust-bzip2-sys-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-partial-io" ,rust-partial-io-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))))

(define-public rust-bzip2-sys-0.1
  (package
    (name "rust-bzip2-sys")
    (version "0.1.9+1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bzip2-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pi8lxzb1104q9cpvv1jgnk909cggqh2zcdhywqwlbq6c2i3jfxd"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (delete-file-recursively "bzip2-1.0.8")
            (delete-file "build.rs")
            ;; Inspired by Debian's patch.
            (with-output-to-file "build.rs"
              (lambda _
                (format #t "fn main() {~@
                        println!(\"cargo:rustc-link-lib=bz2\");~@
                        }~%")))
            #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/alexcrichton/bzip2-rs")
    (synopsis "Rust bindings to libbzip2")
    (description
     "Bindings to @code{libbzip2} for bzip2 compression and decompression
exposed as Reader/Writer streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-c2-chacha-0.2
  (package
    (name "rust-c2-chacha")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "c2-chacha" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00a11qdc8mg3z0k613rhprkc9p6xz0y7b1681x32ixg0hr3x0r3x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-ppv-lite86" ,rust-ppv-lite86-0.2)
        ("rust-stream-cipher" ,rust-stream-cipher-0.3))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/cryptocorrosion/cryptocorrosion")
    (synopsis "The ChaCha family of stream ciphers")
    (description
     "The ChaCha family of stream ciphers.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cache-padded-1
  (package
    (name "rust-cache-padded")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cache-padded" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fkdwv9vjazm6fs3s5v56mm4carwswdmw8fcwm9ygrcvihcya6k3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/cache-padded")
    (synopsis "Prevent once piece of data invalidating other cached data")
    (description
     "In concurrent programming, sometimes it is desirable to make sure
commonly accessed shared data is not all placed into the same cache line.
Updating an atomic value invalides the whole cache line it belongs to, which
makes the next access to the same cache line slower for other CPU cores.  Use
CachePadded to ensure updating one piece of data doesn't invalidate other
cached data.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cachedir-0.1
  (package
    (name "rust-cachedir")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cachedir" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1j18j73fxrr82marcdrn86123vr9v5n0fgyjkf9mi9pzyk8hjrf0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-tempfile" ,rust-tempfile-3))
       ;; Tests require a mutable home directory and access to /var/tmp.
       #:tests? #f))
    (home-page "https://github.com/lilianmoraru/cachedir")
    (synopsis "Interact with cache directories and @file{CACHEDIR.TAG} files")
    (description
     "This package provides a library to help interacting with cache
directories and @code{CACHEDIR.TAG} files.")
    (license (list license:expat license:asl2.0))))

(define-public rust-calamine-0.17
  (package
    (name "rust-calamine")
    (version "0.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calamine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "095sx7dma2p1pn464l51ac6drih3c1bhwfw8g0y00vdwqwmrrvn8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-codepage" ,rust-codepage-0.1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-quick-xml" ,rust-quick-xml-0.19)
        ("rust-serde" ,rust-serde-1)
        ("rust-zip" ,rust-zip-0.5))))
    (home-page "https://github.com/tafia/calamine")
    (synopsis "Reader and deserializer for spreadsheet files")
    (description
     "@code{calamine} is a pure Rust library to read and deserialize any
spreadsheet file.")
    (license license:expat)))

(define-public rust-calamine-0.16
  (package
    (inherit rust-calamine-0.17)
    (name "rust-calamine")
    (version "0.16.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calamine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03nl0n79rbq5x0crgg59brxr86hc9k5kjbf3h7d5c8g5mzlkxf9n"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-codepage" ,rust-codepage-0.1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-quick-xml" ,rust-quick-xml-0.19)
        ("rust-serde" ,rust-serde-1)
        ("rust-zip" ,rust-zip-0.5))))))

(define-public rust-calloop-0.6
  (package
    (name "rust-calloop")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z3jlsv3g28097dhsmi2l8nzkd3p937jhb4pg52njhb0wxkn20qb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.18))))
    (home-page "https://github.com/Smithay/calloop")
    (synopsis "Callback-based event loop")
    (description "This package provides a callback-based event loop.")
    (license license:expat)))

(define-public rust-calloop-0.4
  (package
    (inherit rust-calloop-0.6)
    (name "rust-calloop")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0q6ic9lr0s86886mbyn4yncg68b2sykgwjf3iygdw01swmxhk8ks"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (substitute* "Cargo.toml"
              (("=1.0.0") "^1.0.0"))
            #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-nix" ,rust-nix-0.14))
       #:cargo-development-inputs
       (("rust-lazycell" ,rust-lazycell-1))))))

(define-public rust-capnp-0.13
  (package
    (name "rust-capnp")
    (version "0.13.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bx2pj0ysmyd1ryd5s43m3c7n5k067x1aciqiiyg4kjswlcs6xjf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Runtime library for Cap'n Proto data encoding")
    (description "This package provides a runtime library for Cap'n Proto data
encoding.")
    (license license:expat)))

(define-public rust-capnp-0.10
  (package
    (inherit rust-capnp-0.13)
    (name "rust-capnp")
    (version "0.10.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "capnp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "17hsnmlcrzksjjpwpz51y8g36xzq8042i2cwns0lsg7rixfw2rxq"))))
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2))))))

(define-public rust-capnp-futures-0.13
  (package
    (name "rust-capnp-futures")
    (version "0.13.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-futures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18q93ncbfcnjq7zhvy9idnifypmi2qcp775q7454y3r4lvvdcyyw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-futures" ,rust-futures-0.3))
       #:cargo-development-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Async serialization for Cap'n Proto messages")
    (description "This package provides async serialization for Cap'n Proto
messages.")
    (license license:expat)))

(define-public rust-capnp-futures-0.10
  (package
    (inherit rust-capnp-futures-0.13)
    (name "rust-capnp-futures")
    (version "0.10.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "capnp-futures" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0qdiqkp9mh4acpa0dqhpzv2gwf949rj3m85mgwl1rih6gvgbh1zs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.10)
        ("rust-futures" ,rust-futures-0.1))
       #:cargo-development-inputs
       (("rust-capnp" ,rust-capnp-0.10)
        ("rust-quickcheck" ,rust-quickcheck-0.2))))))

(define-public rust-capnp-rpc-0.13
  (package
    (name "rust-capnp-rpc")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-rpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17p0y0yk68pzsnpmaklhiqrrlrrv0ld8nhbg4qflmgibshi8b69p"))))
    (build-system cargo-build-system)
    (native-inputs
     `(("capnproto" ,capnproto)))
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.13)
        ("rust-capnp-futures" ,rust-capnp-futures-0.13)
        ("rust-futures" ,rust-futures-0.3))
       #:cargo-development-inputs
       (("rust-capnpc" ,rust-capnpc-0.13))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto remote procedure call protocol implementation")
    (description "This package provides an implementation of the Cap'n Proto
remote procedure call protocol")
    (license license:expat)))

(define-public rust-capnp-rpc-0.10
  (package
    (inherit rust-capnp-rpc-0.13)
    (name "rust-capnp-rpc")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "capnp-rpc" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1j6xg7yays1hlm1045wviyn1642yvvi2p4kba26yk07a0kafr3jn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.10)
        ("rust-capnp-futures" ,rust-capnp-futures-0.10)
        ("rust-capnpc" ,rust-capnpc-0.10)
        ("rust-futures" ,rust-futures-0.1))))))

(define-public rust-capnpc-0.13
  (package
    (name "rust-capnpc")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hbm5xqpam3f0ha5ds39wjmpqpzdalpbrls9wlp7m3slh3p5r1c1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-capnp" ,rust-capnp-0.13))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto code generation")
    (description "Cap'n Proto code generation")
    (license license:expat)))

(define-public rust-capnpc-0.10
  (package
    (inherit rust-capnpc-0.13)
    (name "rust-capnpc")
    (version "0.10.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "capnpc" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1zxbmdkr0xfzkfq9p8zn7pp9jjq275qhr8fh9a0cc0ab37yfvbyj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-capnp" ,rust-capnp-0.10))))))

(define-public rust-caps-0.3
  (package
    (name "rust-caps")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caps" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vplgzx8nifzr3f0l8ca77jqnz3fdymdg0ickacgdvawc44a3n90"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-errno" ,rust-errno-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/lucab/caps-rs")
    (synopsis "Pure-Rust library to work with Linux capabilities")
    (description
     "This package provides a pure-Rust library to work with Linux
capabilities")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-metadata-0.9
  (package
    (name "rust-cargo-metadata")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cargo_metadata" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "00pjms89lghvizh4d55lz80hvrih9r55xv9m5wd9vcsgc163gqs6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-semver" ,rust-semver-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-docopt" ,rust-docopt-1)
        ("rust-structopt" ,rust-structopt-0.2))))
    (home-page "https://github.com/oli-obk/cargo_metadata")
    (synopsis "Structured access to the output of `cargo metadata`")
    (description
     "This package provides structured access to the output of @code{cargo
metadata}.")
    (license license:expat)))

(define-public rust-cargo-metadata-0.6
  (package
    (inherit rust-cargo-metadata-0.9)
    (name "rust-cargo-metadata")
    (version "0.6.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cargo_metadata" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1givpi2w7iwqqnl87x5yc15zcm5hs6yw490sb6abkfp1h39v9lg5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-semver" ,rust-semver-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (;("rust-docopt" ,rust-docopt-0.8)
        ("rust-clap" ,rust-clap-2))))))

(define-public rust-cargon-0.0
  (package
    (name "rust-cargon")
    (version "0.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cargon" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1cszlab7jk736p0lb50ag4l9nv72m7j41bwrmygl0lr4iz0350w2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/bryant/argon2rs")
    (synopsis "Thin wrapper around the Argon2 C library")
    (description
     "This package provides a thin wrapper around the Argon2 C library.  It is
used in argon2rs' bench suite.")
    (license license:wtfpl2)))

(define-public rust-cassowary-0.3
  (package
    (name "rust-cassowary")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cassowary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lvanj0gsk6pc1chqrh4k5k0vi1rfbgzmsk46dwy3nmrqyw711nz"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/dylanede/cassowary-rs")
    (synopsis
     "Implementation of the Cassowary linear constraint solving algorithm")
    (description
     "This package provides a Rust implementation of the Cassowary linear
constraint solving algorithm.

The Cassowary algorithm is designed for naturally laying out user interfaces
using linear constraints, like ``this button must line up with this text
box''.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cast-0.2
  (package
    (name "rust-cast")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cast" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1c5z7zryj0zwnhdgs6rw5dfvnlwc1vm19jzrlgx5055alnwk952b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/japaric/cast.rs")
    (synopsis
     "Ergonomic, checked cast functions for primitive types")
    (description
     "Ergonomic, checked cast functions for primitive types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cblas-sys-0.1
  (package
    (name "rust-cblas-sys")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cblas-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0rgsn3klhhh09d8qf3b87zl4rwk93l2g0qzh9hhb0lff5kcfrzmn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/blas-lapack-rs/cblas-sys")
    (synopsis "Bindings to CBLAS (C)")
    (description
     "The package provides bindings to CBLAS (C).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cc-1
  (package
    (name "rust-cc")
    (version "1.0.66")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cc" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0j7d7h4n81z5f22l3v8ggjvvw8m64636nlaqax4x1y44da1rc12c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-jobserver" ,rust-jobserver-0.1))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/alexcrichton/cc-rs")
    (synopsis "Invoke the native C compiler")
    (description
     "This package provides a build-time dependency for Cargo build scripts to
assist in invoking the native C compiler to compile native C code into a static
archive to be linked into Rustcode.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cesu8-1
  (package
    (name "rust-cesu8")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cesu8" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g6q58wa7khxrxcxgnqyi9s1z2cjywwwd3hzr5c55wskhx6s0hvd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/emk/cesu8-rs")
    (synopsis "Convert to and from CESU-8 encoding")
    (description
     "This library implements the CESU-8 compatibility encoding scheme.  This
is a non-standard variant of UTF-8 that is used internally by some systems
that need to represent UTF-16 data as 8-bit characters.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.4
  (package
    (name "rust-cexpr")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cexpr" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09qd1k1mrhcqfhqmsz4y1bya9gcs29si7y3w96pqkgid4y2dpbpl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-5))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.28))))
    (inputs
     `(("clang" ,clang)))
    (home-page "https://github.com/jethrogb/rust-cexpr")
    (synopsis "C expression parser and evaluator")
    (description
     "This package provides a C expression parser and evaluator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.3
  (package
    (inherit rust-cexpr-0.4)
    (name "rust-cexpr")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07fdfj4ff2974y33yixrb657riq9zl9b9h9lr0h7ridhhvxvbrgw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-4))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.28))))))

(define-public rust-cexpr-0.2
  (package
    (inherit rust-cexpr-0.3)
    (name "rust-cexpr")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v1xa3758czmj8h97gh548mr8g0v13ixxvrlm1s79nb7jmgc9aj2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-3))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.11))))))

(define-public rust-cfg-if-1
  (package
    (name "rust-cfg-if")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-if" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/alexcrichton/cfg-if")
    (synopsis "Define an item depending on parameters")
    (description
     "This package provides a macro to ergonomically define an item depending
on a large number of @code{#[cfg]} parameters.  Structured like an if-else
chain, the first matching branch is the item that gets emitted.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cfg-if-0.1
  (package
    (inherit rust-cfg-if-1)
    (name "rust-cfg-if")
    (version "0.1.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cfg-if" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "08h80ihs74jcyp24cd75wwabygbbdgl05k6p5dmq8akbr78vv1a7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))))

(define-public rust-chrono-0.4
  (package
    (name "rust-chrono")
    (version "0.4.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wyfl6c00vhfl562spnfcna3zkw8jqvcp652m9iskhl8j26dc2k7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pure-rust-locales" ,rust-pure-rust-locales-0.5)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-0.8)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-num-iter" ,rust-num-iter-0.1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))
       #:features '("unstable-locales")
       #:tests? #f))
    (home-page "https://github.com/chronotope/chrono")
    (synopsis "Date and time library for Rust")
    (description "Date and time library for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-0.5
  (package
    (name "rust-chrono-tz")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "085i4940kn0fn4gkl3xi1kv3vp2frhfig1vla1i461pcbwas6m15"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/chronotope/chrono-tz")
    (synopsis "TimeZone implementations for rust-chrono from the IANA database")
    (description
     "Chrono-TZ is a library that provides implementors of the
TimeZone trait for @code{rust-chrono}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chunked-transfer-0.3
  (package
    (name "rust-chunked-transfer")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chunked_transfer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11yghnd24w0i9p8g368c3pg7qh9nfz7kgri6pywja9pnmakj13a9"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/frewsxcv/rust-chunked-transfer")
    (synopsis "Encoder and decoder for HTTP chunked transfer coding")
    (description
     "This package provides an encoder and decoder for HTTP chunked transfer
coding.")
    (license license:asl2.0)))

(define-public rust-ci-info-0.3
  (package
    (name "rust-ci-info")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ci-info" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00pr17g6q6i752acrkycg0hkq3lm0p634anm41g3m6lqg8q83s75"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/sagiegurari/ci_info")
    (synopsis "Provides current CI environment information")
    (description
     "This package provides current CI environment information.")
    (license license:asl2.0)))

(define-public rust-clang-sys-1
  (package
    (name "rust-clang-sys")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0695kfrqx7n091fzm6msbqg2q2kyhka64q08lm63f3l9d964i8cx"))))
    (build-system cargo-build-system)
    (inputs
     `(("clang" ,clang)))
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.6))))
    (home-page "https://github.com/KyleMayes/clang-sys")
    (synopsis "Rust bindings for libclang")
    (description "This package provides Rust bindings for libclang.")
    (license license:asl2.0)))

(define-public rust-cipher-0.2
  (package
    (name "rust-cipher")
    (version "0.2.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cipher" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "00b8imbmdg7zdrbaczlivmdfdy09xldg95wl4iijl15xgjcfgy0j"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-blobby" ,rust-blobby-0.3)
         ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://docs.rs/cipher/")
    (synopsis "Traits for describing block ciphers and stream ciphers")
    (description "This package provides traits which define the functionality
of block ciphers and stream ciphers.  See RustCrypto/block-ciphers and
RustCrypto/stream-ciphers for algorithm implementations which use these
traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clang-sys-0.29
  (package
    (inherit rust-clang-sys-1)
    (name "rust-clang-sys")
    (version "0.29.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "02nibl74zbz5x693iy5vdbhnfckja47m7j1mp2bj7fjw3pgkfs7y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.28
  (package
    (inherit rust-clang-sys-0.29)
    (name "rust-clang-sys")
    (version "0.28.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ls8zcqi5bmmrvrk3b6r1ym4wlivinbv590d2dvg2xn9f44mbpl1"))))))

(define-public rust-clang-sys-0.26
  (package
    (inherit rust-clang-sys-0.28)
    (name "rust-clang-sys")
    (version "0.26.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1r50dwy5hj5gq07dn0qf8222d07qv0970ymx0j8n9779yayc3w3f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.23
  (package
    (inherit rust-clang-sys-0.26)
    (name "rust-clang-sys")
    (version "0.23.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hjr333izzhs6bic84qwnyzy5xzmvasib8f3zkzj4ln3a97c1xyp"))))))

(define-public rust-clang-sys-0.22
  (package
    (inherit rust-clang-sys-0.26)
    (name "rust-clang-sys")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0f65dw1ydnzq4wrv894fql78n4ikb53jjp53xck0s4hb64s1m6lk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-glob" ,rust-glob-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.11
  (package
    (inherit rust-clang-sys-0.22)
    (name "rust-clang-sys")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17i47skqp1d9svil2m1wspnhz7ci1x0fipia70ns0qffciwiz48r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-0.7)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-glob" ,rust-glob-0.2)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.3))))))

(define-public rust-clap-2
  (package
    (name "rust-clap")
    (version "2.33.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clap" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "00i065a58987k1sbzqmlz721rw521zcg08jmsh40gi3khp3qmr9p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.11)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-strsim" ,rust-strsim-0.8)
        ("rust-term-size" ,rust-term-size-0.3)
        ("rust-textwrap" ,rust-textwrap-0.11)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vec-map" ,rust-vec-map-0.8)
        ("rust-yaml-rust" ,rust-yaml-rust-0.3))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://clap.rs/")
    (synopsis "Command Line Argument Parser")
    (description
     "This package provides a simple to use, efficient, and full-featured
Command Line Argument Parser.")
    (license license:expat)))

(define-public rust-clicolors-control-1
  (package
    (name "rust-clicolors-control")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clicolors-control" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "07klix8nbpwk0cg1k4h0kkiijm1jxvrzndqdkr7dqr6xvkjjw24h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/clicolors-control")
    (synopsis "Common utility library to control CLI colorization")
    (description
     "This package provides a common utility library to control CLI
colorization.")
    (license license:expat)))

(define-public rust-clipboard-win-4
  (package
    (name "rust-clipboard-win")
    (version "4.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clipboard-win" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bd9gw35zjdh50n2gy6qq2gwpnqfafzwkliqkvm9z046fawwc8si"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-code" ,rust-error-code-2)
        ("rust-str-buf" ,rust-str-buf-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/DoumanAsh/clipboard-win")
    (synopsis "Simple way to interact with Windows clipboard")
    (description
     "This package provides simple way to interact with Windows clipboard.")
    (license license:boost1.0)))

(define-public rust-clipboard-win-3
  (package
    (inherit rust-clipboard-win-4)
    (name "rust-clipboard-win")
    (version "3.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clipboard-win" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hh3npqfa1lfn62fwvkmjlpfnizq343a994b898ffsvb100mxpwz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-bytes-cast" ,rust-lazy-bytes-cast-5)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-clipboard-win-2
  (package
    (inherit rust-clipboard-win-3)
    (name "rust-clipboard-win")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clipboard-win" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0431sg4jhabrqf2dliiwhbx9hinb9z4qfcm6914lm5mb17ya5798"))))
    (arguments
     `(#:tests? #f  ; Tests are for Windows.
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-clippy-0.0
  (package
    (name "rust-clippy")
    (version "0.0.302")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1562x3sq9mgmc8j39gd34wqm7ybrdvpmj7cc1n450gwsawayw4fr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/rust-lang/rust-clippy")
    (synopsis
     "Lints to avoid common pitfalls in Rust")
    (description
     "This package provides a bunch of helpful lints to avoid common
pitfalls in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clircle-0.3
  (package
    (name "rust-clircle")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clircle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15p36klnsgjimfswi0mjc7wsh4b662v7gbfinh56ipk3bacbv2z6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/niklasmohrin/clircle")
    (synopsis "Detect IO circles in your CLI apps arguments.")
    (description
     "Clircle provides a cross-platform API to detect read or write cycles
from your user-supplied arguments.  You can get the important identifiers of
a file (from a path) and for all three stdio streams, if they are piped from
or to a file as well.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cloudabi-0.1
  (package
    (name "rust-cloudabi")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0rv4yf5jlldfkynzrw687s00f4x12ypw7axv71vawhy6h4i52i23"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://cloudabi.org/")
    (synopsis "Low level interface to CloudABI")
    (description "This package provides a low level interface to CloudABI.  It
contains all syscalls and related types.")
    (license license:bsd-2)))

(define-public rust-cloudabi-0.0
  (package
    (inherit rust-cloudabi-0.1)
    (name "rust-cloudabi")
    (version "0.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0kxcg83jlihy0phnd2g8c2c303px3l2p3pkjz357ll6llnd5pz6x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))))

(define-public rust-cloudflare-zlib-sys-0.2
  (package
    (name "rust-cloudflare-zlib-sys")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudflare-zlib-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "01lwfd15ijw4d8jsqp87yv4wpmzcp84qm0qqwy3yxmm0fjr5q6by"))))
    ;; This crate bundles cloudflare's fork of zlib, so we don't unbundle it.
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/cloudflare/zlib")
    (synopsis
     "Cloudflare fork of zlib with massive performance improvements")
    (description
     "Cloudflare fork of zlib with massive performance improvements.")
    (license
      (list license:expat
            license:asl2.0
            license:zlib))))

(define-public rust-cmac-0.5
  (package
    (name "rust-cmac")
    (version "0.5.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cmac" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0wj2kd4lb5hb7dvxfad4hi8gklmbq8vvvcnzmmqgxr94fx7xxm3k"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-crypto-mac" ,rust-crypto-mac-0.10)
         ("rust-dbl" ,rust-dbl-0.3))))
    (home-page "https://docs.rs/cmac/")
    (synopsis "Generic implementation of Cipher-based Message Authentication
Code")
    (description "This package provides a pure Rust implementation of the
Cipher-based Message Authentication Code (CMAC).")
    (license (list license:expat license:asl2.0))))  ; at your choice

(define-public rust-cmake-0.1
  (package
    (name "rust-cmake")
    (version "0.1.44")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cmake" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1fv346ipxmvff6qrnh78rild0s8k72ilfjkdsrk869562y62cmhf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/alexcrichton/cmake-rs")
    (synopsis "Rust build dependency for running cmake")
    (description
     "This package provides a build dependency for running @code{cmake} to build
a native library.  The CMake executable is assumed to be @code{cmake} unless the
CMAKE environmental variable is set.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cocoa-0.24
  (package
    (name "rust-cocoa")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cp8hsajmi7gini22bmlsf9dac7cap7x1k169vxhwlr3j8p90qvg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa-foundation" ,rust-cocoa-foundation-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Cocoa for macOS")
    (description "This package provides bindings to Cocoa for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cocoa-0.23
  (package
    (inherit rust-cocoa-0.24)
    (name "rust-cocoa")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cj4c2axmg7aiid2786mpzj7wxpd582biv7c7yimqfnggp002hn5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa-foundation" ,rust-cocoa-foundation-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.22
  (package
    (inherit rust-cocoa-0.23)
    (name "rust-cocoa")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19qyyv01yzrm6aahn6cdxvb4jhl6v4fj0cgqkxmq38i7hq3dqzv6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.21)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.19
  (package
    (inherit rust-cocoa-0.22)
    (name "rust-cocoa")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0034vahbfv574q4b63rj241b8rnka5cjiqsqc6wiggnin9l7g7zj"))))
    (arguments
     `(#:skip-build? #t     ; only for macOS
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.6)
        ("rust-core-graphics" ,rust-core-graphics-0.17)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))))

(define-public rust-cocoa-0.18
  (package
    (inherit rust-cocoa-0.19)
    (name "rust-cocoa")
    (version "0.18.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m6fgdr4d2fp8jhkqvwr23hrqqqjv72g0j9vdgijc58k05j9j1hp"))))))

(define-public rust-cocoa-foundation-0.1
  (package
    (name "rust-cocoa-foundation")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cocoa-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0633ipbd28z35rsdmsl505f1aasrjsrrnirs826aa32nbnv4kpks"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics-types" ,rust-core-graphics-types-0.1)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Cocoa Foundation for macOS")
    (description
     "This package provides bindings to Cocoa Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codepage-0.1
  (package
    (name "rust-codepage")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codepage" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sdxp0f8dy2rscln646326lny9i0jm7ncgyp4yncdwndq0i943lb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8))))
    (home-page "https://docs.rs/codepage/")
    (synopsis "Mapping between Windows code page and @code{encoding_rs}")
    (description
     "This package provides mapping between Windows code page numbers and
@code{encoding_rs} character encodings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codespan-reporting-0.11
  (package
    (name "rust-codespan-reporting")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codespan-reporting" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04wwbn2c5rcfz3zn4kj7nyvpj37hn5cxh0m8w1r3af4ak6w45kn6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://github.com/brendanzab/codespan")
    (synopsis "Beautiful diagnostic reporting for text-based programming languages")
    (description
     "Languages like Rust and Elm already support beautiful error
reporting output, but it can take a significant amount work to
implement this for new programming languages! The
@code{codespan-reporting} crate aims to make beautiful error
diagnostics easy and relatively painless for everyone!")
    (license license:asl2.0)))

(define-public rust-codespan-reporting-0.9
  (package
    (inherit rust-codespan-reporting-0.11)
    (name "rust-codespan-reporting")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codespan-reporting" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07g86hv1lp5bbr6w6hsa3mgdmavs36igc7k5pi1fvc86ad2n41vf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-insta" ,rust-insta-0.16)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-peg" ,rust-peg-0.6)
        ("rust-rustyline" ,rust-rustyline-6)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-unindent" ,rust-unindent-0.1))))))

(define-public rust-color-quant-1
  (package
    (name "rust-color-quant")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-quant" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12q1n427h2bbmmm1mnglr57jaz2dj9apk0plcxw7nwqiai7qjyrx"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/PistonDevelopers/color_quant.git")
    (synopsis "Color quantization library to reduce n colors to 256 colors")
    (description
     "This package is a color quantization library to reduce n colors to 256
colors.")
    (license license:expat)))

(define-public rust-colored-1
  (package
    (name "rust-colored")
    (version "1.9.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "colored" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nbc1czs512h1k696y7glv1kjrb2b914zpxraic6q5fgv80wizzl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-rspec" ,rust-rspec-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-version-requirements
           (lambda _
             (substitute* "Cargo.toml"
               (("1.0.0-beta.3") ,(package-version rust-rspec-1)))
             #t)))))
    (home-page "https://github.com/mackwic/colored")
    (synopsis "Add colors in your terminal")
    (description
     "The most simple way to add colors in your terminal.")
    (license license:mpl2.0)))

(define-public rust-colored-1.9.1
  (package/inherit rust-colored-1
    (name "rust-colored")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "colored" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fildacm47g86acmx44yvxx6cka8fdym5qkgfm8x8gh2hsrghc7r"))))))

(define-public rust-combine-4
  (package
    (name "rust-combine")
    (version "4.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zkvqp21fbhznf7sjssdiw3zgx3x3q8w10c9mmjdzkf0wjsnjhyc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Parser combinators on arbitrary streams with zero-copy support")
    (description
     "This package is an implementation of parser combinators for Rust,
inspired by the Haskell library Parsec.  As in Parsec the parsers are LL(1) by
default but they can opt-in to arbitrary lookahead using the attempt
combinator.")
    (license license:expat)))

(define-public rust-combine-3
  (package
    (inherit rust-combine-4)
    (name "rust-combine")
    (version "3.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1006sbl3ybiky3d5q28p0lyph37hk7sipls1rkhikv11lfxacgfs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ascii" ,rust-ascii-0.9)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-combine-regex-1" ,rust-combine-regex-1-1)
        ("rust-either" ,rust-either-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-unreachable" ,rust-unreachable-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-tokio-codec" ,rust-tokio-codec-0.1))))))

(define-public rust-combine-regex-1-1
  (package
    (name "rust-combine-regex-1")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine-regex-1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bzir63nvrg98i8g6b7crhgq5qbj4vq9f4y6d279af537djvh5ns"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Re-export of regex 1.0 letting combine use both 0.2 and 1.0")
    (description
     "This package is a re-export of regex 1.0 letting combine use both 0.2
and 1.0.")
    (license (list license:expat license:asl2.0))))

;; This package requires features which are unavailable
;; on the stable releases of Rust.
(define-public rust-compiler-builtins-0.1
  (package
    (name "rust-compiler-builtins")
    (version "0.1.26")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "compiler_builtins" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1rhj6ccmfkh9gcxnxgjq4fg257yi4f9325nfzsphbmxwkrg06sq3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/rust-lang/compiler-builtins")
    (synopsis "Compiler intrinsics used by the Rust compiler")
    (description
     "This package provides compiler intrinsics used by the Rust compiler.  This
package is primarily useful when building the @code{core} crate yourself and you
need compiler-rt intrinsics.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-compiler-error-0.1
  (package
    (name "rust-compiler-error")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiler_error" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0irh7c0gznk2k6mj3cmqw7x4pg59lppmy1y8d6k5xc926rnmz5zg"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/lu-zero/compiler_error")
    (synopsis "Triggerable compiler error")
    (description "This package provides a triggerable compiler error for Rust.")
    (license license:expat)))

(define-public rust-compiletest-rs-0.3
  (package
    (name "rust-compiletest-rs")
    (version "0.3.22")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1di7kl2zv7jcwqq343aafqhn31gfa600zh4mi6cp10mn6a9wq3pl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-diff" ,rust-diff-0.1)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustfix" ,rust-rustfix-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tester" ,rust-tester-0.5)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/laumann/compiletest-rs")
    (synopsis "Compiletest utility from the Rust compiler")
    (description
     "The compiletest utility from the Rust compiler as a standalone testing
harness.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-compiletest-rs-0.2
  (package
    (inherit rust-compiletest-rs-0.3)
    (name "rust-compiletest-rs")
    (version "0.2.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0njz4shbhl1pvb6ngpi1wpz2gr5lf2dcha22lpdk995pzrwd6h97"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-concurrent-queue-1
  (package
    (name "rust-concurrent-queue")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concurrent-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18w6hblcjjk9d0my3657ra1zdj79gwfjmzvc0b3985g01dahgv9h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cache-padded" ,rust-cache-padded-1))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-fastrand" ,rust-fastrand-1))))
    (home-page "https://github.com/stjepang/concurrent-queue")
    (synopsis "Concurrent multi-producer multi-consumer queue")
    (description
     "This package provides a concurrent multi-producer multi-consumer
queue.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-config-0.10
  (package
    (name "rust-config")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qrcp7nm24xzp418xnqf0i26qahw93w31nk5vs6m7ng18ghpdc0r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-rust-ini" ,rust-rust-ini-0.13)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-hjson" ,rust-serde-hjson-0.9)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))))
    (home-page "https://github.com/mehcode/config-rs")
    (synopsis "Layered configuration system for Rust applications")
    (description
     "This package provides a layered configuration system for Rust
applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-configparser-2
  (package
    (name "rust-configparser")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "configparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qdaggalm3js86s2i11pjjcndrrvpk0pw1lfvmv7v25z3y66sqg2"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/mexili/configparser-rs")
    (synopsis "Simple parsing utility for INI and ini-style syntax")
    (description
     "This package provides a simple configuration parsing utility with no
dependencies that allows you to parse INI and ini-style syntax.  You can use
this to write Rust programs which can be customized by end users easily.")
    (license (list license:expat license:lgpl3+))))

(define-public rust-console-0.14
  (package
    (name "rust-console")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ajnr0rga4vya0fza12ighf3ffkm86w1rv8p5wf443s8nd30kj3w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-0.13
  (package
    (inherit rust-console-0.14)
    (name "rust-console")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "022ai0jbbawngrx396qppwgzk4pk3v2fdwckzamvz6h154jsn2m5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.11
  (package
    (inherit rust-console-0.13)
    (name "rust-console")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nmwkbb1j1zjb2z4akk83rqgnbv7j3dla4nxv0ibk9xvavk982cc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.9
  (package
    (inherit rust-console-0.11)
    (name "rust-console")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "console" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1h765951c9mywff534f0191slazykmif4290g2yarcwhd2cg7q25"))))
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-clicolors-control" ,rust-clicolors-control-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-console-0.7
  (package
    (name "rust-console")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0a4n2syzik9lh02v2i4wdazvm05d99bib7dw0lqvz8mq2hn7r9cc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-clicolors-control" ,rust-clicolors-control-1)
        ("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-parking-lot" ,rust-parking-lot-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-error-panic-hook-0.1
  (package
    (name "rust-console-error-panic-hook")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console_error_panic_hook" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04d2narcrzk9bnddz17rr2l819l82pr0h6d98s2w9q236n87dndq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))))
    (home-page "https://github.com/rustwasm/console_error_panic_hook")
    (synopsis "Logs panics to console.error")
    (description
     "This package provides a panic hook for @code{wasm32-unknown-unknown}
that logs panics to @code{console.error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-console-log-0.1
  (package
    (name "rust-console-log")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "console-log" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0j1wd2885m3245bhsb2qjvw08lzplbi1rgg2v3yv0hbljk972y0y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/iamcodemaker/console_log")
    (synopsis "Route Rust log messages to the browser's console")
    (description
     "This package provides a logging facility that routes Rust log messages to
the browser's console.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-fn-0.4
  (package
    (name "rust-const-fn")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-fn" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1wnhzyrhfcaawnzi172k98cfawwi5zwqql7pg0nz2qlccm6dz46f"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/const_fn")
    (synopsis "Generate const functions with conditional compilations")
    (description "This package provides an attribute for easy generation of
const functions with conditional compilations.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-random-0.1
  (package
    (name "rust-const-random")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sp1ang5sh27fq5b7g9fdwpq4d5s17ymj7khfzax4bbvffngj6ig"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-const-random-macro" ,rust-const-random-macro-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Compile time random number generation")
    (description "This package provides compile time random number
generation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-random-macro-0.1
  (package
    (name "rust-const-random-macro")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ykc9riajn6bijvw46092gp18vrbky3y1cjpgjgx57a5xc3cdr15"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Procedural macro used by const-random")
    (description "This package provides the procedural macro used by
@code{rust-const-random}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-constant-time-eq-0.1
  (package
    (name "rust-constant-time-eq")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "constant_time_eq" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32
         "1g3vp04qzmk6cpzrd19yci6a95m7ap6wy7wkwgiy2pjklklrfl14"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cesarb/constant_time_eq")
    (synopsis
     "Compares two equal-sized byte strings in constant time")
    (description
     "This package compares two equal-sized byte strings in constant time.
It is inspired by the Linux kernel's @code{crypto_memneq}.")
    (license license:cc0)))

(define-public rust-content-inspector-0.2
  (package
    (name "rust-content-inspector")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "content_inspector" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f1gwv4axxw9wck4a4jxlkm7xjjakb3616isll2k0s4chmpadgdp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/sharkdp/content_inspector")
    (synopsis "Fast inspection of binary buffers to guess the encoding")
    (description
     "This package is a simple library for fast inspection of binary buffers
to guess the type of content.")
    (license (list license:expat license:asl2.0))))

(define-public rust-conv-0.3
  (package
    (name "rust-conv")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "conv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "168j1npqrif1yqxbgbk0pdrx9shzhs5ylc5a4xw49b6hbxi11zvq"))
        (modules '((guix build utils)))
        (snippet
         '(begin (substitute* "Cargo.toml"
                   (("0.2.21.*") "0.2.21\"\n"))
                 #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-custom-derive" ,rust-custom-derive-0.1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://github.com/DanielKeep/rust-conv")
    (synopsis "Conversion traits with more specific semantics")
    (description
     "This crate provides a number of conversion traits with more specific
semantics than those provided by @code{as} or @code{From}/@code{Into}.")
    (license license:expat)))

(define-public rust-cookie-0.12
  (package
    (name "rust-cookie")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mdvqixahcywvqp0y8k2skkgbpfhsp0w73l9mz93dcrx1gq091l8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-ring" ,rust-ring-0.14)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-1))))
    (home-page "https://github.com/SergioBenitez/cookie-rs")
    (synopsis
     "Crate for parsing HTTP cookie headers and managing a cookie jar")
    (description
     "Parse HTTP cookie headers and manage a cookie jar with this crate.
It supports signed and private (encrypted + signed) jars.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cookie-0.11
  (package
    (inherit rust-cookie-0.12)
    (name "rust-cookie")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i2x04kx1ifljsnwsa83k7cpmajk9j4ayyx2h11y6lkji6hcv5ap"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.5)
        ("rust-base64" ,rust-base64-0.12)
        ("rust-hkdf" ,rust-hkdf-0.8)
        ("rust-hmac" ,rust-hmac-0.7)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-sha2" ,rust-sha2-0.8)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-cookie-store-0.7
  (package
    (name "rust-cookie-store")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie-store" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "174i9k9g62pfx7y1nqynywdpjplkl3j4hi3ck6bz2r996qzhnxa6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cookie" ,rust-cookie-0.12)
        ("rust-idna" ,rust-idna-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-try-from" ,rust-try-from-0.3)
        ("rust-url" ,rust-url-1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))
    (home-page "https://github.com/pfernie/cookie_store")
    (synopsis "Implementation of Cookie storage and retrieval per RFC6265")
    (description
     "This crate provides an implementation for storing and retrieving Cookies per
the path and domain matching rules specified in RFC6265.

Split from the user_agent crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-copyless-0.1
  (package
    (name "rust-copyless")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copyless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dmmxsq3m0i6g9s2kj96n777qhmm7vjgv4r7agc2v6w6bl7rdpx2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kvark/copyless")
    (synopsis "Ways to eliminate @code{memcpy} calls")
    (description
     "This package provides ways to eliminate @code{memcpy} calls when using
the standard library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-copypasta-0.7
  (package
    (name "rust-copypasta")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copypasta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02zz6yndszmzr5yjhn11g1hsj0232jbzl8gch6mxksw3xngxf8s4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-clipboard-win" ,rust-clipboard-win-3)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-objc-id" ,rust-objc-id-0.1)
        ("rust-smithay-clipboard" ,rust-smithay-clipboard-0.6)
        ("rust-x11-clipboard" ,rust-x11-clipboard-0.5))))
    (home-page "https://github.com/alacritty/copypasta")
    (synopsis "Get and set the contents of the OS-level clipboard")
    (description
     "Copypasta is a cross-platform library for getting and setting the
contents of the OS-level clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cordic-0.1
  (package
    (name "rust-cordic")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cordic" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "13zvqn6c8d8lp18p9ik10q100wfsyv2m2n4fca16laq3yw7r231m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; rust-fixed fails to build
       #:cargo-inputs (("rust-fixed" ,rust-fixed-1))))
    (home-page "https://github.com/sebcrozet/cordic")
    (synopsis "Special functions for fixed-point numbers using the CORDIC method")
    (description "This package provides special functions for fixed-point
numbers using the CORDIC method.")
    (license license:bsd-3)))

(define-public rust-cookie-0.14
  (package
    (name "rust-cookie")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q56fl2cqrci9ksa80d7g220phq02nf1yfbvxkpk9g1p95ma2wqk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aes-gcm" ,rust-aes-gcm-0.6)
        ("rust-base64" ,rust-base64-0.12)
        ("rust-hkdf" ,rust-hkdf-0.9)
        ("rust-hmac" ,rust-hmac-0.8)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-time" ,rust-time-0.2))
       #:cargo-development-inputs
       (("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/SergioBenitez/cookie-rs")
    (synopsis "HTTP cookie parsing and cookie jar management")
    (description "This package provides HTTP cookie parsing and cookie jar
management.  It supports signed and private (encrypted, authenticated) jars.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cookie-store-0.12
  (package
    (name "rust-cookie-store")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cookie_store" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lqhmdwgnyvi1mjmw4rbgd02fwav4aabpg4vcld23d8c9g5dy61q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cookie" ,rust-cookie-0.14)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))
    (home-page "https://github.com/pfernie/cookie_store")
    (synopsis "Cookie storage and retrieval")
    (description "This package implements cookie storage and retrieval.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-affinity-0.5
  (package
    (name "rust-core-affinity")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-affinity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07qpwyxps4gp3gci2p6c5h4cmcql7551bp91qgbv0ky3bh8h72kz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://github.com/Elzair/core_affinity_rs")
    (synopsis "Manage CPU affinities")
    (description "This package manages CPU affinities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-arch-0.1
  (package
    (name "rust-core-arch")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_arch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04vdvr9vj0f1cv2p54nsszmrrk9w1js4c0z4i0bdlajl1lydslim"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.2))))
    (home-page "https://github.com/rust-lang/stdarch")
    (synopsis
     "Rust's core library architecture-specific intrinsics")
    (description
     "@code{core::arch} - Rust's core library architecture-specific
intrinsics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-0.9
  (package
    (name "rust-core-foundation")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qhackx0i914nbhcwi6bbxnyyqqldgxc046gviak3a3f8apf528a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f             ;tests fail with a lot of "undefined reference"
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Core Foundation for macOS")
    (description "This package provides bindings to Core Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-0.7
  (package
    (inherit rust-core-foundation-0.9)
    (name "rust-core-foundation")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wbias8f0m5kyn2pcksi0h58fdslams6nmf16w78fgn42dx4rljp"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.7)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))))

(define-public rust-core-foundation-0.6
  (package
    (inherit rust-core-foundation-0.7)
    (name "rust-core-foundation")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0va97wf49c8dzm9c8pgyk1jn7z21rl0bj1syf2zz5m2z2hzy1f95"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.6)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-uuid" ,rust-uuid-0.5))))))

(define-public rust-core-foundation-0.2
  (package
    (inherit rust-core-foundation-0.6)
    (name "rust-core-foundation")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rvcn7ab5r69wvn7gby745jlpy8pirfywcdxbiypy083s93dggr5"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-core-foundation-sys" ,rust-core-foundation-sys-0.2)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-core-foundation-sys-0.8
  (package
    (name "rust-core-foundation-sys")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06wq7yb7mlkc4h2kbc0yjfi0xv44z4snzdpr7c1l0zm4hi91n8pa"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to Core Foundation for macOS")
    (description "This package provides bindings to Core Foundation for macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-foundation-sys-0.7
  (package
    (inherit rust-core-foundation-sys-0.8)
    (name "rust-core-foundation-sys")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ghrg46h4ci306agr2vwm28w6gb5l455nzp61y2zkhwfs49p4nis"))))))

(define-public rust-core-foundation-sys-0.6
  (package
    (inherit rust-core-foundation-sys-0.7)
    (name "rust-core-foundation-sys")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32
         "0fzsw1j9g1x598yhwklg59l15hwzc0pyvs01w9fg2kin4598mjp7"))))))

(define-public rust-core-foundation-sys-0.2
  (package
    (inherit rust-core-foundation-sys-0.6)
    (name "rust-core-foundation-sys")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-foundation-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13f7f3kblyj6yxcxm74yg84vj9ahaprlc1vgblagmj6bzmzmsnh6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))))

(define-public rust-core-text-19
  (package
    (name "rust-core-text")
    (version "19.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-text" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q1sr55v8zq82y0dwnwwksz1radh515i0a45nbsda3w2idpg9iyj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/servo/core-foundation-rs")
    (synopsis "Bindings to the Core Text framework")
    (description "This package provides bindings to the Core Text framework.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-text-13
  (package
    (inherit rust-core-text-19)
    (name "rust-core-text")
    (version "13.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-text" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v9lxn277p39cf81pb45r7k0lzf17pwgd5cpry1c04ajv556b16v"))))
    (arguments
     `(#:skip-build? #t     ; only for macOS
       #:cargo-inputs
       (("rust-core-foundation" ,rust-core-foundation-0.6)
        ("rust-core-graphics" ,rust-core-graphics-0.17)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-cpp-demangle-0.3
  (package
    (name "rust-cpp-demangle")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpp_demangle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "142knq32bpa2hbp4z0bldjd1x869664l0ff2gdrqx7pryv59x4a4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-afl" ,rust-afl-0.8)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-glob" ,rust-glob-0.3))))
    (home-page "https://github.com/gimli-rs/cpp_demangle")
    (synopsis "Demangle C++ symbols")
    (description
     "This package provides a crate for demangling C++ symbols.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cpp-demangle-0.2
  (package
    (inherit rust-cpp-demangle-0.3)
    (name "rust-cpp-demangle")
    (version "0.2.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpp_demangle" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bamx2c78xzjhhvpg6p9bjarl6qm6j8npm6756kiqdh784w29j8k"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-afl" ,rust-afl-0.8)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-glob" ,rust-glob-0.3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1))))))

(define-public rust-cpuid-bool-0.1
  (package
    (name "rust-cpuid-bool")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cpuid-bool" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r3v22cxly1shvw8qi0153708kggdqvh8jp0g82wbxi06d1mqdvd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Lightweight alternative to is_x86_feature_detected")
    (description
     "This package provides a lightweight @code{no-std} compatible alternative
to @code{is_x86_feature_detected}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crates-index-0.13
  (package
    (name "rust-crates-index")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-index" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n7pp6mk59hw3nqlh8irxc9pp0g5ziw7bprqsw2lxvg13cvdp76s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-git2" ,rust-git2-0.9)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page
     "https://github.com/frewsxcv/rust-crates-index")
    (synopsis
     "Retrieving and interacting with the crates.io index")
    (description
     "Library for retrieving and interacting with the crates.io index.")
    (license license:asl2.0)))

(define-public rust-crc-1
  (package
    (name "rust-crc")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sqal6gm6lbj7f45iv3rw2s9w3pvvha8v970y51s7k7mwy6m8qyn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-build-const" ,rust-build-const-0.2))))
    (home-page "https://crates.io/crates/crc")
    (synopsis "Rust implementation of CRC(16, 32, 64)")
    (description "This package provides a Rust implementation of CRC(16, 32,
64) with support for various standards.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc32fast-1
  (package
    (name "rust-crc32fast")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc32fast" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1c9dhkvf3brrzzplcijaywxi2w8wv5578i0ryhcm7x8dmzi5s4ms"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/srijs/rust-crc32fast")
    (synopsis
     "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation")
    (description
     "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-criterion-0.3
  (package
    (name "rust-criterion")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n24l95pgjig4nfhgm3vn9gxb49ky5ylr8390scl7wbcxk7agnkh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-clap" ,rust-clap-2)
        ("rust-criterion-plot" ,rust-criterion-plot-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-oorandom" ,rust-oorandom-11.1)
        ("rust-plotters" ,rust-plotters-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-cbor" ,rust-serde-cbor-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tinytemplate" ,rust-tinytemplate-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://bheisler.github.io/criterion.rs/book/index.html")
    (synopsis "Statistics-driven micro-benchmarking library")
    (description
     "This package provides a statistics-driven micro-benchmarking library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-criterion-0.2
  (package
    (inherit rust-criterion-0.3)
    (name "rust-criterion")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1543wlpc4p1kz7sqqa7ylr8bkdr8l4f34hy4bxj7krpkahwhaqq3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-clap" ,rust-clap-2)
        ("rust-criterion-plot" ,rust-criterion-plot-0.3)
        ("rust-csv" ,rust-csv-1)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand-core" ,rust-rand-core-0.3)
        ("rust-rand-os" ,rust-rand-os-0.1)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rayon-core" ,rust-rayon-core-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tinytemplate" ,rust-tinytemplate-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-criterion-cycles-per-byte-0.1
  (package
    (name "rust-criterion-cycles-per-byte")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-cycles-per-byte" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15iw8zvyilx6k3a7z79vpzmpm6kkyds4c1ng3jlwfc43axd4hd4d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://crates.io/crates/criterion-cycles-per-byte")
    (synopsis "Measure time with CPU cycles for criterion")
    (description "This package lets you measure time with CPU cycles for
criterion.")
    (license (list license:expat license:asl2.0))))

(define-public rust-criterion-plot-0.4
  (package
    (name "rust-criterion-plot")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-plot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17c8v5fv064181yspagkdcfd6jhs7233ba6g94bbl7v0xjnzw8p0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cast" ,rust-cast-0.2)
        ("rust-itertools" ,rust-itertools-0.9))
       #:cargo-development-inputs
       (("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/bheisler/criterion.rs")
    (synopsis "Criterion's plotting library")
    (description "This package provides criterion's plotting library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-criterion-plot-0.3
  (package
    (inherit rust-criterion-plot-0.4)
    (name "rust-criterion-plot")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "criterion-plot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13pv09z4ryp70qyzablkibwa2mh6c2852qq1sjr9wjigvwnj3ybn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-cast" ,rust-cast-0.2)
        ("rust-itertools" ,rust-itertools-0.8))
       #:cargo-development-inputs
       (("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-crossbeam-0.8
  (package
    (name "rust-crossbeam")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "103xnwzkk1zd9kiy6f0f131ap433qfkc757wyrha5bxa7pmsc0gx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.8)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page "https://github.com/crossbeam-rs/crossbeam")
    (synopsis "Tools for concurrent programming in Rust")
    (description "This package provides tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-0.7
  (package
    (inherit rust-crossbeam-0.8)
    (name "rust-crossbeam")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13kzn2d49n2qn5q42y2dj48kyv6aln2d9smq8x9n675l3zzknck9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.2)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-channel-0.5
  (package
    (name "rust-crossbeam-channel")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xfplw54pskl3kyf2q6kw8y2phnq6wn8pqxx003n8qfkz3hnx8nw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-channel")
    (synopsis "Multi-producer multi-consumer channels for message passing")
    (description
     "This package provides multi-producer multi-consumer channels for
message passing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-channel-0.4
  (package
    (inherit rust-crossbeam-channel-0.5)
    (name "rust-crossbeam-channel")
    (version "0.4.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crossbeam-channel" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0qd05n5bcwafkmbzq1lspwrfi29xnzlw46qarg1sl0lwj68qdvfc"))))
    (arguments
     `(#:cargo-inputs
        (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
         ("rust-maybe-uninit" ,rust-maybe-uninit-2))
        #:cargo-development-inputs
        (("rust-num-cpus" ,rust-num-cpus-1)
         ("rust-rand" ,rust-rand-0.6)
         ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-channel-0.3
  (package
    (inherit rust-crossbeam-channel-0.4)
    (name "rust-crossbeam-channel")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ylyzb1m9qbvd1nd3vy38x9073wdmcy295ncjs7wf7ap476pzv68"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-deque-0.8
  (package
    (name "rust-crossbeam-deque")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ad995vzq74k7jd1pgn9zxbacyzj9ii6l0svhlb2dxzy8vxnxbwl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-deque")
    (synopsis "Concurrent work-stealing deque")
    (description "This package provides a concurrent work-stealing deque.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-deque-0.7
  (package
    (inherit rust-crossbeam-deque-0.8)
    (name "rust-crossbeam-deque")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11c2c0x5grdba3ah3g94yn6b8s47xi8qwm85h8hq5vmf9nbsy0lz"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-deque-0.6
  (package
    (inherit rust-crossbeam-deque-0.7)
    (name "rust-crossbeam-deque")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04rcpgjs6ns57vag8a3dzx26190dhbvy2l0p9n22b9p1yf64pr05"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.7)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-epoch-0.9
  (package
    (name "rust-crossbeam-epoch")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17anyfg5azjpmcfidq6wn4phj9h0a0zqcxksi33w44akz4wsgam1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-const-fn" ,rust-const-fn-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memoffset" ,rust-memoffset-0.6)
        ("rust-scopeguard" ,rust-scopeguard-1))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-epoch")
    (synopsis "Epoch-based garbage collection")
    (description "This package provides an Epoch-based garbage collection.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-epoch-0.8
  (package
    (inherit rust-crossbeam-epoch-0.9)
    (name "rust-crossbeam-epoch")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1knsf0zz7rgzxn0nwz5gajjcrivxpw3zrdcp946gdhdgr9sd53h5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2)
        ("rust-memoffset" ,rust-memoffset-0.5)
        ("rust-scopeguard" ,rust-scopeguard-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-epoch-0.7
  (package
    (inherit rust-crossbeam-epoch-0.8)
    (name "rust-crossbeam-epoch")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a9prma2nalqvys7f8wrazkdzh26w3mi5gzrk8mdmwrp5rvxdp7y"))))
    (arguments
     `(#:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memoffset" ,rust-memoffset-0.5)
        ("rust-scopeguard" ,rust-scopeguard-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.3
  (package
    (name "rust-crossbeam-queue")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mk790w2y7cn9zqj6cn1kl8vvgaamlkj6fmpxg1iprdqyp3v6v0g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Concurrent queues in Rust")
    (description
     "This crate provides concurrent queues that can be shared among threads.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-queue-0.2
  (package
    (inherit rust-crossbeam-queue-0.3)
    (name "rust-crossbeam-queue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w15z68nz3ac4f2s4djhwha8vmlwsh9dlfrmsl4x84y2ah5acjvp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.1
  (package
    (inherit rust-crossbeam-queue-0.2)
    (name "rust-crossbeam-queue")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jsa9dbxnwqcxfws09vaschf92d4imlbbikmcn4ka8z7rzb9r5vw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.8
  (package
    (name "rust-crossbeam-utils")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13fvrqlap7bgvlnpqr5gjcxdhx1jv99pkfg5xdlq5xcy30g6vn82"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Utilities for concurrent programming")
    (description
     "This crate provides miscellaneous tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-utils-0.7
  (package
    (inherit rust-crossbeam-utils-0.8)
    (name "rust-crossbeam-utils")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a31wbrda1320gj2a6az1lin2d34xfc3xf88da4c17qy5lxcgiy3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.6
  (package
    (inherit rust-crossbeam-utils-0.7)
    (name "rust-crossbeam-utils")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rk0r9n04bmq4a3g2q5qhvvlmrmx780gc6h9lmc94mwndslkz5q4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossfont-0.2
  (package
    (name "rust-crossfont")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossfont" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04p8k0yn19n2pdbiqzwkknakz9c7kdii0i2nf3s3p298ab7ld28h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cocoa" ,rust-cocoa-0.24)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-core-text" ,rust-core-text-19)
        ("rust-dwrote" ,rust-dwrote-0.11)
        ("rust-foreign-types" ,rust-foreign-types-0.5)
        ("rust-freetype-rs" ,rust-freetype-rs-0.26)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-servo-fontconfig" ,rust-servo-fontconfig-0.5)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/alacritty/crossfont")
    (synopsis "Native font loading and rasterization")
    (description
     "Crossfont is a cross-platform Rust library for loading fonts and
rasterizing glyphs, using native font engines whenever possible.")
    (license license:asl2.0)))

(define-public rust-crossterm-0.19
  (package
    (name "rust-crossterm")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1348lqf8vy3lb2s5icsl3rxs4a4vrpfw5z2j6lplnhnz600w2dkw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.7)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/crossterm-rs/crossterm")
    (synopsis "Crossplatform terminal library for manipulating terminals")
    (description
     "This package provides a crossplatform terminal library for manipulating
terminals.")
    (license license:expat)))

(define-public rust-crossterm-0.18
  (package
    (inherit rust-crossterm-0.19)
    (name "rust-crossterm")
    (version "0.18.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yxpskm03lknj6h0rhggm54xzlpm1ir8q2nid1bpnh0b58zxg1jf"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.6)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-0.13
  (package
    (inherit rust-crossterm-0.19)
    (name "rust-crossterm")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jw9s85mnhpkk38lihr4ildip4jhfhc3h86npncd92i4mdb257vm"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossterm-winapi" ,rust-crossterm-winapi-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.7
  (package
    (name "rust-crossterm-winapi")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fa047zz228qyqbcjdss64j0n01p4adr29yh9w24lgjdrr59da0d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/crossterm-rs/crossterm-winapi")
    (synopsis "Basic simple abstractions around common WinAPI calls")
    (description
     "This package is a WinAPI wrapper that provides some basic simple
abstractions around common WinAPI calls.")
    (license license:expat)))

(define-public rust-crossterm-winapi-0.6
  (package
    (inherit rust-crossterm-winapi-0.7)
    (name "rust-crossterm-winapi")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nqhjp979c6iv092dbxl6hpncwgwjciafyj1nvcpa008iqzmq9n2"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.4
  (package
    (inherit rust-crossterm-winapi-0.7)
    (name "rust-crossterm-winapi")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm-winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j3av8bba3f5y4n4w1vgn0iz28vdajxrli6lqxnvpddbphskmph2"))))
    (arguments
     `(#:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-roxmltree-0.14
  (package
    (name "rust-roxmltree")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "roxmltree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "010mahzyarkzb7kaawgga1a9y46nsp209yh2i4g4pq98bg8afn5z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-xmlparser" ,rust-xmlparser-0.13))))
    (home-page "https://github.com/RazrFalcon/roxmltree")
    (synopsis "Represent an XML as a read-only tree")
    (description
     "@code{roxmltree} represents an XML 1.0 document as a read-only tree.")
    (license (list license:expat license:asl2.0))))

(define-public rust-rust-crypto-0.2
  (package
    (name "rust-rust-crypto")
    (version "0.2.36")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "rust-crypto" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0aias7gh2ypj4skmh6hfsjli4fhnvcvf9s1ljjpz9m9zk79havgp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gcc" ,rust-gcc-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/DaGenix/rust-crypto/")
    (synopsis "Mostly pure-Rust implementation of various cryptographic algorithms")
    (description
     "This package provides a (mostly) pure-Rust implementation of various
common cryptographic algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-mac-0.10
  (package
    (name "rust-crypto-mac")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crypto-mac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "19iyh7h9qaqrv29dhbd31rm6pq023ry78nw7jwr3qjy3l22zsms8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
        (("rust-blobby" ,rust-blobby-0.3)
         ("rust-cipher" ,rust-cipher-0.2)
         ("rust-generic-array" ,rust-generic-array-0.14)
         ("rust-subtle" ,rust-subtle-2))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Trait for Message Authentication Code (MAC) algorithms")
    (description "This package provides trait for @dfn{Message Authentication
Code} (MAC) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-mac-0.8
  (package
    (inherit rust-crypto-mac-0.10)
    (name "rust-crypto-mac")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1axfs4zmy74rn9666p92j7nmcv11zdp2d51yrppc2dv26cqa715m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14)
        ("rust-subtle" ,rust-subtle-2))))))

(define-public rust-crypto-mac-0.7
  (package
    (inherit rust-crypto-mac-0.8)
    (name "rust-crypto-mac")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rbrq6qy9dl0pj4ym2zy33miaaa8vpzdss60p9bdb58xy46l0d24"))))
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.12)
        ("rust-subtle" ,rust-subtle-1))))))

(define-public rust-crypto-mac-0.5
  (package
    (inherit rust-crypto-mac-0.10)
    (name "rust-crypto-mac")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n6r10zlnfv9gbjj0380sxfffxhq1khfjqwsn7fx8iil9pzv9689"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-constant-time-eq" ,rust-constant-time-eq-0.1)
        ("rust-generic-array" ,rust-generic-array-0.9))))))

(define-public rust-crypto-mac-0.4
  (package
    (name "rust-crypto-mac")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "160ixpghhz5kz16f38kzcyv6lx8wmi4cgbhlhq4nazf678iib43p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-constant-time-eq" ,rust-constant-time-eq-0.1)
        ("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Trait for Message Authentication Code (MAC) algorithms")
    (description "This package provides traits for Message Authentication
Code (MAC) algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crypto-tests-0.5
  (package
    (name "rust-crypto-tests")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crypto-tests" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08yrh40a9ll4k29ppizg2yjf96i6s3i9pbkhxp60y8arar93134v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-cipher-trait" ,rust-block-cipher-trait-0.4)
        ("rust-crypto-mac" ,rust-crypto-mac-0.4)
        ("rust-digest" ,rust-digest-0.6)
        ("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Test helpers for cryptographic algorithms")
    (description "This package provides test helpers for cryptographic
algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cryptovec-0.4
  (package
    (name "rust-cryptovec")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cryptovec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n88dmhfb2dxs48zllq1g1dya76zx4fajw482qy8jj4hgg1da4p4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; CryptoVec::from_slice failed
       #:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://crates.io/crates/cryptovec")
    (synopsis
     "Vector which zeroes its memory on clears and reallocations")
    (description
     "This package provides a vector which zeroes its memory on clears and
reallocations.")
    (license license:asl2.0)))

(define-public rust-cssparser-0.28
  (package
    (name "rust-cssparser")
    (version "0.28.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h924c5g2rwlmgk8hllciyky3ih3z9vf04xz3xsp3cv1jyd5kf0x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Rust implementation of CSS Syntax Level 3")
    (description
     "This package contains a Rust implementation of CSS Syntax Level 3.")
    (license license:mpl2.0)))

(define-public rust-cssparser-0.27
  (package
    (inherit rust-cssparser-0.28)
    (name "rust-cssparser")
    (version "0.27.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02nbm690rmkaz1ca0383qq7mc1g066w3s85f17pdihnda79njjvm"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-0.25
  (package
    (inherit rust-cssparser-0.27)
    (name "rust-cssparser")
    (version "0.25.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03klvpdzsk4cyh8k0dbnlngzafv7gqywqrnsqqb3gfmrxyj8rqgv"))))
    (arguments
     `(#:tests? #f      ; Some test files missing.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.3)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-heapsize" ,rust-heapsize-0.4)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.7)
        ("rust-procedural-masquerade" ,rust-procedural-masquerade-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-autocfg" ,rust-autocfg-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-macros-0.6
  (package
    (name "rust-cssparser-macros")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vp13g4blyjvhg3j4r9b7vrwhnfi1y2fmhv8hxgficpjazg7bbnz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Procedural macros for cssparser")
    (description
     "This package provides the procedural macros for rust-cssparser.")
    (license license:mpl2.0)))

(define-public rust-cssparser-macros-0.3
  (package
    (inherit rust-cssparser-macros-0.6)
    (name "rust-cssparser-macros")
    (version "0.3.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vqyc5xm8a4va92vs1nn0cc46c930l2n21gccijnc5y7hx7cicav"))))
    (arguments
     `(#:cargo-inputs
       (("rust-phf-codegen" ,rust-phf-codegen-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-procedural-masquerade" ,rust-procedural-masquerade-0.1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-csv-1
  (package
    (name "rust-csv")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15wydz6klf1shh1ac5n6rsihc4xrz1lzi8vjmhava94v54rqdmgr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-csv-core" ,rust-csv-core-0.1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis "Fast CSV parsing with support for serde")
    (description
     "Fast CSV parsing with support for serde.")
    (license (list license:unlicense license:expat))))

(define-public rust-csv-0.14
  (package
    (inherit rust-csv-1)
    (name "rust-csv")
    (version "0.14.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g0qvr9fj25fq1fy0p758glrb30yz7x46h18hsysaqyaswaihv16"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-0.5)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))
       #:cargo-development-inputs
       (("rust-regex" ,rust-regex-0.1))))))

(define-public rust-csv-core-0.1
  (package
    (name "rust-csv-core")
    (version "0.1.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "145wcc3560v1kmysqqspvddppiysr2rifqzy4nnlh3r6kxanc91b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.5))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis
     "Bare bones CSV parsing with no_std support")
    (description
     "Bare bones CSV parsing with no_std support.")
    (license (list license:unlicense license:expat))))

(define-public rust-ct-logs-0.8
  (package
    (name "rust-ct-logs")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j5as2h789c2gazq3drl5i58xk8zzx6sxd1wdr19x3d6dwc1da61"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-sct" ,rust-sct-0.6))))
    (home-page "https://github.com/ctz/ct-logs")
    (synopsis "Google's list of Certificate Transparency logs")
    (description
     "This package contains Google's list of Certificate Transparency logs for
use with sct crate.")
    (license (list license:asl2.0 license:isc license:expat))))

(define-public rust-ct-logs-0.7
  (package
    (inherit rust-ct-logs-0.8)
    (name "rust-ct-logs")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bk7pbmkjm18cgccm4a76vyn3wkaf2z4bh0jy9fk3dl4188i73lc"))))
    (arguments
     `(#:cargo-inputs (("rust-sct" ,rust-sct-0.6))))))

(define-public rust-ct-logs-0.6
  (package
    (inherit rust-ct-logs-0.7)
    (name "rust-ct-logs")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04wiwiv4ghni3x2vni3z711mlz0ndqvh04vmdkbw3nr7zbsqcdjd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-sct" ,rust-sct-0.6))))))

(define-public rust-ct-logs-0.3
  (package
    (inherit rust-ct-logs-0.7)
    (name "rust-ct-logs")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f0885ws3p49xh6dfgnhh7zjw9h4rhs9ljs8i9cnkhifzz98784f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-sct" ,rust-sct-0.3))))))

(define-public rust-ctor-0.1
  (package
    (name "rust-ctor")
    (version "0.1.15")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ctor" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09x2my9x33srjdip8yf4lm5gq7xqis2694abvpa64r60pajqm19r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))
       #:cargo-development-inputs
       (("rust-libc-print" ,rust-libc-print-0.1))))
    (home-page "https://github.com/mmastrac/rust-ctor")
    (synopsis "__attribute__((constructor)) for Rust")
    (description
     "This package provides an @code{__attribute__((constructor))} for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ctr-0.6
  (package
    (name "rust-ctr")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ctr" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0zvyf13675hrlc37myj97k5ng7m1mj3d9p4ic4yvyhvl9zak0jpv"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-cipher" ,rust-cipher-0.2))))
    (home-page "https://docs.rs/ctr/")
    (synopsis "CTR block mode of operation")
    (description "This package provides a generic implementations of CTR mode
for block ciphers.

Mode functionality is accessed using traits from re-exported cipher crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ctrlc-3
  (package
    (name "rust-ctrlc")
    (version "3.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ctrlc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "027bzbddk0wg7s2wnbgcwx2iv6bjzvxfpp0s2xdg444yfklr4ymm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nix" ,rust-nix-0.18)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Detegr/rust-ctrlc")
    (synopsis "Easy Ctrl-C handler for Rust projects")
    (description
     "This package provides an easy Ctrl-C handler for Rust projects.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cty-0.2
  (package
    (name "rust-cty")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qvkdnkxmd7g6fwhmv26zxqi0l7b9cd4d7h1knylvjyh43bc04vk"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/japaric/cty")
    (synopsis "Type aliases to C types")
    (description "This package provides type aliases to C types like c_int for
use with bindgen.")
    (license (list license:expat license:asl2.0))))

(define-public rust-curl-0.4
  (package
    (name "rust-curl")
    (version "0.4.34")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "curl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vkm6fyizf8m9yxpv3n5pm9ag3bwlyqa6nz2ga8qkzm5y4m1cs72"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;require internet access
       #:cargo-inputs
       (("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("curl" ,curl)
       ("nghttp2" ,nghttp2)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Rust bindings to libcurl for making HTTP requests")
    (description
     "This package provides Rust bindings to libcurl for making HTTP
requests")
    (license license:expat)))

(define-public rust-curl-sys-0.4
  (package
    (name "rust-curl-sys")
    (version "0.4.39+curl-7.74.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "curl-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x7qhq7c3b1vmp3740yiigzm09qvkzpdf578jjrs0s3v3s3cxa07"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "curl") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-libnghttp2-sys" ,rust-libnghttp2-sys-0.1)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-mesalink" ,rust-mesalink-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("curl" ,curl)
       ("nghttp2" ,nghttp2)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Native bindings to the libcurl library")
    (description
     "This package provides native bindings to the @code{libcurl} library.")
    (license license:expat)))

(define-public rust-curve25519-dalek-3
  (package
    (name "rust-curve25519-dalek")
    (version "3.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "curve25519-dalek" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "01xknhlwagv601k6125372vr0lw2j6xjsvnnl74hprp943j2sjf8"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-byteorder" ,rust-byteorder-1)
         ("rust-digest" ,rust-digest-0.9)
         ("rust-packed-simd" ,rust-packed-simd-0.3)
         ("rust-rand-core" ,rust-rand-core-0.5)
         ("rust-serde" ,rust-serde-1)
         ("rust-subtle" ,rust-subtle-2)
         ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://dalek.rs/curve25519-dalek")
    (synopsis "Group operations on ristretto255 and Curve25519")
    (description
      "This package provides a pure-Rust implementation of group operations on
ristretto255 and Curve25519")
    (license license:bsd-3)))

(define-public rust-custom-derive-0.1
  (package
    (name "rust-custom-derive")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "custom_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f81bavw1wnykwh21hh4yyzigs6zl6f6pkk9p3car8kq95yfb2pg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page
     "https://github.com/DanielKeep/rust-custom-derive/tree/custom_derive-master")
    (synopsis "Custom derivation macro for Rust")
    (description
     "This crate provides a macro that enables the use of custom @code{derive}
attributes.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cxx-0.5
  (package
    (name "rust-cxx")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1alj19zf8jm5j8c8hynqb36f0vyjqs8yhwmxpcapfmb5lav4ipgb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Cannot compile cxx-test-suite.
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-cxxbridge-flags" ,rust-cxxbridge-flags-0.5)
        ("rust-cxxbridge-macro" ,rust-cxxbridge-macro-0.5)
        ("rust-link-cplusplus" ,rust-link-cplusplus-1))
       #:cargo-development-inputs
       (("rust-cxx-build" ,rust-cxx-build-0.5)
        ("rust-cxx-gen" ,rust-cxx-gen-0.6)
        ("rust-cxx-test-suite" ,rust-cxx-test-suite-0.0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://cxx.rs")
    (synopsis "Safe interop between Rust and C++")
    (description "This package provides a safe interop between Rust and C++.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-build-0.5
  (package
    (name "rust-cxx-build")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-build" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "01109arjlj8wdq2rcyy3s76a5aidkn7zvhhhvhvkg1cxgqza9p22"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-scratch" ,rust-scratch-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx-gen" ,rust-cxx-gen-0.6)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into a Cargo build.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-gen-0.6
  (package
    (name "rust-cxx-gen")
    (version "0.6.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-gen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0avkca16wjy0paplq1ycaf04bj62agfj0awyhyzxyfpdn9rm45j2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.9)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into higher level tools.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-test-suite-0.0.0
  (package
    (name "rust-cxx-test-suite")
    (version "0.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-test-suite" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1pkf4ay1210g9wqyqhkgvlcsv4i6kgdcmgnh19mrymylznv7pcal"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t)) ; Not meant to be built independantly.
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Test suite of the cxx crate")
    (description "This package provides the test suite of the cxx crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-flags-0.5
  (package
    (name "rust-cxxbridge-flags")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-flags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0jfwsm85s5kalgqbqlg1kq79zcb5zwk375h0qw7ycz5i6v3c8j0k"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Compiler configuration of the `cxx` crate")
    (description "This package provides a compiler configuration of the `cxx`
crate (implementation detail).")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-macro-0.5
  (package
    (name "rust-cxxbridge-macro")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05mhvchmcb8dpgcqkl5vyxycywp2x42vw1qh2hyxxyi576nmmxsr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cxx" ,rust-cxx-0.5))))
    (home-page "https://cxx.rs")
    (synopsis "Implementation detail of the `cxx` crate")
    (description
     "This package provides an implementation detail of the @code{cxx} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-daemonize-0.4
  (package
    (name "rust-daemonize")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "daemonize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05cqr2zjxrxyg23snykd03sgqwxn0pvwj2lzh50bclsgwc9lbhkh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-boxfnonce" ,rust-boxfnonce-0.1)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/knsd/daemonize")
    (synopsis "Library for writing system daemons")
    (description "Daemonize is a Rust library for writing system deaemons.")
    (license (list license:expat license:asl2.0))))

(define-public rust-darling-0.10
  (package
    (name "rust-darling")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0n7qsp6854wm3y1q1lvylhv15zvc87ibbac1nyfmcdbyv1snww0d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-darling-macro" ,rust-darling-macro-0.10))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Proc-macro library for reading attributes in custom derives")
    (description
     "This package provides a proc-macro library for reading attributes
into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-core-0.10
  (package
    (name "rust-darling-core")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16sija1jv0l754x4aa6b6fy01d1kf8m0r4id3flqipm45np61jgh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.9)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "Helper crate for @code{rust-darling}, a proc-macro library for
reading attributes into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-macro-0.10
  (package
    (name "rust-darling-macro")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wlv31cxkrjijz5gv13hvk55c9lmd781aj12c8n84sa9mksa5dfr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "Internal support for @code{rust-darling}, a proc-macro library for
reading attributes into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-dashmap-4
  (package
    (name "rust-dashmap")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1773x18k5m2zw1iyibs8l3wl1p1aijdbrc0w844xys06inr46yp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/xacrimon/dashmap")
    (synopsis "Blazing fast concurrent HashMap for Rust.")
    (description "This package implements a blazing fast concurrent HashMap
for Rust.")
    (license license:expat)))

(define-public rust-dashmap-3
  (package
    (inherit rust-dashmap-4)
    (name "rust-dashmap")
    (version "3.11.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ddrjj4khb0s263pw278g5dvbhaid40611h123s9w5shr0phw9hg"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Enable unstable features
           (substitute* "src/lib.rs"
             (("#!\\[cfg_attr" all)
              (string-append "#![feature(map_get_key_value)]" "\n"
                             "#![feature(inner_deref)]" "\n"
                             all)))
           #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.3)
        ("rust-hashbrown" ,rust-hashbrown-0.8)
        ("rust-serde" ,rust-serde-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-data-encoding-2
  (package
    (name "rust-data-encoding")
    (version "2.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "data-encoding" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "027rcrwdschrkdr2n9d24gnh03vl41qmvhjqn9vn6z1njy2n0flr"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ia0/data-encoding")
    (synopsis "Efficient and customizable data-encoding functions")
    (description
     "This library provides encodings for many different common cases, including
hexadecimal, base32, and base64.")
    (license license:expat)))

(define-public rust-data-url-0.1
  (package
    (name "rust-data-url")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "data-url" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "176wa1n8h71iwyaxhar4sqwrgrvb5sxk26az0fy88vnxrsffjgyk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-matches" ,rust-matches-0.1))
       #:cargo-development-inputs
       (("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/servo/rust-url")
    (synopsis "Processing of data: URL according to WHATWG's Fetch Standard")
    (description
     "Processing of data: URL according to WHATWG's Fetch Standard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-datetime-0.4
  (package
    (name "rust-datetime")
    (version "0.4.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "datetime" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fd74bq48xg8ki5yw1mr1pa5hd3j5lbk4iqc5r0kh3l62b0vci2w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
        (("rust-iso8601" ,rust-iso8601-0.1)
         ("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-locale" ,rust-locale-0.2)
         ("rust-num-traits" ,rust-num-traits-0.1)
         ("rust-pad" ,rust-pad-0.1)
         ("rust-redox-syscall" ,rust-redox-syscall-0.1)
         ("rust-winapi" ,rust-winapi-0.2))
        #:cargo-development-inputs
        (("rust-regex" ,rust-regex-0.1)
         ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page "https://github.com/rust-datetime/datetime")
    (synopsis "Library for date and time formatting and arithmetic")
    (description "This package provides a library for date and time formatting
and arithmetic.")
    (license license:expat)))

(define-public rust-dbl-0.3
  (package
    (name "rust-dbl")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dbl" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1pihf6zrzncbs3lsyqkzxxxqmjf8rfpwvs1sg8nmz8cv7df18d97"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://docs.rs/dbl")
    (synopsis "Double operation in Galois Field")
    (description
      "This package provides double and inverse double over Galois Field -
GF(2^n).  This trait is implemented for 64, 128 and 256 bit block
sizes.  Big-endian order is used.  WARNING: Block must be aligned!")
    (license (list license:expat license:asl2.0))))

(define-public rust-deadpool-0.7
  (package
    (name "rust-deadpool")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deadpool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vb18xvhmyg6gvvq5vrcqmy4x26ryrmkqpsgwmb4bvkav1wn24ix"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-config" ,rust-config-0.10)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/bikeshedder/deadpool")
    (synopsis "Dead simple async pool")
    (description
     "Deadpool is a dead simple async pool for connections and objects of any
type.")
    (license (list license:expat license:asl2.0))))

(define-public rust-decimal-2
  (package
    (name "rust-decimal")
    (version "2.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "decimal" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vb3i8vg1dxrw3kzbfiag3gg7rdjd73z80mwbwkq60vnphiqfig6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-ord-subset" ,rust-ord-subset-3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-cc" ,rust-cc-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/alkis/decimal")
    (synopsis "Decimal floating point arithmetic for Rust")
    (description
     "Decimal floating point arithmetic for Rust.")
    (license license:asl2.0)))

(define-public rust-defer-drop-1
  (package
    (name "rust-defer-drop")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defer-drop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d3pmmn5k2ir3yv8z8fnv4jprs5aijkz5pbdyl8x8kp18m90bbhq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/Lucretiel/defer-drop")
    (synopsis "Defer dropping large types to a background thread")
    (description
     "This package provides a defer dropping large types to a background
thread.")
    (license license:mpl2.0)))

(define-public rust-deflate-0.8
  (package
    (name "rust-deflate")
    (version "0.8.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "deflate" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0x6iqlayg129w63999kz97m279m0jj4x4sm6gkqlvmp73y70yxvk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-gzip-header" ,rust-gzip-header-0.3))
       #:cargo-development-inputs
       (("rust-miniz-oxide" ,rust-miniz-oxide-0.3))))
    (home-page "https://github.com/image-rs/deflate-rs")
    (synopsis "DEFLATE, zlib and gzip encoder written in rust")
    (description
     "This package provides a DEFLATE, zlib and gzip encoder written in rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-deflate-0.7
  (package
    (inherit rust-deflate-0.8)
    (name "rust-deflate")
    (version "0.7.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deflate" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1d7d9fpmgjnznrksmd3vlv3dyw01wsrm11ifil6ag22871xnlyvh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-gzip-header" ,rust-gzip-header-0.3)
        ("rust-flate2" ,rust-flate2-1))))))

(define-public rust-defmac-0.2
  (package
    (name "rust-defmac")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "14cqfvc0f1pkd6gdhjxa2wv3iibqprc0n203ims8lvg96752ynfm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/defmac")
    (synopsis "Macro to define lambda-like macros inline")
    (description "A macro to define lambda-like macros inline.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-defmac-0.1
  (package
    (inherit rust-defmac-0.2)
    (name "rust-defmac")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "17giv0n0n1r64z0dahfvkjy3ys517jxyhs8sd9lmgvcljpjyryxa"))))))

(define-public rust-delta-e-0.2
  (package
    (name "rust-delta-e")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "delta_e" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18rxibmi27ark8vj367qm2iqmv5x293l8fm9ang4y2sv3l251sf5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-lab" ,rust-lab-0.7))))
    (home-page "https://github.com/elliotekj/DeltaE")
    (synopsis "Pure Rust implementation of the CIEDE2000 algorithm")
    (description "DeltaE is a pure-Rust implementation of the
@url{http://en.wikipedia.org/wiki/Color_difference#CIEDE2000, CIEDE2000}
algorithm which serves to quantify the difference between two colors.")
    (license license:expat)))

(define-public rust-demo-hack-0.0
  (package
    (name "rust-demo-hack")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m0114p1g0zzrdph5bg03i8m8p70vrwn3whs191jrbjcrmh5lmnp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-demo-hack-impl" ,rust-demo-hack-impl-0.0)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-impl-0.0
  (package
    (name "rust-demo-hack-impl")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f1fdl60xjas9wlmcl9v6f56vgm3mzwr019kcifav5464rx3w3ld"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derivative-2
  (package
    (name "rust-derivative")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derivative" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03rqx8j9q5nlrpr7w8cwwrvw916pr0ahzs3y8yln18cx6mh2nn6b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/mcarton/rust-derivative")
    (synopsis "Set of alternative @code{derive} attributes for Rust")
    (description
     "This package provides a set of alternative @code{derive} attributes for
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-arbitrary-0.4
  (package
    (name "rust-derive-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rp0z4k0j5ip0bx6dssg97l4q6bakhf6lm5h1lpr3p3kwjsi585i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rust-fuzz/arbitrary")
    (synopsis "Derives arbitrary traits")
    (description "This crate implements support for automatically deriving the
@code{Arbitrary} trait.  Don't depend on this crate directly, though.
Instead, enable the @code{derive} feature of the @code{arbitrary} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-0.9
  (package
    (name "rust-derive-builder")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "derive-builder" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1h4f8vnggmpyw27fznl3cpyjrzz1nw5xrxx6ca3zcb3z54hqcrd2"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
         ("rust-darling" ,rust-darling-0.10)
         ("rust-derive-builder-core" ,rust-derive-builder-core-0.9)
         ("rust-env-logger" ,rust-env-logger-0.5)
         ("rust-log" ,rust-log-0.4)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-skeptic" ,rust-skeptic-0.13)
         ("rust-syn" ,rust-syn-1))
        #:cargo-development-inputs
        (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Builder pattern for arbitrary structs")
    (description "Rust macro to automatically implement the builder pattern
for arbitrary structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-0.5
  (package
    (inherit rust-derive-builder-0.9)
    (name "rust-derive-builder")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fgl8dsigr7h70clxjq8xmsfc021w5ag262wfgcqv0ian1m8x6cc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
        ("rust-derive-builder-core" ,rust-derive-builder-core-0.2)
        ("rust-env-logger" ,rust-env-logger-0.4)
        ("rust-log" ,rust-log-0.3)
        ("rust-quote" ,rust-quote-0.3)
        ("rust-skeptic" ,rust-skeptic-0.9)
        ("rust-syn" ,rust-syn-0.11))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.4)
        ("rust-log" ,rust-log-0.3)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.2)
        ("rust-skeptic" ,rust-skeptic-0.9))))))

(define-public rust-derive-builder-core-0.9
  (package
    (name "rust-derive-builder-core")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-builder-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vwb8nwls4lhd2yiyj87kmwws4mmfqfrjcr0pk09b11c6wzfm497"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-log" ,rust-log-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Internal helper library for @code{rust-derive-builder}")
    (description
     "Internal helper library for @code{rust-derive-builder}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-core-0.2
  (package
    (inherit rust-derive-builder-core-0.9)
    (name "rust-derive-builder-core")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-builder-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mxpl1ja3l60w1v5vr3733hr5mcpds2hfl6shrmy3a2zkvp28pkk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.11))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.2))))))

(define-public rust-derive-error-chain-0.10
  (package
    (name "rust-derive-error-chain")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-error-chain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jnybrpiq5jzx69xq74cwxply36js02z14y9sym8sf2iwsnsk71w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.14))))
    (home-page "https://github.com/Arnavion/derive-error-chain")
    (synopsis "Macros 1.1 implementation of error-chain")
    (description "This package provides a Macros 1.1 implementation of
error-chain.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-is-enum-variant-0.1
  (package
    (name "rust-derive-is-enum-variant")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_is_enum_variant" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15w18649m4h47pdpr04id0wv8br8bg606zvrafcrfijihicqib6h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-heck" ,rust-heck-0.3)
        ("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.11))))
    (home-page "https://github.com/fitzgen/derive_is_enum_variant")
    (synopsis "Automatically derives predicates for enums")
    (description
     "This package automatically derives @samp{is_dog} and @samp{is_cat}
methods for @samp{enum Pet @{ Dog, Cat @}}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-derive-more-0.99
  (package
    (name "rust-derive-more")
    (version "0.99.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-more" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "131xrz5nmnh8zq3vcvv0wfpcaflypbxp3fin984fsqddc5hhxjs1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Some test files missing.
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-peg" ,rust-peg-0.5)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))
    (home-page "https://github.com/JelteF/derive_more")
    (synopsis "Adds derive macros for more traits")
    (description
     "Rust has lots of builtin traits that are implemented for its basic
types, such as @code{Add}, @code{Not}, @code{From} or @code{Display}.
However, when wrapping these types inside your own structs or enums you lose
the implementations of these traits and are required to recreate them.  This is
especially annoying when your own structures are very simple, such as when
using the commonly advised newtype pattern (e.g. @code{MyInt(i32)}).

This library tries to remove these annoyances and the corresponding
boilerplate code.  It does this by allowing you to derive lots of commonly used
traits for both structs and enums.")
    (license license:expat)))

(define-public rust-derive-new-0.5
  (package
    (name "rust-derive-new")
    (version "0.5.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-new" version))
      (file-name (string-append name "-" version ".tar.gz"))
      (sha256
       (base32 "1ncibp4jhpkym7namg3viqyw8hljd32n6abg64af8qjwrn91iwvi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/nrc/derive-new")
    (synopsis "Simple constructor functions for structs and enums")
    (description "`#[derive(new)]` implements simple constructor functions for
structs and enums.")
  (license license:expat)))

(define-public rust-deunicode-0.4
  (package
    (name "rust-deunicode")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deunicode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "146nc3wlwz2j9awwf7zf76qvjcahnls0mlv9jm6clcvr9dlph245"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://lib.rs/crates/deunicode")
    (synopsis "Convert Unicode strings to pure ASCII")
    (description
     "This package converts Unicode strings to pure ASCII by
intelligently transliterating them.  It supports Emoji and Chinese.")
    (license license:bsd-3)))

(define-public rust-devise-0.2
  (package
    (name "rust-devise")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lryvr39ia3rfswfnwn2zynsv2r8kj6gqqf0akcs0prws2i4pq3l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-devise-codegen" ,rust-devise-codegen-0.2)
        ("rust-devise-core" ,rust-devise-core-0.2))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-codegen-0.2
  (package
    (name "rust-devise-codegen")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1msmq0h19l03n9qmkxxi1a5h8904i8m623kdvjzak4ya51wynv06"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-devise-core" ,rust-devise-core-0.2)
        ("rust-quote" ,rust-quote-0.6))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-core-0.2
  (package
    (name "rust-devise-core")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11v4z5kljmpiyif3mmfnm3rl1lsqygjlfy2wll7frqxm4adwahfg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dialoguer-0.6
  (package
    (name "rust-dialoguer")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dialoguer" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0f31ahy6myg2vz9xrdmp0vx0m7x427a1wxpgrgwhxd0rgfpqdapl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-console" ,rust-console-0.11)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/mitsuhiko/dialoguer")
    (synopsis "Library for command line prompts")
    (description
     "This package provides a library for command line prompts and the like.")
    (license license:expat)))

(define-public rust-dialoguer-0.3
  (package
    (inherit rust-dialoguer-0.6)
    (name "rust-dialoguer")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dialoguer" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1a9gqvqp83gg4jbm286q5ab3l44zyyzlsdaiqmw8x4k80fdc5l8s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--lib")
       #:cargo-inputs
       (("rust-console" ,rust-console-0.11)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-tempfile" ,rust-tempfile-2))))))

(define-public rust-diesel-1
  (package
    (name "rust-diesel")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diesel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hpmwrc0zx3zvpgwp9zrm6wj8d8i8q8990grlrnfzlivbi6zqyq4"))))
    (build-system cargo-build-system)
    (native-inputs
     `(("sqlite" ,sqlite)))
    (arguments
     `(#:cargo-inputs
       (("rust-bigdecimal" ,rust-bigdecimal-0.1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-diesel-derives" ,rust-diesel-derives-1)
        ("rust-ipnetwork" ,rust-ipnetwork-0.17)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libsqlite3-sys" ,rust-libsqlite3-sys-0.20)
        ("rust-mysqlclient-sys" ,rust-mysqlclient-sys-0.2)
        ("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pq-sys" ,rust-pq-sys-0.4)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-r2d2" ,rust-r2d2)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-url" ,rust-url-1)
        ("rust-uuid" ,rust-uuid-0.5)
        ("rust-uuid" ,rust-uuid-0.8))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dotenv" ,rust-dotenv-0.10)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-tempdir" ,rust-tempdir-0.3))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "cargo" "test" "--features" "sqlite" "--"
                     "--skip=expression::count::count"))))))
    (home-page "https://diesel.rs")
    (synopsis "Safe, extensible ORM and Query Builder")
    (description "This package provides a safe, extensible ORM and Query
Builder for PostgreSQL, SQLite, and MySQL.")
    (license (list license:expat license:asl2.0))))

(define-public rust-diesel-derives-1
  (package
    (name "rust-diesel-derives")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diesel_derives" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lsq133fwk0zj8xvxhdxqgg0xs31zf3abnwdyshaf0ldca7hkxa5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-diesel" ,rust-diesel-1)
        ("rust-dotenv" ,rust-dotenv-0.10))))
    (home-page "https://diesel.rs")
    (synopsis "Crate internal to Diesel")
    (description "You should not use this crate directly, it is internal to
Diesel.")
    (license (list license:expat license:asl2.0))))

(define-public rust-diff-0.1
  (package
    (name "rust-diff")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diff" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16b40bhsa2qgvgvxs983l625pkxyp6m0mzmpwg2605cvj53yl98f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-speculate" ,rust-speculate-0.1))))
    (home-page "https://github.com/utkarshkukreti/diff.rs")
    (synopsis
     "LCS based slice and string diffing implementation")
    (description
     "An LCS based slice and string diffing implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-difference-2
  (package
    (name "rust-difference")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1621wx4k8h452p6xzmzzvm7mz87kxh4yqz0kzxfjj9xmjxlbyk2j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/johannhof/difference.rs")
    (synopsis "Rust text diffing and assertion library")
    (description
     "This package provides a Rust text diffing and assertion library.")
    (license license:expat)))

(define-public rust-difference-1
  (package/inherit rust-difference-2
    (name "rust-difference")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a5v0b73z7vywbclll32wjsfkdgh6wn9prnq91z0d3lag4clsc5k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-term" ,rust-term-0.2))))))

(define-public rust-diffs-0.3
  (package
    (name "rust-diffs")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diffs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "036sqycmir4bbl4016jprsyjq4hicc31r68dyqadmc8ac9pk55d1"))))
    (build-system cargo-build-system)
    (home-page "https://nest.pijul.com/pijul_org/pijul")
    (synopsis "Diff algorithms, also called longest common subsequence")
    (description
     "This package provides a number of diff algorithms, also called longest
common subsequence.  The diff algorithms include Myer's diff and Patience
diff.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-digest-0.9
  (package
    (name "rust-digest")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "digest" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rmhvk33rgvd6ll71z8sng91a52rw14p0drjn1da0mqa138n1pfk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for cryptographic hash functions")
    (description
     "Traits for cryptographic hash functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-digest-0.8
  (package
    (inherit rust-digest-0.9)
    (name "rust-digest")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1madjl27f3kj5ql7kwgvb9c8b7yb7bv7yfgx7rqzj4i3fp4cil7k"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-blobby" ,rust-blobby-0.1)
        ("rust-generic-array" ,rust-generic-array-0.13))))))

(define-public rust-digest-0.7
  (package
    (inherit rust-digest-0.9)
    (name "rust-digest")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "142vdpvkqlqk9s1dcgpqb2wz76n5a39gjnk68p0zkflc58j75c03"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.9))))))

(define-public rust-digest-0.6
  (package
    (name "rust-digest")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "digest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02mgf8z4hi96w9nl2zb5w3k6lqbhjgv5z8hhyv2b7x7kavqrpcp5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array" ,rust-generic-array-0.8))))
    (home-page "https://github.com/RustCrypto/traits")
    (synopsis "Traits for cryptographic hash functions")
    (description "This package provides traits for cryptographic hash
functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-3
  (package
    (name "rust-directories")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03ysv4m6mhsc3w1xnvncd5sxf7v2dz917awq6ksx0n0bsqwxdzpq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))
    (home-page "https://github.com/dirs-dev/directories-rs")
    (synopsis "Library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config,
cache and other data on Linux, Windows and macOS by leveraging the
mechanisms defined by the XDG base/user directory specifications
on Linux, the Known Folder API on Windows, and the Standard
Directory guidelines on macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-2
  (package
    (inherit rust-directories-3)
    (name "rust-directories")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "071pjx760m0dccdxlhwsz9m0zl180hxwlag62bydfl54fa0pf6jm"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dirs-sys" ,rust-dirs-sys-0.3))))))

(define-public rust-directories-next-2
  (package
    (name "rust-directories-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g1vq8d8mv0vp0l317gh9y46ipqg2fxjnbc7lnjhwqbsv4qf37ik"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/directories")
    (synopsis "Mid-level library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-next-1
  (package
    (inherit rust-directories-next-2)
    (name "rust-directories-next")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mmym1h9vlyapwlzygfas3q9mx03mki8cnf5y1bmr713q7mwqa4a"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys" ,rust-dirs-sys-next-0.1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))))

(define-public rust-dirs-3
  (package
    (name "rust-dirs")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zxrb3anxsh80mnp2il7awccv0s5gvy7djn6gis18nbm0bnraa8l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))))
    (home-page "https://github.com/soc/dirs-rs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package is a tiny low-level library that provides platform-specific
standard locations of directories for config, cache and other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-2
  (package
    (inherit rust-dirs-3)
    (name "rust-dirs")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qymhyq7w7wlf1dirq6gsnabdyzg6yi2yyxkx6c4ldlkbjdaibhk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dirs-sys" ,rust-dirs-sys-0.3))))
    (inputs
     `(("rust-cfg-if" ,rust-cfg-if-0.1)
       ("rust-dirs-sys" ,rust-dirs-sys-0.3)))))

(define-public rust-dirs-1
  (package
    (inherit rust-dirs-2)
    (name "rust-dirs")
    (version "1.0.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dirs" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "009rrhzj9pxyncmm2vhlj70npg0cgggv2hjbbkiwdl9vccq8kmrz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-dirs-next-2
  (package
    (name "rust-dirs-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q9kr151h9681wwp6is18750ssghz6j9j7qm7qi1ngcwy7mzi35r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package provides a tiny low-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-next-1
  (package
    (inherit rust-dirs-next-2)
    (name "rust-dirs-next")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dl2dqzsrcb7qigfiwpdpakhdkpz0629pvylbj2ylyrkh1dfcdng"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-sys-0.3
  (package
    (name "rust-dirs-sys")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ym5843xack45b1yjahrh3q2f72shnwf1dd2jncf9qsxf3sxg4wf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))
    (inputs
     `(("rust-cfg-if" ,rust-cfg-if-0.1)
       ("rust-libc" ,rust-libc-0.2)
       ("rust-redox-users" ,rust-redox-users-0.3)
       ("rust-winapi" ,rust-winapi-0.3)))
    (home-page "https://github.com/soc/dirs-sys-rs")
    (synopsis
     "System-level helper functions for the dirs and directories crates")
    (description
     "This package provides system-level helper functions for the @code{dirs}
and @code{directories} crates.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dirs-sys-next-0.1
  (package
    (inherit rust-dirs-sys-0.3)
    (name "rust-dirs-sys-next")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0zgy7is3h2dyf1l4sa7k065w2kvx0l12l40my4rswm2mc1gkdplr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/dirs-sys")))

(define-public rust-discard-1
  (package
    (name "rust-discard")
    (version "1.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "discard" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1h67ni5bxvg95s91wgicily4ix7lcw7cq0a5gy9njrybaibhyb91"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/Pauan/rust-discard")
    (synopsis "Allow for intentionally leaking memory")
    (description "There are situations where you need to intentionally leak some
memory but not other memory.  This package provides a discard trait which allows
for intentionally leaking memory")
    (license license:expat)))

(define-public rust-dispatch-0.2
  (package
    (name "rust-dispatch")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dispatch" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fwjr9b7582ic5689zxj8lf7zl94iklhlns3yivrnv8c9fxr635x"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/SSheldon/rust-dispatch")
    (synopsis "Rust wrapper for Apple's Grand Central Dispatch")
    (description "This package provides a Rust wrapper for Apple's Grand
Central Dispatch.")
    (license license:expat)))

(define-public rust-dispatch-0.1
  (package
    (inherit rust-dispatch-0.2)
    (name "rust-dispatch")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dispatch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "019nzy993hxaiazcdnayx3csv2iki34i535asw11ki96hakkrs84"))))
    (arguments '(#:tests? #f))))  ; Tests only run on Mac.

(define-public rust-dissimilar-1
  (package
    (name "rust-dissimilar")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dissimilar" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "154ba92ifmh3js1k0hbmxz7pv95n8wmahlyvhdbnxggbs8f1dpir"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/dissimilar")
    (synopsis "Diff library with semantic cleanup")
    (description
     "This package provides a diff library with semantic cleanup, based on
Google's diff-match-patch.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dlib-0.4
  (package
    (name "rust-dlib")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlib" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xlsf3lrz9hd7q3ff6lp5mw4kn3nbryn746kd07i93r6wg8ia7xi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libloading" ,rust-libloading-0.6))))
    (inputs
     `(("rust-libloading" ,rust-libloading-0.6)))
    (home-page "https://github.com/vberger/dlib")
    (synopsis "Helper macros for manually loading optional system libraries")
    (description
     "This package provides helper macros for handling manually loading optional
system libraries.")
    (license license:expat)))

(define-public rust-doc-comment-0.3
  (package
    (name "rust-doc-comment")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "doc-comment" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "15rsqxgarfpb1yim9sbp9yfgj7p2dq6v51c6bq1a62paii9ylgcj"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/GuillaumeGomez/doc-comment")
    (synopsis "Macro to generate doc comments")
    (description "This package provides a way to generate doc comments
from macros.")
    (license license:expat)))

(define-public rust-docmatic-0.1
  (package
    (name "rust-docmatic")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docmatic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hx85n266lxswqxrbbinqlhi1qcnjgd4cc7v42abg72kmz7fnn4d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-which" ,rust-which-2))))
    (home-page "https://github.com/assert-rs/docmatic")
    (synopsis "Test Rust examples in your documentation")
    (description "Test Rust examples in your documentation.")
    (license license:expat)))

(define-public rust-docopt-1
  (package
    (name "rust-docopt")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s9rcpmnnivs502q69lc1h1wrwapkq09ikgbfbgqf31idmc5llkz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-strsim" ,rust-strsim-0.9))))
    (home-page "https://github.com/docopt/docopt.rs")
    (synopsis "Command line argument parsing")
    (description "Command line argument parsing.")
    (license (list license:expat license:unlicense))))

(define-public rust-docopt-0.8
  (package/inherit rust-docopt-1
    (name "rust-docopt")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jha611mffc2qnxvdl3pmglz07akl99lk1vihhb3nl1cd69x7b6q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-strsim" ,rust-strsim-0.6))))))

(define-public rust-docopt-0.7
  (package
    (inherit rust-docopt-1)
    (name "rust-docopt")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n6gbhsks2w9y0b4bwqyawh4ghbkka09w6pjcrq9i1sd51pflcmb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.6))))))

(define-public rust-docopt-0.6
  (package
    (inherit rust-docopt-0.7)
    (name "rust-docopt")
    (version "0.6.86")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nf4f4zf5yk0d0l4kl7hkii4na22fhn0l2hgfb46yzv08l2g6zja"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.5))))))

(define-public rust-downcast-rs-1
  (package
    (name "rust-downcast-rs")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "downcast-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l36kgxqd5djhqwf5abxjmgasdw8n0qsjvw3jdvhi91nj393ba4y"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/marcianx/downcast-rs")
    (synopsis "Trait object downcasting support using only safe Rust")
    (description
     "Trait object downcasting support using only safe Rust.  It supports type
parameters, associated types, and type constraints.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dogged-0.2
  (package
    (name "rust-dogged")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dogged" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yk5l6qqidl5y935x15gi9kkd6niim1wb64r1l7kdzl9jw8dyf16"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/nikomatsakis/dogged")
    (synopsis "Persistent vector, similar to Clojure")
    (description "This package experimental persistent collections in Rust.
Based on a digit-indexed trie, as in Clojure.  Supports @code{push()},
@code{get()}, and @code{get_mut()} as its primitive operations for now.  All
O(1)-in-practice, if not in theory, but obviously not as fast as a
non-persistent vector.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dotenv-0.15
  (package
    (name "rust-dotenv")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13ysjx7n2bqxxqydvnnbdwgik7i8n6h5c1qhr9g11x6cxnnhpjbp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/dotenv-rs/dotenv")
    (synopsis "@code{dotenv} implementation for Rust")
    (description "This package provides a @code{dotenv} implementation for
Rust.")
    (license license:expat)))

(define-public rust-dotenv-0.10
  (package
    (inherit rust-dotenv-0.15)
    (name "rust-dotenv")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ww0wfnilz4cy789fni06gckm45xsb9fplrih26l4qyi4jxy5w6n"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-error-chain" ,rust-derive-error-chain-0.10)
        ("rust-error-chain" ,rust-error-chain-0.10)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-syn" ,rust-syn-0.11))))))

(define-public rust-draw-state-0.8
  (package
    (name "rust-draw-state")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "draw_state" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lfng4fz9x7bwsmzv9r20ply10w0iid6vfcrhx292s6hw8vrbkrk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://github.com/gfx-rs/draw_state")
    (synopsis "Graphics state blocks for gfx-rs")
    (description "Graphics state blocks for gfx-rs.")
    (license license:asl2.0)))

(define-public rust-dtoa-0.4
  (package
    (name "rust-dtoa")
    (version "0.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0phbm7i0dpn44gzi07683zxaicjap5064w62pidci4fhhciv8mza"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/dtolnay/dtoa")
    (synopsis "Fast functions for printing floating-point primitives")
    (description "This crate provides fast functions for printing
floating-point primitives to an @code{io::Write}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-dtoa-0.2
  (package
    (inherit rust-dtoa-0.4)
    (name "rust-dtoa")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0g96cap6si1g6wi62hsdk2fnj3sf5vd4i97zj6163j8hhnsl3n0d"))))))

(define-public rust-dtoa-short-0.3
  (package
    (name "rust-dtoa-short")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa-short" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wkn7ziqffq8hj0a411lgn7674ackzdk734ikp230rmp2f2hn0jr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dtoa" ,rust-dtoa-0.4))
       #:cargo-development-inputs
       (("rust-float-cmp" ,rust-float-cmp-0.3))))
    (home-page "https://github.com/upsuper/dtoa-short")
    (synopsis "Serialize float number and truncate to certain precision")
    (description
     "Serialize float number and truncate to certain precision in Rust.")
    (license license:mpl2.0)))

(define-public rust-dtparse-1
  (package
    (name "rust-dtparse")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dtparse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xh9hasfffnfyv8q9pwr31g63rigfx114qz6xw05wdkzpmfnq9qk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rust-decimal" ,rust-rust-decimal-0.10))))
    (home-page "https://github.com/bspeice/dtparse.git")
    (synopsis "Dateutil-compatible timestamp parser for Rust")
    (description
     "This package provides a @code{dateutil}-compatible timestamp parser for
Rust.")
    (license license:asl2.0)))

(define-public rust-duct-0.13
  (package
    (name "rust-duct")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duct" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ir3884i1yznkfdccqqbcb9v5sdpcgxlv41hgzncrqaljv18r0wj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-os-pipe" ,rust-os-pipe-0.8)
        ("rust-shared-child" ,rust-shared-child-0.3))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page
     "https://github.com/oconnor663/duct.rs")
    (synopsis
     "Library for running child processes")
    (description
     "A library for running child processes.")
    (license license:expat)))

(define-public rust-dunce-1
  (package
    (name "rust-dunce")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dunce" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d7f7wg83i1by16rxc1fdipi872nvkzjnmzaaggh2h8cgi51qr5j"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://gitlab.com/kornelski/dunce")
    (synopsis "Normalize Windows paths to the most compatible format")
    (description
     "This crate converts Windows UNC paths to the MS-DOS-compatible format
whenever possible, but leaves UNC paths as-is when they can't be unambiguously
expressed in a simpler way.  This allows legacy programs to access all paths
they can possibly access, and doesn't break any paths for UNC-aware
programs.")
    (license license:cc0)))

(define-public rust-dyn-clone-1
  (package
    (name "rust-dyn-clone")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dyn-clone" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10idzzq2sad7dhrfhrhcx7yckzj8il2bzr16204683ryclxdqlsc"))))
    (arguments
     `(#:skip-build? #t))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/dyn-clone")
    (synopsis "Clone trait that is object-safe")
    (description "Clone trait that is object-safe")
    (license (list license:expat license:asl2.0))))

(define-public rust-dwrote-0.11
  (package
    (name "rust-dwrote")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dwrote" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nx6d9ddqjv0gfi1if3zbsnc9sfj6qfm900jfgnx66k1llmir6j3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-wio" ,rust-wio-0.2))))
    (home-page "https://github.com/servo/dwrote-rs")
    (synopsis "Lightweight binding to DirectWrite")
    (description
     "This package provides lightweight binding to DirectWrite.")
    (license license:mpl2.0)))

(define-public rust-dwrote-0.9
  (package
    (inherit rust-dwrote-0.11)
    (name "rust-dwrote")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dwrote" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03gzl5pd90nlkmwqmbmjmyz47h7wlblbqrwv5a29npnv0ag3dl8b"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ;("rust-wio" ,rust-wio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-easy-parallel-3
  (package
    (name "rust-easy-parallel")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-parallel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x28z540fc4g8fqm1sbpqbpdfbi40mkas4xr57s3yn0jjbbszm0x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/easy-parallel")
    (synopsis "Run closures in parallel")
    (description
     "This crate provides a simple primitive for spawning threads in bulk and
waiting for them to complete.  Threads are allowed to borrow local variables
from the main thread.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-easycurses-0.12
  (package
    (name "rust-easycurses")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easycurses" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10cp60lrhn1k0vg97jgzqbk03x4hmhrgxbz9m3gcmzhzbpn88m2a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-pancurses" ,rust-pancurses-0.16))))
    (home-page "https://github.com/Lokathor/easycurses-rs")
    (synopsis "Work with @code{curses} easily")
    (description
     "This package provides a crate that makes working with @code{curses}
easy.")
    (license (list license:unlicense license:zlib))))

(define-public rust-eax-0.3
  (package
    (name "rust-eax")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "eax" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0vmpbqncpbj2ldm3fhfz87ija1sk4zk9vad91yd2jjsrbrx6xxz1"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-aead" ,rust-aead-0.3)
         ("rust-cipher" ,rust-cipher-0.2)
         ("rust-cmac" ,rust-cmac-0.5)
         ("rust-ctr" ,rust-ctr-0.6)
         ("rust-subtle" ,rust-subtle-2))))
    (home-page "https://docs.rs/eax/")
    (synopsis "Pure Rust implementation of the EAX Authenticated Encryption
with Associated Data (AEAD)")
    (description "This package provides a pure Rust implementation of the EAX
Authenticated Encryption with Associated Data (AEAD) Cipher with optional
architecture-specific hardware acceleration.  This scheme is only based on a
block cipher.  It uses counter mode (CTR) for encryption and CBC mode for
generating a OMAC/CMAC/CBCMAC (all names for the same thing).")
    (license (list license:asl2.0 license:expat))))  ; at your choice

(define-public rust-ed25519-1
  (package
    (name "rust-ed25519")
    (version "1.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ed25519" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1vxn7x1xinbv1cl31015m0fw08jwkphylxrll17animv9i9nmiip"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-serde" ,rust-serde-1)
         ("rust-signature" ,rust-signature-1))))
    (home-page "")
    (synopsis "Edwards Digital Signature Algorithm (EdDSA) over Curve25519")
    (description
      "EdDSA over Curve25519 is specified in RFC 8032.  This package contains
an ed25519::Signature type which other packages can use in conjunction with
the signature::Signer and signature::Verifier traits It doesn't contain an
implementation of Ed25519.

These traits allow packages which produce and consume Ed25519 signatures to be
written abstractly in such a way that different signer/verifier providers can
be plugged in, enabling support for using different Ed25519 implementations,
including HSMs or Cloud KMS services.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ed25519-dalek-1
  (package
    (name "rust-ed25519-dalek")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ed25519-dalek" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "17bsriciv93nkm39z22w7mr0h2a3hnbmgf378v4c895gvkkblqn7"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-curve25519-dalek" ,rust-curve25519-dalek-3)
         ("rust-ed25519" ,rust-ed25519-1)
         ("rust-merlin" ,rust-merlin-2)
         ("rust-rand" ,rust-rand-0.7)
         ("rust-rand-core" ,rust-rand-core-0.5)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-bytes" ,rust-serde-bytes-0.11)
         ("rust-sha2" ,rust-sha2-0.9)
         ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://dalek.rs")
    (synopsis "Ed25519 EdDSA key generations, signing, and verification")
    (description
      "This package provides fast and efficient ed25519 EdDSA key generations,
signing, and verification in pure Rust.")
    (license license:bsd-3)))

(define-public rust-edit-distance-2
  (package
    (name "rust-edit-distance")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "edit-distance" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0yq3wlmd7ly22qxhfysi77qp31yvpx2ll9waa75bkpiih7rsmfmv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page "https://github.com/febeling/edit-distance")
    (synopsis "Levenshtein edit distance between strings")
    (description
     "Levenshtein edit distance between strings, a measure for similarity.")
    (license license:asl2.0)))

(define-public rust-either-1
  (package
    (name "rust-either")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "either" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qyz1b1acad6w0k5928jw5zaq900zhsk7p8dlcp4hh61w4f6n7xv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/bluss/either")
    (synopsis
     "Enum @code{Either} with variants @code{Left} and @code{Right}")
    (description
     "The enum @code{Either} with variants @code{Left} and
@code{Right} is a general purpose sum type with two cases.")
    (license (list license:expat license:asl2.0))))

(define-public rust-embed-resource-1
  (package
    (name "rust-embed-resource")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "embed-resource" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pbif8kl6xcvfnp8gibqsw0w14l28vfkff9k6byw506s0d20nsqz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-vswhom" ,rust-vswhom-0.1)
        ("rust-winreg" ,rust-winreg-0.6))))
    (home-page "https://github.com/nabijaczleweli/rust-embed-resource")
    (synopsis
     "Cargo library to handle compilation and inclusion of Windows resources")
    (description
     "This package provides a Cargo library to handle compilation and
inclusion of Windows resources in the most resilient fashion imaginable.")
    (license license:expat)))

(define-public rust-ena-0.14
  (package
    (name "rust-ena")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hrnkx2swbczn0jzpscxxipx7jcxhg6sf9vk911ff91wm6a2nh6p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-dogged" ,rust-dogged-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-petgraph" ,rust-petgraph-0.4))))
    (home-page "https://github.com/rust-lang/ena")
    (synopsis "Union-find, congruence closure, and other unification code")
    (description "This package provides an implementation of union-find /
congruence-closure in Rust.  It was extracted from rustc for independent
experimentation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ena-0.13
  (package
    (inherit rust-ena-0.14)
    (name "rust-ena")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dkggq0qwv140y2kjfd4spp77zi3v7vnpm4bfy7s7r4cla7xqi49"))))))

(define-public rust-encode-unicode-0.3
  (package
    (name "rust-encode-unicode")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encode_unicode" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07w3vzrhxh9lpjgsg2y5bwzfar2aq35mdznvcp3zjl0ssj7d4mx3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ascii" ,rust-ascii-1)
        ("rust-clippy" ,rust-clippy-0.0))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/tormol/encode_unicode")
    (synopsis
     "UTF-8 and UTF-16 support for char, u8 and u16")
    (description
     "UTF-8 and UTF-16 character types, iterators and related methods for
char, u8 and u16.")
    (license (list license:expat license:asl2.0))))

(define-public rust-encoding-0.2
  (package
    (name "rust-encoding")
    (version "0.2.33")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v1ndmkarh9z3n5hk53da4z56hgk9wa5kcsm7cnx345raqw983bb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-japanese"
         ,rust-encoding-index-japanese-1.20141219)
        ("rust-encoding-index-korean"
         ,rust-encoding-index-korean-1.20141219)
        ("rust-encoding-index-simpchinese"
         ,rust-encoding-index-simpchinese-1.20141219)
        ("rust-encoding-index-singlebyte"
         ,rust-encoding-index-singlebyte-1.20141219)
        ("rust-encoding-index-tradchinese"
         ,rust-encoding-index-tradchinese-1.20141219))
       #:cargo-development-inputs
       (("rust-getopts" ,rust-getopts-0.2))))
    (home-page
     "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Character encoding support for Rust")
    (description
     "Character encoding support for Rust.")
    (license license:expat)))

(define-public rust-encoding-index-japanese-1.20141219
  (package
    (name "rust-encoding-index-japanese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-japanese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "148c1lmd640p1d7fzk0nv7892mbyavvwddgqvcsm78798bzv5s04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Japanese character encodings")
    (description
     "Index tables for Japanese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-korean-1.20141219
  (package
    (name "rust-encoding-index-korean")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-korean" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10cxabp5ppygbq4y6y680856zl9zjvq7ahpiw8zj3fmwwsw3zhsd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Korean character encodings")
    (description
     "Index tables for Korean character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-simpchinese-1.20141219
  (package
    (name "rust-encoding-index-simpchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-simpchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xria2i7mc5dqdrpqxasdbxv1qx46jjbm53if3y1i4cvj2a72ynq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for simplified Chinese character encodings")
    (description
     "Index tables for simplified Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-singlebyte-1.20141219
  (package
    (name "rust-encoding-index-singlebyte")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-singlebyte" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jp85bz2pprzvg9m95w4q0vibh67b6w3bx35lafay95jzyndal9k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for various single-byte character encodings")
    (description
     "Index tables for various single-byte character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tests-0.1
  (package
    (name "rust-encoding-index-tests")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_index_tests" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s85y091gl17ixass49bzaivng7w8p82p6nyvz2r3my9w4mxhim2"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis
     "Macros used to test index tables for character encodings")
    (description
     "Helper macros used to test index tables for character
encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tradchinese-1.20141219
  (package
    (name "rust-encoding-index-tradchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-tradchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "060ci4iz6xfvzk38syfbjvs7pix5hch3mvxkksswmqwcd3aj03px"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for traditional Chinese character encodings")
    (description
     "Index tables for traditional Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-rs-0.8
  (package
    (name "rust-encoding-rs")
    (version "0.8.28")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rf0r99q4kgjrx22kx7pjyjg4lm21599y3ggvy3hzj2spi7h5pw0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-packed-simd" ,rust-packed-simd-2-0.3)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://docs.rs/encoding_rs/")
    (synopsis "Gecko-oriented implementation of the Encoding Standard")
    (description
     "This package provides a Gecko-oriented implementation of the Encoding
Standard.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-encoding-rs-io-0.1
  (package
    (name "rust-encoding-rs-io")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs_io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10ra4l688cdadd8h1lsbahld1zbywnnqv68366mbhamn3xjwbhqw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8))))
    (home-page "https://github.com/BurntSushi/encoding_rs_io")
    (synopsis "Streaming transcoding for encoding_rs")
    (description
     "Streaming transcoding for encoding_rs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-endian-type-0.1
  (package
    (name "rust-endian-type")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "endian-type" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bbh88zaig1jfqrm7w3gx0pz81kw2jakk3055vbgapw3dmk08ky3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/Lolirofle/endian-type")
    (synopsis "Type safe wrappers for types with a defined byte order")
    (description
     "This crates provides type safe wrappers for types with a defined byte
order.")
    (license license:expat)))

(define-public rust-enum-as-inner-0.3
  (package
    (name "rust-enum-as-inner")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-as-inner" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15gmpgywijda93lkq7hf2y53h66sqkhzabzbxich288xm6b00pvw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-heck" ,rust-heck-0.3)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/bluejekyll/enum-as-inner")
    (synopsis "Proc-macro for deriving inner field accessor functions on enums")
    (description "This package provides a proc-macro for deriving inner field
accessor functions on enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-as-inner-0.2
  (package
    (inherit rust-enum-as-inner-0.3)
    (name "rust-enum-as-inner")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enum-as-inner" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0zg3h7k3g1z7a9ayqy63sk302d4dg5g2h274ddv80mj4jxn2cn1x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-enum-primitive-0.1
  (package
    (name "rust-enum-primitive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-primitive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100ip2p3w1rq0clca2ai5shhvpxfipnsjncj0f9ralad5w4m2idy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1))))
    (home-page "https://github.com/andersk/enum_primitive-rs")
    (synopsis "Macro to generate @code{num::FromPrimitive} instances for enum")
    (description
     "This package provides a macro to generate @code{num::FromPrimitive}
instances for enum.")
    (license license:expat)))

(define-public rust-enum-to-u8-slice-derive-0.1
  (package
    (name "rust-enum-to-u8-slice-derive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum_to_u8_slice_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvzi74pnh5a7f4klrk0dz45l0mgcy5l3zajjhjsxzws28js4yc4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.11))))
    (home-page "https://github.com/mesalock-linux/enum_to_u8_slice_derive")
    (synopsis "Convert enum to u8 slice ref")
    (description
     "This package provides a simple fork of @code{enum_to_str_derive},
convert enum to u8 slice ref.")
    (license license:bsd-3)))

(define-public rust-env-logger-0.8
  (package
    (name "rust-env-logger")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env-logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gwx1pvbv99fj9wpicknyv4p2vj997xpva8ac5dg03m35q0jlf8p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))
    (home-page "https://github.com/sebasmagri/env_logger/")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This package provides a logging implementation for @code{log} which
is configured via an environment variable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-logger-0.7
  (package
    (inherit rust-env-logger-0.8)
    (name "rust-env-logger")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0djx8h8xfib43g5w94r1m1mkky5spcw4wblzgnhiyg5vnfxknls4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.6
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lx2s5nk96xx4i3m4zc4ghqgi8kb07dsnyiv8jk2clhax42dxz5a"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.5
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.5.13")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env-logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0f0c4i4c65jh8lci0afl5yg74ac0lbnpxcp81chj114zwg9a9c0m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.4
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.4.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env-logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nydz2lidsvx9gs0v2zcz68rzqx8in7fzmiprgsrhqh17vkj3prx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-regex" ,rust-regex-0.2))))))

(define-public rust-env-logger-0.3
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bvcjgkw4s3k1rd7glpflgc8s9a393zjd6jfdgvs8gjvwj0dgaqm"))))
    (arguments
     `(#:skip-build? #t     ; Cannot find dependent crates.
       #:cargo-inputs
       (("rust-regex" ,rust-regex-0.1)
        ("rust-log" ,rust-log-0.3))))))

(define-public rust-environment-0.1
  (package
    (name "rust-environment")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "environment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vh32mcxf3z8xaibwv751zj14d08nh7iwk1vqdj90rkq17i18jqz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f)) ;; 3/6 tests fail due to missing file
    (home-page "https://github.com/Freyskeyd/environment")
    (synopsis "Helper to deal with environment variables")
    (description "This package provides helper to deal with environment
variables.")
    (license (list license:expat license:asl2.0))))

(define-public rust-envmnt-0.6
  (package
    (name "rust-envmnt")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "envmnt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12zkq3p999bypyxmjnpiqw9r3hmifb3bcikd7j3as1fdcbq01fyl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-indexmap" ,rust-indexmap-1))))
    (home-page "https://github.com/sagiegurari/envmnt")
    (synopsis "Environment variables utility functions")
    (description
     "Environment variables utility functions.")
    (license license:asl2.0)))

(define-public rust-erased-serde-0.3
  (package
    (name "rust-erased-serde")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "erased-serde" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lgkpkk7nx6f24gmr3psyj8d2avc9701r9jyw1i4ssp10lbnv2yq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (;("rust-serde-cbor" ,rust-serde-cbor-0.9)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/dtolnay/erased-serde")
    (synopsis "Type-erased Serialize and Serializer traits")
    (description
     "Type-erased Serialize and Serializer traits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-err-derive-0.2
  (package
    (name "rust-err-derive")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "err-derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0v6wxrshfpg7mwaxzq8jwxbfiyn7zk5rlm4m8kkrwh7dpf8nrx42"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-synstructure" ,rust-synstructure-0.12)
        ("rust-skeptic" ,rust-skeptic-0.13)
        ("rust-proc-macro-error" ,rust-proc-macro-error-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-quote" ,rust-quote-1))
       #:cargo-development-inputs
       (("rust-skeptic" ,rust-skeptic-0.13))))
    (home-page "https://gitlab.com/torkleyy/err-derive")
    (synopsis "Derive macro for `std::error::Error`")
    (description
     "Derive macro for @code{std::error::Error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-errno-0.2
  (package
    (name "rust-errno")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kn8mlygxxr02cm97401nppd2dbkwsalpcbai67rh6yh3rh73862"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-errno-dragonfly" ,rust-errno-dragonfly-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/lambda-fairy/rust-errno")
    (synopsis "Cross-platform interface to the @code{errno} variable")
    (description
     "Cross-platform interface to the @code{errno} variable.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-errno-dragonfly-0.1
  (package
    (name "rust-errno-dragonfly")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno-dragonfly" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rshlc00nv45f14v2l1w0ma2nf1jg5j7q9pvw7hh018r6r73bjhl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/mneumann/errno-dragonfly-rs")
    (synopsis "Exposes errno functionality to stable Rust on DragonFlyBSD")
    (description
     "Exposes errno functionality to stable Rust on DragonFlyBSD.")
    (license license:expat)))

(define-public rust-error-chain-0.12
  (package
    (name "rust-error-chain")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-chain" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ka5y0fmymxzx3gz2yrd7rpz2i555m1iw4fpmcggpzcgr1n10wfk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/rust-lang-nursery/error-chain")
    (synopsis "Yet another error boilerplate library")
    (description
     "Yet another error boilerplate library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-error-chain-0.11
  (package
    (inherit rust-error-chain-0.12)
    (name "rust-error-chain")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wykkr0naizbkwxjwia1rch8xhwvgij9khqvjzs07mrmqifislgz"))))
    (arguments
     `(#:tests? #f      ; Not all test files included.
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-chain-0.10
  (package
    (inherit rust-error-chain-0.11)
    (name "rust-error-chain")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1y1gyj9g5c3k1nzkvxrgry8v9k86kcc585mczrm3qz019s35shyr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-code-2
  (package
    (name "rust-error-code")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-code" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lmblmk2kr0cy6x3d1y2ywxg3jg6nicf8fahd3l5wb1ddzv9975l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-str-buf" ,rust-str-buf-1))))
    (home-page "")
    (synopsis "Alternative @code{Error} for Rust")
    (description
     "This package provides a simplified @code{Error} which works in
@code{no_std} environment.")
    (license license:boost1.0)))

(define-public rust-escargot-0.5
  (package
    (name "rust-escargot")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "escargot" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vd9phbpd6yrnsksn2as8flvq8ykzvck2zlz143xpp42qaz9dkvl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; not all test files included
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-assert-fs" ,rust-assert-fs-0.11))))
    (home-page "https://github.com/crate-ci/escargot")
    (synopsis "Cargo API written in Paris")
    (description "Cargo API written in Paris.")
    (license (list license:expat license:asl2.0))))

(define-public rust-escargot-0.3
  (package
    (inherit rust-escargot-0.5)
    (name "rust-escargot")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "escargot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19fmn7bz1h6nlqy0mp825xwjwnrjn4xjdpwc06jl51j3fiz1znqr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-event-listener-2
  (package
    (name "rust-event-listener")
    (version "2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ndyp41pb2cx7gxijqh4ymnc47nyrvhvir7rvjlw6x09ayb10lzp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-waker-fn" ,rust-waker-fn-1))))
    (home-page "https://github.com/stjepang/event-listener")
    (synopsis "Notify async tasks or threads")
    (description
     "This is a synchronization primitive similar to @code{eventcounts}.
You can use this crate to turn non-blocking data structures into async or
blocking data structures.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-exitfailure-0.5
  (package
    (name "rust-exitfailure")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exitfailure" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0585wix3b3pjjj90fkqj9x4ar46d24x82k8rdin3czzk5a1vvx9g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-failure" ,rust-failure-0.1))
       #:cargo-development-inputs
       (("rust-assert-cmd" ,rust-assert-cmd-0.9)
        ("rust-predicates" ,rust-predicates-0.9))
       ;; Tests fail with "No such file or directory".
       #:tests? #f))
    (home-page "https://github.com/tismith/exitfailure")
    (synopsis "Provide @code{newtype} wrappers for using @code{?} in @code{main}")
    (description
     "This package provides a basic @code{newtype} wrappers to help with using
@code{?} in @code{main}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-expat-sys-2
  (package
    (name "rust-expat-sys")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expat-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1yj5pqynds776ay8wg9mhi3hvna4fv7vf244yr1864r0i5r1k3v5"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "expat") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cmake" ,rust-cmake-0.1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("expat" ,expat)))
    (home-page "http://www.libexpat.org/")
    (synopsis "XML parser library written in C")
    (description "XML parser library written in C")
    (license license:expat)))

(define-public rust-expectest-0.9
  (package
    (name "rust-expectest")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expectest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f24q2a53x7sfmmrqjbwbk7pahzwkpd829fcr023kb7q5xnd6z4g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1))))
    (home-page "https://github.com/zummenix/expectest")
    (synopsis "Matchers and matcher functions for unit testing")
    (description "This crate provides matchers and matcher functions for unit
testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-extend-0.1
  (package
    (name "rust-extend")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "extend" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01azyniinxrwng13hkj450gplp1ajslbqzksjg4dk6655sks6zgl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=test::test_ui" )
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/davidpdrsn/extend")
    (synopsis "Create extensions for types you don't own")
    (description
     "This crates creates extensions for types you don't own with extension
traits but without the boilerplate.")
    (license license:expat)))

(define-public rust-fake-simd-0.1
  (package
    (name "rust-fake-simd")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fake-simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vfylvk4va2ivqx85603lyqqp0zk52cgbs4n5nfbbbqx577qm2p8"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Crate for mimicking simd crate on stable Rust")
    (description
     "Crate for mimicking simd crate on stable Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-failure-0.1
  (package
    (name "rust-failure")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0js6i6mb42q1g6q3csfbmi6q40s64k96705xbim0d8zg44j9qlmq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-failure-derive" ,rust-failure-derive-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Experimental error handling abstraction")
    (description
     "Experimental error handling abstraction.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-failure-derive-0.1
  (package
    (name "rust-failure-derive")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure_derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cfjz0c9szqpxn43b2r722p6m3swzxj7aj6xhqw23ml7h8y762h3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-synstructure" ,rust-synstructure-0.12))
       #:cargo-development-inputs
       (("rust-failure" ,rust-failure-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Derives for the failure crate")
    (description "Derives for the failure crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fallible-iterator-0.2
  (package
    (name "rust-fallible-iterator")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fallible-iterator" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1xq759lsr8gqss7hva42azn3whgrbrs2sd9xpn92c5ickxm1fhs4"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-fallible-iterator")
    (synopsis "Fallible iterator traits")
    (description "If the @code{std} or @code{alloc} features are enabled, this
crate provides implementations for @code{Box}, @code{Vec}, @code{BTreeMap}, and
@code{BTreeSet}.  If the @code{std} feature is enabled, this crate additionally
provides implementations for @code{HashMap} and @code{HashSet}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-fallible-iterator-0.1
  (package
    (inherit rust-fallible-iterator-0.2)
    (name "rust-fallible-iterator")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bpp2812lxm9fjv082dsy70ggsfg40nhqva7nxr5dp0j9091fwpb"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-fallible-streaming-iterator-0.1
  (package
    (name "rust-fallible-streaming-iterator")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-streaming-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nj6j26p71bjy8h42x6jahx1hn0ng6mc2miwpgwnp8vnwqf4jq3k"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/fallible-streaming-iterator")
    (synopsis "Fallible streaming iteration")
    (description "Fallible streaming iteration")
    (license (list license:expat license:asl2.0))))

(define-public rust-fancy-regex-0.3
  (package
    (name "rust-fancy-regex")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "051bnj890xrvhslppdzw6n956xfjg0wr2ixvhy336d2japvap4df"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-regex" ,rust-regex-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.7))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-version-requirements
           (lambda _
             (substitute* "Cargo.toml"
               (("0.3.0") ,(package-version rust-criterion-0.3)))))
         ;; XXX: Remove Oniguruma-related tests since Guix does not provide
         ;; the library yet.
         (add-after 'unpack 'remove-oniguruma-tests
           (lambda _
             (delete-file-recursively "tests/oniguruma")
             (delete-file "tests/oniguruma.rs"))))))
    (home-page "https://github.com/fancy-regex/fancy-regex")
    (synopsis "Implementation of regexes with a rich set of features")
    (description
     "This package is a Rust library for compiling and matching regular
expressions.  It uses a hybrid regex implementation designed to support
a relatively rich set of features.  In particular, it uses backtracking to
implement features such as look-around and backtracking, which are not
supported in purely NFA-based implementations.")
    (license license:expat)))

(define-public rust-fastrand-1
  (package
    (name "rust-fastrand")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastrand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qvz1i7g5mb2hcsaawrvxx88b8vwrsr85qr98ffmrkj5fh2sypya"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-instant" ,rust-instant-0.1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/stjepang/fastrand")
    (synopsis "Simple and fast random number generator")
    (description
     "This package provides a simple and fast random number generator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-femme-2
  (package
    (name "rust-femme")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d7h1lzbcrqcn8v5l6m7i15lkbbaaz394l6vavbr8nhs757s5w9a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-kv-log-macro" ,rust-kv-log-macro-1))))
    (home-page "https://github.com/lrlna/femme")
    (synopsis "Pretty-printer and @code{ndjson} logger for @code{log} crate")
    (description
     "This package provides a pretty-printer and @code{ndjson} logger for
@code{log} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-femme-1
  (package
    (inherit rust-femme-2)
    (name "rust-femme")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0spf66m22dvnz6x077znybk906lh4p5z30nh8c37mad2c3dc56jd"))))
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-async-log" ,rust-async-log-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-console" ,rust-console-0.7)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))))))

(define-public rust-fern-0.6
  (package
    (name "rust-fern")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fern" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rghkbmpm7ckchd2fr2ifahprc7ll3qs0fbwsspsgj6cy0h4i6lc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-colored" ,rust-colored-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-reopen" ,rust-reopen-0.3)
        ("rust-syslog" ,rust-syslog-3)
        ("rust-syslog" ,rust-syslog-4))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-clap" ,rust-clap-2)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/daboross/fern")
    (synopsis "Simple, efficient logging")
    (description
     "This package provides a simple, efficient logging system for Rust.")
    (license license:expat)))

(define-public rust-fern-0.5
  (package
    (inherit rust-fern-0.6)
    (name "rust-fern")
    (version "0.5.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fern" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1anslk0hx9an4ypcaxqff080hgbcxm7ji7d4qf4f6qx1mkav16p6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-reopen" ,rust-reopen-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-colored" ,rust-colored-1)
        ("rust-syslog" ,rust-syslog-3)
        ("rust-syslog" ,rust-syslog-4))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-filesize-0.2
  (package
    (name "rust-filesize")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filesize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvx4dfnara3a2dnhb9ci5bmm1m8s44h9l61s5djwkjx87i43mqj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Freaky/rust-filesize")
    (synopsis "Find the physical space used by a file")
    (description
     "@code{filesize} abstracts platform-specific methods of determining the
real space used by files, taking into account file system compression and
sparse files.")
    (license license:expat)))

(define-public rust-filetime-0.2
  (package
    (name "rust-filetime")
    (version "0.2.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "filetime" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0zfc90802dbw11bx6kmm8zw6r88k7glm4q6l8riqw35an3dd9xhz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/alexcrichton/filetime")
    (synopsis "Platform-agnostic accessors of timestamps in File metadata")
    (description
     "This library contains a helper library for inspecting and setting the
various timestamps of files in Rust.  This library takes into account
cross-platform differences in terms of where the timestamps are located, what
they are called, and how to convert them into a platform-independent
representation.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-findshlibs-0.5
  (package
    (name "rust-findshlibs")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "findshlibs" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1n2vagn0q5yim32hxkwi1cjgp3yn1dm45p7z8nw6lapywihhs9mi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/gimli-rs/findshlibs")
    (synopsis "Find the set of shared libraries loaded in the current process")
    (description
     "Find the set of shared libraries loaded in the current process with a
cross platform API.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-fixed-1
  (package
    (name "rust-fixed")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixed" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0p0v4jjgbbvp91sl8rkfqb2hldaxbzv89mzwmp8753mlrfqwn185"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-az" ,rust-az-1)
        ("rust-half" ,rust-half-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4))))
    (home-page "https://gitlab.com/tspiteri/fixed")
    (synopsis "Rust fixed-point numbers")
    (description "This package provides fixed-point numbers in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixedbitset-0.2
  (package
    (name "rust-fixedbitset")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0kg03p777wc0dajd9pvlcnsyrwa8dhqwf0sd9r4dw0p82rs39arp"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/petgraph/fixedbitset")
    (synopsis "FixedBitSet is a simple bitset collection")
    (description "FixedBitSet is a simple bitset collection.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-fixedbitset-0.1
  (package
    (inherit rust-fixedbitset-0.2)
    (name "rust-fixedbitset")
    (version "0.1.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0czam11mi80dbyhf4rd4lz0ihcf7vkfchrdcrn45wbs0h40dxm46"))))))

(define-public rust-flame-0.2
  (package
    (name "rust-flame")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flame" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c5bmhyimzxch3pmh0w3z9n57saasgix4bmbbksr9vp1c5j71hhz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-thread-id" ,rust-thread-id-3))))
    (home-page "https://github.com/llogiq/flame")
    (synopsis "Profiling and flamegraph library")
    (description "A profiling and flamegraph library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-flamer-0.3
  (package
    (name "rust-flamer")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flamer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1b2d7jx80f3p7hqpgdi7wksaiq18k9w23p0cs2sxf7jbx2jx3bgj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Uses features not available in stable Rust release
       #:cargo-inputs
       (("rust-flame" ,rust-flame-0.2)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/llogiq/flamer")
    (synopsis "Macro to insert @code{flame::start_guard(_)}")
    (description
     "A procedural macro to insert @code{flame::start_guard(_)} calls.")
    (license license:asl2.0)))

(define-public rust-flate2-1
  (package
    (name "rust-flate2")
    (version "1.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flate2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hlb2zmn5ixrgr0i1qvrd3a7j4fpp002d0kddn2hm7hjj49z9zrc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-cloudflare-zlib-sys"
         ,rust-cloudflare-zlib-sys-0.2)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-miniz-sys" ,rust-miniz-sys-0.1)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.3)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-threadpool" ,rust-tokio-threadpool-0.1))))
    (home-page "https://github.com/alexcrichton/flate2-rs")
    (synopsis
     "Bindings to miniz.c for DEFLATE compression and decompression")
    (description
     "Bindings to miniz.c for DEFLATE compression and decompression exposed as
Reader/Writer streams.  Contains bindings for zlib, deflate, and gzip-based
streams.")
    (license (list license:expat license:asl2.0))))

(define-public rust-float-cmp-0.8
  (package
    (name "rust-float-cmp")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1i56hnzjn5pmrcm47fwkmfxiihk7wz5vvcgpb0kpfhzkqi57y9p1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/mikedilger/float-cmp")
    (synopsis "Floating point approximate comparison traits")
    (description
     "Floating point approximate comparison traits in Rust.")
    (license license:expat)))

(define-public rust-float-cmp-0.6
  (package
    (inherit rust-float-cmp-0.8)
    (name "rust-float-cmp")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0zb1lv3ga18vsnpjjdg87yazbzvmfwwllj3aiid8660rp3qw8qns"))))))

(define-public rust-float-cmp-0.5
  (package
    (inherit rust-float-cmp-0.6)
    (name "rust-float-cmp")
    (version "0.5.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03hmx3n48hjm0x1ig84n1j87kzp75lzr6cj1sgi6a6pykgn4n8km"))))))

(define-public rust-float-cmp-0.4
  (package
    (inherit rust-float-cmp-0.5)
    (name "rust-float-cmp")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-cmp" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0036jb8ry4h83n319jb20b5yvyfyq8mx8dkxnyjm22nq8fl8yjhk"))))))

(define-public rust-float-cmp-0.3
  (package
    (inherit rust-float-cmp-0.5)
    (name "rust-float-cmp")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "float-cmp" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1c0hmj46xma5aysz0qb49padhc26aw875whx6q6rglsj5dqpds1b"))))
    (arguments
     `(#:cargo-inputs (("rust-num" ,rust-num-0.1))))))

(define-public rust-float-ord-0.2
  (package
    (name "rust-float-ord")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "float-ord" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kin50365sr3spnbscq43lksymybi99ai9rkqdw90m6vixhlibbv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/notriddle/rust-float-ord")
    (synopsis "Total ordering for floating-point numbers")
    (description
     "This package provides a total ordering for floating-point numbers.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fluid-0.4
  (package
    (name "rust-fluid")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fluid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04qgdc4lx934158icx9rvs0v6lyvirmb0brllvz38hj9fsaqfbsp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-colored" ,rust-colored-1)
        ("rust-fluid-attributes" ,rust-fluid-attributes-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://crates.io/crates/fluid")
    (synopsis "Human readable test library")
    (description "This package provides a human readable test library.")
    (license license:asl2.0)))

(define-public rust-fluid-attributes-0.4
  (package
    (name "rust-fluid-attributes")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fluid_attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1i67vcas0gr64bc8spprlfp7m7msv1jyspghgq1q8f0qrnvy8px8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15)
        ("rust-uuid" ,rust-uuid-0.7))))
    (home-page "https://gitlab.com/Boiethios/fluid-rs/wikis")
    (synopsis "Proc macro attributes for the fluid crate")
    (description "This package provides proc macro attributes for the fluid
crate.")
    (license license:asl2.0)))

(define-public rust-flume-0.10
  (package
    (name "rust-flume")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flume" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14dvj6d2r6vgsy3adv4lncbddjwc59rgl0rcwc1kdnsmqkh7lwhy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true    ;XXX: remove when rust-async-std-1 is packaged
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-nanorand" ,rust-nanorand-0.5)
        ("rust-spinning-top" ,rust-spinning-top-0.2))
       #:cargo-development-inputs
       (;("rust-async-std" ,rust-async-std-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-waker-fn" ,rust-waker-fn-1))))
    (home-page "https://github.com/zesterer/flume")
    (synopsis "Fast multi-producer channel")
    (description
     "This package provides a fast multi-producer channel.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-flume-0.9
  (package
    (inherit rust-flume-0.10)
    (name "rust-flume")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flume" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ck1w9881848xjjk93nxqsvnxfp4xsaysxxn23a210bg2amsvsqv"))))
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-nanorand" ,rust-nanorand-0.4)
        ("rust-spinning-top" ,rust-spinning-top-0.2))))))

(define-public rust-fnv-1
  (package
    (name "rust-fnv")
    (version "1.0.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fnv" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1ww56bi1r5b8id3ns9j3qxbi7w5h005rzhiryy0zi9h97raqbb9g"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/servo/rust-fnv")
    (synopsis "Implementation of the Fowler-Noll-Vo hash function")
    (description "The @code{fnv} hash function is a custom @code{Hasher}
implementation that is more efficient for smaller hash keys.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-font-kit-0.4
  (package
    (name "rust-font-kit")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "font-kit" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1fmg1jmqdvsjxjbyz8chpx1mhp544mwq128ns1shhrha5a6zzdqp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lyon-path" ,rust-lyon-path-0.14)
        ("rust-core-graphics" ,rust-core-graphics-0.17)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-euclid" ,rust-euclid-0.20)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-servo-fontconfig"
         ,rust-servo-fontconfig-0.4)
        ("rust-freetype" ,rust-freetype-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-core-foundation"
         ,rust-core-foundation-0.6)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-dwrote" ,rust-dwrote-0.9)
        ("rust-dirs" ,rust-dirs-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-core-text" ,rust-core-text-13)
        ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://github.com/servo/font-kit")
    (synopsis "Cross-platform font loading library")
    (description
     "This package provides a cross-platform font loading library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-0.5
  (package
    (name "rust-foreign-types")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rfr2zfxnx9rz3292z5nyk8qs2iirznn5ff3rd4vgdwza6mdjdyp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-foreign-types-macros" ,rust-foreign-types-macros-0.2)
        ("rust-foreign-types-shared" ,rust-foreign-types-shared-0.3))))
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Framework for Rust wrappers over C APIs")
    (description
     "This package provides a framework for Rust wrappers over C APIs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-0.3
  (package
    (inherit rust-foreign-types-0.5)
    (name "rust-foreign-types")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cgk0vyd7r45cj769jym4a6s7vwshvd0z4bqrb92q1fwibmkkwzn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-foreign-types-macros" ,rust-foreign-types-macros-0.1)
        ("rust-foreign-types-shared" ,rust-foreign-types-shared-0.1))))))

(define-public rust-foreign-types-macros-0.2
  (package
    (name "rust-foreign-types-macros")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0x71sdffjfb123l2jn5vhz0ni09b4rdq3h3gpczd1dj1g5qlr2yv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Internal crate used by foreign-types")
    (description
     "This package is an internal crate used by foreign-types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-macros-0.1
  (package
    (inherit rust-foreign-types-macros-0.2)
    (name "rust-foreign-types-macros")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bh6z5rwdhfm987idal8r0ha5svz1li7md5l1g2a5966gya1jns0"))))))

(define-public rust-foreign-types-shared-0.3
  (package
    (name "rust-foreign-types-shared")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mg85r21bxg2i97zl3q8l3cviqz4wcbwziz875wlja3zpcrwz13n"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/foreign-types")
    (synopsis "Internal crate used by foreign-types")
    (description
     "An internal crate used by foreign-types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-foreign-types-shared-0.2
  (package
    (inherit rust-foreign-types-shared-0.3)
    (name "rust-foreign-types-shared")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "foreign-types-shared" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0kanxlif1vp0ffh2r9l610jqbkmb3183yqykxq1z5w1vay2rn7y6"))))))

(define-public rust-foreign-types-shared-0.1
  (package
    (inherit rust-foreign-types-shared-0.2)
    (name "rust-foreign-types-shared")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "foreign-types-shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jxgzd04ra4imjv8jgkmdq59kj8fsz6w4zxsbmlai34h26225c00"))))))

(define-public rust-form-urlencoded-1
  (package
    (name "rust-form-urlencoded")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "form_urlencoded" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "005yi1319k5bz8g5ylbdiakq5jp5jh90yy6k357zm11fr4aqvrpc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-matches" ,rust-matches-0.1)
        ("rust-percent-encoding" ,rust-percent-encoding-2))))
    (home-page "https://github.com/servo/rust-url")
    (synopsis "Parser and serializer for the urlencoded syntax")
    (description
     "Parser and serializer for the application/x-www-form-urlencoded
syntax, as used by HTML forms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fragile-0.3
  (package
    (name "rust-fragile")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fragile" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1yf2hmkw52x2dva3c9km1x8c2z5kwby7qqn8kz5ms3gs480i9y05"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mitsuhiko/rust-fragile")
    (synopsis "Wrapper types for sending non-send values to other threads")
    (description "This package provides wrapper types for sending non-send
values to other threads.")
    (license license:asl2.0)))

(define-public rust-freetype-0.4
  (package
    (name "rust-freetype")
    (version "0.4.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "freetype" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0a70x03n68997f08bi3n47q9wyi3pv5s9v4rjc79sihb84mnp4hi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-servo-freetype-sys" ,rust-servo-freetype-sys-4))))
    (home-page "https://github.com/servo/rust-freetype")
    (synopsis "Bindings for Freetype used by Servo")
    (description
     "Bindings for Freetype used by Servo.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-freetype-rs-0.26
  (package
    (name "rust-freetype-rs")
    (version "0.26.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yzmbd73hlblbns0dqkcwfj54l97hx3yb0lqpda8rhm5s34xxskl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-freetype-sys" ,rust-freetype-sys-0.13)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/PistonDevelopers/freetype-rs")
    (synopsis "Bindings for FreeType font library")
    (description "This package provides bindings for FreeType font library.")
    (license license:expat)))

(define-public rust-freetype-rs-0.23
  (package
    (inherit rust-freetype-rs-0.26)
    (name "rust-freetype-rs")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06yn6l44wad0h0i4nzs5jfq64zgf89xr01fy1w22i90j22ilnkmd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-freetype-sys" ,rust-freetype-sys-0.9)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-unicode-normalization" ,rust-unicode-normalization-0.1))))
    (inputs
     `(("freetype" ,freetype)
       ("zlib" ,zlib)))))

(define-public rust-freetype-sys-0.13
  (package
    (name "rust-freetype-sys")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06kkds31s6b1i39dyanwmzbnic7laia1kk3gfvx8sqncq08l0zd3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cmake" ,rust-cmake-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/PistonDevelopers/freetype-sys")
    (synopsis "Low level binding for FreeType font library")
    (description
     "This package provides low level binding for FreeType font library.")
    (license license:expat)))

(define-public rust-freetype-sys-0.9
  (package
    (inherit rust-freetype-sys-0.13)
    (name "rust-freetype-sys")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "freetype-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1i309xc6gcsgdfiim3j5f0sk08imr4frlzfa185iaxqciysqgikx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (inputs
     `(("freetype" ,freetype)
       ("zlib" ,zlib)))))

(define-public rust-fs2-0.4
  (package
    (name "rust-fs2")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04v2hwk7035c088f19mfl5b1lz84gnvv2hv6m935n0hmirszqr4m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; "#![feature] may not be used on stable release channel"
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/danburkert/fs2-rs")
    (synopsis "Cross-platform file locks and file duplication")
    (description "This package provides cross-platform file locks and file
duplication.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fs-extra-1
  (package
    (name "rust-fs-extra")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs_extra" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32 "151k6dr35mhq5d8pc8krhw55ajhkyiv0pm14s7zzlc5bc9fp28i0"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/webdesus/fs_extra")
    (synopsis "Extra file system methods")
    (description "Expanding opportunities standard library @code{std::fs} and
@code{std::io}.  Recursively copy folders with recept information about
process and much more.")
    (license license:expat)))

(define-public rust-fs2-0.2
  (package
    (name "rust-fs2")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fs2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vsih93cvds3x6f3w9bc5rnkyv8haix1px4jpcqvjyd9l7ji9m5w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/danburkert/fs2-rs")
    (synopsis "File locks and file duplication")
    (description
     "This package provides cross-platform file locks and file duplication.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fsevent-0.4
  (package
    (name "rust-fsevent")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fsevent" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1djxnc2fmv265xqf1iyfz56smh13v9r1p0w9125wjg6k3fyx3dss"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; only available on macOS
       #:cargo-inputs
        (("rust-bitflags" ,rust-bitflags-1)
         ("rust-fsevent-sys" ,rust-fsevent-sys-2))
        #:cargo-development-inputs
        (("rust-tempdir" ,rust-tempdir-0.3)
         ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/octplane/fsevent-rust")
    (synopsis "Rust bindings to the fsevent-sys macOS API")
    (description
     "This package provides Rust bindings to the @code{fsevent-sys} macOS API
for file changes notifications")
    (license license:expat)))

(define-public rust-fsevent-sys-2
  (package
    (name "rust-fsevent-sys")
    (version "2.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fsevent-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18246vxk7rqn52m0sfrhivxq802i34p2wqqx5zsa0pamjj5086zl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; only available on macOS
       #:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/octplane/fsevent-rust/tree/master/fsevent-sys")
    (synopsis "Rust bindings to the fsevent macOS API")
    (description "This package provides Rust bindings to the @code{fsevent}
macOS API for file changes notifications")
    (license license:expat)))

(define-public rust-fst-0.4
  (package
    (name "rust-fst")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fst" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ybmdzkknhv1wx6ws86iyixfyzc04l4nm71b9va7953r1m3i6z1z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-utf8-ranges" ,rust-utf8-ranges-1))))
    (home-page "https://github.com/BurntSushi/fst")
    (synopsis "Represent sets or maps of large numbers of strings.")
    (description
     "Use finite state transducers to compactly represent sets or maps of many
strings (> 1 billion is possible).")
    (license (list license:unlicense license:expat))))

(define-public rust-fuchsia-cprng-0.1
  (package
    (name "rust-fuchsia-cprng")
    (version "0.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-cprng" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page
     "https://fuchsia.googlesource.com/fuchsia/+/master/garnet/public/rust/fuchsia-cprng")
    (synopsis "Fuchsia cryptographically secure pseudorandom number generator")
    (description "Rust crate for the Fuchsia cryptographically secure
pseudorandom number generator")
    (license license:bsd-3)))

(define-public rust-fuchsia-zircon-0.3
  (package
    (name "rust-fuchsia-zircon")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-zircon" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "10jxc5ks1x06gpd0xg51kcjrxr35nj6qhx2zlc5n7bmskv3675rf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-fuchsia-zircon-sys" ,rust-fuchsia-zircon-sys-0.3))))
    (home-page "https://fuchsia.googlesource.com/garnet/")
    (synopsis "Rust bindings for the Zircon kernel")
    (description "Rust bindings for the Zircon kernel.")
    (license license:bsd-3)))

(define-public rust-fuchsia-zircon-sys-0.3
  (package
    (name "rust-fuchsia-zircon-sys")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuchsia-zircon-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "19zp2085qsyq2bh1gvcxq1lb8w6v6jj9kbdkhpdjrl95fypakjix"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://fuchsia.googlesource.com/garnet/")
    (synopsis "Low-level Rust bindings for the Zircon kernel")
    (description "Low-level Rust bindings for the Zircon kernel.")
    (license license:bsd-3)))

(define-public rust-funty-1
  (package
    (name "rust-funty")
    (version "1.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "funty" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19wx3p3jmv863y0mjb56sr4qf1kvqhl3fsyslkd92zli0p8lrlzy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://github.com/myrrlyn/funty")
    (synopsis "Trait generalization over the primitive types")
    (description
     "Prior to 1.0, Rust had traits for the numeric primitive types to permit
code to generalize over which specific type it accepted. This was never
stabilized, and eventually removed.  This library reïnstates these traits.")
    (license license:expat)))

(define-public rust-futf-0.1
  (package
    (name "rust-futf")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futf" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fxc18bnabird5jl941nsd6d25vq8cn8barmz4d30dlkzbiir73w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-mac" ,rust-mac-0.1)
        ("rust-new-debug-unreachable" ,rust-new-debug-unreachable-1))))
    (home-page "https://github.com/servo/futf")
    (synopsis "Handling fragments of UTF-8")
    (description "Handling fragments of UTF-8.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-futures-0.3
  (package
    (name "rust-futures")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l7i1hcag46k5v34cbn5dk45gwxn5yy5rxcvmbaxhi02lnhm546s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Rust implementation of futures and streams")
    (description
     "This package is a Rust implementation of futures and streams featuring
zero allocations, composability, and iterator-like interfaces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-0.1
  (package
    (name "rust-futures")
    (version "0.1.29")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1vq3cw37knnd0afw3rcjzh71i2l01v5m4ysinrrqdvnn2ql0z60v"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis "Implementation of zero-cost futures in Rust")
    (description "An implementation of @code{futures} and @code{streams}
featuring zero allocations, composability, and iterator-like interfaces.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-channel-0.3
  (package
    (name "rust-futures-channel")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-channel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ihq3a3yc6ial3sw536q75hrhixq22xk6wn5qzpnxazgqxz1plzj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3))))
    (home-page  "https://rust-lang.github.io/futures-rs")
    (synopsis "Channels for asynchronous communication using @code{futures-rs}")
    (description
     "This package provides channels for asynchronous communication using
@code{futures-rs}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-channel-preview-0.3
  (package
    (name "rust-futures-channel-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-channel-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fi6bi4lpyxjigy11y5sjg6wlc8nc71vbpmxz31c3aagjvgz9rfm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3))))
    (home-page "https://rust-lang.github.io/futures-rs/")
    (synopsis
     "Channels for asynchronous communication using futures-rs")
    (description
     "Channels for asynchronous communication using futures-rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-codec-0.4
  (package
    (name "rust-futures-codec")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures_codec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nzadpxhdxdlnlk2f0gfn0qbifqc3pbnzm10v4z04x8ciczxcm6f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-cbor" ,rust-serde-cbor-0.11)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/matthunz/futures-codec")
    (synopsis
     "Utilities for encoding and decoding frames using @code{async/await}")
    (description
     "This package provides utilities for encoding and decoding frames using
@code{async/await}.")
    (license license:expat)))

(define-public rust-futures-core-0.3
  (package
    (name "rust-futures-core")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0r8ag0mkxx9cd74yrccjk31lph4gr6lhgb9di6rx39wdvrfi9rbr"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Core traits and types in for the @code{futures} library")
    (description "This package provides the core traits and types in for the
@code{futures} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-core-preview-0.3
  (package
    (name "rust-futures-core-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-core-preview" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "02n66jkjhpy210dv24pz0j30lvyin5kzlrb50p1j7x8yzdin4nxk"))))
    (build-system cargo-build-system)
    (arguments '(#:tests? #f))
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis "Core traits and types in for the @code{futures} library.")
    (description "This crate provides the core traits and types in for the
@code{futures} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-cpupool-0.1
  (package
    (name "rust-futures-cpupool")
    (version "0.1.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-cpupool" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1r32456gpblzfvnkf60545v8acqk7gh5zhyhi1jn669k9gicv45b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://github.com/rust-lang-nursery/futures-rs")
    (synopsis "Implementation of thread pools which hand out futures")
    (description
     "An implementation of thread pools which hand out futures to the results of
the computation on the threads themselves.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-executor-0.3
  (package
    (name "rust-futures-executor")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-executor" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ffr1zclhz60ql49n2pj44jhhk22yah41xwlpyb30jws03f9zrg9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "Executors for asynchronous tasks based on the @code{futures-rs} library")
    (description
     "This package provides executors for asynchronous tasks based on the
@code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-executor-preview-0.3
  (package
    (name "rust-futures-executor-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-executor-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "161yv7wwha60mdzj1id47kh8ylnhcnv7blgwidg8xs4zpn46w8vm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis
     "Executors for asynchronous tasks based on futures-rs")
    (description
     "Executors for asynchronous tasks based on the futures-rs
library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-intrusive-0.3
  (package
    (name "rust-futures-intrusive")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-intrusive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00qpir3q6j7blwpnpffj7ypf1z8wc87ldn62qr7sapymgg82j5dw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;XXX: need rust-async-std-1
       #:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lock-api" ,rust-lock-api-0.3)
        ("rust-parking-lot" ,rust-parking-lot-0.10))))
    (home-page "https://github.com/Matthias247/futures-intrusive")
    (synopsis "Futures based on intrusive data structures")
    (description
     "This crate provides a variety of Futures-based and
@code{async/await} compatible types that are based on the idea of
intrusive collections.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-io-0.3
  (package
    (name "rust-futures-io")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0005hz30pdxlbdamhd0imixmxcjpwrfxxr27kljxh6i84lshbgi8"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "@code{AsyncRead} and @code{AsyncWrite} traits for the @code{futures-rs}
library")
    (description
     "This package provides the @code{AsyncRead} and @code{AsyncWrite} traits
for the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-io-preview-0.3
  (package
    (name "rust-futures-io-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-io-preview" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1npb04xbn2gw5rjllz88cb88fql44xxfkgcidjjj26fva3j4m4gl"))))
    (build-system cargo-build-system)
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis "Async read and write traits for the futures library")
    (description "This crate provides the @code{AsyncRead} and
@code{AsyncWrite} traits for the @code{futures-rs} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-join-macro-preview-0.3
  (package
    (name "rust-futures-join-macro-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-join-macro-preview" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1smwaja466yjh5adlhgggfk9k942sy4702n46scxkrwcnkk61qjr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs")
    (synopsis "Definition of the `join!` macro and the `try_join!` macro")
    (description
     "This package provides the definition of the @code{join!} macro and the
@code{try_join!} macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-lite-1
  (package
    (name "rust-futures-lite")
    (version "1.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ywmyvpy4f348jri8rxhpj59a7bvy12pspm59x5207fys061sj5l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-waker-fn" ,rust-waker-fn-1))
       #:cargo-development-inputs
       (("rust-spin-on" ,rust-spin-on-0.1))))
    (home-page "https://github.com/stjepang/futures-lite")
    (synopsis "Futures, streams, and async I/O combinators")
    (description
     "This crate is a subset of @code{futures} that compiles an order of
magnitude faster, fixes minor warts in its API, fills in some obvious gaps,
and removes almost all unsafe code from it.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-futures-lite-0.1
  (package
    (inherit rust-futures-lite-1)
    (name "rust-futures-lite")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lnflz8ysp0vlq1sxzz1sw9cq7s33lh12cm9rc68z04v29q9k6cp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-futures-macro-0.3
  (package
    (name "rust-futures-macro")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pgyb219ybh3fj3ig0h1c2b7k4cqldy95ifdpnd9yb9jvmdd51y2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "@code{futures-rs} procedural macro implementations")
    (description
     "This package provides the @code{futures-rs} procedural macro
implementations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-preview-0.3
  (package
    (name "rust-futures-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-preview" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vnp63aicm9vgapn4hm45ag9lrsf9f3bma3mzz3abbb708mcw79v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-executor-preview" ,rust-futures-executor-preview-0.3)
        ("rust-futures-io-preview" ,rust-futures-io-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3))
       #:cargo-development-inputs
       (("rust-futures-join-macro-preview"
         ,rust-futures-join-macro-preview-0.3))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs")
    (synopsis "Implementation of futures and streams")
    (description
     "This package provides an implementation of futures and streams featuring
zero allocations, composability, and iterator-like interfaces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-select-macro-preview-0.3
  (package
    (name "rust-futures-select-macro-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-select-macro-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xsq55cf2rnf7k6r04q8wynmxiy9svm3pi840vjva47bc0sy8anz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis
     "Handle the first Future to complete")
    (description
     "This package provides the @code{select!} macro for waiting on multiple
different @code{Future}s at once and handling the first one to complete.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-sink-0.3
  (package
    (name "rust-futures-sink")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-sink" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mj22d4w6digh7wfp6jkr5fdcl9r138q41fxzm1yg8mx568cdxfa"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Asynchronous @code{Sink} trait for the @code{futures-rs} library")
    (description "This package provides the asynchronous @code{Sink} trait for
the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-sink-preview-0.3
  (package
    (name "rust-futures-sink-preview")
    (version "0.3.0-alpha.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "futures-sink-preview" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1v7y5qvgvl0d6hd9s4k7bd5qrj2gdlrs5yfl22v5pxv9dgpliwc6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3))))
    (home-page "https://rust-lang-nursery.github.io/futures-rs/")
    (synopsis  "Asynchronous `Sink` trait for the futures-rs library")
    (description
     "This package provides the asynchronous @code{Sink} trait for the
futures-rs library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-futures-task-0.3
  (package
    (name "rust-futures-task")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11ldlpl7mis5crys731dj7s7npgigdgrzdm7mi2y86m8ivmhgphk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Tools for working with tasks")
    (description "This package provides tools for working with tasks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-test-0.3
  (package
    (name "rust-futures-test")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v9r2mmgdbm0x4gppd5jzf4rss7439ivkqwi604m0r2il3zap6ci"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis "Test components built off futures-rs")
    (description "This package provides common utilities for testing
components built off futures-rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-timer-3
  (package
    (name "rust-futures-timer")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b5v7lk9838ix6jdcrainsyrh7xrf24pwm61dp13907qkn806jz6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gloo-timers" ,rust-gloo-timers-0.2)
        ("rust-send-wrapper" ,rust-send-wrapper-0.4))))
    (home-page "https://github.com/async-rs/futures-timer")
    (synopsis "Timeouts for futures")
    (description "This package is a general purpose crate for working with
timeouts and delays with futures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-timer-1
  (package
    (inherit rust-futures-timer-3)
    (name "rust-futures-timer")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0idyz2k72jbl9z0wj48n15wjv6qgxgsgvs6k8lrhkzr9jj728ikr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))))

(define-public rust-futures-timer-0.3
  (package
    (inherit rust-futures-timer-3)
    (name "rust-futures-timer")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l35r7nm8p43j0adkhybnwxzbjiqy0b00kgccjy3l513m9abb7lg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures-preview" ,rust-futures-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))))))

(define-public rust-futures-timer-0.1
  (package
    (inherit rust-futures-timer-1)
    (name "rust-futures-timer")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-timer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hw0nlyrq5an6l6y8md1rg6r380zrddvmh9cg0h64xfwnvlxzkm5"))))
    (arguments
     `(#:cargo-inputs (("rust-futures" ,rust-futures-0.1))))))

(define-public rust-futures-util-0.3
  (package
    (name "rust-futures-util")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-util" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jv25s07igmqavigdfzr02yw6j1q0vg8pw2p2vmgvcx4yb88qak3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-macro" ,rust-futures-macro-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-task" ,rust-futures-task-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro-nested" ,rust-proc-macro-nested-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))
    (home-page "https://rust-lang.github.io/futures-rs")
    (synopsis
     "Common utilities and extension traits for the @code{futures-rs} library")
    (description "This package provides common utilities and extension traits
for the @code{futures-rs} library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-futures-util-preview-0.3
  (package
    (name "rust-futures-util-preview")
    (version "0.3.0-alpha.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "futures-util-preview" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "138f8wy0vqy2gsgk28kldbqnrdcgwfv9f9xx6rwzkr8p7iinisaw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-io-preview" ,rust-futures-io-preview-0.3)
        ("rust-futures-select-macro-preview"
         ,rust-futures-select-macro-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro-nested" ,rust-proc-macro-nested-0.1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-futures-join-macro-preview"
         ,rust-futures-join-macro-preview-0.3))))
    (home-page "https://github.com/rust-lang/futures-rs")
    (synopsis "Utilities and extension traits for futures-rs library")
    (description
     "This package provides common utilities and extension traits for the
futures-rs library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fuzzy-matcher-0.3
  (package
    (name "rust-fuzzy-matcher")
    (version "0.3.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fuzzy-matcher" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "153csv8rsk2vxagb68kpmiknvdd3bzqj03x805khckck28rllqal"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-thread-local" ,rust-thread-local-1))
       #:cargo-development-inputs
       (("rust-termion" ,rust-termion-1))))
    (home-page "https://github.com/lotabout/fuzzy-matcher")
    (synopsis "Fuzzy Matching Library")
    (description "This package provides a fuzzy matching library in Rust.")
    (license license:expat)))

(define-public rust-fxhash-0.2
  (package
    (name "rust-fxhash")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fxhash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "037mb9ichariqi45xm6mz0b11pa92gj38ba0409z3iz239sns6y3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-seahash" ,rust-seahash-3))))
    (home-page "https://github.com/cbreeden/fxhash")
    (synopsis "Hashing algorithm from hasher used in FireFox and Rustc")
    (description
     "This package provides a fast, non-secure, hashing algorithm
derived from an internal hasher used in FireFox and Rustc.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-gag-0.1
  (package
    (name "rust-gag")
    (version "0.1.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gag" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d874gmyhyqbb78k6mkk9p0sd21n5vwd5w88m2nmzp3m6bsvkh4c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/Stebalien/gag-rs")
    (synopsis "Gag, redirect, or hold stdout/stderr output")
    (description
     "This packages gags, redirects, or holds stdout/stderr output.")
    (license license:expat)))

(define-public rust-galil-seiferas-0.1
  (package
    (name "rust-galil-seiferas")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "galil-seiferas" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nhxks4qv1q6wrclxxbdch8k9h66i5ccdy3zn3913ym3zmfc4jkr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-defmac" ,rust-defmac-0.1)
        ("rust-unchecked-index" ,rust-unchecked-index-0.2))))
    (home-page "https://github.com/bluss/galil-seiferas")
    (synopsis "General string search in constant space, linear time")
    (description
     "This package provides general string search in constant space, linear
time, for nonorderable alphabets.")
    (license (list license:expat license:asl2.0))))

(define-public rust-gcc-0.3
  (package
    (name "rust-gcc")
    (version "0.3.55")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gcc" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hng1sajn4r67hndvhjysswz8niayjwvcj42zphpxzhbz89kjpwg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; gcc-test folder missing from release tarball.
       #:cargo-inputs
       (("rust-rayon" ,rust-rayon-0.8))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/alexcrichton/cc-rs")
    (synopsis "Library to compile C/C++ code into a Rust library/application")
    (description
     "This package provides a build-time dependency for Cargo build scripts to
assist in invoking the native C compiler to compile native C code into a static
archive to be linked into Rustcode.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-gdi32-sys-0.2
  (package
    (name "rust-gdi32-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gdi32-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0605d4ngjsspghwjv4jicajich1gnl0aik9f880ajjzjixd524h9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.2)
        ("rust-winapi-build" ,rust-winapi-build-0.1))))
    (home-page "https://github.com/retep998/winapi-rs")
    (synopsis "Function definitions for the Windows API library gdi32")
    (description "This package contains function definitions for the Windows
API library @code{gdi32}.")
    (license license:expat)))

(define-public rust-generator-0.6
  (package
    (name "rust-generator")
    (version "0.6.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0f07mwkarwrqrykhkzqpvfnd5crz20dd8l24psn01kiqzc71dana"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-cc" ,rust-cc-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))
    (home-page "https://github.com/Xudong-Huang/generator-rs")
    (synopsis "Stackfull Generator Library in Rust")
    (description "Stackfull Generator Library in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-generic-array-0.14
  (package
    (name "rust-generic-array")
    (version "0.14.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "generic-array" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "107r1fpm8zcab3lzci4x9par6ik8bra390c60rhxvnmz7dgnlx5c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1)
        ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/fizyk20/generic-array.git")
    (synopsis
     "Generic types implementing functionality of arrays")
    (description
     "Generic types implementing functionality of arrays.")
    (license license:expat)))

(define-public rust-generic-array-0.13
  (package
    (inherit rust-generic-array-0.14)
    (name "rust-generic-array")
    (version "0.13.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kddwxpd58y807y1r3lijg7sw3gxm6nczl6wp57gamhv6mhygl8f"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-generic-array-0.12
  (package
    (inherit rust-generic-array-0.13)
    (name "rust-generic-array")
    (version "0.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v5jg7djicq34nbiv1dwaki71gkny002wyy9qfn3y0hfmrs053y6"))))))

(define-public rust-generic-array-0.9
  (package
    (inherit rust-generic-array-0.14)
    (name "rust-generic-array")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17avshwh41d1w9p75mw2k6pflmbaj9ra7svxplmhqmv76xlca9gg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))))))

(define-public rust-generic-array-0.8
  (package
    (inherit rust-generic-array-0.12)
    (name "rust-generic-array")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "generic-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1wi6rlx3dmrvl26yxm4z5n68kyj2ikk4nllk1kazw2ik9scnkszw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nodrop" ,rust-nodrop-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-genmesh-0.6
  (package
    (name "rust-genmesh")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "genmesh" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17qybydyblf3hjiw7mq181jpi4vrbb8dmsj0wi347r8k0m354g89"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cgmath" ,rust-cgmath-0.16)
        ("rust-mint" ,rust-mint-0.5))))
    (home-page "https://github.com/gfx-rs/genmesh")
    (synopsis "Package for generating 3D meshes")
    (description
     "This package provides a package for generating 3D meshes/")
    (license license:asl2.0)))

(define-public rust-geo-0.4
  (package
    (name "rust-geo")
    (version "0.4.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "geo" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10mvrmi5xgpil6hxl6h3b0w4lvg7mxy04n3388ah0gwhcnc1whh3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/georust/geo")
    (synopsis "Geospatial primitives and algorithms")
    (description
     "This package provides geospatial primitives and algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-getch-0.2
  (package
    (name "rust-getch")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00in8q95qi8a5q3zn2zcaqp5avj79f5myd2a4zfdy2m24ycvbc5v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-termios" ,rust-termios-0.2))))
    (home-page "https://nest.pijul.com/pijul_org/getch")
    (synopsis "Portable implementation of getch")
    (description
     "This package provides a portable implementation of getch, using
@code{_getch} on Windows, and @code{termios} on Unix.")
    (license license:asl2.0)))

(define-public rust-getopts-0.2
  (package
    (name "rust-getopts")
    (version "0.2.21")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "getopts" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1mgb3qvivi26gs6ihqqhh8iyhp3vgxri6vwyrwg28w0xqzavznql"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-rustc-std-workspace-std" ,rust-rustc-std-workspace-std-1))
       #:cargo-development-inputs
       (("rust-log" ,rust-log-0.3))))
    (home-page "https://github.com/rust-lang/getopts")
    (synopsis "Rust library for option parsing for CLI utilities")
    (description "This library provides getopts-like option parsing.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-getrandom-0.2
  (package
    (name "rust-getrandom")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getrandom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x3clmvj5k2h9qv3ihbyif1rns3pf5y5n66f5jjyc5zr6v7jb07f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-wasi" ,rust-wasi-0.9)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/rust-random/getrandom")
    (synopsis "Retrieve random data from system source")
    (description
     "This package provides a small cross-platform library for
retrieving random data from system source.")
    (license (list license:expat license:asl2.0))))

(define-public rust-getrandom-0.1
  (package
    (inherit rust-getrandom-0.2)
    (name "rust-getrandom")
    (version "0.1.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getrandom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sq30li71h19rhnhs1h6576ja68insajx8wvh1nn088r8pc8vg3s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-wasi" ,rust-wasi-0.9)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))))

(define-public rust-getset-0.1
  (package
    (name "rust-getset")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "getset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "016590lxhlqga016z1qnavl0zavk59b97aix2zcd4wad3b02icr4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Hoverbear/getset")
    (synopsis "Getters and setters for Rust")
    (description
     "This package provides a procedural macro for generating the most basic
getters and setters on fields.")
    (license license:expat)))

(define-public rust-gettext-rs-0.5
  (package
    (name "rust-gettext-rs")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-rs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1qc9a63i54b9ad3jx951hn7xb6xf76c9f3hmi2cdy2m7rhczm58v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gettext-sys" ,rust-gettext-sys-0.19)
        ("rust-locale-config" ,rust-locale-config-0.3))))
    (inputs
     `(("gettext" ,gettext-minimal)))
    (home-page "https://github.com/Koka/gettext-rs")
    (synopsis "GNU Gettext FFI binding for Rust")
    (description "This package provides GNU Gettext FFI bindings for Rust.")
    (license license:expat)))

(define-public rust-gettext-rs-0.4
  (package
    (inherit rust-gettext-rs-0.5)
    (name "rust-gettext-rs")
    (version "0.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-rs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0z6fcsn1g3w9mlgfj6ln6qvqf8610w3zwvk6g062h657v114lifz"))))
    (arguments
     `(#:cargo-inputs
       (("rust-gettext-sys" ,rust-gettext-sys-0.19)
        ("rust-locale-config" ,rust-locale-config-0.2))))))

(define-public rust-gettext-sys-0.19
  (package
    (name "rust-gettext-sys")
    (version "0.19.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gettext-sys" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0lzi6ja81vc16mhcdmn3lw35120n9ijhvsy5dh5775mpbfxc8d70"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file "gettext-0.19.8.1.tar.xz") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1))))
    (inputs
     `(("gettext" ,gettext-minimal)))
    (home-page "https://github.com/Koka/gettext-rs")
    (synopsis "Gettext raw FFI bindings")
    (description "This package provides raw FFI bindings for GNU Gettext.")
    (license license:expat)))

(define-public rust-gfa-0.6
  (package
    (name "rust-gfa")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gfa" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ghmy4r0324s6vvmj9nmh326346nkwm7nybnpcpswnjvf02b85gw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/chfi/rs-gfa")
    (synopsis "Library for graphs in the GFA (Graphical Fragment Assembly) format")
    (description
     "This package provides a library for working with graphs in the
@acronym{GFA, Graphical Fragment Assembly} format.")
    (license license:expat)))

(define-public rust-ghash-0.3
  (package
    (name "rust-ghash")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ghash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c957q9sk1q93pqqfvhcmflfm1zvbr14aznfpm25kqd6i437zqnn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-polyval" ,rust-polyval-0.4)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-hex-literal" ,rust-hex-literal-0.1))))
    (home-page "https://github.com/RustCrypto/universal-hashes")
    (synopsis "Universal hash over GF(2^128)")
    (description "This package provides a universal hash over GF(2^128) useful
for constructing a Message Authentication Code (MAC), as in the AES-GCM
authenticated encryption cipher.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ghash-0.2
  (package
    (inherit rust-ghash-0.3)
    (name "rust-ghash")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ghash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lijv1y6qcysnxv45ny5fjvc4v9gmpggxlj6xa4l065737nk02cz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-polyval" ,rust-polyval-0.3)
        ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-gimli-0.23
  (package
    (name "rust-gimli")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gimli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1km657nwcrb0pnv7v0ldhgl9y8s889y2j9jckmws8k2i8bhkyl7n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/gimli-rs/gimli")
    (synopsis "Library for reading and writing the DWARF debugging format")
    (description
     "This package provides a library for reading and writing the DWARF
debugging format.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-gimli-0.20
  (package
    (inherit rust-gimli-0.23)
    (name "rust-gimli")
    (version "0.20.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "gimli" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0cz6wg1niwfqf0mk28igsdnsm92cs57cai9jpzdmvw6hma863pc1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-fallible-iterator"
         ,rust-fallible-iterator-0.2)
        ("rust-arrayvec" ,rust-arrayvec-0.5)
        ("rust-stable-deref-trait"
         ,rust-stable-deref-trait-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-byteorder" ,rust-byteorder-1))))))

(define-public rust-gimli-0.18
  (package
    (name "rust-gimli")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gimli" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ma1zg2klqr47rasm7jn3zzd1j1pj2a8wkfbv5zsx10qh43phy4k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.4)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))
       #:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-object" ,rust-object-0.12)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-test-assembler" ,rust-test-assembler-0.1)
        ("rust-typed-arena" ,rust-typed-arena-1))))
    (home-page "https://github.com/gimli-rs/gimli")
    (synopsis "Reading and writing the DWARF debugging format")
    (description
     "This package provides a library for reading and writing the
DWARF debugging format.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-git2-0.13
  (package
    (name "rust-git2")
    (version "0.13.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0na3vsa44nn1sr6pzscn93w69wbmdih277mm2p3f6kcavb4ngwj4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.12)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-0.1)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-time" ,rust-time-0.1))))
    (native-inputs
     `(("pkg-config" ,pkg-config)
       ("git" ,git-minimal)))           ;for a single test
    (inputs
     `(("libgit2" ,libgit2)
       ("libssh2" ,libssh2)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/rust-lang/git2-rs")
    (synopsis "Rust bindings to libgit2")
    (description
     "This package provides bindings to libgit2 for interoperating with git
repositories.  This library is both threadsafe and memory safe and allows both
reading and writing git repositories.")
    (license (list license:expat license:asl2.0))))

(define-public rust-git2-0.11
  (package
    (inherit rust-git2-0.13)
    (name "rust-git2")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i0fgsr91r97hsjbgqnymkcyiyg0057m7m04116k3vmyqpvrwlbp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.10)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-docopt" ,rust-docopt-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-git2-0.9
  (package
    (inherit rust-git2-0.11)
    (name "rust-git2")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "git2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cayf5w7wkvclvs8brbi7lyfxbdklwls9s49mpf2brl655yjwjwj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libgit2-sys" ,rust-libgit2-sys-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-url" ,rust-url-1))
       #:cargo-development-inputs
       (("rust-docopt" ,rust-docopt-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-glium-0.25
  (package
    (name "rust-glium")
    (version "0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "glium" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mhjly07x10lxg802ppg16wbxddhh4fdnlg10i99qwpfamvqhzbd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-glutin" ,rust-glutin-0.21)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-takeable-option" ,rust-takeable-option-0.4))
       #:cargo-development-inputs
       (("rust-cgmath" ,rust-cgmath-0.17)
        ("rust-genmesh" ,rust-genmesh-0.6)
        ("rust-gl-generator" ,rust-gl-generator-0.11)
        ("rust-image" ,rust-image-0.21)
        ("rust-obj" ,rust-obj-0.9)
        ("rust-rand" ,rust-rand-0.6))))
    (home-page "https://github.com/glium/glium")
    (synopsis
     "OpenGL wrapper")
    (description
     "Glium is an intermediate layer between OpenGL and your application.  You
still need to manually handle the graphics pipeline, but without having to use
OpenGL's old and error-prone API.")
    (license license:asl2.0)))

(define-public rust-glob-0.3
  (package
    (name "rust-glob")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "glob" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0x25wfr7vg3mzxc9x05dcphvd3nwlcmbnxrvwcvrrdwplcrrk4cv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/rust-lang-nursery/glob")
    (synopsis "Match file paths against Unix shell style patterns")
    (description
     "This package provides support for matching file paths against Unix
shell style patterns.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-glob-0.2
  (package
    (inherit rust-glob-0.3)
    (name "rust-glob")
    (version "0.2.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "glob" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1ysvi72slkw784fcsymgj4308c3y03gwjjzqxp80xdjnkbh8vqcb"))))))

(define-public rust-globset-0.4
  (package
    (name "rust-globset")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "globset" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0841ihdg1ps2618cs0kjbr3pn3rzrj24rx3n4pg1sa6p1d1xmlbs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page
     "https://github.com/BurntSushi/ripgrep/tree/master/globset")
    (synopsis
     "Cross platform single glob and glob set matching")
    (description
     "Cross platform single glob and glob set matching.  Glob set matching is
the process of matching one or more glob patterns against a single candidate
path simultaneously, and returning all of the globs that matched.")
    (license (list license:expat license:unlicense))))

(define-public rust-globwalk-0.8
  (package
    (name "rust-globwalk")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "globwalk" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k6xwkydr7igvwjn3xkwjywk4213lcs53f576ilqz1h84jaazqwk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-ignore" ,rust-ignore-0.4)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-backtrace" ,rust-backtrace-0.3.35)
        ("rust-docmatic" ,rust-docmatic-0.1)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/gilnaa/globwalk")
    (synopsis "Glob-matched recursive file system walking")
    (description "This package provides glob-matched recursive file system
walking.  Based on both @code{rust-walkdir} and @code{rust-ignore}, this crate
inherits many goodies from both, such as limiting search depth and amount of
open file descriptors.")
    (license license:expat)))

(define-public rust-globwalk-0.5
  (package
    (inherit rust-globwalk-0.8)
    (name "rust-globwalk")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "globwalk" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09axyql26s09z60sgi3y3lkin9swy2b5km3b0v6mm84xhlljxyl9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ignore" ,rust-ignore-0.4)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-gloo-timers-0.2
  (package
    (name "rust-gloo-timers")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gloo-timers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07w999jm1r1i8r574qbmsa3l4w3gxhyx04cbllg0m4pzm934l827"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/rustwasm/gloo")
    (synopsis "Convenience crate for working with JavaScript timers")
    (description
     "This package is a convenience crate for working with JavaScript
timers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-goblin-0.2
  (package
    (name "rust-goblin")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "goblin" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1j38fkqadbsjxawr3wnj9m0qaihcwp6pmfakmhsar881509y7mfx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-scroll" ,rust-scroll-0.10)
        ("rust-plain" ,rust-plain-0.2)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/m4b/goblin")
    (synopsis "ELF, Mach-o, and PE binary parsing and loading crate")
    (description "This package provides an ELF, Mach-o, and PE binary parsing
and loading crate.")
    (license license:expat)))

(define-public rust-goblin-0.1
  (package
    (inherit rust-goblin-0.2)
    (name "rust-goblin")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "goblin" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1nn0aa2jf207gbyccxnrzm7n217di025z5y1ybblp7nkk11j309h"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-scroll" ,rust-scroll-0.10)
        ("rust-plain" ,rust-plain-0.2)
        ("rust-log" ,rust-log-0.4))))))

(define-public rust-goblin-0.0
  (package
    (name "rust-goblin")
    (version "0.0.23")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "goblin" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g92bl76dgc3v3rins61l811pkwsl3jif1x35h2jx33b7dsv8mmc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-plain" ,rust-plain-0.2)
        ("rust-scroll" ,rust-scroll-0.9))))
    (home-page "https://github.com/m4b/goblin")
    (synopsis "Binary parsing and loading")
    (description
     "An impish, cross-platform, ELF, Mach-o, and PE binary parsing and
loading crate.")
    (license license:expat)))

(define-public rust-grep-0.2
  (package
    (name "rust-grep")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s3y1rx94swqnciz2zzifm8pmy2iyck270skgxhgkq7ab6x96bjq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-grep-cli" ,rust-grep-cli-0.1)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-grep-pcre2" ,rust-grep-pcre2-0.1)
        ("rust-grep-printer" ,rust-grep-printer-0.1)
        ("rust-grep-regex" ,rust-grep-regex-0.1)
        ("rust-grep-searcher" ,rust-grep-searcher-0.1))
       #:cargo-development-inputs
       (("rust-termcolor" ,rust-termcolor-1)
        ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Line oriented regex searching as a library")
    (description
     "Fast line oriented regex searching as a library.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-cli-0.1
  (package
    (name "rust-grep-cli")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-cli" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10mi7pkvlm5r478jhwlx15wlmqylq9fmkdg4qazz1xcifx7pi4im"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))
    (home-page
     "https://github.com/BurntSushi/ripgrep")
    (synopsis
     "Utilities for search oriented command line applications")
    (description
     "Utilities for search oriented command line applications.")
    (license license:expat)))

(define-public rust-grep-matcher-0.1
  (package
    (name "rust-grep-matcher")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-matcher" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l4k9c0iw17vqw02z0wbx1nfj9h2xiiqx1px32lhhw7ibbyy3w7x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Trait for regular expressions")
    (description
     "This crate provides a low level interface for describing regular
expression matchers.  The @code{grep} crate uses this interface in order to make
the regex engine it uses pluggable.")
    (license (list license:expat license:unlicense))))

(define-public rust-grep-pcre2-0.1
  (package
    (name "rust-grep-pcre2")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-pcre2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sk8b188j81zfrmmy7jsq0pckydz42qf7w0pd2lwyfsa2nw4yksb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-pcre2" ,rust-pcre2-0.2))))
    (native-inputs
     `(("pcre2" ,pcre2)
       ("pkg-config" ,pkg-config)))
    (home-page
     "https://github.com/BurntSushi/ripgrep")
    (synopsis "Use PCRE2 with the grep crate")
    (description "Use PCRE2 with the grep crate.")
    (license (list license:expat license:unlicense))))

(define-public rust-grep-printer-0.1
  (package
    (name "rust-grep-printer")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-printer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "004xv2bb52x801n0m1pknkdmzcjbi9fk9625m49y9s0ghh6d8d3z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.12)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-grep-searcher" ,rust-grep-searcher-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-termcolor" ,rust-termcolor-1))
       #:cargo-development-inputs
       (("rust-grep-regex" ,rust-grep-regex-0.1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Standard printing of search results")
    (description
     "An implementation of the grep crate's Sink trait that provides
standard printing of search results, similar to grep itself.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-regex-0.1
  (package
    (name "rust-grep-regex")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-regex" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lm3mpp93m8qw6sgcqw64inadp0z061x3xb0pnn51684594mxfm7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bstr" ,rust-bstr-0.2)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-regex-syntax" ,rust-regex-syntax-0.6)
        ("rust-thread-local" ,rust-thread-local-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Use Rust's regex library with the grep crate")
    (description
     "Use Rust's regex library with the grep crate.")
    (license (list license:unlicense license:expat))))

(define-public rust-grep-searcher-0.1
  (package
    (name "rust-grep-searcher")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "grep-searcher" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06sb8n7nvaa4dnqnsx9jxvs78nnzmyp110cyzdvxnw09i4h7728r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-encoding-rs-io" ,rust-encoding-rs-io-0.1)
        ("rust-grep-matcher" ,rust-grep-matcher-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memmap" ,rust-memmap-0.7))
       #:cargo-development-inputs
       (("rust-grep-regex" ,rust-grep-regex-0.1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/BurntSushi/ripgrep")
    (synopsis "Line oriented regex searching as a library")
    (description
     "Fast line oriented regex searching as a library.")
    (license (list license:unlicense license:expat))))

(define-public rust-groupable-0.2
  (package
    (name "rust-groupable")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "groupable" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0msfvg8xw4bqi7y7xdkm8nvjjllznc10dnzkx8wnjr5yp119jq9j"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/ryman/groupable-rs")
    (synopsis "Easily aggregate groups of values from key-value iterators")
    (description
     "This package aggregates groups of values from key-value iterators.")
    (license license:expat)))

(define-public rust-gzip-header-0.3
  (package
    (name "rust-gzip-header")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "gzip-header" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fg6vm8sgsm69szwqyz7abfbyziv6pv0jkcailimlamvsfrzwc81"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crc32fast" ,rust-crc32fast-1))))
    (home-page "https://github.com/oyvindln/gzip-header")
    (synopsis "Decoding and encoding the header part of gzip files")
    (description
     "This package provides a crate for decoding and encoding the header part
of gzip files based on the gzip header implementation in the @code{flate2} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-h2-0.3
  (package
    (name "rust-h2")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y5fxy3sy0s3j1h6p0c2xk5n2gs4jk1dvmk88lvgwm22ywfv0cnq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-util" ,rust-tokio-util-0.6)
        ("rust-tracing" ,rust-tracing-0.1))))
    (home-page "https://github.com/hyperium/h2")
    (synopsis "HTTP/2.0 client and server")
    (description "This package provides an HTTP/2.0 client and server.")
    (license license:expat)))

(define-public rust-h2-0.2
  (package
    (inherit rust-h2-0.3)
    (name "rust-h2")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lvdrzn43iikl521dlrb7z96lsmy7l6nnm35ylf00q7dmq5rwgwr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-sink" ,rust-futures-sink-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-hex" ,rust-hex-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-walkdir" ,rust-walkdir-1)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-h2-0.1
  (package
    (inherit rust-h2-0.2)
    (name "rust-h2")
    (version "0.1.26")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "h2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qn457y8xh03p7c7cpk76r22gqpyqxc58g5022j3iya7d0j4rcx5"))))
    (arguments
     `(#:skip-build? #t ;; TODO missing indirect dependency
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-string" ,rust-string-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-hex" ,rust-hex-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-rand" ,rust-rand-0.3)
        ;;("rust-rustls" ,rust-rustls-0.12) requires 0.5
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.12)
        ("rust-walkdir" ,rust-walkdir-1)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-half-1
  (package
    (name "rust-half")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "half" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xq1qkbfwnxv72b2fakgi5ai0j8arw38whwxgxs3rp1fz28anvyk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/starkat99/half-rs")
    (synopsis "Half-precision floating point f16 type")
    (description
     "Half-precision floating point f16 type for Rust implementing the
IEEE 754-2008 binary16 type.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bat-0.17
  (package
    (name "rust-bat")
    (version "0.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bat" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ia12774prjnm3msiaja6qdpxkpyknxswqpgkmwzj0wn9nhkc7nz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ansi-colours" ,rust-ansi-colours-1)
        ("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-clap" ,rust-clap-2)
        ("rust-clap" ,rust-clap-2)
        ("rust-console" ,rust-console-0.13)
        ("rust-content-inspector" ,rust-content-inspector-0.2)
        ("rust-dirs" ,rust-dirs-3)
        ("rust-encoding" ,rust-encoding-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-git2" ,rust-git2-0.13)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-path-abs" ,rust-path-abs-0.5)
        ("rust-semver" ,rust-semver-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-shell-words" ,rust-shell-words-1)
        ("rust-syntect" ,rust-syntect-4)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-wild" ,rust-wild-2))))
    (home-page "https://github.com/sharkdp/bat")
    (synopsis "@command{cat} clone with syntax highlighting and git integration")
    (description
     "@command{bat} is a drop-in @command{cat} replacement featuring syntax
highlighting for a large number of languages, git integration, and automatic
paging.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hamcrest2-0.3
  (package
    (name "rust-hamcrest2")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hamcrest2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x8hx7jyzz2bl0wf6nir62imd26yhp6qcr7zf76cjpg05p33gy29"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num" ,rust-num-0.2)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Valloric/hamcrest2-rust")
    (synopsis "Rust port of the Hamcrest testing library")
    (description
     "This package provides a port of the Hamcrest testing library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-handlebars-2
  (package
    (name "rust-handlebars")
    (version "2.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "handlebars" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1m99gwjd7q7q79bk4f716wsdvcyhsrcsq4vbzcavbkmc48d194mg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
        (("rust-hashbrown" ,rust-hashbrown-0.5)
         ("rust-log" ,rust-log-0.4)
         ("rust-pest" ,rust-pest-2)
         ("rust-pest-derive" ,rust-pest-derive-2)
         ("rust-quick-error" ,rust-quick-error-1)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-json" ,rust-serde-json-1)
         ("rust-walkdir" ,rust-walkdir-2))
        #:cargo-development-inputs
        (("rust-criterion" ,rust-criterion-0.2)
         ("rust-env-logger" ,rust-env-logger-0.6)
         ("rust-maplit" ,rust-maplit-1)
         ("rust-serde-derive" ,rust-serde-derive-1)
         ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/sunng87/handlebars-rust")
    (synopsis "Handlebars templating implemented in Rust")
    (description
     "This package provides handlebars templating implemented in Rust.  It is
the template engine that renders the official Rust website")
    (license license:expat)))

(define-public rust-handlegraph-0.3
  (package
    (name "rust-handlegraph")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "handlegraph" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1sj100w4lpj7798pws85qrfrzsily5hhzh6j118rwf56sgic1yml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-gfa" ,rust-gfa-0.6))))
    (home-page "https://github.com/chfi/rs-handlegraph")
    (synopsis "Library for use in variation graphs")
    (description
     "This package provides a Rust implementation of VG handle graph.")
    (license license:expat)))

(define-public rust-hash32-0.1
  (package
    (name "rust-hash32")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1k7lv7hsbzv14pz90cxay6v7avh6d6kcrra0rsc45b33dvw1l16l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-hash32-derive" ,rust-hash32-derive-0.1))))
    (home-page "https://github.com/japaric/hash32")
    (synopsis "32-bit hashing machinery")
    (description "This package provides 32-bit hashing machinery.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hash32-derive-0.1
  (package
    (name "rust-hash32-derive")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hash32-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18lrlxycq45kaz0l688shxnhgh3ryjp3zn0n6vfcs5sa2nyyzh7b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.3)
        ("rust-quote" ,rust-quote-0.5)
        ("rust-syn" ,rust-syn-0.13))))
    (home-page "https://github.com/japaric/hash32")
    (synopsis "Macros 1.1 implementation of @code{#[derive(Hash32)]}")
    (description "This package provides a macros 1.1 implementation of
@code{#[derive(Hash32)]}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hashbrown-0.9
  (package
    (name "rust-hashbrown")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "016dsm9s4xmxlkw2jfikm54qlz6vyk0qr280gab7kzp342jf9byp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.4)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/rust-lang/hashbrown")
    (synopsis "Rust port of Google's SwissTable hash map")
    (description "This package provides a Rust port of Google's SwissTable
hash map.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hashbrown-0.8
  (package
    (inherit rust-hashbrown-0.9)
    (name "rust-hashbrown")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09y86zmf59n6ys9yf2bvg9ckwwa1ijv2i3flkz45iqkwfmh7i6xb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.3)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.5
  (package
    (inherit rust-hashbrown-0.8)
    (name "rust-hashbrown")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lr3gsicplw7czapsscmii87hgzpvxf5ch92v7pi95xsipxl3pp1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashbrown-0.1
  (package
    (inherit rust-hashbrown-0.5)
    (name "rust-hashbrown")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashbrown" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1np350nrzysy021ndn2135q5vpzrp5nli78ywz114d1vcnv2kbiv"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("~1.2") "1.2"))
           #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-scopeguard" ,rust-scopeguard-0.3)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-hashlink-0.6
  (package
    (name "rust-hashlink")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hashlink" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a2gi4737lmqq1i48b9w13gvbkh4g3gc7gj6d3974hywy21gg76r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hashbrown" ,rust-hashbrown-0.9)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://crates.io/crates/hashlink")
    (synopsis "HashMap-like containers with user controllable order")
    (description "This package provides HashMap-like containers that hold
their key-value pairs in a user controllable order.")
    (license (list license:expat license:asl2.0))))

(define-public rust-headers-0.3
  (package
    (name "rust-headers")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hyafm9q5havnbljfdzpkb7wrpx11ayzqzv02abycmklgk2rss32"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-headers-core" ,rust-headers-core-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-sha-1" ,rust-sha-1-0.8)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://hyper.rs")
    (synopsis "Typed HTTP headers")
    (description "This package provides typed HTTP headers.")
    (license license:expat)))

(define-public rust-headers-0.2
  (package
    (inherit rust-headers-0.3)
    (name "rust-headers")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hmnrra00cjqpsn05klnr9cysrv2bm19akxl5lncwcrgfbcafb48"))))
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-headers-core" ,rust-headers-core-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-sha-1" ,rust-sha-1-0.8)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-headers-core-0.2
  (package
    (name "rust-headers-core")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ab469xfpd411mc3dhmjhmzrhqikzyj8a17jn5bkj9zfpy0n9xp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-http" ,rust-http-0.2))))
    (home-page "https://hyper.rs")
    (synopsis "Typed HTTP headers core trait")
    (description "This package provides typed HTTP headers core trait.")
    (license license:expat)))

(define-public rust-headers-core-0.1
  (package
    (inherit rust-headers-core-0.2)
    (name "rust-headers-core")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "headers-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ds20kg0igncs2r0jrcf26mq72k3j6ilanr0qwh7r7xak8kk2wcn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-http" ,rust-http-0.1))))))

(define-public rust-heapless-0.5
  (package
    (name "rust-heapless")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1h1d6s1f9zn0rz2vkdn0b42kcnkmlpd90yhfyqqhpirv38ws5a3k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-as-slice" ,rust-as-slice-0.1)
        ("rust-generic-array" ,rust-generic-array-0.13)
        ("rust-hash32" ,rust-hash32-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1)
        ("rust-ufmt-write" ,rust-ufmt-write-0.1))
       #:cargo-development-inputs
       (("rust-scoped-threadpool" ,rust-scoped-threadpool-0.1)
        ("rust-ufmt" ,rust-ufmt-0.1))))
    (home-page "https://github.com/japaric/heapless")
    (synopsis "@code{statice} friendly data structures")
    (description "This package provides @code{static} friendly data structures
that don't require dynamic memory allocation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-heapsize-0.4
  (package
    (name "rust-heapsize")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "heapsize" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32
         "0q94q9ppqjgrw71swiyia4hgby2cz6dldp7ij57nkvhd6zmfcy8n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/servo/heapsize")
    (synopsis "Measure the total runtime size of an object on the heap")
    (description
     "Infrastructure for measuring the total runtime size of an object on the
heap.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-heapsize-0.3
  (package
    (inherit rust-heapsize-0.4)
    (name "rust-heapsize")
    (version "0.3.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heapsize" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0dmwc37vgsdjzk10443dj4f23439i9gch28jcwzmry3chrwx8v2m"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-kernel32-sys" ,rust-kernel32-sys-0.2))))))

;; This package makes use of removed features
(define-public rust-heapsize-plugin-0.1
  (package
    (name "rust-heapsize-plugin")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heapsize_plugin" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1i72isf699q9jl167g2kg4xd6h3cd05rc79zaph58aqjy0g0m9y9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-heapsize" ,rust-heapsize-0.3))))
    (home-page "https://github.com/servo/heapsize")
    (synopsis "Measure runtime size of an object on the heap")
    (description
     "This package automatically generates infrastructure for measuring the
total runtime size of an object on the heap")
    (license license:mpl2.0)))

(define-public rust-heck-0.3
  (package
    (name "rust-heck")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "heck" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "01a2v7yvkiqxakdqz4hw3w3g4sm52ivz9cs3qcsv2arxsmw4wmi0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/withoutboats/heck")
    (synopsis "Case conversion library")
    (description
     "This library exists to provide case conversion between common cases like
CamelCase and snake_case.  It is intended to be unicode aware, internally
consistent, and reasonably well performing.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-hermit-abi-0.1
  (package
    (name "rust-hermit-abi")
    (version "0.1.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hermit-abi" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0blmmzik5cs79ivq70s9gal8ypgzj50wnl2hwsaam46gjjbz2p3j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
        (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/hermitcore/rusty-hermit")
    (synopsis "Small interface to call functions from RustyHermit")
    (description
     "Hermit-abi is small interface to call functions from the unikernel RustyHermit.
It is used to build the target x86_64-unknown-hermit.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hex-0.4
  (package
    (name "rust-hex")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dbf00j3h3pz0lw8jp245rwypna6i23l4cpvym8gsczin9c92kv4"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/KokaKiwi/rust-hex")
    (synopsis "Encode and decode data to/from hexadecimals")
    (description "This crate allows for encoding and decoding data into/from
hexadecimal representation.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-hex-0.3
  (package
    (inherit rust-hex-0.4)
    (name "rust-hex")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hex" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0xsdcjiik5j750j67zk42qdnmm4ahirk3gmkmcqgq7qls2jjcl40"))))))

(define-public rust-hex-0.2
  (package
    (inherit rust-hex-0.4)
    (name "rust-hex")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32 "1ajkw40qzn2ygnqjj9w584f6l31wi318258n84pn2hax8la2i8nn"))))))

(define-public rust-hex-literal-0.2
  (package
    (name "rust-hex-literal")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q36f0qq31ggh4ipcwb7a5g6jmci2010vn2v3qpaz4csxhhf47cn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-hex-literal-impl" ,rust-hex-literal-impl-0.2)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis
     "Convert hexadecimal string to byte array at compile time")
    (description
     "Procedural macro for converting hexadecimal string to byte array at
compile time.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hex-literal-0.1
  (package
    (inherit rust-hex-literal-0.2)
    (name "rust-hex-literal")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ffnn5g9q5xhdmzj2ic5hk9y18kyqflbmqcssqcya9gixs5r5hnx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-hex-literal-impl" ,rust-hex-literal-impl-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-hex-literal-impl-0.2
  (package
    (name "rust-hex-literal-impl")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bgldhp5gdwwnikfdxigmz9b64qpgwbjqk6mfgv0pvig9s25qk4x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Internal implementation of the hex-literal crate")
    (description
     "Internal implementation of the hex-literal crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-hex-literal-impl-0.1
  (package
    (inherit rust-hex-literal-impl-0.2)
    (name "rust-hex-literal-impl")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hex-literal-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nnxqhyn9l998ma04ip79bmpqv1as6003s03g26ynhrr471p022j"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-hkdf-0.9
  (package
    (name "rust-hkdf")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jdvmf8aadk3s0kn9kk3dj00nprjk9glks5f8dm55r43af34j4gy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-digest" ,rust-digest-0.9)
        ("rust-hmac" ,rust-hmac-0.8))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-crypto-tests" ,rust-crypto-tests-0.5)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))
    (home-page "https://github.com/RustCrypto/KDFs/")
    (synopsis "HMAC-based Extract-and-Expand Key Derivation Function (HKDF)")
    (description "This package provides a HMAC-based Extract-and-Expand Key
Derivation Function (HKDF).")
    (license (list license:expat license:asl2.0))))

(define-public rust-hkdf-0.8
  (package
    (inherit rust-hkdf-0.9)
    (name "rust-hkdf")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hkdf" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qzsmqrvcmgnrb109qr2mvsmr5c4psm1702vrpcqnj02c408m81z"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-digest" ,rust-digest-0.8)
        ("rust-hmac" ,rust-hmac-0.7))))))

(define-public rust-hmac-0.8
  (package
    (name "rust-hmac")
    (version "0.8.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0h48wc7iysh4xd6ci4prh8bb7nszijrh9w3blaaq8a6cilk8hs0j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-digest" ,rust-digest-0.9))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-md-5" ,rust-md-5-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))
    (home-page "https://github.com/RustCrypto/MACs")
    (synopsis "Generic implementation of Hash-based Message Authentication Code")
    (description
     "This package provides a generic implementation of @acronym{HMAC,
Hash-based Message Authentication Code}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hmac-0.7
  (package
    (inherit rust-hmac-0.8)
    (name "rust-hmac")
    (version "0.7.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hmac" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15cnwpssp2n1kdm9x7abir67f2hp3q6rdfj1mcck3hm4rmj5xjsx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-digest" ,rust-digest-0.8))
       #:cargo-development-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-md-5" ,rust-md-5-0.8)
        ("rust-sha2" ,rust-sha2-0.8))))))

(define-public rust-hmac-0.5
  (package
    (inherit rust-hmac-0.8)
    (name "rust-hmac")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ppm927wsczkkvybj0y7r2w2lprvy5kf5h31qxyrvnbrhnqbvws4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.5)
        ("rust-digest" ,rust-digest-0.7))))))

(define-public rust-hmac-0.4
  (package
    (inherit rust-hmac-0.8)
    (name "rust-hmac")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0amfn9wggxapyva1i0j7wldy9chj487cxal4wldwmid078bg84vs"))))
    (arguments
     `(#:skip-build?
       #t
       #:cargo-inputs
       (("rust-crypto-mac" ,rust-crypto-mac-0.4)
        ("rust-digest" ,rust-digest-0.6)
        ("rust-generic-array" ,rust-generic-array-0.8))))))

(define-public rust-hmac-sha1-0.1
  (package
    (name "rust-hmac-sha1")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hmac-sha1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08k7aylc0v8x3abmxn3h73dkad3anfq2i94xk2mjrf4linnkycz1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-sha1" ,rust-sha1-0.2))))
    (home-page "https://github.com/pantsman0/rust-hmac-sha1")
    (synopsis "Minimal implementation of HMAC-SHA1 in Rust")
    (description
     "This package is a pure Rust implementation of the @acronym{HMAC,
Hash-based Message Authentication Code algorithm} for SHA1.")
    (license license:bsd-3)))

(define-public rust-hostname-0.3
  (package
    (name "rust-hostname")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hostname" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rz8yf70cvzl3nry71m4bz9w6x4j9kdz3qng6pnwhk2h20z1qwrw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-match-cfg" ,rust-match-cfg-0.1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/svartalf/hostname")
    (synopsis "Get hostname for Rust")
    (description
     "Get hostname for Rust.")
    (license license:expat)))

(define-public rust-hostname-0.1
  (package
    (inherit rust-hostname-0.3)
    (name "rust-hostname")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "hostname" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0kprf862qaa7lwdms6aw7f3275h0j2rwhs9nz5784pm8hdmb9ki1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winutil" ,rust-winutil-0.1))))))

(define-public rust-html5ever-0.25
  (package
    (name "rust-html5ever")
    (version "0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0szdpwr6l3p21flf01pdlpj6fkpqisqf34lvs918449n3a5g7z5a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.10)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/servo/html5ever")
    (synopsis "High-performance browser-grade HTML5 parser")
    (description
     "This package provides a high-performance browser-grade HTML5 parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-html5ever-0.24
  (package
    (inherit rust-html5ever-0.25)
    (name "rust-html5ever")
    (version "0.24.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1js4cr04941ld4r4fqpblvfigy75ds48qcbqhnr7nmz4l6q86m02"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.9)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-typed-arena" ,rust-typed-arena-1))))))

(define-public rust-html5ever-0.23
  (package/inherit rust-html5ever-0.24
    (name "rust-html5ever")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "html5ever" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dx8k7synrmf3fl6gcfm5q1cybfglvhc9xnvly3s5xcc0b45mrjw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mac" ,rust-mac-0.1)
        ("rust-markup5ever" ,rust-markup5ever-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-typed-arena" ,rust-typed-arena-1))))))

(define-public rust-htmlescape-0.3
  (package
    (name "rust-htmlescape")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "htmlescape" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qria8paf19qy5sgzzk3iiii9fp2j7spbhqf0zjxwrg7v9c500p9"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/veddan/rust-htmlescape")
    (synopsis "Library for HTML entity encoding and decoding")
    (description
     "This package provides a library for HTML entity encoding and decoding.")
    (license (list license:asl2.0 license:expat license:mpl2.0))))

(define-public rust-http-0.2
  (package
    (name "rust-http")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y827q7j0gvs8z2x12biaik9db6nb902lpqv889cbcj84sbnkm98"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-itoa" ,rust-itoa-0.4))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/hyperium/http")
    (synopsis "Set of types for representing HTTP requests and responses")
    (description "This package provides a set of types for representing HTTP
requests and responses.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-http-0.1
  (package/inherit rust-http-0.2
    (name "rust-http")
    (version "0.1.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06icxvrd26r6s7dzjavja7r47hgjb9851wblqh8frxnsy3q29lzf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-itoa" ,rust-itoa-0.4))
       #:cargo-development-inputs
       (("rust-indexmap" ,rust-indexmap-1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-http-body-0.4
  (package
    (name "rust-http-body")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "150rkibhyrcmsyi0qzwx4hp02c4lga1kkdg8j7l5wkh7xqkvsq98"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-http" ,rust-http-0.2))))
    (home-page "https://github.com/hyperium/http-body")
    (synopsis "Asynchronous, streaming, HTTP request or response body")
    (description
     "This crate provides a trait representing an asynchronous, streaming,
HTTP request or response body.")
    (license license:expat)))

(define-public rust-http-body-0.3
  (package
    (inherit rust-http-body-0.4)
    (name "rust-http-body")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06qi0ni45lb92w3ml260c0bxbq5zd4snjmz0a9k69xq6021zzm8k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-http" ,rust-http-0.2))))))

(define-public rust-http-body-0.1
  (package/inherit rust-http-body-0.3
    (name "rust-http-body")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-body" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b99404k4mw6a92hvyr0qwzkqv4f866ykg0x7913limjq5cwhhb7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-tokio-buf" ,rust-tokio-buf-0.1))))))

(define-public rust-http-client-6
  (package
    (name "rust-http-client")
    (version "6.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-client" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i0mys38gsih9kkrdbfsmd8p9lnb2nd5wch76cpkjmqk8mm2mhcq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-h1" ,rust-async-h1-2)
        ("rust-async-native-tls" ,rust-async-native-tls-0.3)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-async-tls" ,rust-async-tls-0.10)
        ("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dashmap" ,rust-dashmap-4)
        ("rust-deadpool" ,rust-deadpool-0.7)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-http-types" ,rust-http-types-2)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-hyper-tls" ,rust-hyper-tls-0.4)
        ("rust-isahc" ,rust-isahc-0.9)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/http-rs/http-client")
    (synopsis "Types and traits for HTTP clients")
    (description "This package provides types and traits for HTTP clients.")
    (license (list license:expat license:asl2.0))))

(define-public rust-http-req-0.5
  (package
    (name "rust-http-req")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http_req" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0qaw43nwvvxbnqddxhb9fh9316dn64nmkzj08pq8n49qdy51xrys"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       ;; Haven't packaged rustls and webpki because of license
       (("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-unicase" ,rust-unicase-2))))
    (home-page "https://github.com/jayjamesjay/http_req")
    (synopsis
     "HTTP client with built-in HTTPS support")
    (description
     "Simple and lightweight HTTP client with built-in HTTPS support.")
    (license license:expat)))

(define-public rust-http-types-2
  (package
    (name "rust-http-types")
    (version "2.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "http-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p7g2rzgzvnd419a5ddlyb2nz85z9bw7cdkqyl7467cx2fxkwq9j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-std" ,rust-async-std-1)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-cookie" ,rust-cookie-0.14)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-http" ,rust-http-0.2)
        ("rust-infer" ,rust-infer-0.2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-qs" ,rust-serde-qs-0.7)
        ("rust-serde-urlencoded" ,rust-serde-urlencoded-0.7)
        ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/http-rs/http-types")
    (synopsis "Common types for HTTP operations.")
    (description
     "This package provides common types for HTTP operations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-httparse-1
  (package
    (name "rust-httparse")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "httparse" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1yf23ldnjwfkkhkca7f4w15mky9961gjz28dlwyybhphc7l9l5yd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-pico-sys" ,rust-pico-sys-0.0))))
    (home-page "https://github.com/seanmonstar/httparse")
    (synopsis "Zero-copy HTTP/1.x parser")
    (description
     "This package provides a tiny, safe, speedy, zero-copy HTTP/1.x parser.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-httpdate-0.3
  (package
    (name "rust-httpdate")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "httpdate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0izbd3sf0625wm4rrfv85xa4xa8j4n1ldxhwlkgff4cm6rh4sjs9"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/pyfisch/httpdate")
    (synopsis "HTTP date parsing and formatting")
    (description
     "This crates parses and formats HTTP datetime strings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humansize-1
  (package
    (name "rust-humansize")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humansize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0piadmwjah1jv6q288im4za9szlgalzjyq2811w35i6gg9ib5jmn"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/LeopoldArkham/humansize")
    (synopsis "Represent file sizes in a human-readable format")
    (description "This package provides a configurable crate to easily
represent file sizes in a human-readable format.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humantime-2
  (package
    (name "rust-humantime")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humantime" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0yivhqyi8xik2j6sd3q45ybakjx8jsx5632dx9xjn0birh4dj6iw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/tailhook/humantime")
    (synopsis
     "Parser and formatter for Duration and SystemTime")
    (description
     "A parser and formatter for @code{std::time::{Duration,
SystemTime}}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-humantime-1
  (package
    (inherit rust-humantime-2)
    (name "rust-humantime")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "humantime" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0krwgbf35pd46xvkqg14j070vircsndabahahlv3rwhflpy4q06z"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quick-error" ,rust-quick-error-1))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-time" ,rust-time-0.1))))))

(define-public rust-hyper-0.14
  (package
    (name "rust-hyper")
    (version "0.14.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ivaqbcvsws6svwykiq7fgma7wds72r83qianzh5b41ln714dsg8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-h2" ,rust-h2-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-http-body" ,rust-http-body-0.4)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-httpdate" ,rust-httpdate-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-pin-project" ,rust-pin-project-1)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tower-service" ,rust-tower-service-0.3)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-want" ,rust-want-0.3))))
    (home-page "https://hyper.rs")
    (synopsis "Fast and correct HTTP library.")
    (description "This package provides a fast and correct HTTP library.")
    (license license:expat)))

(define-public rust-hyper-0.13
  (package
    (inherit rust-hyper-0.14)
    (name "rust-hyper")
    (version "0.13.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1symcnba2y03b8lj6xp2wd994lk3xyk3wizacjg5s60njzfshs1y"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-h2" ,rust-h2-0.2)
        ("rust-http" ,rust-http-0.2)
        ("rust-http-body" ,rust-http-body-0.3)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-pin-project" ,rust-pin-project-0.4)
        ("rust-socket2" ,rust-socket2-0.3)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tower-service" ,rust-tower-service-0.3)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-want" ,rust-want-0.3))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-pretty-env-logger" ,rust-pretty-env-logger-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-spmc" ,rust-spmc-0.3)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-test" ,rust-tokio-test-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.3)
        ("rust-tower-util" ,rust-tower-util-0.3)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-0.12
  (package
    (inherit rust-hyper-0.13)
    (name "rust-hyper")
    (version "0.12.35")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xnm8zi4bdjqhlnx3238kx8yjf29jjd1ww54apcql7wf8g8nxglx"))))
    (arguments
     `(#:skip-build? #t ;; fails due to some missing example file
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-futures-cpupool" ,rust-futures-cpupool-0.1)
        ("rust-h2" ,rust-h2-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-http-body" ,rust-http-body-0.1)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-buf" ,rust-tokio-buf-0.1)
        ("rust-tokio-executor" ,rust-tokio-executor-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1)
        ("rust-tokio-tcp" ,rust-tokio-tcp-0.1)
        ("rust-tokio-threadpool" ,rust-tokio-threadpool-0.1)
        ("rust-tokio-timer" ,rust-tokio-timer-0.2)
        ("rust-want" ,rust-want-0.2))
       #:cargo-development-inputs
       (("rust-futures-timer" ,rust-futures-timer-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-pretty-env-logger" ,rust-pretty-env-logger-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-spmc" ,rust-spmc-0.3)
        ("rust-tokio-fs" ,rust-tokio-fs-0.1)
        ("rust-tokio-mockstream" ,rust-tokio-mockstream-1)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-0.11
  (package
    (inherit rust-hyper-0.13)
    (name "rust-hyper")
    (version "0.11.27")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1msrx9fgiiv7vl4kryn2zgahbqndph5szrgqvm6fjhfk1759199l"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-futures-cpupool" ,rust-futures-cpupool-0.1)
        ("rust-http" ,rust-http-0.1)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-percent-encoding" ,rust-percent-encoding-1)
        ("rust-relay" ,rust-relay-0.1)
        ("rust-time" ,rust-time-0.1)
        ("rust-tokio-core" ,rust-tokio-core-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-proto" ,rust-tokio-proto-0.1)
        ("rust-tokio-service" ,rust-tokio-service-0.1)
        ("rust-unicase" ,rust-unicase-2)
        ("rust-want" ,rust-want-0.0))))))

(define-public rust-hyper-0.10
  (package
    (inherit rust-hyper-0.13)
    (name "rust-hyper")
    (version "0.10.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwjh9p3mzvg3fss2lqz5r7ddcgl1fh9w6my2j69d6k0lbcm41ha"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-log" ,rust-log-0.3)
        ("rust-mime" ,rust-mime-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-traitobject" ,rust-traitobject-0.1)
        ("rust-typeable" ,rust-typeable-0.1)
        ("rust-unicase" ,rust-unicase-1)
        ("rust-url" ,rust-url-1))))))

(define-public rust-hyper-native-tls-0.3
  (package
    (name "rust-hyper-native-tls")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s30y20qy0akzss91yxsq1x1q7rr04jy33i0cq72nx22yjc5advd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-antidote" ,rust-antidote-1)
        ("rust-hyper" ,rust-hyper-0.10)
        ("rust-native-tls" ,rust-native-tls-0.2))))
    (home-page "https://github.com/sfackler/hyper-native-tls")
    (synopsis "native-tls support for Hyper 0.10")
    (description "This package provides native-tls support for Hyper 0.10.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-old-types-0.11
  (package
    (name "rust-hyper-old-types")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-old-types" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1i69sks0bwamzqdbx8ffgkssxffv6crdmwjgl47nr5pkxi8vx5k8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ; Tests do not compile
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-http" ,rust-http-0.1)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-language-tags" ,rust-language-tags-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-percent-encoding" ,rust-percent-encoding-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-unicase" ,rust-unicase-2))))
    (home-page "https://hyper.rs")
    (synopsis "HTTP types from hyper 0.11.x")
    (description
     "This package contains HTTP types from the newer hyper crate in versions
0.11.x.")
    (license license:expat)))

(define-public rust-hyper-rustls-0.22
  (package
    (name "rust-hyper-rustls")
    (version "0.22.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0r2szp06nzqx6gblcw69kwx8afjp218fc083kfpw0i3d66bpm7sz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ct-logs" ,rust-ct-logs-0.8)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-hyper" ,rust-hyper-0.14)
        ("rust-log" ,rust-log-0.4)
        ("rust-rustls" ,rust-rustls-0.19)
        ("rust-rustls-native-certs" ,rust-rustls-native-certs-0.5)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.22)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.21))))
    (home-page "https://github.com/ctz/hyper-rustls")
    (synopsis "Rustls+Hyper integration for pure Rust HTTPS")
    (description
     "This package provides Rustls+Hyper integration for pure Rust HTTPS.")
    (license
     (list license:asl2.0 license:isc license:expat))))

(define-public rust-hyper-rustls-0.21
  (package
    (inherit rust-hyper-rustls-0.22)
    (name "rust-hyper-rustls")
    (version "0.21.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dmbj15fx6qyg26hji2jm7q9y383090jy3z9zjn5xs4f7v43qx1p"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-ct-logs" ,rust-ct-logs-0.7)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-log" ,rust-log-0.4)
        ("rust-rustls" ,rust-rustls-0.18)
        ("rust-rustls-native-certs" ,rust-rustls-native-certs-0.4)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.14)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.20))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-hyper-rustls-0.17
  (package
    (inherit rust-hyper-rustls-0.21)
    (name "rust-hyper-rustls")
    (version "0.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0li9xkzmqd40dbjbl9g0nbf2ka9y0q538ififyd30zsavz3qb7bi"))))
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=server" "--skip=client"
                            "--skip=custom_ca_store")
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-ct-logs" ,rust-ct-logs-0.6)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-hyper" ,rust-hyper-0.12)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-rustls" ,rust-tokio-rustls-0.10)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))))))

(define-public rust-hyper-sync-rustls-0.3
  (package
    (name "rust-hyper-sync-rustls")
    (version "0.3.0-rc.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-sync-rustls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16zirxhsk26kz5jxxxs37wxsm02id97h57kkqs512fj1j0x486kd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hyper" ,rust-hyper-0.10)
        ("rust-rustls" ,rust-rustls-0.14)
        ("rust-webpki" ,rust-webpki-0.18)
        ("rust-webpki-roots" ,rust-webpki-roots-0.15))))
    (home-page "https://github.com/SergioBenitez/hyper-sync-rustls")
    (synopsis "Glue code for Rustls and synchronous Hyper")
    (description
     "This package provides glue code for Rustls and synchronous Hyper.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-tls-0.5
  (package
    (name "rust-hyper-tls")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01crgy13102iagakf6q4mb75dprzr7ps1gj0l5hxm1cvm7gks66n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-hyper" ,rust-hyper-0.14)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-native-tls" ,rust-tokio-native-tls-0.3))))
    (home-page "https://hyper.rs")
    (synopsis "Default TLS implementation for use with hyper")
    (description "This package provides the default TLS implementation for use
with hyper.")
    (license (list license:expat license:asl2.0))))

(define-public rust-hyper-tls-0.4
  (package
    (inherit rust-hyper-tls-0.5)
    (name "rust-hyper-tls")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vcfyz7dxavf4brns15afmj5fxz88lbn05rrpbfqsnybdp2sqyfr"))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("openssl" ,openssl)))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-hyper" ,rust-hyper-0.13)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-tls" ,rust-tokio-tls-0.3))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-0.2))))))

(define-public rust-hyper-tls-0.3
  (package
    (inherit rust-hyper-tls-0.4)
    (name "rust-hyper-tls")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "hyper-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kqp4sz8613j6nv375wfj3gh95ff4nb6a3rb1f2vbx0almm0v01s"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-hyper" ,rust-hyper-0.12)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-0.1))))))

(define-public rust-ident-case-1
  (package
    (name "rust-ident-case")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ident_case" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fac21q6pwns8gh1hz3nbq15j8fi441ncl6w4vlnd1cmc55kiq5r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/TedDriggs/ident_case")
    (synopsis "Utility for applying case rules to Rust identifiers")
    (description
     "Utility for applying case rules to Rust identifiers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-idna-0.2
  (package
    (name "rust-idna")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "idna" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a9066imqpdrm1aavfasdyb1zahqaz8jmdcwdawvb1pf60y6gqh2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-matches" ,rust-matches-0.1)
        ("rust-unicode-bidi" ,rust-unicode-bidi-0.3)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))
       #:cargo-development-inputs
       (("rust-rustc-test" ,rust-rustc-test-0.3)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/servo/rust-url/")
    (synopsis "Internationalizing Domain Names in Applications and Punycode")
    (description
     "IDNA (Internationalizing Domain Names in Applications) and Punycode.")
    (license (list license:expat license:asl2.0))))

(define-public rust-idna-0.1
  (package
    (inherit rust-idna-0.2)
    (name "rust-idna")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "idna" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kl4gs5kaydn4v07c6ka33spm9qdh2np0x7iw7g5zd8z1c7rxw1q"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-matches" ,rust-matches-0.1)
        ("rust-unicode-bidi" ,rust-unicode-bidi-0.3)
        ("rust-unicode-normalization" ,rust-unicode-normalization-0.1))
       #:cargo-development-inputs
       (("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-rustc-test" ,rust-rustc-test-0.3))))))

(define-public rust-if-chain-1
  (package
    (name "rust-if-chain")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "if_chain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0zgcn31bahnsmsjc0cgk0cy38p8sfjs79yvi6rjs5zz5b5xhqdn3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/lfairy/if_chain")
    (synopsis "Macro for writing nested @code{if let} expressions")
    (description "This package provides a macro for writing nested @code{if
let} expressions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ignore-0.4
  (package
    (name "rust-ignore")
    (version "0.4.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ignore" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1347mxd0cwiidcl0qvixl7za524x5ds0izv8vjh2df0bqr2zp1xj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-globset" ,rust-globset-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-thread-local" ,rust-thread-local-1)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-winapi-util" ,rust-winapi-util-0.1))
       #:cargo-development-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5))))
    (home-page "https://github.com/BurntSushi/ripgrep/tree/master/crates/ignore")
    (synopsis "Efficiently match ignore files such as @file{.gitignore}")
    (description
     "This package provides a fast library for efficiently matching
ignore files such as @file{.gitignore} against file paths.")
    (license (list license:unlicense license:expat))))

(define-public rust-include-flate-0.1
  (package
    (name "rust-include-flate")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xd63rhr03ax1w327ws46wc9zyw5k9jsaxfy24j6wg9km3xhfqii"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-include-flate-codegen-exports" ,rust-include-flate-codegen-exports-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libflate" ,rust-libflate-0.1))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Variant of @code{include_bytes!/include_str!} with compression")
    (description
     "This package provides a variant of @code{include_bytes!/include_str!}
with compile-time deflation and runtime lazy inflation.")
    (license license:asl2.0)))

(define-public rust-include-flate-codegen-0.1
  (package
    (name "rust-include-flate-codegen")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate-codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mbw6fcczmfw4dabps4l90mdn2wdy9zhqwh60xx4fjcxqfsm9ksb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libflate" ,rust-libflate-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Macro codegen for the @code{include-flate} crate")
    (description
     "This package provides macro codegen for the @code{include-flate}
crate.")
    (license license:asl2.0)))

(define-public rust-include-flate-codegen-exports-0.1
  (package
    (name "rust-include-flate-codegen-exports")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "include-flate-codegen-exports" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dk7xdrck9f3bjnwm3rmh5gl1hs64lr2gnd3dv3jznharcmyb4mw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-include-flate-codegen" ,rust-include-flate-codegen-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/SOF3/include-flate")
    (synopsis "Macro codegen for the @code{include-flate} crate")
    (description
     "This package provides macro codegen for the @code{include-flate}
crate.")
    (license license:asl2.0)))

(define-public rust-indexmap-1
  (package
    (name "rust-indexmap")
    (version "1.6.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "indexmap" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0friqyzr4ssyayks7nirqbc36zcsf8fdi67jmvl4vpjh8a9zmcag"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-hashbrown" ,rust-hashbrown-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-rayon" ,rust-rayon-1))
       #:cargo-development-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/bluss/indexmap")
    (synopsis "Hash table with consistent order and fast iteration.")
    (description
     "This package provides a hash table with consistent order and fast iteration.

The indexmap is a hash table where the iteration order of the key-value
pairs is independent of the hash values of the keys.  It has the usual
hash table functionality, it preserves insertion order except after
removals, and it allows lookup of its elements by either hash table key
or numerical index.  A corresponding hash set type is also provided.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-indicatif-0.15
  (package
    (name "rust-indicatif")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indicatif" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r4n50mclyi4c7b9c9mlma1rhchjamw71r3z8vgqcmp24mhvbakv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-console" ,rust-console-0.13)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-number-prefix" ,rust-number-prefix-0.3)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/mitsuhiko/indicatif")
    (synopsis "Progress bar and CLI reporting library for Rust")
    (description
     "This package provides a progress bar and CLI reporting library for
Rust.")
    (license license:expat)))

(define-public rust-indoc-1
  (package
    (name "rust-indoc")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "indoc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0diih20xsxjb159nr0dq6jxnyhq7gg10dlsnh2siikphmvm5m9z5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-unindent" ,rust-unindent-0.1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/indoc")
    (synopsis "Indented document literals for Rust")
    (description
     "This crate provides a procedural macro for indented string literals.
The @code{indoc!()} macro takes a multiline string literal and un-indents it
at compile time so the leftmost non-space character is in the first column.")
    (license (list license:expat license:asl2.0))))

(define-public rust-infer-0.2
  (package
    (name "rust-infer")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "infer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b4ziqcv0d1wga5yfqf620dkgzijsdw3ylnzq61bfaxla2d85sb4"))))
    (build-system cargo-build-system)
    (arguments `(#:tests? #false))      ;missing files
    (home-page "https://github.com/bojand/infer")
    (synopsis "Infer file types based on its magic number signature")
    (description
     "This crate infers a file types based on its magic number
signature.")
    (license license:expat)))

(define-public rust-inflate-0.4
  (package
    (name "rust-inflate")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inflate" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zxjdn8iwa0ssxrnjmywm3r1v284wryvzrf8vkc7nyf5ijbjknqw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-adler32" ,rust-adler32-1))))
    (home-page "https://github.com/PistonDevelopers/inflate.git")
    (synopsis "DEFLATE decoding")
    (description "This package provides DEFLATE decoding.")
    (license license:expat)))

(define-public rust-inflector-0.11
  (package
    (name "rust-inflector")
    (version "0.11.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "Inflector" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lqmcni21ifzyq41fhz6k1j2b23cmsx469s4g4sf01l78miqqhzy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/whatisinternet/inflector")
    (synopsis "String based inflections for Rust")
    (description "This package adds String based inflections for Rust.  Snake,
kebab, camel, sentence, class, title and table cases as well as ordinalize,
deordinalize, demodulize, foreign key, and pluralize/singularize are supported
as both traits and pure functions acting on String types.")
    (license license:bsd-2)))

(define-public rust-inotify-0.8
  (package
    (name "rust-inotify")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m74znskinrvfcp0hczwwdxvc7kvnrrailngkivk1iwknfa0mpa6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-tokio" ,rust-tokio-0.2))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/inotify-rs/inotify")
    (synopsis "Idiomatic wrapper for inotify")
    (description "This package provides an idiomatic wrapper for inotify
written in Rust.")
    (license license:isc)))

(define-public rust-inotify-0.7
  (package
    (inherit rust-inotify-0.8)
    (name "rust-inotify")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0byhq4x4b2rlbkmfrab5dni39wiq2ls1hv1nhggp7rla5inwc5j8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-inotify-0.6
  (package
    (inherit rust-inotify-0.7)
    (name "rust-inotify")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0627k5aq44knjlrc09hl017nxap3svpl79przf26y3ciycwlbda0"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-inotify-sys" ,rust-inotify-sys-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-tokio-io" ,rust-tokio-io-0.1)
        ("rust-tokio-reactor" ,rust-tokio-reactor-0.1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-inotify-sys-0.1
  (package
    (name "rust-inotify-sys")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "inotify-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1h2nwgajz80qddjm4mpma94zahxw84nscbycy9pgzbjrgjl1ljp7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/inotify-rs/inotify-sys")
    (synopsis "Inotify bindings for Rust")
    (description
     "This package provides inotify bindings for the Rust programming language.")
    (license license:isc)))

(define-public rust-input-buffer-0.3
  (package
    (name "rust-input-buffer")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "input_buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0m4pamqvr00z90cmrgjj25iwpqy6fyac53k1ms63k86m8d9aka0r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5))))
    (home-page "https://github.com/snapview/input_buffer")
    (synopsis
     "Peekable FIFO-like buffer for receiving network data efficiently")
    (description
     "This package provides a peekable FIFO-like buffer for receiving network
data efficiently.")
    (license (list license:expat license:asl2.0))))

(define-public rust-insta-0.16
  (package
    (name "rust-insta")
    (version "0.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vhqlirp75nx8qalz87qk2wjs7mzwxww0n09n2ircgw1phd94zk1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-console" ,rust-console-0.11)
        ("rust-difference" ,rust-difference-2)
        ("rust-globwalk" ,rust-globwalk-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8))))
    (home-page "https://github.com/mitsuhiko/insta")
    (synopsis "Snapshot testing library for Rust")
    (description "This package provides a snapshot testing library for Rust.")
    (license license:asl2.0)))

(define-public rust-insta-0.12
  (package
    (inherit rust-insta-0.16)
    (name "rust-insta")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j8k8rfcbdvh2s3jfj9hj7mspl32rqxqa393cw55jhg8cb09sj8d"))))
    (arguments
     `(#:cargo-test-flags
       '("--release"
         "--"
         "--skip=runtime::test_format_rust_expression")
       #:cargo-inputs
       (("rust-console" ,rust-console-0.9)
        ("rust-difference" ,rust-difference-2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-uuid" ,rust-uuid-0.8))))))

(define-public rust-insta-0.8
  (package
    (inherit rust-insta-0.16)
    (name "rust-insta")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "insta" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17rvqw9xm61prncbqi3cplphr3l2dl85sljdpyr3fz2mqjgbdfwb"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-ci-info" ,rust-ci-info-0.3)
        ("rust-console" ,rust-console-0.7)
        ("rust-difference" ,rust-difference-2)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-ron" ,rust-ron-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.8)
        ("rust-uuid" ,rust-uuid-0.7))))))

(define-public rust-instant-0.1
  (package
    (name "rust-instant")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "instant" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10k1170waz1na056wvjvkps3lz28z9pc8kp8vpy4kpp53i5a4xvp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Issue during the wasm test.
       #:cargo-inputs
       (("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-stdweb" ,rust-stdweb-0.4)
        ("rust-time" ,rust-time-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.2))))
    (home-page "https://github.com/sebcrozet/instant")
    (synopsis
     "Partial replacement for std::time::Instant that works on WASM too")
    (description
     "This package provides a partial replacement for @code{std::time::Instant}
that works on WASM too.")
    (license license:bsd-3)))

(define-public rust-interpolate-name-0.2
  (package
    (name "rust-interpolate-name")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "interpolate_name" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05vzsiqb69d1mbpaphcg4ifjsjs6g03b8pacskfcydqhh555zcxl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/lu-zero/interpolate_name")
    (synopsis "Simple procedural macro attribute for repetitive tests")
    (description
     "Simple procedural macro attribute for repetitive tests.")
    (license license:expat)))

(define-public rust-interpolation-0.2
  (package
    (name "rust-interpolation")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "interpolation" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "00icvvgc72zdgyrwwg2p0wad4hry4d2vd6l9iqpyjpmw5dykbdyk"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/pistondevelopers/interpolation")
    (synopsis "Library for interpolation")
    (description
     "This package provides a library for interpolation.")
    (license license:expat)))

(define-public rust-intervaltree-0.2
  (package
    (name "rust-intervaltree")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "intervaltree" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10k40gsv79kwnsqrzwmnmm6psa5fqws8yggavmbggvymv16hffdg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-0.6))))
    (home-page "https://github.com/main--/rust-intervaltree")
    (synopsis "Immutable interval trees")
    (description
     "This package provides a simple and generic implementation of an
immutable interval tree.")
    (license license:expat)))

(define-public rust-iovec-0.1
  (package
    (name "rust-iovec")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "iovec" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0ph73qygwx8i0mblrf110cj59l00gkmsgrpzz1rm85syz5pymcxj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/carllerche/iovec")
    (synopsis "Portable buffer type for scatter/gather I/O operations")
    (description
     "Portable buffer type for scatter/gather I/O operations.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-ipconfig-0.2
  (package
    (name "rust-ipconfig")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipconfig" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mzsagc6bk3i3fpggqlq8am5rxn4hgs297rsaya90w79xj5g3qpp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-socket2" ,rust-socket2-0.3)
        ("rust-widestring" ,rust-widestring-0.4)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winreg" ,rust-winreg-0.6))))
    (home-page "https://github.com/liranringel/ipconfig")
    (synopsis "Get network adapters and configuration information for Windows")
    (description "This package lets you get network adapters information and
network configuration for Windows.")
    (license (list license:expat license:asl2.0))))

(define-public rust-is-macro-0.1
  (package
    (name "rust-is-macro")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "is-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vjh4sdpvx1kdf1znyk3b54gkyk7f8lsasc47ypkksp3r4ypz004"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-inflector" ,rust-inflector-0.11)
        ("rust-pmutil" ,rust-pmutil-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/kdy1/is-macro")
    (synopsis "Create methods to use custom enum like Option/Result")
    (description "This package lets you easily create methods to use a custom
enum like Option/Result.")
    (license license:expat)))

(define-public rust-isahc-0.9
  (package
    (name "rust-isahc")
    (version "0.9.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "isahc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12iqz5fj0509pr813pds2fgdk649a0b6ipvy3pqjwb1ywh68m572"))))
    (build-system cargo-build-system)
    (arguments
     ;; Build fails with "failed to run custom build command for `curl-sys
     ;; v0.4.39+curl-7.74.0`".  Skip for now.
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-curl" ,rust-curl-0.4)
        ("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-flume" ,rust-flume-0.9)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-http" ,rust-http-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-sluice" ,rust-sluice-0.5)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-futures" ,rust-tracing-futures-0.2)
        ("rust-url" ,rust-url-2)
        ("rust-waker-fn" ,rust-waker-fn-1))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-indicatif" ,rust-indicatif-0.15)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-test-case" ,rust-test-case-1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.2))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("curl" ,curl)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/sagebind/isahc")
    (synopsis "Practical HTTP client")
    (description
     "Isahc is an acronym that stands for Incredible Streaming Asynchronous
HTTP Client.  It is an asynchronous HTTP client for the Rust language.  It
uses libcurl as an HTTP engine inside, and provides an easy-to-use API on top
that integrates with Rust idioms.")
    (license license:expat)))

(define-public rust-isahc-0.7
  (package
    (inherit rust-isahc-0.9)
    (name "rust-isahc")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "isahc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yy3v4r2i4hf0a436676cw4b2bnkb510gxvrldcswlrfy4kp1dqp"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-curl" ,rust-curl-0.4)
        ("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-futures-io-preview" ,rust-futures-io-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-http" ,rust-http-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-publicsuffix" ,rust-publicsuffix-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-sluice" ,rust-sluice-0.4))))))

(define-public rust-ipnet-2
  (package
    (name "rust-ipnet")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipnet" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0db147nh8jnxr23yxa7hwqn7dcjivdqi3aq4mgf2zgkqqqa2zgj7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/krisprice/ipnet")
    (synopsis "Work with IPv4 and IPv6 network addresses")
    (description "This package provides types and useful methods for working
with IPv4 and IPv6 network addresses, commonly called IP prefixes.  The new
IpNet, Ipv4Net, and Ipv6Net types build on the existing IpAddr, Ipv4Addr, and
Ipv6Addr types already provided in Rust's standard library and align to their
design to stay consistent.  The module also provides useful traits that extend
Ipv4Addr and Ipv6Addr with methods for Add, Sub, BitAnd, and BitOr operations.
The module only uses stable feature so it is guaranteed to compile using the
stable toolchain.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ipnetwork-0.17
  (package
    (name "rust-ipnetwork")
    (version "0.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ipnetwork" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sviri9ksb3cmhx3h0rcfy8pvpx7f0cx5ba1z87ydvf07amymhq2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://crates.io/crates/ipnetwork")
    (synopsis "Work with IP CIDRs in Rust")
    (description "This package provides a library to work with IP CIDRs in
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-iron-0.6
  (package
    (name "rust-iron")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "iron" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s4mf8395f693nhwsr0znw3j5frzn56gzllypyl50il85p50ily6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-hyper" ,rust-hyper-0.10)
        ("rust-hyper-native-tls" ,rust-hyper-native-tls-0.3)
        ("rust-log" ,rust-log-0.3)
        ("rust-mime-guess" ,rust-mime-guess-1)
        ("rust-modifier" ,rust-modifier-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-plugin" ,rust-plugin-0.2)
        ("rust-typemap" ,rust-typemap-0.3)
        ("rust-url" ,rust-url-1))))
    (home-page "https://github.com/iron/iron")
    (synopsis "Extensible, concurrency focused web development in Rust")
    (description
     "Iron is a high level web framework built in and for Rust.  It is highly
concurrent and can scale horizontally on more machines behind a load balancer
or by running more threads on a more powerful machine.  Iron avoids the
bottlenecks encountered in highly concurrent code by avoiding shared writes
and locking in the core framework.")
    (license license:expat)))

(define-public rust-is-executable
  (package
    (name "rust-is-executable")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "is_executable" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0xy516afjh79a0d53j9v4w5mgi2s0r6f6qynnyz8g0dwi8xmab9h"))))
    (build-system cargo-build-system)
    (arguments
     `(;; One test tries to invoke 'cargo readme' which does not exist and aborts.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-test
           (lambda _
             (substitute* "tests/tests.rs"
               (("panic!\\(\"Run `cargo readme > README.md` to update README.md\"\\)")
                "return;"))
             #t)))
       #:cargo-inputs
       (("rust-diff" ,rust-diff-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/fitzgen/is_executable")
    (synopsis "Find executable files at path")
    (description
     "This package provides a small helper function which determines
whether or not a given path points to an executable file.")
    (license (list license:expat license:asl2.0))))

(define-public rust-iso8601-0.1
  (package
    (name "rust-iso8601")
    (version "0.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "iso8601" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0xy48qyfmirslaj4dy6n4g8b564jap3cjiql35fmj5vgii7ldp0i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-nom" ,rust-nom-1))))
    (home-page "https://github.com/badboy/iso8601")
    (synopsis "Parsing ISO8601 dates using nom")
    (description "Parsing ISO8601 dates using nom.")
    (license license:expat)))

(define-public rust-itertools-0.10
  (package
    (name "rust-itertools")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06dkghwi1a6ah2103gibxnr2ys762m5x4rp75x0q43imis8p5m9p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-either" ,rust-either-1))))
    (home-page "https://github.com/rust-itertools/itertools")
    (synopsis "Extra iterator adaptors, methods, free functions, and macros")
    (description
     "This package provides extra iterator adaptors, iterator methods, free
functions, and macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-itertools-0.9
  (package
    (inherit rust-itertools-0.10)
    (name "rust-itertools")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0jyml7ygr7kijkcjdl3fk5f34y5h5jsavclim7l13zjiavw1hkr8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-cargo-toml
           (lambda _
             (substitute* "Cargo.toml"
               (("=0.3.0") "0.3"))
             #t)))))))

(define-public rust-itertools-0.8
  (package
    (inherit rust-itertools-0.9)
    (name "rust-itertools")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1154j48aw913v5jnyhpxialxhdn2sfpl4d7bwididyb1r05jsspm"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-itertools-0.7
  (package
    (inherit rust-itertools-0.8)
    (name "rust-itertools")
    (version "0.7.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "03cpsj26xmyamcalclqzr1i700vwx8hnbgxbpjvs354f8mnr8iqd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.5))))))

(define-public rust-itertools-0.5
  (package
    (inherit rust-itertools-0.7)
    (name "rust-itertools")
    (version "0.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itertools" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1z4lyrakgynvhylya72qb3vizmxmd62whjmg4r8k01d4inbxccs8"))))
    (arguments
     `(#:tests? #f ; Tests fail to compile
       #:cargo-inputs
       (("rust-either" ,rust-either-1))
       #:cargo-development-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-itertools-num-0.1
  (package
    (name "rust-itertools-num")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itertools-num" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rr7ig9nkpampcas23s91x7yac6qdnwssq3nap522xbgkqps4wm8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-itertools" ,rust-itertools-0.8)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))
    (home-page
     "https://github.com/bluss/itertools-num")
    (synopsis
     "Numerical iterator tools")
    (description
     "Numerical iterator tools.  Extra iterators and iterator methods
and functions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-itoa-0.4
  (package
    (name "rust-itoa")
    (version "0.4.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "itoa" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "13nxqrfnh83a7x5rw4wq2ilp8nxvwy74dxzysdg59dbxqk0agdxq"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/itoa")
    (synopsis "Fast functions for printing integer primitives")
    (description "This crate provides fast functions for printing integer
primitives to an @code{io::Write}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-itoa-0.3
  (package
    (inherit rust-itoa-0.4)
    (name "rust-itoa")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itoa" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "136vwi6l2k1vrlvfx49lhficj813pk88xrcx1q3axqh1mwms6943"))))))

(define-public rust-itoa-0.1
 (package
   (inherit rust-itoa-0.4)
   (name "rust-itoa")
   (version "0.1.1")
   (source
     (origin
       (method url-fetch)
       (uri (crate-uri "itoa" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32
         "18g7p2hrb3dk84z3frfgmszfc9hjb4ps9vp99qlb1kmf9gm8hc5f"))))))

(define-public rust-ivf-0.1
  (package
    (name "rust-ivf")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ivf" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wfjf3rilqavrhvwagzinvng9dg28wcjk3c6c6p5qmc1xy65qfh1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitstream-io" ,rust-bitstream-io-0.8))))
    (home-page "https://github.com/xiph/rav1e")
    (synopsis "Simple ivf muxer")
    (description "This package provides a simple ivf muxer.")
    (license license:bsd-2)))

(define-public rust-jemalloc-sys-0.3
  (package
    (name "rust-jemalloc-sys")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "jemalloc-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ify9vlql01qhfxlj7d4p9jvcp90mj2h69nkbq7slccvbhzryfqd"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "jemalloc") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1)
        ("rust-fs-extra" ,rust-fs-extra-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))
    (native-inputs
     `(("jemalloc" ,jemalloc)))
    (home-page "https://github.com/gnzlbg/jemallocator")
    (synopsis "Rust FFI bindings to jemalloc")
    (description "This package provides Rust FFI bindings to jemalloc.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-jemalloc-sys-0.1
  (package
    (inherit rust-jemalloc-sys-0.3)
    (name "rust-jemalloc-sys")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemalloc-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1bh07rlzgg39ys1lsgnpxgvjj6blagp2h17fx267d0g3a272rimz"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "jemalloc") #t))))))

(define-public rust-jemallocator-0.3
  (package
    (name "rust-jemallocator")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemallocator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0sabfa5118b7l4ars5n36s2fjyfn59w4d6mjs6rrmsa5zky67bj3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-jemalloc-sys" ,rust-jemalloc-sys-0.3)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-0.1))))
    (home-page "https://github.com/gnzlbg/jemallocator")
    (synopsis "Rust allocator backed by jemalloc")
    (description
     "This package provides a Rust allocator backed by jemalloc.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jemallocator-0.1
  (package
    (inherit rust-jemallocator-0.3)
    (name "rust-jemallocator")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jemallocator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1csabk36p06nlh3qxxsg6nkf074b2jq2cld5zriq0xazqqmd834z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jemalloc-sys" ,rust-jemalloc-sys-0.1)
        ("rust-libc" ,rust-libc-0.2))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))
    (native-inputs
     `(("jemalloc" ,jemalloc)))))

(define-public rust-jetscii-0.3
  (package
    (name "rust-jetscii")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jetscii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sq6d6c9vi44gkr566w2f1d4n6mmrjx8gjdwgnhkgcsg051j391j"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/shepmaster/jetscii")
    (synopsis
     "Search strings and byte slices for sets of ASCII characters or bytes")
    (description
     "This package provides a tiny library to efficiently search strings and
byte slices for sets of ASCII characters or bytes.")
    (license license:expat)))

(define-public rust-jni-0.18
  (package
    (name "rust-jni")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1brglk3kfia9wkr6rkm6p297b8qk6rv3k8rf6jjiqc74l49735i4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cesu8" ,rust-cesu8-1)
        ("rust-combine" ,rust-combine-4)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/jni-rs/jni-rs")
    (synopsis "Rust bindings to the JNI")
    (description
     "This package provides Rust bindings to the JNI.  It permits to
implement native Java methods for JVM and Android in Rust, call Java
code from Rust, embed JVM in Rust applications and use any Java
libraries.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jni-0.14
  (package
    (inherit rust-jni-0.18)
    (name "rust-jni")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00jl4jzzbbcf1nyziras5drp501xsk89g0132pwg194ilh6k308r"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cesu8" ,rust-cesu8-1)
        ("rust-combine" ,rust-combine-3)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-walkdir" ,rust-walkdir-2))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-jni-glue-0.0
  (package
    (name "rust-jni-glue")
    (version "0.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni-glue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "054kc2hkdfjiihy7ssrn97s9hs35c2v32ph2h0jlv4vkazx39ddb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/MaulingMonkey/jni-bindgen")
    (synopsis "Glue code to accompany the jni-bindgen code generator")
    (description
     "This package provides manually written glue code to accompany
the jni-bindgen code generator for binding to JVM APIs from Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jni-sys-0.3
  (package
    (name "rust-jni-sys")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jni-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c01zb9ygvwg9wdx2fii2d39myzprnpqqhy7yizxvjqp5p04pbwf"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-jni-sys")
    (synopsis "Rust definitions corresponding to @file{jni.h}")
    (description
     "This package provides Rust definitions corresponding to
@file{jni.h}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jobserver-0.1
  (package
    (name "rust-jobserver")
    (version "0.1.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jobserver" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q2w80v8p2pbfm8ayhjs6zi11a1hp4535z4ck8kg872z8ldnrc37"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-tokio-core" ,rust-tokio-core-0.1)
        ("rust-tokio-process" ,rust-tokio-process-0.2))))
    (home-page "https://github.com/alexcrichton/jobserver-rs")
    (synopsis "GNU make jobserver for Rust")
    (description
     "An implementation of the GNU make jobserver for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-jsonrpc-core-14
  (package
    (name "rust-jsonrpc-core")
    (version "14.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "jsonrpc-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qkvgkr05sg0j25jqgw7zcw4r1agzg8gnfnrmw1rgyqz283p6x50"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/paritytech/jsonrpc")
    (synopsis "Transport agnostic Rust implementation of JSON-RPC 2.0")
    (description
     "This package provides a transport agnostic Rust implementation of
JSON-RPC 2.0 specification.")
    (license license:expat)))

(define-public rust-js-sys-0.3
  (package
    (name "rust-js-sys")
    (version "0.3.46")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "js-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xc1llkp23q8ac2wdwh46y6gjbc34prrd98g5my9qz4zja1p6gfg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://rustwasm.github.io/wasm-bindgen/")
    (synopsis "Bindings for all JS global objects and functions in WASM")
    (description
     "Bindings for all JS global objects and functions in all JS environments
like Node.js and browsers, built on @code{#[wasm_bindgen]} using the
wasm-bindgen crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-json-0.11
  (package
    (name "rust-json")
    (version "0.11.15")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "json" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1rg9jxf6bpbwis3ixd5ak8rp37him7n4z8awz4ssrxl6hyplbhlj"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/maciejhirsz/json-rust")
    (synopsis "JSON implementation in Rust")
    (description "This crate provides a JSON implementation in Rust, reducing
friction with idiomatic Rust structs to ease interopability.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-juliex-0.3
  (package
    (name "rust-juliex")
    (version "0.3.0-alpha.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juliex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g4r23i7dkpid8zmkg6aiw73gkp7jagwhrjfi12yklyx4dczvp12"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures-preview" ,rust-futures-preview-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://github.com/withoutboats/juliex")
    (synopsis "Very basic future executor")
    (description
     "juliex is a concurrent executor for Rust futures.  It is implemented as
a threadpool executor using a single, shared queue.  Algorithmically, it is
very similar to the Threadpool executor provided by the futures crate.  The
main difference is that juliex uses a crossbeam channel and performs a single
allocation per spawned future, whereas the futures Threadpool uses std
concurrency primitives and multiple allocations.")
    (license (list license:expat license:asl2.0))))

(define-public rust-juniper-codegen-0.14
  (package
    (name "rust-juniper-codegen")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juniper_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06ym8568k9p75kvnfc4ywqbkzaa4ib6gngx9vpbsjwg9v0sg42nl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;FIXME: fail due to unresolved import
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-juniper" ,rust-juniper-0.14))))
    (home-page "https://github.com/graphql-rust/juniper")
    (synopsis "Internal custom derive trait for Juniper GraphQL")
    (description
     "This package provides an internal custom derive trait for Juniper
GraphQL.")
    (license license:bsd-2)))

(define-public rust-juniper-0.14
  (package
    (name "rust-juniper")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "juniper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s56rb31yddhvjynl5bk8jihcdln8h5yfsx63kfxdhzvw98vlqpn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-juniper-codegen" ,rust-juniper-codegen-0.14)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2)
        ("rust-uuid" ,rust-uuid-0.7))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/graphql-rust/juniper")
    (synopsis "GraphQL server library for Rust")
    (description
     "Juniper makes it possible to write GraphQL servers in Rust that are
type-safe and fast.  It also tries to make declaring and resolving GraphQL
schemas convenient.

Juniper does not include a web server.  Instead it provides building blocks to
make integration with existing servers straightforward.  It optionally
provides a pre-built integration for the Actix, Hyper, Iron, Rocket, and Warp
frameworks, including embedded Graphiql and GraphQL Playground for easy
debugging.")
    (license license:bsd-2)))

(define-public rust-keccak-0.1
  (package
    (name "rust-keccak")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "keccak" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "19ybbvxrdk9yy65rk7f5ad0hcxszkjwph68yzkj3954lnir1bhk7"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://crates.io/crates/keccak")
    (synopsis "Keccak-f sponge function for Rust")
    (description "This package provides a keccak-f sponge function")
    (license license:cc0)))

(define-public rust-kernel32-sys-0.2
  (package
    (name "rust-kernel32-sys")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "kernel32-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1389av0601a9yz8dvx5zha9vmkd6ik7ax0idpb032d28555n41vm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.2)
        ("rust-winapi-build" ,rust-winapi-build-0.1))))
    (home-page "https://github.com/retep998/winapi-rs")
    (synopsis "Function definitions for the Windows API library kernel32")
    (description "Contains function definitions for the Windows API library
kernel32.")
    (license license:expat)))

(define-public rust-khronos-api-3
  (package
    (name "rust-khronos-api")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "khronos-api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1p0xj5mlbagqyvvnv8wmv3cr7l9y1m153888pxqwg3vk3mg5inz2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/brendanzab/gl-rs/")
    (synopsis "Khronos XML API Registry")
    (description
     "The Khronos XML API Registry, exposed as byte string constants.")
    (license license:asl2.0)))

(define-public rust-kv-log-macro-1
  (package
    (name "rust-kv-log-macro")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "kv-log-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zwp4bxkkp87rl7xy2dain77z977rvcry1gmr5bssdbn541v7s0d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4))
       #:cargo-development-inputs
       (("rust-femme" ,rust-femme-1))))
    (home-page "https://github.com/yoshuawuyts/kv-log-macro")
    (synopsis "Log macro for log's kv-unstable backend")
    (description
     "This package provides a Log macro for log's kv-unstable backend.")
    (license (list license:expat license:asl2.0))))

(define-public rust-language-tags-0.2
  (package
    (name "rust-language-tags")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "language-tags" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "16hrjdpa827carq5x4b8zhas24d8kg4s16m6nmmn1kb7cr5qh7d9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-heapsize" ,rust-heapsize-0.3)
        ("rust-heapsize-plugin" ,rust-heapsize-plugin-0.1))))
    (home-page "https://github.com/pyfisch/rust-language-tags")
    (synopsis "Language tags for Rust")
    (description
     "Language tags can be used identify human languages, scripts e.g. Latin
script, countries and other regions.  They are commonly used in HTML and HTTP
@code{Content-Language} and @code{Accept-Language} header fields.  This package
currently supports parsing (fully conformant parser), formatting and comparing
language tags.")
    (license license:expat)))

(define-public rust-lab-0.8
  (package
    (name "rust-lab")
    (version "0.8.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lab" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ysnbviwi35mq6xyz9c59mpgigyfp4s4y2mispxzrms4vk83bx15"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-rand" ,rust-rand-0.5))))
    (home-page "https://github.com/TooManyBees/lab")
    (synopsis "Convert RGB to CIE-LAB for Rust")
    (description
     "This package contains tools for converting RGB colors to the CIE-LAB color
space, and comparing differences in color.")
    (license license:expat)))

(define-public rust-lab-0.7
  (package
    (inherit rust-lab-0.8)
    (name "rust-lab")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lab" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0g692d489lq01pv3mzfhxd98j0r22lw28l6bk112m74djlfzxdmw"))))
    (arguments
     `(#:tests? #f  ; test suite assumes avx2 support
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-rand" ,rust-rand-0.5))))))

(define-public rust-lab-0.4
  (package
    (inherit rust-lab-0.8)
    (name "rust-lab")
    (version "0.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lab" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0h4ig5bvzmwlzd74zj7b4sh7kzi3c6mjjnw7yjz8ijxvr4mrcr1s"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-lalrpop-0.19
  (package
    (name "rust-lalrpop")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lalrpop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j52sybjhn82ydgsmnw7nkywjyb7pvg50mvyb48m7vdq3wcmdyv0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
      (("rust-ascii-canvas" ,rust-ascii-canvas-2)
       ("rust-atty" ,rust-atty-0.2)
       ("rust-bit-set" ,rust-bit-set-0.5)
       ("rust-diff" ,rust-diff-0.1)
       ("rust-docopt" ,rust-docopt-1)
       ("rust-ena" ,rust-ena-0.14)
       ("rust-itertools" ,rust-itertools-0.9)
       ("rust-lalrpop-util" ,rust-lalrpop-util-0.19)
       ("rust-petgraph" ,rust-petgraph-0.5)
       ("rust-regex" ,rust-regex-1)
       ("rust-regex-syntax" ,rust-regex-syntax-0.6)
       ("rust-serde" ,rust-serde-1)
       ("rust-serde-derive" ,rust-serde-derive-1)
       ("rust-sha2" ,rust-sha2-0.8)
       ("rust-string-cache" ,rust-string-cache-0.8)
       ("rust-term" ,rust-term-0.5)
       ("rust-unicode-xid" ,rust-unicode-xid-0.2))
      #:cargo-development-inputs
      (("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/lalrpop/lalrpop")
    (synopsis "Convenient LR(1) parser generator for Rust")
    (description "LALRPOP is a Rust parser generator framework with usability
as its primary goal.  You should be able to write compact, DRY, readable
grammars.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-lalrpop-0.17
  (package
    (inherit rust-lalrpop-0.19)
    (name "rust-lalrpop")
    (version "0.17.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lalrpop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nv7ma8cgw3r1fcma7gy06fwwlpl4fkz91mxv5kjhiaxwyc3dp34"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
      (("rust-ascii-canvas" ,rust-ascii-canvas-2)
       ("rust-atty" ,rust-atty-0.2)
       ("rust-bit-set" ,rust-bit-set-0.5)
       ("rust-diff" ,rust-diff-0.1)
       ("rust-docopt" ,rust-docopt-1)
       ("rust-ena" ,rust-ena-0.13)
       ("rust-itertools" ,rust-itertools-0.8)
       ("rust-lalrpop-util" ,rust-lalrpop-util-0.17)
       ("rust-petgraph" ,rust-petgraph-0.4)
       ("rust-regex" ,rust-regex-1)
       ("rust-regex-syntax" ,rust-regex-syntax-0.6)
       ("rust-serde" ,rust-serde-1)
       ("rust-serde-derive" ,rust-serde-derive-1)
       ("rust-sha2" ,rust-sha2-0.8)
       ("rust-string-cache" ,rust-string-cache-0.7)
       ("rust-term" ,rust-term-0.5)
       ("rust-unicode-xid" ,rust-unicode-xid-0.2))
      #:cargo-development-inputs
      (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-lalrpop-util-0.19
  (package
    (name "rust-lalrpop-util")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lalrpop-util" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0224r8gsbk8and96nhwgzdj4hc1c01g78zmvv3x4f5jnzwg1cwb7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-regex" ,rust-regex-1))))
  (home-page "https://github.com/lalrpop/lalrpop")
  (synopsis "Runtime library for parsers generated by LALRPOP")
  (description "THis package provides the runtime library for parsers
generated by LALRPOP.")
  (license (list license:asl2.0 license:expat))))

(define-public rust-lalrpop-util-0.17
  (package
    (inherit rust-lalrpop-util-0.19)
    (name "rust-lalrpop-util")
    (version "0.17.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lalrpop-util" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z4bjn3g9232n1im5p6mn9mwlvw5aj5iac6hbjmljqxkhf3d2xy2"))))))

(define-public rust-lazy-bytes-cast-5
  (package
    (name "rust-lazy-bytes-cast")
    (version "5.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lazy-bytes-cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sr0dy1jfg7bjwm9js4hk0ngl0cmgparq2idv1m1bkc9y2cp898h"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/DoumanAsh/lazy-bytes-cast")
    (synopsis "Lazy casts from and to byte arrays")
    (description
     "This crate provides simple methods to cast from and into byte arrays.")
    (license license:boost1.0)))

(define-public rust-lazy-static-1
  (package
    (name "rust-lazy-static")
    (version "1.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lazy_static" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-spin" ,rust-spin-0.5))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))
    (inputs
     `(("rust-spin" ,rust-spin-0.5)))
    (home-page  "https://github.com/rust-lang-nursery/lazy-static.rs")
    (synopsis "Macro for declaring lazily evaluated statics in Rust")
    (description
     "This package provides a macro for declaring lazily evaluated statics in
Rust.  Using this macro, it is possible to have @code{static}s that require code
to be executed at runtime in order to be initialized.  This includes anything
requiring heap allocations, like vectors or hash maps, as well as anything that
requires non-const function calls to be computed.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-lazy-static-0.2
  (package
    (inherit rust-lazy-static-1)
    (name "rust-lazy-static")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lazy_static" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wxy8vak7jsx6r8gx475pjqpx11p2bfq4wvw6idmqi31mp3k7w3n"))))
    (arguments
     `(#:tests? #f      ; Tests fail to compile.
       #:cargo-inputs
       (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
        ("rust-spin" ,rust-spin-0.4))))))

(define-public rust-lazy-static-0.1
  (package
    (inherit rust-lazy-static-0.2)
    (name "rust-lazy-static")
    (version "0.1.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lazy_static" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05vl1h4b0iv800grsdyc3fg2bq29p70wjav6zpjvxxd5i8d6s66g"))))
    (arguments '())))

(define-public rust-lazycell-1
  (package
    (name "rust-lazycell")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lazycell" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gvqycmpv7parc98i6y64ai7rvxrn1947z2a6maa02g4kvxdd55j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-clippy" ,rust-clippy-0.0))))
    (home-page "https://github.com/indiv0/lazycell")
    (synopsis "Lazily filled Cell struct")
    (description
     "This package provides a library providing a lazily filled Cell struct.")
    (license (list license:expat license:asl2.0))))

(define-public rust-lexical-core-0.7
  (package
    (name "rust-lexical-core")
    (version "0.7.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lexical-core" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05i6b69ay8xbxw88vx89vglb7xm5n8ky82hax7d5a7z60bdccrfv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.5)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dtoa" ,rust-dtoa-0.4)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-static-assertions" ,rust-static-assertions-1))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-quickcheck" ,rust-quickcheck-0.9))))
    (home-page
     "https://github.com/Alexhuszagh/rust-lexical/tree/master/lexical-core")
    (synopsis
     "Lexical, to- and from-string conversion routines")
    (description
     "Lexical, to- and from-string conversion routines.")
    (license (list license:expat license:asl2.0))))

(define-public rust-lexical-core-0.4
  (package
    (inherit rust-lexical-core-0.7)
    (name "rust-lexical-core")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lexical-core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1gr5y3ykghd3wjc00l3iizkj1dxylyhwi6fj6yn2qg06nzx771iz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dtoa" ,rust-dtoa-0.4)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-stackvector" ,rust-stackvector-1)
        ("rust-static-assertions" ,rust-static-assertions-0.3))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-proptest" ,rust-proptest-0.9)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-libc-0.2
  (package
    (name "rust-libc")
    (version "0.2.86")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "074b38mq1rx3dgg7sf952d4ccywq450zymk7gzn5q9z39f92sa5p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/rust-lang/libc")
    (synopsis "Raw FFI bindings to platform libraries like libc")
    (description
     "The rust libc crate provides all of the definitions necessary to easily
interoperate with C code (or \"C-like\" code) on each of the platforms that Rust
supports.  This includes type definitions (e.g., c_int), constants (e.g., EINVAL)
as well as function headers (e.g., malloc).

This crate exports all underlying platform types, functions, and constants under
the crate root, so all items are accessible as @samp{libc::foo}.  The types and
values of all the exported APIs match the platform that libc is compiled for.")
    (license (list license:expat
                   license:asl2.0))))

(define-public rust-libc-print-0.1
  (package
    (name "rust-libc-print")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libc-print" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cjvz622b9bmf32q3mzmxv9ddxfdla6z2v647v8f3qx7lci9kmji"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/mmastrac/rust-libc-print")
    (synopsis "Println! and eprintln! without stdlib")
    (description "This package provices @code{println!} and @code{eprintln!}
macros on libc without stdlib.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-libflate-1
  (package
    (name "rust-libflate")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libflate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jarv5ildsm0ci4prd4gz7fqypifhp9xk34z9w49rchx7q1ckfp9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-libflate-lz77" ,rust-libflate-lz77-1)
        ("rust-rle-decode-fast" ,rust-rle-decode-fast-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2))))
    (home-page "https://github.com/sile/libflate")
    (synopsis "DEFLATE algorithm and related formats (ZLIB, GZIP)")
    (description "This package provides a Rust implementation of DEFLATE
algorithm and related formats (ZLIB, GZIP).")
    (license license:expat)))

(define-public rust-libflate-0.1
  (package
    (inherit rust-libflate-1)
    (name "rust-libflate")
    (version "0.1.27")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libflate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1p8z839c5lpl0g01mf8iglys9lgcjxw6xjw56crhwp8z7gs5s4yr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-adler32" ,rust-adler32-1)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-rle-decode-fast" ,rust-rle-decode-fast-1)
        ("rust-take-mut" ,rust-take-mut-0.2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2))))))

(define-public rust-libflate-lz77-1
  (package
    (name "rust-libflate-lz77")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libflate_lz77" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06xir79gmp97mdnlnjclk5zlzgkf5s6qvwilcd4gq9j9gngz11ij"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-libflate" ,rust-libflate-0.1))))
    (home-page "https://github.com/sile/libflate")
    (synopsis "LZ77 encoder for libflate crate")
    (description "This package provides a LZ77 encoder for libflate crate.")
    (license license:expat)))

(define-public rust-libfuzzer-sys-0.3
  (package
    (name "rust-libfuzzer-sys")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libfuzzer-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vv42rpvmfr83hlblyrjf8ifilsmc3d5gcznblmghx5jnsj89wgw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-0.4)
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/rust-fuzz/libfuzzer")
    (synopsis "Wrapper around LLVM's libFuzzer runtime")
    (description
     "This package provides a wrapper around LLVM's libFuzzer runtime.")
    (license
     (list license:expat license:asl2.0 license:ncsa))))

(define-public rust-libgit2-sys-0.12
  (package
    (name "rust-libgit2-sys")
    (version "0.12.17+1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libgit2-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hc89v7kp2b3rbc64cxq024shd85m8vqcs14i3gjclblr9jxzszl"))
       (modules '((guix build utils)))
       (snippet
        '(begin (delete-file-recursively "libgit2") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libssh2-sys" ,rust-libssh2-sys-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("libgit2" ,libgit2)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/rust-lang/git2-rs")
    (synopsis "Native bindings to the libgit2 library")
    (description
     "This package provides native Rust bindings to the @code{libgit2}
library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-libgit2-sys-0.10
  (package
    (inherit rust-libgit2-sys-0.12)
    (name "rust-libgit2-sys")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libgit2-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0l9fvki7qxsl97vgzqwlv75nl213a5vxw7b1jaik97ala356pv6r"))
       (modules '((guix build utils)))
       (snippet
        '(begin (delete-file-recursively "libgit2") #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-libssh2-sys" ,rust-libssh2-sys-0.2)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))))

(define-public rust-libgit2-sys-0.8
  (package
    (inherit rust-libgit2-sys-0.10)
    (name "rust-libgit2-sys")
    (version "0.8.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libgit2-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0y2mibmx7wy91s2kmb2gfb29mrqlqaxpy5wcwr8s1lwws7b9w5sc"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "libgit2") #t))))))

(define-public rust-libgit2-sys-0.7
  (package
    (inherit rust-libgit2-sys-0.8)
    (name "rust-libgit2-sys")
    (version "0.7.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libgit2-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wcvg2qqra2aviasvqcscl8gb2rnjnd6h998wy5dlmf2bnriqi28"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "libgit2") #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libssh2-sys" ,rust-libssh2-sys-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))))

(define-public rust-libloading-0.6
  (package
    (name "rust-libloading")
    (version "0.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libloading" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10wq4a4jkman8k6y0v2cw3d38y1h3rw6d2in5klggm8jg90k46im"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (inputs
     `(("rust-cfg-if" ,rust-cfg-if-1)
       ("rust-winapi" ,rust-winapi-0.3)))
    (home-page "https://github.com/nagisa/rust_libloading/")
    (synopsis "Safer binding to dynamic library loading utilities")
    (description "This package provides a safer binding to dynamic library
loading utilities.")
    (license license:isc)))

(define-public rust-libloading-0.5
  (package
    (name "rust-libloading")
    (version "0.5.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libloading" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0lyply8rcqc8agajzxs7bq6ivba9dnn1i68kgb9z2flnfjh13cgj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3)
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/nagisa/rust_libloading/")
    (synopsis "Rust library for loading dynamic libraries")
    (description
     "A memory-safer wrapper around system dynamic library loading primitives.
The most important safety guarantee by this library is prevention of
dangling-Symbols that may occur after a Library is unloaded.  Using this library
allows loading dynamic libraries (also known as shared libraries) as well as use
functions and static variables these libraries contain.")
    (license license:isc)))

(define-public rust-libloading-0.3
  (package
    (inherit rust-libloading-0.5)
    (name "rust-libloading")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libloading" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0risz19rllhdc0d7nkpwkf4pcbjjgg1iim0kkmzb6kkp874hl0ha"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Some test libraries not included in release.
       #:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-winapi" ,rust-winapi-0.2)
        ("rust-target-build-utils" ,rust-target-build-utils-0.3))))))

(define-public rust-libm-0.2
  (package
    (name "rust-libm")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libm" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0akh56sh51adhagmk9l84dyrlz60gv8ri05xhr13i1b18czkpmy7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rand" ,rust-rand-0.6))
       #:cargo-development-inputs
       (("rust-no-panic" ,rust-no-panic-0.1))))
    (home-page "https://github.com/rust-lang/libm")
    (synopsis "Libm in pure Rust")
    (description "This package provides an implementation of libm in pure Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-libm-0.1
  (package
    (inherit rust-libm-0.2)
    (name "rust-libm")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libm" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16pc0gx4gkg0q2s1ssq8268brn14j8344623vwhadmivc4lsmivz"))))))

(define-public rust-libmimalloc-sys-0.1
  (package
    (name "rust-libmimalloc-sys")
    (version "0.1.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libmimalloc-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bbm03687j9fspvk6nqspmjlvchlvbxydl0mrc1x9i1k6kqiy5c2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cty" ,rust-cty-0.2)
        ("rust-cmake" ,rust-cmake-0.1))))
    (native-inputs
     `(("cmake" ,cmake-minimal)))
    (home-page "https://github.com/purpleprotocol/mimalloc_rust")
    (synopsis "Sys crate wrapping the mimalloc allocator")
    (description "This package provides a sys crate wrapping the mimalloc
allocator.")
    (license license:expat)))

(define-public rust-libnghttp2-sys-0.1
  (package
    (name "rust-libnghttp2-sys")
    (version "0.1.4+1.41.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libnghttp2-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wcd93a8cw1h9y25834160y6ng982fi0qcd277hpjvhnvz34wqh3"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (delete-file-recursively "nghttp2")
            (substitute* "Cargo.toml"
              (("false")
               "false\n[build-dependencies.pkg-config]\nversion = \"0.3\"\n"))
            (delete-file "build.rs")
            (with-output-to-file "build.rs"
              (lambda _
                (format #t "fn main() {~@
                        println!(\"cargo:rustc-link-lib=nghttp2\");~@
                        }~%")))
                 #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (inputs
     `(("nghttp2" ,nghttp2 "lib")
       ("pkg-config" ,pkg-config)))
    (home-page "https://github.com/alexcrichton/nghttp2-rs")
    (synopsis "FFI bindings for libnghttp2 (nghttp2)")
    (description
     "This package provides FFI bindings for libnghttp2 (nghttp2).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-libpijul-0.12
  (package
    (name "rust-libpijul")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libpijul" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18d9n8xaq5ncq3375f0xrr96l8si1frczgzdlrz3fl1jby8vbl6f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; backend::file_header::test_fileheader_alignment fails
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-bincode" ,rust-bincode-1)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-bs58" ,rust-bs58-0.2)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-diffs" ,rust-diffs-0.3)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-ignore" ,rust-ignore-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-sanakirja" ,rust-sanakirja-0.10)
        ("rust-sequoia-openpgp" ,rust-sequoia-openpgp-0.9)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-toml" ,rust-toml-0.4))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("clang" ,clang)
       ("nettle" ,nettle)
       ("openssl" ,openssl)))
    (home-page "https://pijul.org/")
    (synopsis "Library component of the pijul version control system")
    (description
     "This crate contains the core API to access Pijul repositories.

The key object is a @code{Repository}, on which @code{Txn} (immutable
transactions) and @code{MutTxn} (mutable transactions) can be started, to
perform a variety of operations.

Another important object is a @code{Patch}, which encodes two different pieces
of information:

@itemize
@item Information about deleted and inserted lines between two versions of a
file.
@item Information about file moves, additions and deletions.
@end itemize")
    (license license:gpl2+)))

(define-public rust-libsqlite3-sys-0.20
  (package
    (name "rust-libsqlite3-sys")
    (version "0.20.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libsqlite3-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g9gbjjpm9phhs991abkzmacszibp94m5nrh331ycd99y9ci1lv4"))))
    (build-system cargo-build-system)
    (inputs
     `(("sqlite" ,sqlite)))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       ;; build dependencies
       (("rust-bindgen" ,rust-bindgen-0.55)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))
    (home-page "https://github.com/rusqlite/rusqlite")
    (synopsis "Native bindings to the libsqlite3 library")
    (description "Native bindings to the libsqlite3 library")
    (license license:expat)))

(define-public rust-libsqlite3-sys-0.18
  (package
    (inherit rust-libsqlite3-sys-0.20)
    (name "rust-libsqlite3-sys")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libsqlite3-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ggpbnis0rci97ln628y2v6pkgfhb6zgc8rsp444mkdfph14lw0y"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (delete-file-recursively "sqlite3")
           ;; Enable unstable features
           (substitute* "src/lib.rs"
             (("#!\\[allow\\(non_snake_case, non_camel_case_types\\)\\]" all)
              (string-append "#![feature(non_exhaustive)]\n" all)))))))
    (arguments
     `(#:cargo-inputs
       ;; build-dependencies
       (("rust-bindgen" ,rust-bindgen-0.53)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-libsqlite3-sys-0.15
  (package
    (inherit rust-libsqlite3-sys-0.20)
    (name "rust-libsqlite3-sys")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "libsqlite3-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "104n0s4f46zprppjq6y82y0wjh1r2cgwzw26w914yj30rizy1cbj"))))
    (build-system cargo-build-system)
    (inputs
     `(("sqlite" ,sqlite)))
    (arguments
     `(#:cargo-inputs
       ;; build dependencies
       (("rust-bindgen" ,rust-bindgen-0.49)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))))

(define-public rust-libz-sys-1
  (package
    (name "rust-libz-sys")
    (version "1.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libz-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1q25cb8vs113si7q2p0innhi8jk0wpq37hqi2wcc219hcmw43cr3"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "src/zlib")
                 (delete-file-recursively "src/zlib-ng")
                 #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1)
        ("rust-cmake" ,rust-cmake-0.1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))
    (native-inputs
     `(("pkg-config" ,pkg-config)
       ("zlib" ,zlib)))
    (home-page "https://github.com/rust-lang/libz-sys")
    (synopsis "Bindings to the system libz library")
    (description
     "This package provides bindings to the system @code{libz} library (also
known as zlib).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-line-0.1
  (package
    (name "rust-line")
    (version "0.1.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "line" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pissvrl5398701zlfd22w51ca32vhw83vbsl58a330hr4w5ra04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-utf8parse" ,rust-utf8parse-0.1))))
    (home-page "https://crates.io/crates/line")
    (synopsis "Rust implementation of line editing in a terminal")
    (description
     "The main goals of this library are:

@itemize
@item Portability: should work on any system (Unix or Windows).
@item Support: was written for a real-world project (Pijul), so support is
unlikely to stop soon.
@item Output quality: avoid usual blinking terminal lines that older C
libraries have.
@end itemize")
    (license (list license:asl2.0 license:expat))))

(define-public rust-line-wrap-0.1
  (package
    (name "rust-line-wrap")
    (version "0.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "line-wrap" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ffa2whkyh9mwvdlpk6v8pjkg8p8mlzyjfymq5adll9a18sl80zk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-safemem" ,rust-safemem-0.3))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.5))))
    (home-page "https://bitbucket.org/marshallpierce/line-wrap-rs/src")
    (synopsis "Efficiently insert line separators")
    (description
     "Efficiently insert line separators.")
    (license license:asl2.0)))

(define-public rust-link-cplusplus-1
  (package
    (name "rust-link-cplusplus")
    (version "1.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "link-cplusplus" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0m7365ig7r88x7b4gkzj5m7b6wiq42pi1ign7mvyq63jr22sfspr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/dtolnay/link-cplusplus")
    (synopsis "Link libstdc++ or libc++ automatically or manually")
    (description "This crate helps link to libstdc++ or libc++ automatically or
manually from Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-linked-hash-map-0.5
  (package
    (name "rust-linked-hash-map")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "linked-hash-map" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jih3za0p1mywlnwcakc462q1byk6z8vnrzdm36hg6cxk7asdmcd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-heapsize" ,rust-heapsize-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page
     "https://github.com/contain-rs/linked-hash-map")
    (synopsis
     "HashMap wrapper that holds key-value pairs in insertion order")
    (description
     "This package provides a HashMap wrapper that holds key-value
pairs in insertion order.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-linked-hash-map-0.4
  (package
    (inherit rust-linked-hash-map-0.5)
    (name "rust-linked-hash-map")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "linked-hash-map" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fd958y02ggwpa2246kmjky9xmnww7vxg0ik3rxgy23hgwlyqq3q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-heapsize" ,rust-heapsize-0.3)
        ("rust-serde" ,rust-serde-0.9)
        ("rust-serde-test" ,rust-serde-test-0.9))))))

(define-public rust-linked-hash-map-0.3
  (package
    (inherit rust-linked-hash-map-0.5)
    (name "rust-linked-hash-map")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "linked-hash-map" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kaf95grvfqchxn8pl0854g8ab0fzl56217hndhhhz5qqm2j09kd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-clippy" ,rust-clippy-0.0)
        ("rust-serde" ,rust-serde-0.8)
        ("rust-serde-test" ,rust-serde-test-0.8))))))

(define-public rust-linkify-0.4
  (package
    (name "rust-linkify")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "linkify" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15i0q81vrhm4asskacy2z83fyj09ivcff0km82gwbli4vlkib583"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/robinst/linkify")
    (synopsis "Find URLs and email addresses in plain text")
    (description
     "Linkify is a Rust library to find links such as URLs and email addresses
in plain text.  It is smart about where a link ends, such as with trailing
punctuation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-libssh2-sys-0.2
  (package
    (name "rust-libssh2-sys")
    (version "0.2.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "libssh2-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0mkhw4pksbz7gldj8hia7k6npc479n1x09i8r0pm275sac424ina"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "libssh2") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("libssh2" ,libssh2)
       ("openssl" ,openssl)
       ("zlib" ,zlib)))
    (home-page "https://github.com/alexcrichton/ssh2-rs")
    (synopsis "Native bindings to the libssh2 library")
    (description
     "This package provides native rust bindings to the @code{libssh2} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-lmdb-rkv-0.14
  (package
    (name "rust-lmdb-rkv")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lmdb-rkv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0aylp9j3s34cgxfj3dszcnplj5a594ylykhgnpxrqafag9pjjyj4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-lmdb-rkv-sys" ,rust-lmdb-rkv-sys-0.11))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("lmdb" ,lmdb)))
    (home-page "https://github.com/mozilla/lmdb-rs")
    (synopsis "Safe Rust bindings for LMDB")
    (description "This package provides idiomatic and safe APIs for interacting
with lmdb.")
    (license license:asl2.0)))

(define-public rust-lmdb-rkv-sys-0.11
  (package
    (name "rust-lmdb-rkv-sys")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lmdb-rkv-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1994mvbdxkvq6c3z9npv1zjpvrhvpk9zry3azgyklyqn4nn70x5j"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (delete-file-recursively "lmdb")
           #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests fail after removing bundled source.
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-bindgen" ,rust-bindgen-0.53)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("lmdb" ,lmdb)))
    (home-page "https://github.com/mozilla/lmdb-rs")
    (synopsis "Rust bindings for liblmdb")
    (description "This package provides rust bindings for liblmdb.")
    (license license:asl2.0)))

(define-public rust-locale-0.2
  (package
    (name "rust-locale")
    (version "0.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "locale" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1z87wc7z6889x1pqlrwjw8f1crshzi15q5m102lqs8y0m69f9nsz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/rust-locale/rust-locale")
    (synopsis "Library for basic localisation")
    (description
     "This package provides a library for basic localisation.")
    (license license:expat)))

(define-public rust-locale-config-0.3
  (package
    (name "rust-locale-config")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "locale_config" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0d399alr1i7h7yji4vydbdbzd8hp0xaykr7h4rn3yj7l2rdw7lh8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-regex" ,rust-regex-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/rust-locale/locale_config/")
    (synopsis "Maintains locale preferences for processes and threads")
    (description
     "Maintains locale preferences for process and thread and initialises them
by inspecting the system for user preference.")
    (license license:expat)))

(define-public rust-locale-config-0.2
  (package
    (inherit rust-locale-config-0.3)
    (name "rust-locale-config")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "locale-config" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0p2kdgc1c9cq5bi2rpszbhkh7pdk1fwxhij37gayb2alwkmikb3k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-lock-api-0.4
  (package
    (name "rust-lock-api")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lock_api" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0716z2rs0kydmd1818kqp4641dfkqzr0rpbnrpxhabxylp2pq918"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-owning-ref" ,rust-owning-ref-0.4)
        ("rust-scopeguard" ,rust-scopeguard-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/Amanieu/parking_lot")
    (synopsis "Wrappers to create fully-featured Mutex and RwLock types")
    (description "This package provides wrappers to create fully-featured
@code{Mutex} and @code{RwLock} types.  It is compatible with @code{no_std}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-lock-api-0.3
  (package
    (inherit rust-lock-api-0.4)
    (name "rust-lock-api")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lock_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xgc5dzmajh0akbh5d6d7rj9mh5rzpk74pyrc946v2ixgakj9nn4"))))
    (build-system cargo-build-system)))

(define-public rust-lock-api-0.2
  (package
    (inherit rust-lock-api-0.3)
    (name "rust-lock-api")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lock_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zx7pksmgyggpczgw4qrr4vj2nkdk5lipgiysvr20slm552nv57d"))))))

(define-public rust-lock-api-0.1
  (package
    (inherit rust-lock-api-0.2)
    (name "rust-lock-api")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lock_api" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0b24q9mh258xa52ap636q1sxz0j5vrnp0hwbbh7ddjka3wwz3sv2"))))
    (arguments
     `(#:cargo-inputs
       (("rust-scopeguard" ,rust-scopeguard-0.3)
        ("rust-owning-ref" ,rust-owning-ref-0.4))))))

(define-public rust-log-0.4
  (package
    (name "rust-log")
    (version "0.4.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "log" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32 "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Not all test files included in release.
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-sval" ,rust-sval-1)
        ("rust-value-bag" ,rust-value-bag-1))
       #:cargo-development-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-sval" ,rust-sval-1)
        ("rust-value-bag" ,rust-value-bag-1))))
    (home-page "https://github.com/rust-lang/log")
    (synopsis "Lightweight logging facade for Rust")
    (description
     "This package provides a lightweight logging facade for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-log-0.3
  (package
    (inherit rust-log-0.4)
    (name "rust-log")
    (version "0.3.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "log" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0jq23hhn5h35k7pa8r7wqnsywji6x3wn1q5q7lif5q536if8v7p1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4))))))

(define-public rust-logtest-2
  (package
    (name "rust-logtest")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "logtest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09ihwkq6z7xm6wdwxmc9mz74lsl20g5bi7fcdm8n87bwcnl46gpb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))
       #:cargo-development-inputs
       (("rust-kv-log-macro" ,rust-kv-log-macro-1))))
    (home-page "https://github.com/yoshuawuyts/logtest")
    (synopsis "Test and assert log statements")
    (description "This package tests and asserts log statements.")
    (license (list license:expat license:asl2.0))))

(define-public rust-loom-0.4
  (package
    (name "rust-loom")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "loom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1941ji91nvriqqkgzlx285kq38zg74sw68gb2x4pnjbfcfs76k6l"))))
    (build-system cargo-build-system)
    (arguments
     ;; FIXME: build phase fails with the error: "the
     ;; `#[track_caller]` attribute is an experimental feature".
     `(#:skip-build? #true
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-generator" ,rust-generator-0.6)
        ("rust-scoped-tls" ,rust-scoped-tls-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/tokio-rs/loom")
    (synopsis "Permutation testing for concurrent code")
    (description
     "Loom is a testing tool for concurrent Rust code.  It runs a test many
times, permuting the possible concurrent executions of that test under the C11
memory model.  It uses state reduction techniques to avoid combinatorial
explosion.")
    (license license:expat)))

(define-public rust-loom-0.3
  (package
    (inherit rust-loom-0.4)
    (name "rust-loom")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "loom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vabpqzdhcqy1d64kcyzgfwigiak0dr18whq0lkic8915w7lds50"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-generator" ,rust-generator-0.6)
        ("rust-scoped-tls" ,rust-scoped-tls-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-loom-0.2
  (package/inherit rust-loom-0.3
    (name "rust-loom")
    (version "0.2.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "loom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qwvwbpnxff5m6647v9rc9i6ak8ral4jy0br5xx1s9a5zcd3xddh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-generator" ,rust-generator-0.6)
        ("rust-scoped-tls" ,rust-scoped-tls-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-loom-0.1
  (package/inherit rust-loom-0.3
    (name "rust-loom")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "loom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jmp5mffwwyqgp914cwz92ij2s6vk1hsnkvgndvzw74xrcfraibj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-generator" ,rust-generator-0.6)
        ("rust-scoped-tls" ,rust-scoped-tls-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-loop9-0.1
  (package
    (name "rust-loop9")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "loop9" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h4rys8001cdq4l2f30k66wmvscm4lb2laxgpia794p5652800x7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-imgref" ,rust-imgref-1))))
    (home-page "https://lib.rs/loop9")
    (synopsis "Helper function to visit every pixel and its neighbors")
    (description
     "This package provides a tiny helper function to visit every pixel in the
image together with its neighboring pixels.")
    (license license:expat)))

(define-public rust-lopdf-0.26
  (package
    (name "rust-lopdf")
    (version "0.26.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "lopdf" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1wqnmibs8qzi6pr3ig4h3sg6bfkkgyv4ngdng81x069725r056ml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-dtoa" ,rust-dtoa-0.4)
        ("rust-encoding" ,rust-encoding-0.2)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-image" ,rust-image-0.20)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-linked-hash-map" ,rust-linked-hash-map-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-lzw" ,rust-lzw-0.10)
        ("rust-nom" ,rust-nom-5)
        ("rust-pom" ,rust-pom-3)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://github.com/J-F-Liu/lopdf")
    (synopsis "Rust library for PDF document manipulation")
    (description
     "This package provides a Rust library for PDF document manipulation.")
    (license license:expat)))

(define-public rust-lru-cache-0.1
  (package
    (name "rust-lru-cache")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lru-cache" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "071viv6g2p3akwqmfb3c8vsycs5n7kr17b70l7la071jv0d4zqii"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-heapsize" ,rust-heapsize-0.4)
        ("rust-linked-hash-map" ,rust-linked-hash-map-0.5))))
    (home-page "https://github.com/contain-rs/lru-cache")
    (synopsis "Cache that holds a limited number of key-value pairs")
    (description "This package provides a cache that holds a limited number of
key-value pairs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-lscolors-0.7
  (package
    (name "rust-lscolors")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lscolors" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0vn1824lagf0xdv5rxyl7m9fbrcylyjibmnd4634dnn98m68jjyj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/sharkdp/lscolors")
    (synopsis "Colorize paths using the LS_COLORS environment variable")
    (description
     "Colorize paths using the LS_COLORS environment variable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-lscolors-0.6
  (package
    (inherit rust-lscolors-0.7)
    (name "rust-lscolors")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lscolors" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jxsgkn378kxkiqdshdjdclw5wwp2xaz45cqd3yw85fhn8a38fza"))))))

(define-public rust-lsp-types-0.80
  (package
    (name "rust-lsp-types")
    (version "0.80.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lsp-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vwjmi4apa4np6fgy95gq1nxc322br9cx7q2mm6vpb5x2lkmw9pl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.12)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-repr" ,rust-serde-repr-0.1)
        ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/gluon-lang/lsp-types")
    (synopsis "Types for interaction with a language server")
    (description
     "This package provides types useful for interacting with a language
server (LSP).")
    (license license:expat)))

(define-public rust-lzma-sys-0.1
  (package
    (name "rust-lzma-sys")
    (version "0.1.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lzma-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06fnjsx5cj2w6rsqb12x30nl9lnj0xv4hv78z4x1vlfsxp1vgd5x"))
       (modules '((guix build utils)))
       (snippet
        '(begin (delete-file-recursively "xz-5.2") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     `(("pkg-config" ,pkg-config)
       ("xz" ,xz)))
    (home-page "https://github.com/alexcrichton/xz2-rs")
    (synopsis "Bindings to liblzma for lzma and xz stream encoding/decoding")
    (description
     "This package contains the raw bindings to liblzma which contains an
implementation of LZMA and xz stream encoding/decoding.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-lzw-0.10
  (package
    (name "rust-lzw")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "lzw" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1170dfskhzlh8h2bm333811hykjvpypgnvxyhhm1rllyi2xpr53x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/nwin/lzw.git")
    (synopsis "LZW compression and decompression")
    (description
     "This package provides LZW compression and decompression.")
    (license (list license:expat license:asl2.0))))

(define-public rust-mac-0.1
  (package
    (name "rust-mac")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mac" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "194vc7vrshqff72rl56f9xgb0cazyl4jda7qsv31m5l6xx7hq7n4"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/reem/rust-mac")
    (synopsis "Collection of great and ubiqutitous macros")
    (description
     "This package provides a collection of great and ubiqutitous macros.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-mach-0.2
  (package
    (name "rust-mach")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mach" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qdhs16cl1j3w7kvy6ak7h8lbyqmr6i3i15qfzpnv9gyrn3j9pc6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/fitzgen/mach")
    (synopsis "Rust interface to the Mach 3.0 kernel that underlies OSX")
    (description
     "This package provides a Rust interface to the user-space API of the
Mach 3.0 kernel that underlies OSX.")
    (license (list license:asl2.0 license:expat license:bsd-2))))

(define-public rust-mach-o-sys-0.1
  (package
    (name "rust-mach-o-sys")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mach-o-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09l8p7nmzq37450x2h6nb7dzg1sk6dk36a5rkcrcy81zm21lb19y"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/fitzgen/mach_o_sys")
    (synopsis "Bindings to the OSX mach-o system library")
    (description "This package provides bindings to the OSX mach-o system
library")
  (license (list license:asl2.0 license:expat))))

(define-public rust-make-cmd-0.1
  (package
    (name "rust-make-cmd")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "make-cmd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ly0lc5p1a0qdiqnh19ly3snb9q83sjbbb1njvh8a5xgx3xqmjm8"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mneumann/make-cmd-rs")
    (synopsis "Enable build.rs scripts to invoke gnu_make")
    (description "This package enables build.rs scripts to invoke gnu_make
platform-independently.")
    (license license:expat)))

(define-public rust-malloc-buf-0.0
 (package
   (name "rust-malloc-buf")
   (version "0.0.6")
   (source
    (origin
      (method url-fetch)
      (uri (crate-uri "malloc-buf" version))
      (file-name
       (string-append name "-" version ".tar.gz"))
      (sha256
       (base32
        "1jqr77j89pwszv51fmnknzvd53i1nkmcr8rjrvcxhm4dx1zr1fv2"))))
   (build-system cargo-build-system)
   (arguments
    `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
   (home-page "https://github.com/SSheldon/malloc_buf")
   (synopsis "Structs for handling malloc'd memory passed to Rust")
   (description
    "This package provides structs for handling malloc'd memory passed to Rust.")
   (license license:expat)))

(define-public rust-maplit-1
  (package
    (name "rust-maplit")
    (version "1.0.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "maplit" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "07b5kjnhrrmfhgqm9wprjw8adx6i225lqp49gasgqg74lahnabiy"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/bluss/maplit")
    (synopsis "Collection of Map macros")
    (description "This crate provides a collection of @code{literal} macros for
@code{HashMap}, @code{HashSet}, @code{BTreeMap}, and @code{BTreeSet.}")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-markup5ever-0.10
  (package
    (name "rust-markup5ever")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "markup5ever" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1aqxl1lsc8s6ycsw5ibwynadnb9qpiab4ggwgdq9pjlnjdk8vqxa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-string-cache" ,rust-string-cache-0.8)
        ("rust-tendril" ,rust-tendril-0.4)
        ("rust-phf-codegen" ,rust-phf-codegen-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-string-cache-codegen" ,rust-string-cache-codegen-0.5))))
    (home-page "https://github.com/servo/html5ever")
    (synopsis "Common code for xml5ever and html5ever")
    (description
     "Common code for xml5ever and html5ever.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-markup5ever-0.9
  (package
    (inherit rust-markup5ever-0.10)
    (name "rust-markup5ever")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "markup5ever" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "00wxigkiw8f777pjp7q5kfq77xpwda9zskkwp698assh8yfisf35"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-phf" ,rust-phf-0.7)
        ("rust-string-cache" ,rust-string-cache-0.7)
        ("rust-tendril" ,rust-tendril-0.4)
        ("rust-phf-codegen" ,rust-phf-codegen-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-string-cache-codegen" ,rust-string-cache-codegen-0.4))))))

(define-public rust-markup5ever-0.8
  (package
    (inherit rust-markup5ever-0.9)
    (name "rust-markup5ever")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "markup5ever" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08ayl9aqjnmf7ly1ipy6dk3wjvyfn4w51l40jzh1fh984ykldbzi"))))))

(define-public rust-match-cfg-0.1
  (package
    (name "rust-match-cfg")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "match-cfg" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r5j3zqc3qr8ybcx95bk8q57mkizmgmffj5lmicd4i8d9riyigpz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/gnzlbg/match_cfg")
    (synopsis
     "Define an item depending on a large number of `#[cfg]` parameters")
    (description
     "This package provides a convenience macro to ergonomically define an item
depending on a large number of @code{#[cfg]} parameters.  Structured like match
statement, the first matching branch is the item that gets emitted.")
    (license (list license:expat license:asl2.0))))

(define-public rust-matches-0.1
  (package
    (name "rust-matches")
    (version "0.1.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "matches" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "020axl4q7rk9vz90phs7f8jas4imxal9y9kxl4z4v7a6719mrz3z"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/SimonSapin/rust-std-candidates")
    (synopsis "Macro to evaluate whether an expression matches a pattern")
    (description "This package provides a macro to evaluate, as a boolean,
whether an expression matches a pattern.")
    (license license:expat)))

(define-public rust-matchers-0.0
  (package
    (name "rust-matchers")
    (version "0.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "matchers" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q8ckqmkjqkznvdi9x0z769yz2bmvlqcwx51ad2lpk4mfmgpi6gh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-regex-automata" ,rust-regex-automata-0.1))))
    (home-page "https://github.com/hawkw/matchers")
    (synopsis "Regex matching on character and byte streams")
    (description
     "Use this crate to match on character and byte streams using regular
grammars.  It provides the subset of the regex crate that only deals with
matching, not parsing substrings.")
    (license license:expat)))

(define-public rust-matrixmultiply-0.2
  (package
    (name "rust-matrixmultiply")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "matrixmultiply" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "13s7nfd3dfcsrixld2lk8c563ih5xzczl2w36hprfc016rkfrxyl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rawpointer" ,rust-rawpointer-0.2))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-itertools" ,rust-itertools-0.7))))
    (home-page "https://github.com/bluss/matrixmultiply/")
    (synopsis "General matrix multiplication for f32 and f64 matrices")
    (description "General matrix multiplication for f32 and f64 matrices.
Operates on matrices with general layout (they can use arbitrary row and column
stride).  Detects and uses AVX or SSE2 on x86 platforms transparently for higher
performance.  Uses a microkernel strategy, so that the implementation is easy to
parallelize and optimize.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-matrixmultiply-0.1
  (package
    (inherit rust-matrixmultiply-0.2)
    (name "rust-matrixmultiply")
    (version "0.1.15")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "matrixmultiply" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "00p0fpjhm45qdzi37mgv7ggsy8b9gqvq4999yrbgyn1dxkf6gbfw"))))
    (arguments
     `(#:cargo-inputs (("rust-rawpointer" ,rust-rawpointer-0.1))
       #:cargo-development-inputs (("rust-bencher" ,rust-bencher-0.1))))))

(define-public rust-maybe-uninit-2
  (package
    (name "rust-maybe-uninit")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "maybe-uninit" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "004y0nzmpfdrhz251278341z6ql34iv1k6dp1h6af7d6nd6jwc30"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/est31/maybe-uninit")
    (synopsis "MaybeUninit for friends of backwards compatibility")
    (description
     "This package provides MaybeUninit for friends of backwards compatibility.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-md-5-0.9
  (package
    (name "rust-md-5")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "md-5" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "14x7yxfi4pk4qy3zmn9dj69yc18fg3cyind346kribjd93077qij"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-block-buffer" ,rust-block-buffer-0.8)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-md5-asm" ,rust-md5-asm-0.4)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-digest" ,rust-digest-0.9)
        ("rust-hex-literal" ,rust-hex-literal-0.2))))
    (home-page "https://github.com/RustCrypto/hashes")
    (synopsis "MD5 hash function")
    (description "MD5 hash function.")
    (license (list license:expat license:asl2.0))))

(define-public rust-md-5-0.8
  (package
    (inherit rust-md-5-0.9)
    (name "rust-md-5")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "md-5" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1j5rfxy2p76xf5f1lgaw85xla0b1bbv2lknvdhv1j0ibmzfg72m1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-buffer" ,rust-block-buffer-0.7)
        ("rust-digest" ,rust-digest-0.8)
        ("rust-md5-asm" ,rust-md5-asm-0.4)
        ("rust-opaque-debug" ,rust-opaque-debug-0.2))
       #:cargo-development-inputs
       (("rust-digest" ,rust-digest-0.8)
        ("rust-hex-literal" ,rust-hex-literal-0.1))))))

(define-public rust-md5-0.7
  (package
    (name "rust-md5")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "md5" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32 "0wcps37hrhz59fkhf8di1ppdnqld6l1w5sdy7jp7p51z0i4c8329"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/stainless-steel/md5")
    (synopsis "MD5 hash function in Rust")
    (description "The package provides the MD5 hash function.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-md5-0.6
  (package
    (inherit rust-md5-0.7)
    (name "rust-md5")
    (version "0.6.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "md5" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "17b2xm4h4cvxsdjsf3kdrzqv2za60kak961xzi5kmw6g6djcssvy"))))))

(define-public rust-md5-0.3
  (package
    (inherit rust-md5-0.6)
    (name "rust-md5")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "md5" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0j2s8aqdkhwhy7awga2bmv5n8qq8bgy8672iha9f3y871dm6vibr"))))))

(define-public rust-md5-asm-0.4
  (package
    (name "rust-md5-asm")
    (version "0.4.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "md5-asm" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0gpk5647js1k084jc7pg2gji0cvl6hjkkbfia6lnpk8y4shyairv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/RustCrypto/asm-hashes")
    (synopsis "Assembly implementation of MD5 compression function")
    (description "This package contains an assembly implementation of MD5
compression function.")
    (supported-systems '("x86_64-linux" "i686-linux"))
    (license license:expat)))

(define-public rust-measureme-0.7
  (package
    (name "rust-measureme")
    (version "0.7.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "measureme" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0cmrrh86b3rvws6d7xp07wfn703yw02cakzirykvn4vh4p9hkxzy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-rustc-hash" ,rust-rustc-hash-1))))
    (home-page "https://github.com/rust-lang/measureme")
    (synopsis "Support crate for rustc's self-profiling feature")
    (description
     "Record rustc compiler events and serializing them to a compact binary
format with this support package.  It is integrated into rustc via the
unstable -Z self-profile flag.")
    (license (list license:expat license:asl2.0))))

(define-public rust-memchr-2
  (package
    (name "rust-memchr")
    (version "2.3.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "memchr" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "098m9clfs495illlw00hv2gg67mhm7jflld3msyclvi5m9xc9q8f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/BurntSushi/rust-memchr")
    (synopsis "Safe interface to memchr")
    (description "The @code{memchr} crate provides heavily optimized routines
for searching bytes.")
    (license (list license:unlicense license:expat))))

(define-public rust-memchr-1
  (package
    (inherit rust-memchr-2)
    (name "rust-memchr")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memchr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0yjyja34pzhipdl855q3m21w1lyih4lw79x2dp3czwdla4pap3ql"))))))

(define-public rust-memchr-0.1
  (package
    (inherit rust-memchr-1)
    (name "rust-memchr")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memchr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "084d85hjfa3xf5kwdms2mhbkh78m1gl2254cp5swcxj3a7xjkdnq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2))))))

(define-public rust-memmap-0.7
  (package
    (name "rust-memmap")
    (version "0.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "memmap" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0ns7kkd1h4pijdkwfvw4qlbbmqmlmzwlq3g2676dcl5vwyazv1b5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/danburkert/memmap-rs")
    (synopsis "Rust library for cross-platform memory mapped IO")
    (description
     "This package provides a cross-platform Rust API for memory-mapped
file IO.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-memmap-0.6
  (package
    (inherit rust-memmap-0.7)
    (name "rust-memmap")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "memmap" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1zy6s0ni0lx9rjzq3gq2zz9r8zgjmbp02332g3gsj4fyhv4s5zz2"))))))

(define-public rust-memmap-0.2
  (package
    (inherit rust-memmap-0.6)
    (name "rust-memmap")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memmap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0li737lakqcbbgd87x7h8d4vp0r1fqcbn5lb5vi746i9jgnp43zj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fs2" ,rust-fs2-0.2)
        ("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.2))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-memmap2-0.1
  (package
    (name "rust-memmap2")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memmap2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nmymqy9q62x577ydja0ysfyir7h5qa0n5fwcnvchfhhlsi0rdyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/RazrFalcon/memmap2-rs")
    (synopsis "Cross-platform Rust API for memory-mapped file IO")
    (description "This package provides a Rust API for memory-mapped file IO.")
    (license (list license:expat license:asl2.0))))

(define-public rust-memoffset-0.6
  (package
    (name "rust-memoffset")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memoffset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11yxgw330cf8g4wy0fnb20ag8gg1b33fsnfmg2g8z6h5wc444yqm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1))))
    (home-page "https://github.com/Gilnaa/memoffset")
    (synopsis "C-like offset_of functionality for Rust structs")
    (description
     "This package provides C-like @code{offset_of} functionality
for Rust structs.")
    (license license:expat)))

(define-public rust-memoffset-0.5
  (package
    (inherit rust-memoffset-0.6)
    (name "rust-memoffset")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memoffset" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fblqzc25hfaym8m0pj112s66pqq87avvaqm5hp5rskib2w9w63m"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3))))))

(define-public rust-memoffset-0.2
  (package
    (inherit rust-memoffset-0.5)
    (name "rust-memoffset")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memoffset" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cvm2z7dy138s302ii7wlzcxbka5a8yfl5pl5di7lbdnw9hw578g"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-memsec-0.6
  (package
    (name "rust-memsec")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memsec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pfbpl75586bjdkphnaa4j58d668rl1wgcqzpnpzzx1phxfzkx1a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mach-o-sys" ,rust-mach-o-sys-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/quininer/memsec")
    (synopsis "Rust implementation of libsodium/utils")
    (description "This package provides a Rust implementation of
@code{libsodium/utils}.")
    (license license:expat)))

(define-public rust-memsec-0.5
  (package
    (inherit rust-memsec-0.6)
    (name "rust-memsec")
    (version "0.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "memsec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13ir50j549gdz94pds1i7ljnk14d66q5x91s11hncm1pih7jif8c"))))))

(define-public rust-merlin-2
  (package
    (name "rust-merlin")
    (version "2.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "merlin" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "0y5vd610q7x82vf54pmnzlh0mh8hgxr6imv92yh46d7syi3cmzn6"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-byteorder" ,rust-byteorder-1)
         ("rust-hex" ,rust-hex-0.3)
         ("rust-keccak" ,rust-keccak-0.1)
         ("rust-rand-core" ,rust-rand-core-0.5)
         ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://docs.rs/merlin")
    (synopsis "Composable proof transcripts for public-coin arguments of
knowledge")
    (description
     "Merlin is a STROBE-based transcript construction for zero-knowledge
proofs.  It automates the Fiat-Shamir transform, so that by using Merlin,
non-interactive protocols can be implemented as if they were interactive.")
    (license license:expat)))

(define-public rust-mesalink-1
  (package
    (name "rust-mesalink")
    (version "1.1.0-cratesio")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mesalink" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02lp27j5vxdc95bf5g983yr660cm6vljikk0yqry4j6cjvfnyq85"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release"
         "--"
         "--skip=libssl::ssl::tests::early_data_to_mesalink_io"
         "--skip=libssl::ssl::tests::get_ssl_fd"
         "--skip=libssl::ssl::tests::ssl_on_nonblocking_socket")
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.10)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-enum-to-u8-slice-derive" ,rust-enum-to-u8-slice-derive-0.1)
        ("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-jemallocator" ,rust-jemallocator-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-ring" ,rust-ring-0.16)
        ("rust-rustls" ,rust-rustls-0.16)
        ("rust-sct" ,rust-sct-0.6)
        ("rust-untrusted" ,rust-untrusted-0.7)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-webpki" ,rust-webpki-0.21)
        ("rust-webpki-roots" ,rust-webpki-roots-0.17))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))))
    (home-page "https://github.com/mesalock-linux/mesalink")
    (synopsis "Memory-safe and OpenSSL-compatible TLS library")
    (description
     "MesaLink is a memory-safe and OpenSSL-compatible TLS library
based on Rustls and Ring.")
    (license license:bsd-3)))

(define-public rust-metadeps-1
  (package
    (name "rust-metadeps")
    (version "1.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "metadeps" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hjla9ypycqw1snd2qf87cckcc0d5z5qvxpcijn5yrrs3f825cbk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.10)
        ("rust-toml" ,rust-toml-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/joshtriplett/metadeps")
    (synopsis "Run pkg-config from declarative dependencies in Cargo.toml")
    (description "Run pkg-config from declarative dependencies in Cargo.toml.")
    (license (list license:expat license:asl2.0))))

(define-public rust-metal-0.18
  (package
    (name "rust-metal")
    (version "0.18.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "metal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08n3kfv78jm3pf7fafwfv67n40lgcdg7w9lqn9g4sdvfwdk90vrf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa" ,rust-cocoa-0.22)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/gfx-rs/metal-rs")
    (synopsis "Rust bindings for Metal")
    (description "This package provides Rust bindings for Metal.")
    (license (list license:expat license:asl2.0))))

(define-public rust-metal-0.14
  (package
    (inherit rust-metal-0.18)
    (name "rust-metal")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "metal" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0my1xwlv562i80y3jbk0nygayi383j5skdwk48clb286b7922gyd"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-block" ,rust-block-0.1)
        ("rust-cocoa" ,rust-cocoa-0.18)
        ("rust-core-graphics" ,rust-core-graphics-0.17)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-foundation" ,rust-objc-foundation-0.1)
        ("rust-objc-id" ,rust-objc-id-0.1))
       #:cargo-development-inputs
       (("rust-sema" ,rust-sema-0.1)
        ("rust-winit" ,rust-winit-0.19)))))) ; 0.17?

(define-public rust-meval-0.2
  (package
    (name "rust-meval")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "meval" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ncj0fv9q3b4his7g947fmgkskpfly6dsniw0g6mg38wcnjrd57p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-nom" ,rust-nom-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/rekka/meval-rs")
    (synopsis "Simple math expression parser and evaluator")
    (description
     "This package provides a simple math expression parser and evaluator.")
    (license (list license:unlicense license:expat))))

(define-public rust-mimalloc-0.1
  (package
    (name "rust-mimalloc")
    (version "0.1.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mimalloc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0x74b6jv6pxfl6bh44bnch6ajm3l5z3zq8w8mqlscbq8d77rnx80"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libmimalloc-sys" ,rust-libmimalloc-sys-0.1))))
    (home-page "https://crates.io/crates/mimalloc")
    (synopsis "Performance and security oriented drop-in allocator")
    (description "This package provides a performance and security oriented
drop-in allocator.")
    (license license:expat)))

(define-public rust-mime-0.3
  (package
    (name "rust-mime")
    (version "0.3.16")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "mime" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "13dcm9lh01hdwfjcg74ppljyjfj1c6w3a3cwkhxf0w8wa37cfq1a"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/hyperium/mime")
    (synopsis "Strongly Typed Mimes")
    (description
     "Support MIME (HTTP Media Types) as strong types in Rust.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-mime-0.2
  (package
    (inherit rust-mime-0.3)
    (name "rust-mime")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mime" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q1s1ax1gaz8ld3513nvhidfwnik5asbs1ma3hp6inp5dn56nqms"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-heapsize" ,rust-heapsize-0.3)
        ("rust-log" ,rust-log-0.3)
        ("rust-serde" ,rust-serde-0.8))))))

(define-public rust-mime-guess-2
  (package
    (name "rust-mime-guess")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mime_guess" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04pjpbl90z4yn0cmifvwgf4mqznciw6b095k626q96bxx71d9116"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-mime" ,rust-mime-0.3)
        ("rust-unicase" ,rust-unicase-2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-unicase" ,rust-unicase-2))))
    (home-page "https://github.com/abonander/mime_guess")
    (synopsis "Detect a file's MIME type by its extension")
    (description "This package provides a simple crate for detection of a
file's MIME type by its extension.")
    (license license:expat)))

(define-public rust-mime-guess-1
  (package
    (inherit rust-mime-guess-2)
    (name "rust-mime-guess")
    (version "1.8.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mime_guess" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18qcd5aa3363mb742y7lf39j7ha88pkzbv9ff2qidlsdxsjjjs91"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-mime" ,rust-mime-0.2)
        ("rust-phf" ,rust-phf-0.7)
        ("rust-phf-codegen" ,rust-phf-codegen-0.7)
        ("rust-unicase" ,rust-unicase-1))))))

(define-public rust-miniz-oxide-0.4
  (package
    (name "rust-miniz-oxide")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "miniz_oxide" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17d1xp29v5xgh4vahxld14w1c1hgh38qmxpv7i18wy096gn2cb8g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-adler" ,rust-adler-0.2)
        ("rust-autocfg" ,rust-autocfg-1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page  "https://github.com/Frommi/miniz_oxide/tree/master/miniz_oxide")
    (synopsis "Pure rust replacement for the miniz DEFLATE/zlib encoder/decoder")
    (description
     "A pure rust replacement for the miniz DEFLATE/zlib encoder/decoder.  Using
@code{flate2} with the @code{rust_backend} feature provides an easy to use
streaming API for miniz_oxide.")
    (license (list license:expat license:zlib license:asl2.0))))

(define-public rust-miniz-oxide-0.3
  (package
    (inherit rust-miniz-oxide-0.4)
    (name "rust-miniz-oxide")
    (version "0.3.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "miniz_oxide" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "198n4hfpq0qcxf275l6fpzh7b9cl7ck2xs6pjgpds74bazv9yrxa"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-adler32" ,rust-adler32-1))))))

(define-public rust-miniz-oxide-0.2
  (package
    (inherit rust-miniz-oxide-0.3)
    (name "rust-miniz-oxide")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "miniz_oxide" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "17f92krv9hhsyc38prpfyn99m2hqhr4fgszpsla66a6gcrnpbhxn"))))))

(define-public rust-miniz-oxide-c-api-0.2
  (package
    (name "rust-miniz-oxide-c-api")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "miniz_oxide_c_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1514mvlj8vl723xqxnww5cfqr2mhnqqqf18fn3df17yx8racly2v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.2))
       #:cargo-development-inputs
       (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/Frommi/miniz_oxide/")
    (synopsis "DEFLATE compression and decompression API")
    (description
     "DEFLATE compression and decompression API designed to be Rust
drop-in replacement for miniz.")
    (license license:expat)))

(define-public rust-miniz-sys-0.1
  (package
    (name "rust-miniz-sys")
    (version "0.1.12")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "miniz-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "00l2r4anm8g35x0js2zfdnwfbrih9m43vphdpb77c5ga3kjkm7hy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ;; Build dependencies:
        ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/alexcrichton/flate2-rs")
    (synopsis "Bindings to the miniz.c library")
    (description
     "This package provides bindings to the @code{miniz.c} library.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-mint-0.5
  (package
    (name "rust-mint")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mint" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c4190gr348fkfijij7vm19iagwl36mssj1irc9f6m448hbhgn68"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kvark/mint")
    (synopsis "Math interoperability standard types")
    (description
     "This package provides math interoperability standard types.")
    (license license:expat)))

(define-public rust-minus-3
  (package
    (name "rust-minus")
    (version "3.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "minus" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f5kx0q3pc04zlaf0dv2vmbzza65kjdr1h9kk8x716fyzc0w5pga"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-crossterm" ,rust-crossterm-0.19)
        ("rust-regex" ,rust-regex-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/arijit79/minus")
    (synopsis "Asynchronous paging library for Rust")
    (description
     "Minus is a fast, asynchronous terminal paging library for Rust.  It
provides high level functionalities to easily write a pager for any terminal
application.")
    (license (list license:expat license:asl2.0))))

(define-public rust-mio-0.7
  (package
    (name "rust-mio")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12qsvmsmpijnghgci5i0liskvwxrbg2dz6hc09kgvwaf0s3whfzk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-ntapi" ,rust-ntapi-0.3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.6)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/tokio-rs/mio")
    (synopsis "Lightweight non-blocking IO")
    (description
     "Mio is a fast, low-level I/O library for Rust focusing on non-blocking
APIs and event notification for building I/O apps with as little overhead as
possible over the OS abstractions.")
    (license license:expat)))

(define-public rust-mio-0.6
  (package
    (inherit rust-mio-0.7)
    (name "rust-mio")
    (version "0.6.21")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13q02a7cwc140aygf8amadpzpl5lyj3p2r4wnvgydfpnphifqb9h"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-fuchsia-zircon" ,rust-fuchsia-zircon-0.3)
        ("rust-fuchsia-zircon-sys" ,rust-fuchsia-zircon-sys-0.3)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.2)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-winapi" ,rust-winapi-0.2))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-0.3)
        ("rust-env-logger" ,rust-env-logger-0.4)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-mio-anonymous-pipes-0.1
  (package
    (name "rust-mio-anonymous-pipes")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio-anonymous-pipes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1bqs8wncd73q4pnbiwskhgds57hyr8g89vfpqmw1vk9dqp1p9hpq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-mio" ,rust-mio-0.6)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-spsc-buffer" ,rust-spsc-buffer-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/davidhewitt/mio-anonymous-pipes")
    (synopsis "Asynchronous wrapper for Windows synchronous pipes")
    (description
     "This package provides asynchronous wrapper for Windows synchronous pipes.")
    (license license:expat)))

(define-public rust-mio-extras-2
  (package
    (name "rust-mio-extras")
    (version "2.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio-extras" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "069gfhlv0wlwfx1k2sriwfws490kjp490rv2qivyfb01j3i3yh2j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-slab" ,rust-slab-0.4))))
    (home-page "https://github.com/dimbleby/mio-extras")
    (synopsis "Extra components for use with Mio")
    (description "Extra components for use with Mio.")
    (license (list license:expat license:asl2.0))))

(define-public rust-mio-named-pipes-0.1
  (package
    (name "rust-mio-named-pipes")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio-named-pipes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cwwfx1yr9vws8x971x34ijnirs377vcxi47frdirki5yppp9qzm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-env-logger" ,rust-env-logger-0.4)
        ("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/alexcrichton/mio-named-pipes")
    (synopsis "Windows named pipe bindings for mio")
    (description
     "A library for integrating Windows Named Pipes with mio.")
    (license `(,license:asl2.0 ,license:expat))))

(define-public rust-mio-uds-0.6
  (package
    (name "rust-mio-uds")
    (version "0.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mio-uds" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09gimdbnj7b9yca99pk8lxh9jhl79msj795c8fxi2sqr9slmfqln"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-iovec" ,rust-iovec-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/alexcrichton/mio-uds")
    (synopsis "Unix domain socket bindings for mio")
    (description
     "Unix domain socket bindings for mio.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-miow-0.3
  (package
    (name "rust-miow")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "miow" version))
       (file-name (string-append name "-" version ".crate"))
       (sha256
        (base32 "15sqdhh29dqgw5xh59clwv6scbsbvdkbmdc16hbfvyq7b2sw2css"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-socket2" ,rust-socket2-0.3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))
    (home-page "https://github.com/alexcrichton/miow")
    (synopsis "Rust I/O library for Windows")
    (description
     "This package provides a zero overhead I/O library for Windows, focusing on
IOCP and Async I/O abstractions.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-miow-0.2
  (package
    (inherit rust-miow-0.3)
    (name "rust-miow")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "miow" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "06g9b8sqlh5gxakwqq4rrib07afwanfnxgxajrldwcgk3hxjy7wc"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-net2" ,rust-net2-0.2)
        ("rust-winapi" ,rust-winapi-0.2)
        ("rust-ws2-32-sys" ,rust-ws2-32-sys-0.2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-mockito-0.23
  (package
    (name "rust-mockito")
    (version "0.23.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mockito" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kh2wg24441miqcnrp2miaapphn8wgm18x23yjq45pajsjxfd0mf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release"
         "--"
         "--skip=test_assert_with_last_unmatched_request"
         "--skip=test_assert_with_last_unmatched_request_and_headers")
       #:cargo-inputs
       (("rust-assert-json-diff" ,rust-assert-json-diff-1)
        ("rust-colored" ,rust-colored-1)
        ("rust-difference" ,rust-difference-2)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/lipanski/mockito")
    (synopsis "HTTP mocking for Rust")
    (description "This crate provides HTTP mocking for Rust.")
    (license license:expat)))

(define-public rust-model-0.1
  (package
    (name "rust-model")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "model" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kx6hy5i1fn2qs4x6hpng9jixpm68g83vm24z8bqqscr317yinb6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-permutohedron" ,rust-permutohedron-0.2)
        ("rust-proptest" ,rust-proptest-0.9))))
    (home-page "https://github.com/spacejam/model")
    (synopsis "Model-based testing for data structures")
    (description
     "Model-based testing for data structures, with linearizability
checking.")
    (license (list license:expat license:asl2.0))))

(define-public rust-modifier-0.1
  (package
    (name "rust-modifier")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "modifier" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0n3fmgli1nsskl0whrfzm1gk0rmwwl6pw1q4nb9sqqmn5h8wkxa1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/reem/rust-modifier")
    (synopsis
      "Chaining APIs for both self -> Self and &mut self methods.")
    (description
      "Chaining APIs for both self -> Self and &mut self methods.")
    (license license:expat)))

(define-public rust-multi-default-trait-impl-0.1
  (package
    (name "rust-multi-default-trait-impl")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "multi-default-trait-impl" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1r6y5zb6kg655zi02yk4amkwsgds5ay9ag1dk30cls7rn3dlvvqs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/hainish/multi-default-trait-impl")
    (synopsis "Define multiple implementations of trait")
    (description
     "This library contains two attribute macros: @code{default_trait_impl}
which defines a default trait implementation, and @code{trait_impl} which uses
a default trait implementation you've defined.")
    (license license:lgpl2.1+)))

(define-public rust-multipart-0.17
  (package
    (name "rust-multipart")
    (version "0.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "multipart" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m3nrydgc56wjixsahipmvjgnxnw2cz7w8ryghsgahwjr3nswl6h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-buf-redux" ,rust-buf-redux-0.8)
        ("rust-clippy" ,rust-clippy-0.0)
        ("rust-httparse" ,rust-httparse-1)
        ("rust-hyper" ,rust-hyper-0.10)
        ("rust-iron" ,rust-iron-0.6)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-mime-guess" ,rust-mime-guess-2)
        ("rust-nickel" ,rust-nickel-0.11)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rocket" ,rust-rocket-0.4)
        ("rust-safemem" ,rust-safemem-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tiny-http" ,rust-tiny-http-0.6)
        ("rust-twoway" ,rust-twoway-0.1))))
    (home-page "https://github.com/abonander/multipart")
    (synopsis
     "Backend-agnostic extension for file uploads in HTTP libraries for Rust")
    (description
     "This package provides a backend-agnostic extension for HTTP libraries
that provides support for POST multipart/form-data requests on both client and
server.")
    (license (list license:expat license:asl2.0))))

(define-public rust-mustache-0.9
  (package
    (name "rust-mustache")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mustache" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dfakqld6zf995nnkgs9ybccgps4zcbfd4adaa2162njqpqnx5ai"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/nickel-org/rust-mustache")
    (synopsis "Rust implementation of Mustache")
    (description "This package provides a Rust implementation of Mustache.")
    (license (list license:expat license:asl2.0))))

(define-public rust-mysqlclient-sys-0.2
  (package
    (name "rust-mysqlclient-sys")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "mysqlclient-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "11ggkcbfnmp81amc9g0j98dk17fnmqcp9smgm9w401286kckg5ky"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))
    (native-inputs
     `(("mariadb" ,mariadb "lib")))
    (home-page "https://github.com/sgrif/mysqlclient-sys")
    (synopsis "Auto-generated rust bindings for libmysqlclient")
    (description "This package provides auto-generated rust bindings for
libmysqlclient.")
    (license (list license:expat license:asl2.0))))

(define-public rust-nanorand-0.5
  (package
    (name "rust-nanorand")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nanorand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ryi6jdfsfij4di33f269099g7m32rlr7sv7j4pklnjcj2xxfwri"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;error with pre-release randomize
       #:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-random-fast-rng" ,rust-random-fast-rng-0.1)
        ("rust-randomize" ,rust-randomize-4))))
    (home-page "https://github.com/aspenluxxxy/nanorand-rs")
    (synopsis "Tiny, fast, zero-dep library for random number generation")
    (description
     "This library is meant for fast, random number generation with
quick compile time, and minimal dependencies.")
    (license license:zlib)))

(define-public rust-nanorand-0.4
  (package
    (inherit rust-nanorand-0.5)
    (name "rust-nanorand")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nanorand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ifpjgir1a6lw64jkb6la5hb8j5jvqq70nmxgzjj0cjf13jd3kys"))))
    (arguments
     `(#:skip-build? #true              ;error with pre-release randomize
       #:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-random-fast-rng" ,rust-random-fast-rng-0.1)
        ("rust-randomize" ,rust-randomize-4))))))

(define-public rust-nasm-rs-0.2
  (package
    (name "rust-nasm-rs")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nasm-rs" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1lgc3gg32hj4pcbfp07vzwy013smdm27469fyy4rqgyil3x46vx7"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-arrayvec" ,rust-arrayvec-0.5)
         ("rust-rayon" ,rust-rayon-1))))
    (home-page "https://github.com/medek/nasm-rs")
    (synopsis "Run NASM during your Cargo build")
    (description "Run NASM during your Cargo build.")
    (license (list license:expat license:asl2.0))))

(define-public rust-nasm-rs-0.1
  (package
    (inherit rust-nasm-rs-0.2)
    (name "rust-nasm-rs")
    (version "0.1.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nasm-rs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0r34hiy1pc0aksrfc02zsl0zyw33i9yi7kyx8l214l7nm0mzm97y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rayon" ,rust-rayon-1))))))

(define-public rust-nalgebra-0.21
  (package
    (name "rust-nalgebra")
    (version "0.21.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nalgebra" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "11ili22n4ffgcjbgvbjqmpbd67qrl2acqbpymg6z7d2h7my19dnn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-abomonation" ,rust-abomonation-0.7)
        ("rust-alga" ,rust-alga-0.9)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-generic-array" ,rust-generic-array-0.13)
        ("rust-matrixmultiply" ,rust-matrixmultiply-0.2)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-rational" ,rust-num-rational-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-distr" ,rust-rand-distr-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-simba" ,rust-simba-0.1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-rand-isaac" ,rust-rand-isaac-0.2)
        ("rust-rand-xorshift" ,rust-rand-xorshift-0.2)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://nalgebra.org")
    (synopsis "Linear algebra library")
    (description
     "This package provides a linear algebra library with transformations and
statically-sized or dynamically-sized matrices.")
    (license license:bsd-3)))

(define-public rust-nalgebra-0.19
  (package
    (inherit rust-nalgebra-0.21)
    (name "rust-nalgebra")
    (version "0.19.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nalgebra" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0i87k57nav221lnr9z7ljlwxh8073qsx33bajdm146y00q805fqa"))))
    (arguments
     `(#:cargo-inputs
       (("rust-abomonation" ,rust-abomonation-0.7)
        ("rust-alga" ,rust-alga-0.9)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-generic-array" ,rust-generic-array-0.13)
        ("rust-matrixmultiply" ,rust-matrixmultiply-0.2)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-rational" ,rust-num-rational-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-distr" ,rust-rand-distr-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-rand-xorshift" ,rust-rand-xorshift-0.2)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-nalgebra-0.18
  (package
    (inherit rust-nalgebra-0.19)
    (name "rust-nalgebra")
    (version "0.18.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nalgebra" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18i1npny8s45ff67p5qpdwwsn36fp23mal8847fkb32cqgdzvada"))))
    (arguments
     `(#:cargo-inputs
       (("rust-abomonation" ,rust-abomonation-0.7)
        ("rust-alga" ,rust-alga-0.9)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-generic-array" ,rust-generic-array-0.12)
        ("rust-matrixmultiply" ,rust-matrixmultiply-0.2)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-rational" ,rust-num-rational-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-rand-xorshift" ,rust-rand-xorshift-0.1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-named-pipe-0.4
  (package
    (name "rust-named-pipe")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "named-pipe" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0azby10wzmsrf66m1bysbil0sjfybnvhsa8py093xz4irqy4975d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Only builds on Windows.
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/blackbeam/named_pipe")
    (synopsis "Wrapper for overlapped (asynchronous) IO of Windows's named pipes")
    (description "This package provides a wrapper for overlapped (asynchronous)
IO of Windows's named pipes.")
    (license (list license:expat license:asl2.0))))

(define-public rust-napi-0.5
  (package
    (name "rust-napi")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "napi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0mp0di7zv1r9gn3r3pmqnyy6q94akd9d6bl1p7m76nm9hgj9rw56"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-napi-sys" ,rust-napi-sys-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-0.2))
       #:cargo-development-inputs
       (("rust-napi-build" ,rust-napi-build-0.2))))
    (home-page "https://github.com/napi-rs/napi-rs")
    (synopsis "N-API bindings")
    (description "This package provides N-API bindings.")
    (license license:expat)))

(define-public rust-napi-build-0.2
  (package
    (name "rust-napi-build")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "napi-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1z02mlw1wa01fjpjnqns3f3vxacbg1jnk98hcg3pgwp5xy3zdyqq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-reqwest" ,rust-reqwest-0.10))))
    (home-page "https://github.com/napi-rs/napi-rs")
    (synopsis "N-API build support")
    (description "This package provides N-API build support.")
    (license license:expat)))

(define-public rust-napi-derive-0.5
  (package
    (name "rust-napi-derive")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "napi-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kkgpzw4i6f0zkg80v9vhr7y5rg25q3kv67029i1gcgsrxlqx4zi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/napi-rs/napi-rs")
    (synopsis "N-API procedural macros")
    (description "This package provides N-API procedural macros.")
    (license license:expat)))

(define-public rust-napi-sys-0.4
  (package
    (name "rust-napi-sys")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "napi-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cjirf6n4i2lw65iaww8d4hahv3cbfm5ka9hlansvnbfgzwadzq9"))))
    (build-system cargo-build-system)
    (inputs
     `(("openssl" ,openssl)))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.55)
        ("rust-semver" ,rust-semver-0.10)
        ("rust-tar" ,rust-tar-0.4))
       #:cargo-development-inputs
       (("rust-flate2" ,rust-flate2-1)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-reqwest" ,rust-reqwest-0.10))))
    (home-page "https://github.com/napi-rs/napi-rs")
    (synopsis "NodeJS N-API raw binding")
    (description "This package provides a NodeJS N-API raw binding.")
    (license license:expat)))

(define-public rust-native-tls-0.2
  (package
    (name "rust-native-tls")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m6v16xl8h4pm32pw6yhrvgwznf60bqhj2qhb1yrb8wd3hp6pndq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ; tests require network access
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-security-framework" ,rust-security-framework-2)
        ("rust-security-framework-sys" ,rust-security-framework-sys-2)
        ("rust-tempfile" ,rust-tempfile-3))
       #:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.4)
        ("rust-test-cert-gen" ,rust-test-cert-gen-0.1))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("openssl" ,openssl)))
    (home-page "https://github.com/sfackler/rust-native-tls")
    (synopsis "Wrapper over a platform's native TLS implementation")
    (description
     "This package provides a wrapper over a platform's native TLS
implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-native-tls-0.1
  (package
    (inherit rust-native-tls-0.2)
    (name "rust-native-tls")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "native-tls" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h7v80nlskyr7b1gsg4ivlpm6pilj6ybgvcwadj7ips3igfblkgp"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl" ,rust-openssl-0.9)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-security-framework" ,rust-security-framework-0.1)
        ("rust-security-framework-sys" ,rust-security-framework-sys-0.1)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-natord-1
  (package
    (name "rust-natord")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "natord" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0z75spwag3ch20841pvfwhh3892i2z2sli4pzp1jgizbipdrd39h"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/lifthrasiir/rust-natord")
    (synopsis "Natural ordering for Rust")
    (description
     "This package provides a crate to perform natural ordering for Rust.")
    (license license:expat)))

(define-public rust-nb-connect-1
  (package
    (name "rust-nb-connect")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nb-connect" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1649m71wc0cg1rqgl8vbh0489znkhpwgl0isjd5x8mz470ash8w1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-polling" ,rust-polling-2))))
    (home-page "https://github.com/stjepang/nb-connect")
    (synopsis "Non-blocking TCP or Unix connect")
    (description
     "This crate allows you to create a TcpStream or a UnixStream in
a non-blocking way, without waiting for the connection to become fully
established.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ncurses-5
  (package
    (name "rust-ncurses")
    (version "5.100.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ncurses" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ss1ia7skbs5x2p5lccp38qmm3xnkq7spcp8cyr4yvvz5350gnx7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/jeaye/ncurses-rs")
    (synopsis "Thin wrapper around the @code{ncurses} TUI library")
    (description
     "This package provides a very thin wrapper around the @code{ncurses} TUI
library.")
    (license license:expat)))

(define-public rust-ndarray-0.12
  (package
    (name "rust-ndarray")
    (version "0.12.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ndarray" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0a5rfwcbqnvbwi3nw5sfz6kf0flhmjxs64s0b4kxc6lhmyl81wvw"))
        (patches (search-patches "rust-ndarray-remove-blas-src-dep.patch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-itertools" ,rust-itertools-0.7)
        ("rust-matrixmultiply" ,rust-matrixmultiply-0.1)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-cblas-sys" ,rust-cblas-sys-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-defmac" ,rust-defmac-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rawpointer" ,rust-rawpointer-0.1))))
    (home-page "https://github.com/rust-ndarray/ndarray")
    (synopsis "N-dimensional container for general elements and for numerics")
    (description "@code{ndarray} implements an n-dimensional container for
general elements and for numerics.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-ndk-0.2
  (package
    (name "rust-ndk")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ndk" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wvf4hy18lpfkr4bap846qv2cx1vdg3x0d4hcfba9l5yzv0ngcay"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;XXX: Android only
       #:cargo-inputs
       (("rust-jni" ,rust-jni-0.14)
        ("rust-jni-glue" ,rust-jni-glue-0.0)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-ndk-sys" ,rust-ndk-sys-0.2)
        ("rust-num-enum" ,rust-num-enum-0.4)
        ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/rust-windowing/android-ndk-rs")
    (synopsis "Safe Rust bindings to the Android NDK")
    (description
     "This package provides safe Rust bindings to the Android NDK.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ndk-glue-0.2
  (package
    (name "rust-ndk-glue")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ndk-glue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hajn6nsg6i3khi7yr2ayafpiznm5z3k5v64afqnz753nyw9kwxx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #true              ;XXX: Android only
       #:cargo-inputs
       (("rust-android-logger" ,rust-android-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-ndk" ,rust-ndk-0.2)
        ("rust-ndk-macro" ,rust-ndk-macro-0.2)
        ("rust-ndk-sys" ,rust-ndk-sys-0.2))))
    (home-page "https://github.com/rust-windowing/android-ndk-rs")
    (synopsis "Startup code for Android binaries")
    (description
     "This package provides startup code for Android binaries.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ndk-macro-0.2
  (package
    (name "rust-ndk-macro")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ndk-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07a8vjr4fpksssgp453bf82n73i4i17yj1lvbgvd0964glqcdl85"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-proc-macro-crate" ,rust-proc-macro-crate-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rust-windowing/android-ndk-rs")
    (synopsis "Helper macros for android ndk")
    (description "This package provides helper macros for android ndk.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ndk-sys-0.2
  (package
    (name "rust-ndk-sys")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ndk-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13c68a217ag3k18vlffpcj2qjfinchxxchzlwnsp075v7p5j4jf4"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rust-windowing/android-ndk-rs")
    (synopsis "FFI bindings for the Android NDK")
    (description "This package provides FFI bindings for the Android NDK.")
    (license (list license:expat license:asl2.0))))

(define-public rust-neso-0.5
  (package
    (name "rust-neso")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "neso" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j78iyrv3r46n7jdayvgwarpq9iaikc7yhqqvdii226bzgg32g3b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-console-error-panic-hook" ,rust-console-error-panic-hook-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))))
    (home-page "https://gitlab.com/jeffrey-xiao/neso-rs")
    (synopsis "Nintendo Entertainment System (NES) emulator")
    (description
     "NES Oxidized (NESO) is a Nintendo Entertainment System emulator written
in Rust that can compile to WebAssembly.")
    (license (list license:expat license:asl2.0))))

(define-public rust-net2-0.2
  (package
    (name "rust-net2")
    (version "0.2.33")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "net2" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "126g3fgfxp06zimc1l9iyxnn9cif1hjsg7sd81nlls5nnyghsma2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/rust-lang-nursery/net2-rs")
    (synopsis "Extensions to the standard library's networking types")
    (description
     "This library contains extensions to the standard library's networking
types as proposed in RFC 1158.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-nettle-7
  (package
    (name "rust-nettle")
    (version "7.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nettle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1n6dwy9zba8853bmxzhwaashd3np0wxpx0pj43brm0hb8n2sxbxi"))
       (patches (search-patches "rust-nettle-disable-vendor.patch"))))
    (build-system cargo-build-system)
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("clang" ,clang)
       ("gmp" ,gmp)
       ("nettle" ,nettle)))
    (arguments
     `(#:skip-build? #t ;; provides nothing, has no tests
       #:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-nettle-sys" ,rust-nettle-sys-2)
        ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs
       (("rust-bindgen" ,rust-bindgen-0.51)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://gitlab.com/sequoia-pgp/nettle-rs")
  (synopsis "Rust bindings for the Nettle cryptographic library")
  (description "This package provides Rust bindings for the Nettle
cryptographic library.")
  (license (list license:lgpl3 license:gpl2 license:gpl3))))

(define-public rust-nettle-5
  (package
    (inherit rust-nettle-7)
    (version "5.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nettle" version))
       (file-name
        (string-append (package-name rust-nettle-7) "-" version ".tar.gz"))
       (sha256
        (base32 "0zfplqdf3mag8r7lc124hl24vri8yg711jmm8gl1mpwnlhass2n4"))
       (patches (search-patches "rust-nettle-disable-vendor.patch"))))))

(define-public rust-nettle-sys-2
  (package
    (name "rust-nettle-sys")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nettle-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yq1w6dlcmg89x529i7s20j29afdhgim7qnsa7978fszzwrr6qmq"))
       (patches (search-patches "rust-nettle-sys-disable-vendor.patch"))))
    (build-system cargo-build-system)
    (native-inputs
     `(("clang" ,clang)
       ("pkg-config" ,pkg-config)))
    (inputs
     `(("nettle" ,nettle)))
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.51)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://gitlab.com/sequoia-pgp/nettle-sys")
    (synopsis "Low-level Rust bindings for the Nettle cryptographic library")
    (description "This package provides low-level Rust bindings for the Nettle
cryptographic library.")
    (license ;; licensed under either of these, at your option
     (list license:lgpl3 license:gpl2 license:gpl3))))

(define-public rust-new-debug-unreachable-1
  (package
    (name "rust-new-debug-unreachable")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "new_debug_unreachable" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c1br326qa0rrzxrn2rd5ah7xaprig2i9r4rwsx06vnvc1f003zl"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page
     "https://github.com/mbrubeck/rust-debug-unreachable")
    (synopsis
     "Panic in debug, @code{intrinsics::unreachable()} in release")
    (description
     "Panic in debug, @code{intrinsics::unreachable()} in
release (fork of debug_unreachable)")
    (license license:expat)))

(define-public rust-nibble-vec-0.1
  (package
    (name "rust-nibble-vec")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nibble_vec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hsdp3s724s30hkqz74ky6sqnadhp2xwcj1n1hzy4vzkz4yxi9bp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1))))
    (home-page "https://github.com/michaelsproul/rust_nibble_vec")
    (synopsis "Vector data-structure for half-byte values")
    (description "NibbleVec is a data structure for storing a sequence of half-bytes.")
    (license license:expat)))

(define-public rust-nickel-0.11
  (package
    (name "rust-nickel")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nickel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1na619j2k0hkv5qhws7ccibzhn1v637f1vqwnsn2vnr84y1il1p5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
        ("rust-groupable" ,rust-groupable-0.2)
        ("rust-hyper" ,rust-hyper-0.10)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.3)
        ("rust-modifier" ,rust-modifier-0.1)
        ("rust-mustache" ,rust-mustache-0.9)
        ("rust-plugin" ,rust-plugin-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-time" ,rust-time-0.1)
        ("rust-typemap" ,rust-typemap-0.3)
        ("rust-url" ,rust-url-1))))
    (home-page "http://nickel-org.github.io/")
    (synopsis "Web application framework for Rust")
    (description
     "@code{nickel.rs} is a simple and lightweight foundation for web
applications written in Rust.  Its API is inspired by the popular
@code{express} framework for JavaScript.")
    (license license:expat)))

(define-public rust-nipper-0.1
  (package
    (name "rust-nipper")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nipper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l003qvzivrqq2lj2cdn4q5x0fg6xczld13m41x492x0g91hwvap"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cssparser" ,rust-cssparser-0.27)
        ("rust-html5ever" ,rust-html5ever-0.25)
        ("rust-markup5ever" ,rust-markup5ever-0.10)
        ("rust-selectors" ,rust-selectors-0.22)
        ("rust-tendril" ,rust-tendril-0.4))))
    (home-page "https://github.com/importcjj/nipper")
    (synopsis "HTML manipulation with CSS selectors")
    (description
     "Nipper is based on HTML crate html5ever and the CSS selector crate
selectors.  You can use the jQuery-like syntax to query and manipulate an HTML
document quickly.")
    (license (list license:expat license:asl2.0))))

(define-public rust-nix-0.20
  (package
    (name "rust-nix")
    (version "0.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12n1syfd967hblrcrrqk63a4s1h4hsybfqwblh71rihvv8cli6zs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/nix-rust/nix")
    (synopsis "Rust friendly bindings to *nix APIs")
    (description
     "Nix seeks to provide friendly bindings to various *nix platform APIs.
The goal is to not provide a 100% unified interface, but to unify what can be
while still providing platform specific APIs.")
    (license license:expat)))

(define-public rust-nix-0.19
  (package
    (inherit rust-nix-0.20)
    (name "rust-nix")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wk1pmaf9pv84sc4jf19gm1as2yq3ydwcx0n5nc1bpsgzq6bmk5j"))))
    (arguments
     `(#:tests? #f                      ; test suite hangs
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-caps" ,rust-caps-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-semver" ,rust-semver-0.9)
        ("rust-sysctl" ,rust-sysctl-0.1)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-nix-0.18
  (package
    (inherit rust-nix-0.19)
    (name "rust-nix")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0m8h9bskjjqx9sk687z8bxqg2kpwhdh78jq6zfaxsb8llvk0yic3"))))
    (arguments
     `(#:tests? #f                      ; test suite hangs
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-caps" ,rust-caps-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-semver" ,rust-semver-0.9)
        ("rust-sysctl" ,rust-sysctl-0.1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (inputs
     `(("rust-bitflags" ,rust-bitflags-1)
       ("rust-cc" ,rust-cc-1)
       ("rust-cfg-if" ,rust-cfg-if-0.1)
       ("rust-libc" ,rust-libc-0.2)))))

(define-public rust-nix-0.17
  (package
    (inherit rust-nix-0.19)
    (name "rust-nix")
    (version "0.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qvk09kib3jpvpbaps0682nav20ibql61pf1s2h8jx9v5igpir2h"))))
    (arguments
     `(#:tests? #f                      ; test suite hangs
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-void" ,rust-void-1))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-caps" ,rust-caps-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-sysctl" ,rust-sysctl-0.1)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-nix-0.15
  (package
    (inherit rust-nix-0.17)
    (name "rust-nix")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0aa2l7wg9pzx24ks4p97gdy09a4hhs1sr9drxnm75v906d7hnbiv"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Unpin the dependency on tempfile, as it was withheld for MSRV
           ;; concerns, which don't matter for Guix:
           ;; https://github.com/nix-rust/nix/commit/98531c8f04bc23fb632c08e06dc4e56284b9c027
           (substitute* "Cargo.toml"
             (("version = \">= 3.0.5, < 3.0.9\"") "version = \"3.0.5\""))
           #t))))))

(define-public rust-nix-0.14
  (package
    (inherit rust-nix-0.15)
    (name "rust-nix")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nix" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kmxdlmvnmq8cfpmr3g6wk37rwi2ybdvp1z6z3831m1p23p2nwkc"))))))

(define-public rust-no-panic-0.1
  (package
    (name "rust-no-panic")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "no-panic" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xan5v9ac1aklinc8aw16raq36pb4idjrl502np8gy32gfs6s751"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/dtolnay/no-panic")
    (synopsis "Prove a function can't ever panic")
    (description
     "This package provides a rust attribute macro to require that the compiler
prove a function can't ever panic.")
    (license (list license:expat license:asl2.0))))

(define-public rust-nodrop-0.1
  (package
    (name "rust-nodrop")
    (version "0.1.14")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nodrop" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1fz1v9r8ijacf0hlq0pdv5l9mz8vgqg1snmhvpjmi9aci1b4mvvj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nodrop-union" ,rust-nodrop-union-0.1))))
    (home-page "https://github.com/bluss/arrayvec")
    (synopsis "Wrapper type to inhibit drop (destructor)")
    (description "This package provides a wrapper type to inhibit drop
(destructor).  Use @code{std::mem::ManuallyDrop} instead!")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-nodrop-union-0.1
  (package
    (name "rust-nodrop-union")
    (version "0.1.11")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "nodrop-union" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1h59pph19rxanyqcaid8pg73s7wmzdx3zhjv5snlim5qx606zxkc"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))   ; depends on features not in stable Rust
    (home-page "https://github.com/bluss/arrayvec")
    (synopsis "Wrapper type to inhibit drop (destructor)")
    (description "This package provides a wrapper type to inhibit drop
(destructor).  Implementation crate for @code{nodrop}, the untagged unions
implementation (which is unstable / requires nightly).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-nom-6
  (package
    (name "rust-nom")
    (version "6.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1w0ppq112myzwk23c8m0wmq0nv73xvn0g9gl2kfm83aadgylq0w8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests require example directory, not included in tarball.
       #:cargo-inputs
       (("rust-bitvec" ,rust-bitvec-0.19)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.7)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-jemallocator" ,rust-jemallocator-0.3))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))
    (native-inputs
     `(("jemalloc" ,jemalloc)))
    (home-page "https://github.com/Geal/nom")
    (synopsis
     "Byte-oriented, zero-copy, parser combinators library")
    (description
     "This package provides a byte-oriented, zero-copy, parser
combinators library.")
    (license license:expat)))

(define-public rust-nom-5
  (package
    (inherit rust-nom-6)
    (name "rust-nom")
    (version "5.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1br74rwdp3c2ddga03bphnf355spn4mzwf1slg0a30zd4qnjdd7z"))))
    (arguments
     `(#:tests? #f  ; Tests require example directory, not included in tarball.
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.7)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-jemallocator" ,rust-jemallocator-0.1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'configure 'override-jemalloc
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jemalloc (assoc-ref inputs "jemalloc")))
               (setenv "JEMALLOC_OVERRIDE"
                       (string-append jemalloc "/lib/libjemalloc_pic.a")))
             #t)))))))

(define-public rust-nom-4
  (package
    (inherit rust-nom-5)
    (name "rust-nom")
    (version "4.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mkvby8b4m61p4g1px0pwr58yfkphyp1jcfbp4qfp7l6iqdaklia"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-check" ,rust-version-check-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-jemallocator" ,rust-jemallocator-0.1))))))

(define-public rust-nom-3
  (package
    (inherit rust-nom-4)
    (name "rust-nom")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0yr8fazcspgawl6s7wmx5llz61s68jl88cnrph18fa7xf06cbbh5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; stream::tests::seeking_consumer fails
       #:cargo-inputs
       (("rust-compiler-error" ,rust-compiler-error-0.1)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-memchr" ,rust-memchr-1)
        ("rust-regex" ,rust-regex-0.2))))))

(define-public rust-nom-2
  (package
    (inherit rust-nom-4)
    (name "rust-nom")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1zv6ig7nw532rl4p35jsahglfhyyznjkblwa6si6c0plxhlsflfg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.2))
       #:tests? #f))))

(define-public rust-nom-1
  (package
    (inherit rust-nom-4)
    (name "rust-nom")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "nom" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kjh42w67z1hh1dw3jrilgqrf54jk2xcvhw4rcdm4wclzmbc5f55"))))
    (arguments
      ;; This is an ancient version and all inputs are optional.
     `(#:skip-build? #t))))

(define-public rust-noop-proc-macro-0.3
  (package
    (name "rust-noop-proc-macro")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "noop_proc_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j2v1c6ric4w9v12h34jghzmngcwmn0hll1ywly4h6lcm4rbnxh6"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/lu-zero/noop_proc_macro")
    (synopsis "No-op procedural macro, literally does nothing")
    (description
     "This package provides a no-op procedural macro, which literally does
nothing.")
    (license license:expat)))

(define-public rust-noop-proc-macro-0.2
  (package
    (inherit rust-noop-proc-macro-0.3)
    (name "rust-noop-proc-macro")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "noop_proc_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0in1l0rjxzs4fylb6zad484z1c58jxyzchhc12k0cjrvm0y6zwsz"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-normalize-line-endings-0.3
  (package
    (name "rust-normalize-line-endings")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "normalize-line-endings" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1gp52dfn2glz26a352zra8h04351icf0fkqzw1shkwrgh1vpz031"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/derekdreery/normalize-line-endings")
    (synopsis
     "Iterate over chars and returns a new iterator with all line endings")
    (description
     "This package takes an iterator over characters and returns a new iterator
with all line endings.")
    (license license:asl2.0)))

(define-public rust-normalize-line-endings-0.2
  (package
    (inherit rust-normalize-line-endings-0.3)
    (name "rust-normalize-line-endings")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "normalize-line-endings" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a1knz9j1w5a1pl2q6whmjphm3z6p64r5njnam7syp5rx8wil2if"))))))

(define-public rust-notify-4
  (package
    (name "rust-notify")
    (version "4.0.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "notify" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1gadf8jf1vz7sip37rlwa66vw85ripy6977ibcfbiynii1v4mbl0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-fsevent" ,rust-fsevent-0.4)
        ("rust-fsevent-sys" ,rust-fsevent-sys-2)
        ("rust-inotify" ,rust-inotify-0.7)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/passcod/notify")
    (synopsis "Cross-platform file system notification library")
    (description
     "Cross-platform file system notification library.")
    (license license:cc0)))

(define-public rust-ntapi-0.3
  (package
    (name "rust-ntapi")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ntapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i5daj9sr8wyi5jkpwpybln2jqpn59z0mqfc0dpdidipwh1bjsrz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "")
    (synopsis "FFI bindings for Native API")
    (description "FFI bindings for Native API")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ntest-0.3
  (package
    (name "rust-ntest")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ntest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04cljndihkcqqwj061bgpnxyv7wqbd3f91ag1b3ryrayn7rrclxv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ntest-test-cases" ,rust-ntest-test-cases-0.3)
        ("rust-ntest-timeout" ,rust-ntest-timeout-0.3)
        ("rust-timebomb" ,rust-timebomb-0.1))
       #:cargo-development-inputs
       (("rust-ntest-test-cases" ,rust-ntest-test-cases-0.3)
        ("rust-ntest-timeout" ,rust-ntest-timeout-0.3)
        ("rust-timebomb" ,rust-timebomb-0.1))))
    (home-page "https://github.com/becheran/ntest")
    (synopsis "Testing framework for Rust")
    (description "This package provides a testing framework for Rust which
enhances the built-in library with some useful features.")
    (license license:expat)))

(define-public rust-ntest-test-cases-0.3
  (package
    (name "rust-ntest-test-cases")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ntest_test_cases" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0b67m368599b2zgwx19psqz6n3m9m5532h1257x6vz1pym3gd2na"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/becheran/ntest")
    (synopsis "Test cases for ntest framework")
    (description "This package provides test cases for ntest framework.")
    (license license:expat)))

(define-public rust-ntest-timeout-0.3
  (package
    (name "rust-ntest-timeout")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ntest_timeout" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0klryn3rgjxnq3cv6j8bwcsr0b7zw3x216h63144v22aja18p0g0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-timebomb" ,rust-timebomb-0.1))))
    (home-page "https://github.com/becheran/ntest")
    (synopsis "Timeout attribute for the ntest framework")
    (description "This package provides a timeout attribute for the ntest
framework.")
    (license license:expat)))

(define-public rust-num-0.3
  (package
    (name "rust-num")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jng6s3i51k3227id2z8h348l2da8x3jq4p3az9slkxwj5hifgmb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-complex" ,rust-num-complex-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-iter" ,rust-num-iter-0.1)
        ("rust-num-rational" ,rust-num-rational-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/rust-num/num")
    (synopsis "Collection of numeric types and traits for Rust")
    (description
     "This package provides a collection of numeric types and traits for Rust,
including bigint, complex, rational, range iterators, generic integers, and more.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-0.2
  (package
    (inherit rust-num-0.3)
    (name "rust-num")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dhcvhprvvx1iaaq7sxlgxw5awmj8dibni8vhizi59zyz4q60lxq"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-iter" ,rust-num-iter-0.1)
        ("rust-num-rational" ,rust-num-rational-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))))))

(define-public rust-num-0.1
  (package
    (inherit rust-num-0.2)
    (name "rust-num")
    (version "0.1.42")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0vhmyvfan380f86895z0f8rjscjc6qvwcmyvm15370ik2mjas0s7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.1)
        ("rust-num-complex" ,rust-num-complex-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-iter" ,rust-num-iter-0.1)
        ("rust-num-rational" ,rust-num-rational-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2))))))

(define-public rust-num-bigint-0.3
  (package
    (name "rust-num-bigint")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-bigint" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gq7cpvmzk5jixzr26fbjfayiigzh4p4vyyzbb73yqz4g9s436jy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-0.4)
        ("rust-autocfg" ,rust-autocfg-1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/rust-num/num-bigint")
    (synopsis "Big integer implementation for Rust")
    (description
     "This package provides a big integer implementation for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-bigint-0.2
  (package
    (inherit rust-num-bigint-0.3)
    (name "rust-num-bigint")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-bigint" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "015k3wixdi4w698sappvy43pf8bvkw0f88xplmdgc3zfk2cpy309"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-0.8)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-autocfg" ,rust-autocfg-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-num-bigint-0.1
  (package
    (inherit rust-num-bigint-0.2)
    (name "rust-num-bigint")
    (version "0.1.44")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-bigint" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1hg80xd7vd5yqzks1h0zk2fcgqnf84m2cdj9q4cffk581nnrjf76"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-0.8))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))))

(define-public rust-num-bigint-dig-0.6
  (package
    (name "rust-num-bigint-dig")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-bigint-dig" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1aljx3bxfnzq35i9pkbqkj0d0hc1wjc2dd60wccjqylz1wrkrl5k"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-autocfg" ,rust-autocfg-0.1)
         ("rust-byteorder" ,rust-byteorder-1)
         ("rust-lazy-static" ,rust-lazy-static-1)
         ("rust-libm" ,rust-libm-0.2)
         ("rust-num-integer" ,rust-num-integer-0.1)
         ("rust-num-iter" ,rust-num-iter-0.1)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-rand" ,rust-rand-0.7)
         ("rust-serde" ,rust-serde-1)
         ("rust-smallvec" ,rust-smallvec-1)
         ("rust-zeroize" ,rust-zeroize-1))))
    (home-page
      "https://github.com/dignifiedquire/num-bigint")
    (synopsis "Big integer implementation for Rust")
    (description "This package provides a big integer implementation
for Rust")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-complex-0.3
  (package
    (name "rust-num-complex")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-complex" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1dczd81f2xb092dhb0brbdbf19pyfn0v9xmkf6qm0w4pv1dx0nmh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1))))
    (home-page
     "https://github.com/rust-num/num-complex")
    (synopsis
     "Complex numbers implementation for Rust")
    (description
     "Complex numbers implementation for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-complex-0.2
  (package
    (inherit rust-num-complex-0.3)
    (name "rust-num-complex")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-complex" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15dwaksw729r3v14sgzc9723s3fnfixiir8jzwx7b7kim48r9cdn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-autocfg" ,rust-autocfg-1))))))

(define-public rust-num-complex-0.1
  (package
    (inherit rust-num-complex-0.2)
    (name "rust-num-complex")
    (version "0.1.43")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-complex" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0mln3h018lar511hadjwfkbyq1561s8kdzfg8aagbakqg0fn725j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-0.8))))))

(define-public rust-num-cpus-1
  (package
    (name "rust-num-cpus")
    (version "1.13.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num_cpus" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1cv6yxhz2zbnwn8pn1yn8grg7zsnd523947fby41a737aqvryj85"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
        (("rust-hermit-abi" ,rust-hermit-abi-0.1)
         ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/seanmonstar/num_cpus")
    (synopsis "Get the number of CPUs on a machine")
    (description
     "Get the number of CPUs on a machine.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-num-derive-0.3
  (package
    (name "rust-num-derive")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1czs5215ypgbwg0qgy2i515xj3vfcgm8fw7gi4gmwsyv3a2bj2bg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))
       #:cargo-development-inputs
       (("rust-num" ,rust-num-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/rust-num/num-derive")
    (synopsis "Numeric syntax extensions")
    (description "This package provides numeric syntax extensions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-derive-0.2
  (package
    (name "rust-num-derive")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1wnv7776fh4i40r3zfxcxcmm0dh029skx7gp4sjknz2kqm2hpzga"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-num" ,rust-num-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/rust-num/num-derive")
    (synopsis "Numeric syntax extensions")
    (description "Numeric syntax extensions in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-enum-0.4
  (package
    (name "rust-num-enum")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num_enum" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r1nisdzm9m7xm0389nwyi85jhx1bnh5pwllai44ngbgy1ymlmna"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;missing files
       #:cargo-inputs
       (("rust-derivative" ,rust-derivative-2)
        ("rust-num-enum" ,rust-num-enum-0.4)
        ("rust-num-enum-derive" ,rust-num-enum-derive-0.4))))
    (home-page "https://github.com/illicitonion/num_enum")
    (synopsis "Macros easing inter-operation between primitives and enums")
    (description
     "This library provides procedural macros to make inter-operation between
primitives and enums easier.")
    (license license:bsd-3)))

(define-public rust-num-enum-derive-0.4
  (package
    (name "rust-num-enum-derive")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num_enum_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17fvb7xpxq2dsqp5nsz98w1qhkk3gnc56xis53009vnzvlys79gz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ;FIXME: some doc tests fail
       #:cargo-inputs
       (("rust-proc-macro-crate" ,rust-proc-macro-crate-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/illicitonion/num_enum")
    (synopsis "Procedural macros to ease operation between primitives and enums")
    (description
     "This package provides procedural macros to make inter-operation between
primitives and enums easier.")
    (license license:bsd-3)))

(define-public rust-num-format-0.4
  (package
    (name "rust-num-format")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-format" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0r94i9lhr15hk32494v9my31r0829w29yyp7iql98a1cf9wl3zms"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-num-format-windows" ,rust-num-format-windows-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-widestring" ,rust-widestring-0.4)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/bcmyers/num-format")
    (synopsis "Produce string-representations of numbers")
    (description
     "This package provides a Rust crate for producing string-representations
of numbers, formatted according to international standards.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-format-windows-0.3
  (package
    (name "rust-num-format-windows")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-format-windows" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sy5jxrbhv6s28c51ibzi34s8qcjm8b21nf7biray7v1qi89h5sf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.47))))
    (home-page "https://github.com/bcmyers/num-format/num-format-windows")
    (synopsis "Helper crate for @code{num-format}")
    (description
     "This package provides a helper crate for num-format.  Do not use it
directly.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-integer-0.1
  (package
    (name "rust-num-integer")
    (version "0.1.44")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-integer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nq152y3304as1iai95hqz8prqnc94lks1s7q05sfjdmcf56kk6j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/rust-num/num-integer")
    (synopsis "Integer traits and functions")
    (description "This package provides Integer traits and functions.")
    ;; Dual licensed.
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-num-iter-0.1
  (package
    (name "rust-num-iter")
    (version "0.1.41")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-iter" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "17sb142lhmpsq17cf9wrffjh8vjk901axxf55565r6cgfiy6nvks"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-autocfg" ,rust-autocfg-1))))
    (home-page "https://github.com/rust-num/num-iter")
    (synopsis "External iterators for generic mathematics")
    (description
     "This crate provides external iterators for generic mathematics.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-num-rational-0.3
  (package
    (name "rust-num-rational")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-rational" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0f41j1l1kn5jj36a8xdy8kv242wlwq0ka578vm8gnb1n1wvdgd55"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-autocfg" ,rust-autocfg-1))))
    (home-page "https://github.com/rust-num/num-rational")
    (synopsis "Rational numbers implementation for Rust")
    (description
     "Rational numbers implementation for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-num-rational-0.2
  (package
    (inherit rust-num-rational-0.3)
    (name "rust-num-rational")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-rational" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18q3vq3xldhaj0z3f92am8f59m1awywgdj28c7wvx0bcksgwfkfs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-autocfg" ,rust-autocfg-1))))))

(define-public rust-num-rational-0.1
  (package
    (inherit rust-num-rational-0.2)
    (name "rust-num-rational")
    (version "0.1.42")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-rational" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kkqb8j3b3nis9hs4ww4hkrmb4a6v9sr9al08xmwhgvmpms4qcgf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-0.8))))))

(define-public rust-num-traits-0.2
  (package
    (name "rust-num-traits")
    (version "0.2.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "num-traits" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "144j176s2p76azy2ngk2vkdzgwdc0bc8c93jhki8c9fsbknb2r4s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/rust-num/num-traits")
    (synopsis "Numeric traits for generic mathematics")
    (description "This package provides numeric traits for generic
mathematics.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-num-traits-0.1
  (package
    (inherit rust-num-traits-0.2)
    (name "rust-num-traits")
    (version "0.1.43")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "num-traits" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0c9whknf2dm74a3cqirafy6gj83a76gl56g4v3g19k6lkwz13rcj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" , rust-num-traits-0.2))))))

(define-public rust-number-prefix-0.3
  (package
    (name "rust-number-prefix")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "number_prefix" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0slm4mqmpgs6hvz22ycny9lvyvl9ivs80a1lncslp7lszz02zc0p"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ogham/rust-number-prefix")
    (synopsis "Format numeric prefixes: kilo, giga, kibi")
    (description
     "This package provides a library for formatting numeric prefixes: kilo,
giga, kibi.")
    (license license:expat)))

(define-public rust-numtoa-0.1
  (package
    (name "rust-numtoa")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "numtoa" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1vs9rhggqbql1p26x8nkha1j06wawwgb2jp5fs88b5gi7prvvy5q"))))
    (build-system cargo-build-system)
    (arguments '(#:tests? #f))
    (home-page "https://gitlab.com/mmstick/numtoa")
    (synopsis "Convert numbers into stack-allocated byte arrays")
    (description
     "This package can convert numbers into stack-allocated byte arrays.")
    (license (list license:expat license:asl2.0))))

(define-public rust-obj-0.9
  (package
    (name "rust-obj")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "obj" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10z1r2r0xyhr4j1n07135kz4bc0zhqy98vabs99vz0x171bi8gy0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-genmesh" ,rust-genmesh-0.6))))
    (home-page "https://github.com/kvark/obj")
    (synopsis "Package for loading Wavefront .obj files")
    (description
     "This package provides a package for loading Wavefront @code{.obj} files.")
    (license license:asl2.0)))

(define-public rust-objc-0.2
  (package
    (name "rust-objc")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "objc" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cbpf6kz8a244nn1qzl3xyhmp05gsg4n313c9m3567625d3innwi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests require gcc-objc.
       #:cargo-inputs
       (("rust-malloc-buf" ,rust-malloc-buf-0.0)
        ("rust-objc-exception" ,rust-objc-exception-0.1))))
    (home-page "https://github.com/SSheldon/rust-objc")
    (synopsis "Objective-C Runtime bindings and wrapper for Rust")
    (description "This package provides an Objective-C Runtime bindings and
wrapper for Rust.")
    (license license:expat)))

(define-public rust-objc-exception-0.1
  (package
    (name "rust-objc-exception")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "objc-exception" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "191cmdmlypp6piw67y4m8y5swlxf5w0ss8n1lk5xd2l1ans0z5xd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/SSheldon/rust-objc-exception")
    (synopsis "Rust interface for Objective-C's throw and try/catch statements")
    (description
     "This package provides a Rust interface for Objective-C's throw and
try/catch statements.")
    (license license:expat)))

(define-public rust-objc-foundation-0.1
  (package
    (name "rust-objc-foundation")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "objc-foundation" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1y9bwb3m5fdq7w7i4bnds067dhm4qxv4m1mbg9y61j9nkrjipp8s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Only available on macOS.
       #:cargo-inputs
       (("rust-block" ,rust-block-0.1)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-objc-id" ,rust-objc-id-0.1))))
    (home-page "https://github.com/SSheldon/rust-objc-foundation")
    (synopsis "Rust wrapper for Objective-C's Foundation framework")
    (description "This package provides a rust wrapper for Objective-C's
Foundation framework.")
    (license license:expat)))

(define-public rust-objc-id-0.1
  (package
    (name "rust-objc-id")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "objc_id" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fq71hnp2sdblaighjc82yrac3adfmqzhpr11irhvdfp9gdlsbf9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests require gcc-objc.
       #:cargo-inputs (("rust-objc" ,rust-objc-0.2))))
    (home-page "https://github.com/SSheldon/rust-objc-id")
    (synopsis "Rust smart pointers for Objective-C reference counting")
    (description
     "This package provides Rust smart pointers for Objective-C reference counting.")
    (license license:expat)))

(define-public rust-objc-test-utils-0.0
  (package
    (name "rust-objc-test-utils")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "objc_test_utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09rckmp5h9bbns08xzicdlk7y5lxj2ygbg3yqk1cszfnzd5n8kzx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/SSheldon/rust-objc")
    (synopsis "Utilities for testing Objective-C interop")
    (description
     "This package provides utilities for testing Objective-C interop.")
    (license license:expat)))

(define-public rust-object-0.23
  (package
    (name "rust-object")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "object" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m658q2ci9hk8csbl17zwcg1hpvcxm2sspjb9bzg0kc1cifsp9x9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-wasmparser" ,rust-wasmparser-0.57))))
    (home-page "https://github.com/gimli-rs/object")
    (synopsis "Unified interface for reading and writing object file formats")
    (description
     "This package provides a unified interface for reading and writing object
file formats.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-object-0.22
  (package
    (inherit rust-object-0.23)
    (name "rust-object")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "object" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15r383qxxwq08q3a5rfqhp971wd0nixd9ny22xw37jy31qv66fwd"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-wasmparser" ,rust-wasmparser-0.57))))))

(define-public rust-object-0.17
  (package
    (inherit rust-object-0.23)
    (name "rust-object")
    (version "0.17.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "object" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1bmgbg4k0725lchfy9j1wnpfmywh5qhs0k4k6j2g7c0acvys8i7a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-goblin" ,rust-goblin-0.1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.10)
        ("rust-scroll" ,rust-scroll-0.10)
        ("rust-parity-wasm" ,rust-parity-wasm-0.41)
        ("rust-uuid" ,rust-uuid-0.8)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-crc32fast" ,rust-crc32fast-1)
        ("rust-indexmap" ,rust-indexmap-1))))))

(define-public rust-object-0.12
  (package
    (name "rust-object")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "object" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dch1ajjp05d16lig1dnvisfis0hrlrvw9lcwy1hwgdcym3z6jnz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-flate2" ,rust-flate2-1)
        ("rust-goblin" ,rust-goblin-0.0)
        ("rust-parity-wasm" ,rust-parity-wasm-0.40)
        ("rust-scroll" ,rust-scroll-0.9)
        ("rust-uuid" ,rust-uuid-0.7))
       #:cargo-development-inputs
       (("rust-memmap" ,rust-memmap-0.7))))
    (home-page "https://github.com/gimli-rs/object")
    (synopsis "Parse object file formats")
    (description
     "This package provides a unified interface for parsing object file
formats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-odds-0.3
  (package
    (name "rust-odds")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "odds" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rdnxa0na4897yb0svb3figz35g4imxjv61yfm2j21gbh5q8v8d9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rawpointer" ,rust-rawpointer-0.1)
        ("rust-rawslice" ,rust-rawslice-0.1)
        ("rust-unchecked-index" ,rust-unchecked-index-0.2))
       #:cargo-development-inputs
       (("rust-itertools" ,rust-itertools-0.7)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-quickcheck" ,rust-quickcheck-0.4))))
    (home-page "https://github.com/bluss/odds")
    (synopsis "Extra functionality for slices, strings and other things")
    (description
     "Odds and ends collection miscellania.  Extra functionality for
slices (@code{.find()}, @code{RevSlice}), strings and other things.
Things in odds may move to more appropriate crates if we find them.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-odds-0.2
  (package
    (inherit rust-odds-0.3)
    (name "rust-odds")
    (version "0.2.26")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "odds" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08pvngx0nf7yl9cgk4bahn1a0s8na5g9knbhq7y29kysp58h3bjf"))))
    (arguments
     `(#:tests? #f      ; doc tests fail
       #:cargo-inputs
       (("rust-rawpointer" ,rust-rawpointer-0.1)
        ("rust-rawslice" ,rust-rawslice-0.1)
        ("rust-unchecked-index" ,rust-unchecked-index-0.2))
       #:cargo-development-inputs
       (("rust-itertools" ,rust-itertools-0.5)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-onig-6
  (package
    (name "rust-onig")
    (version "6.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "onig" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mcx125hh22kx2d0676hkk2gli6v8r6c4rp3wh5qy0dwxpcnzd1h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-onig-sys" ,rust-onig-sys-69.6))))
    (home-page "https://github.com/rust-onig/rust-onig")
    (synopsis "Rust bindings for the Oniguruma regular expression library")
    (description
     "Rust-Onig is a set of Rust bindings for the Oniguruma regular expression
library.")
    (license license:expat)))

(define-public rust-onig-5
  (package
    (inherit rust-onig-6)
    (name "rust-onig")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "onig" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ivr0wq1zlyjhhkxpsnmpncg92sjx3rha8pnp3m1mzvgk7y27rz4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-onig-sys" ,rust-onig-sys-69.2))))))

(define-public rust-onig-sys-69.6
  (package
    (name "rust-onig-sys")
    (version "69.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "onig_sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xapbm4mrmyar1lbs3xrly2hm2mkb38hji1j15fjw3scryb3q1pd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.55)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/rust-onig/rust-onig")
    (synopsis "Rust bindings to the Oniguruma library")
    (description
     "This crate contains raw Rust bindings to the Oniguruma library.
This crate exposes a set of unsafe functions which can then be used by
other crates to create safe wrappers around Oniguruma.")
    (license license:expat)))

(define-public rust-onig-sys-69.2
  (package
    (inherit rust-onig-sys-69.6)
    (name "rust-onig-sys")
    (version "69.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "onig_sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kjijq29yx05xxg9snvqnfn53dl52hchb4sk3zhfr77mypxlx38a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.50)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))))

(define-public rust-once-cell-1
  (package
    (name "rust-once-cell")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "once-cell" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "183zs1dbmsv24mkafjypf9qwjrx46an58vb004a162l113sl3g8k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-parking-lot" ,rust-parking-lot-0.11))
       #:cargo-development-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/matklad/once_cell")
    (synopsis "Single assignment cells and lazy values")
    (description
     "This package provides two new cell-like types, @code{unsync::OnceCell}
and @code{sync::OnceCell}.  OnceCell might store arbitrary non-copy types, can
be assigned to at most once and provide direct access to the stored
contents.")
    (license (list license:expat license:asl2.0))))

(define-public rust-once-cell-0.1
  (package
    (inherit rust-once-cell-1)
    (name "rust-once-cell")
    (version "0.1.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "once-cell" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0drcjs7si0hygc0v64y55hkxv9fpvlvrb3wl5374b2hnc6i2jb2k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-parking-lot" ,rust-parking-lot-0.7))
       #:cargo-development-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))))))

(define-public rust-oorandom-11.1
  (package
    (name "rust-oorandom")
    (version "11.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "oorandom" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "01clxfnz1zwg4maynvbgj09wlkj5m3c8kjqfrp3sqp59qb4wgkpb"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://hg.sr.ht/~icefox/oorandom")
    (synopsis "A tiny, robust PRNG implementation.")
    (description
      "This package provides a tiny, robust PRNG implementation.")
    (license license:expat)))

(define-public rust-opaque-debug-0.3
  (package
    (name "rust-opaque-debug")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "opaque-debug" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1m8kzi4nd6shdqimn0mgb24f0hxslhnqd1whakyq06wcqd086jk2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Macro for opaque debug trait implementation")
    (description
     "This package provides a macro for opaque debug trait implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-opaque-debug-0.2
  (package
    (inherit rust-opaque-debug-0.3)
    (name "rust-opaque-debug")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "opaque-debug" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02942l2gc7w5r4js7i9063x99szic5mzzk1055j83v4diqpbpxck"))))))

(define-public rust-open-1
  (package
    (name "rust-open")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "open" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j6ci7jc2aabvw0rvq7a51sw9s2rk3mfsq0s5zjakzjf27q3na3w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Byron/open-rs")
    (synopsis "Open a path or URL using the program configured on the system")
    (description
     "Use this library to open a path or URL using the program configured on
the system.")
    (license license:expat)))

(define-public rust-openssl-0.10
  (package
    (name "rust-openssl")
    (version "0.10.30")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "openssl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1d5wwajanjw1q5d2y23yaq8rvbaqb20z53v7hfdryhb56vzmwmwd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9))
       #:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/sfackler/rust-openssl")
    (synopsis "OpenSSL bindings")
    (description "OpenSSL bindings.")
    (license license:asl2.0)))

(define-public rust-openssl-0.9
  (package
    (inherit rust-openssl-0.10)
    (name "rust-openssl")
    (version "0.9.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "openssl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11br5b8x1kc5klsn50ihiml82ajyzcwi3lljvrlsm8vlhhlmqq53"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-0.9)
        ("rust-foreign-types" ,rust-foreign-types-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9))))))

(define-public rust-openssl-0.7
  (package
    (inherit rust-openssl-0.10)
    (name "rust-openssl")
    (version "0.7.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "openssl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cw767rbasg4dbsfcsnxqm3q5ljkv6s1jq0a2p82xi5a8ii7n4f4"))))
    (arguments
     `(#:tests? #f      ; Test directory not included in release
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-0.7)
        ("rust-gcc" ,rust-gcc-0.3)
        ("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-sys" ,rust-openssl-sys-0.7)
        ("rust-openssl-sys-extras" ,rust-openssl-sys-extras-0.7))
       #:cargo-development-inputs
       (("rust-net2" ,rust-net2-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-winapi" ,rust-winapi-0.2)
        ("rust-ws2-32-sys" ,rust-ws2-32-sys-0.2))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-cargo-toml
           (lambda _
             (substitute* "Cargo.toml"
               ((", path =.*}") "}"))
             #t)))))
    (inputs
     `(("openssl" ,openssl-1.0))))) ; for openssl-sys-extras

(define-public rust-openssl-probe-0.1
  (package
    (name "rust-openssl-probe")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "openssl-probe" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1pijrdifgsdwd45b08c2g0dsmnhz7c3kmagb70839ngrd7d29bvp"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/alexcrichton/openssl-probe")
    (synopsis "Find SSL certificate locations")
    (description
     "This package provides a tool to find SSL certificate locations on the
system for OpenSSL.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-openssl-sys-0.9
  (package
    (name "rust-openssl-sys")
    (version "0.9.60")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "openssl-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1rpkfl0rmdcvxzyzp3n24g9clplh4avgzpi5c2a3hx96hcccf7wj"))
        (patches (search-patches "rust-openssl-sys-no-vendor.patch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ;; Build dependencies:
        ("rust-autocfg" ,rust-autocfg-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-vcpkg" ,rust-vcpkg-0.2))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (inputs
     `(("openssl" ,openssl)))
    (home-page "https://github.com/sfackler/rust-openssl")
    (synopsis "FFI bindings to OpenSSL")
    (description
     "This package provides FFI bindings to OpenSSL for use in rust crates.")
    (license license:expat)))

(define-public rust-openssl-sys-0.7
  (package
    (inherit rust-openssl-sys-0.9)
    (name "rust-openssl-sys")
    (version "0.7.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "openssl-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0gswbbfkhhj8f9jifwvdssv3p2lpgyz69qzqvafylbim9klpxi49"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; rust-libressl-pnacl-sys vendors libressl.
           (substitute* "Cargo.toml"
             ((".*nacl.*") ""))
           #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gdi32-sys" ,rust-gdi32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-user32-sys" ,rust-user32-sys-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))))

(define-public rust-openssl-sys-extras-0.7
  (package
    (name "rust-openssl-sys-extras")
    (version "0.7.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "openssl-sys-extras" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ymrmfnknyjji74fflbnnq9r5ihx25h0vgs5y203vl6klzdy3i8i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-sys" ,rust-openssl-sys-0.7)
        ("rust-gcc" ,rust-gcc-0.3))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-cargo-toml
           (lambda _
             (substitute* "Cargo.toml"
               ((", path =.*}") "}"))
             #t)))))
    (inputs
     `(("openssl" ,openssl-1.0)))   ; openssl-1.0 specifically
    (home-page "https://github.com/sfackler/rust-openssl")
    (synopsis
     "Extra FFI bindings to OpenSSL that require a C shim")
    (description
     "Extra FFI bindings to OpenSSL that require a C shim.")
    (license license:expat)))

(define-public rust-ord-subset-3
  (package
    (name "rust-ord-subset")
    (version "3.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ord-subset" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vvb6zmz279nb59dki7kbsvixbk8zpg2gxvgcpsjfnxg9ik19knp"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/emerentius/ord_subset")
    (synopsis "Tools for working with the Ord subset of certain PartialOrd types")
    (description
     "This package provides tools for working with the Ord subset of certain
PartialOrd types, like floats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ordered-float-1
  (package
    (name "rust-ordered-float")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ordered-float" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0625x96987kspdxbikry5mb7hsf5pdc5bbanxd8wjwqlx0ar71hq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/reem/rust-ordered-float")
    (synopsis "Wrappers for total ordering on floats")
    (description
     "This package provides wrappers for total ordering on floats in Rust.")
    (license license:expat)))

(define-public rust-ordermap-0.3
  (package
    (name "rust-ordermap")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ordermap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0qr0a50l0qakbjcck93qdayd0xl8gzpp42x0n7b75cs4ybsx6vm8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/bluss/indexmap")
    (synopsis "Hash table with consistent order and fast iteration")
    (description
     "This package provides a hash table with consistent order and fast
iteration.  NOTE: This crate was renamed to @code{indexmap}.  Please use it
under its new name.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-os-pipe-0.8
  (package
    (name "rust-os-pipe")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "os-pipe" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "049ax8shxik7mm68r2nf7xnrcq3z3p7hz54sbrcxwywxqsjdzs41"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-nix" ,rust-nix-0.15)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page
     "https://github.com/oconnor663/os_pipe.rs")
    (synopsis
     "Cross-platform library for opening OS pipes")
    (description
     "A cross-platform library for opening OS pipes.")
    (license license:expat)))

(define-public rust-output-vt100-0.1
  (package
    (name "rust-output-vt100")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "output_vt100" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ygqplpxz4gg3i8f3rkan2q69pqll7gv65l2mmd8r9dphnvwbkak"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Phundrak/output-vt100-rs")
    (synopsis
     "Utility to activate escape codes in Windows' CMD and PowerShell")
    (description
     "Utility to activate escape codes in Windows' CMD and PowerShell.")
    (license license:expat)))

(define-public rust-owned-ttf-parser-0.6
  (package
    (name "rust-owned-ttf-parser")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "owned_ttf_parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qydjksjcllf0pnm0jkjvbg4n52wfcwv59dl5b06cqn40sw3z4lz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ttf-parser" ,rust-ttf-parser-0.6))))
    (home-page "https://github.com/alexheretic/owned-ttf-parser")
    (synopsis "TTF-parser plus support for owned data")
    (description
     "This package provides a TTF-parser plus support for owned data.")
    (license license:asl2.0)))

(define-public rust-owning-ref-0.4
  (package
    (name "rust-owning-ref")
    (version "0.4.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "owning_ref" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1kjj9m28wjv452jw49p1mp3d8ql058x78v4bz00avr7rvsnmpxbg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/Kimundi/owning-ref-rs")
    (synopsis "Create references that carry their owner with them")
    (description
     "This package provides a library for creating references that carry their
owner with them.  This can sometimes be useful because Rust borrowing rules
normally prevent moving a type that has been borrowed from.")
    (license license:expat)))

(define-public rust-packed-simd-0.3
  (package
    (name "rust-packed-simd")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "packed_simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0822wqf6kzw4ig9ykndg348w2bxkhs3x64brzsvdxh2a1pyajpm8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-core-arch" ,rust-core-arch-0.1)
        ("rust-sleef-sys" ,rust-sleef-sys-0.1))
       #:cargo-development-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.4)
        ("rust-paste" ,rust-paste-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.2))))
    (home-page "https://github.com/rust-lang/packed_simd")
    (synopsis "Portable Packed SIMD vectors")
    (description "Portable Packed SIMD vectors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-packed-simd-2-0.3
  (package
    (name "rust-packed-simd-2")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "packed-simd-2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05wsm2yxxpwww6a74hi8l80qszisfar5d7whf2pd87wn5x4y0y1j"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Unpin the dependencies.
           (substitute* "Cargo.toml"
             (("=0.2.52") "^0.2.52")
             (("=0.3.2") "^0.3.2"))
           #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; error[E0432]: unresolved import `packed_simd`
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-core-arch" ,rust-core-arch-0.1)
        ("rust-libm" ,rust-libm-0.1)
        ("rust-sleef-sys" ,rust-sleef-sys-0.1))
       #:cargo-development-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.5)
        ("rust-paste" ,rust-paste-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))
    (home-page "https://github.com/rust-lang-nursery/packed_simd")
    (synopsis "Portable Packed SIMD vectors")
    (description "Portable Packed SIMD vectors.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pad-0.1
  (package
    (name "rust-pad")
    (version "0.1.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pad" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1qy0r26r52gp034fv252mmg0s599a55h9nr4xswy04hvky49pbfj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://github.com/ogham/rust-pad")
    (synopsis "Library for padding strings at runtime")
    (description
      "This package provides a library for padding strings at runtime.")
    (license license:expat)))

(define-public rust-palette-0.5
  (package
    (name "rust-palette")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "palette" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nfc4ycdsx2qgf2wkcpxqxc0vmx7188jjjx3ppgs8qlf8qs06p50"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-palette-derive" ,rust-palette-derive-0.5)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-phf-codegen" ,rust-phf-codegen-0.8)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/Ogeon/palette")
    (synopsis "Linear color calculations and conversion")
    (description
     "This package makes linear color calculations and conversion accessible.")
    (license (list license:expat license:asl2.0))))

(define-public rust-palette-derive-0.5
  (package
    (name "rust-palette-derive")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "palette_derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1x5icddb877923rpl27bg4cjsf1x0d3layxmgwa3mpb01rh5yjqb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/Ogeon/palette")
    (synopsis "Automatically implement traits from the palette crate")
    (description
     "Automatically implement traits from the palette crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pancurses-0.16
  (package
    (name "rust-pancurses")
    (version "0.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pancurses" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w0gknaz07fzq7gw7zjg1bg9xr7srp2z3zksmjr9cc23gk1qn1fk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-ncurses" ,rust-ncurses-5)
        ("rust-pdcurses-sys" ,rust-pdcurses-sys-0.7)
        ("rust-winreg" ,rust-winreg-0.5))))
    (home-page "https://github.com/ihalila/pancurses")
    (synopsis "@code{curses} library for Rust")
    (description "@code{pancurses} is a @code{curses} library for Rust.")
    (license license:expat)))

(define-public rust-parity-tokio-ipc-0.4
  (package
    (name "rust-parity-tokio-ipc")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parity-tokio-ipc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gzifrrpiw78p6dq9ax64vhffc4h6mwg6jazpfgkz8zy0jjzwmqy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-mio-named-pipes" ,rust-mio-named-pipes-0.1)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-tokio" ,rust-tokio-0.1)
        ("rust-tokio-named-pipes" ,rust-tokio-named-pipes-0.1)
        ("rust-tokio-uds" ,rust-tokio-uds-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/nikvolf/parity-tokio-ipc")
    (synopsis "Interprocess communication library for tokio")
    (description "Interprocess communication library for tokio.")
    (license (list license:expat license:asl2.0))))

(define-public rust-parity-wasm-0.41
  (package
    (name "rust-parity-wasm")
    (version "0.41.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "parity-wasm" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0rfqgjyxrxrfjq5r5n81mdklahl8g4az6yhyyvw25nh0mj6qgz6x"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page
      "https://github.com/paritytech/parity-wasm")
    (synopsis "WebAssembly low-level format library")
    (description
      "WebAssembly low-level format library")
    (license (list license:expat license:asl2.0))))

(define-public rust-parity-wasm-0.40
  (package
    (name "rust-parity-wasm")
    (version "0.40.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "parity-wasm" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "03qycy21avz4970zc7aj8rj5h4wvi4qsrc90a6hpws1a56mglf8y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-time" ,rust-time-0.1))))
    (home-page "https://github.com/paritytech/parity-wasm")
    (synopsis "Low-level WebAssembly format library")
    (description
     "This package provides a WebAssembly binary format serialization,
deserialization, and interpreter in Rust.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-parking-2
  (package
    (name "rust-parking")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wnxxnizfxlax3n709s5r83f4n8awy3m4a18q4fdk0z7z693hz22"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3))))
    (home-page "https://github.com/stjepang/parking")
    (synopsis "Thread parking and unparking")
    (description "This packages provides methods for thread parking and
unparking.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-parking-1
  (package
    (inherit rust-parking-2)
    (name "rust-parking")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z6q9rxm98vrp3fimw8b5syzwgf8l0pnn6y0cqm4lbblf7r01cvc"))))))

(define-public rust-parking-lot-0.11
  (package
    (name "rust-parking-lot")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sqmgaia8zfd5fbnqw2w13ijh7crk3lf9vw4cb52vwlx0an48xvd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-instant" ,rust-instant-0.1)
        ("rust-lock-api" ,rust-lock-api-0.4)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.8))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/Amanieu/parking_lot")
    (synopsis
     "Efficient implementations of the standard synchronization primitives")
    (description
     "This package provides more compact and efficient implementations
of the standard synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-parking-lot-0.10
  (package
    (name "rust-parking-lot")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pjhcbyk6n0g6jsr6s9nf4x8wribm1b2yf8fgc8drbqa77mh99yk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lock-api" ,rust-lock-api-0.3)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.7))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/Amanieu/parking_lot")
    (synopsis "Compact standard synchronization primitives")
    (description
     "More compact and efficient implementations of the standard
synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-parking-lot-0.9
  (package
    (inherit rust-parking-lot-0.10)
    (name "rust-parking-lot")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lk2vq3hp88ygpgsrypdr3ss71fidnqbykva0csgxhmn5scb2hpq"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lock-api" ,rust-lock-api-0.3)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.6))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parking-lot-0.8
  (package
    (inherit rust-parking-lot-0.9)
    (name "rust-parking-lot")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rrcdalr8l5zx3bw28l376321l6dnd6rqnsqsl0ygk01fy0nfxzs"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lock-api" ,rust-lock-api-0.2)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.5))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parking-lot-0.7
  (package
    (inherit rust-parking-lot-0.9)
    (name "rust-parking-lot")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dz32cqx9200n1lk3kwyb599vabfid3f8sj1aq85sw42s2pb8hdb"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lock-api" ,rust-lock-api-0.1)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.4))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parking-lot-core-0.8
  (package
    (name "rust-parking-lot-core")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16yazfg3sq9mz6cfdkhgbv8yvc1kkasyhys4y7r3g16hgmralqf3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-cloudabi" ,rust-cloudabi-0.1)
        ("rust-instant" ,rust-instant-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Amanieu/parking_lot")
    (synopsis "API for creating custom synchronization primitives")
    (description "This package provides an advanced API for creating custom
synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-parking-lot-core-0.7
  (package
    (inherit rust-parking-lot-core-0.8)
    (name "rust-parking-lot-core")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18s0cw5y32447c06fhg2mp3xfng22fn1h9fpx3il98sbimv7r36m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-cloudabi" ,rust-cloudabi-0.0)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-parking-lot-core-0.6
  (package
    (inherit rust-parking-lot-core-0.7)
    (name "rust-parking-lot-core")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ay67dpnrn68ryyvp720m9i8hzp189fd4d6slrs1lvmcwywv2xmq"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-cloudabi" ,rust-cloudabi-0.0)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-petgraph" ,rust-petgraph-0.4)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parking-lot-core-0.5
  (package
    (inherit rust-parking-lot-core-0.6)
    (name "rust-parking-lot-core")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1317j5a1yd03baza2kqqrxb4kr1vxa7rckw4frksl2vrncfcp26b"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-cloudabi" ,rust-cloudabi-0.0)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-petgraph" ,rust-petgraph-0.4)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parking-lot-core-0.4
  (package
    (inherit rust-parking-lot-core-0.6)
    (name "rust-parking-lot-core")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parking_lot_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jcq8aq4wv9y5fip7jg12jdwjd5g5r3x857xdma8vcin769cgj4l"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-petgraph" ,rust-petgraph-0.4)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-smallvec" ,rust-smallvec-0.6)
        ("rust-thread-id" ,rust-thread-id-3)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-rustc-version" ,rust-rustc-version-0.2))))))

(define-public rust-parse-zoneinfo-0.3
  (package
    (name "rust-parse-zoneinfo")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "parse-zoneinfo" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h8g6jy4kckn2gk8sd5adaws180n1ip65xhzw5jxlq4w8ibg41f7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "")
    (synopsis "Parse zoneinfo files from the IANA database")
    (description
     "This packages parses zoneinfo files from the IANA database.")
    (license license:expat)))

(define-public rust-partial-io-0.3
  (package
    (name "rust-partial-io")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "partial-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0b9a2bvqmaj2r4rkbshjsg8zzvp23b67qfvj2y6jwjckrn6zhb38"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))
    (home-page "https://github.com/facebookincubator/rust-partial-io")
    (synopsis "Helpers to test partial, interrupted and would-block I/O operations")
    (description "This package provides helpers to test partial, interrupted
and would-block I/O operations.")
    (license license:expat)))

(define-public rust-partial-io-0.2
  (package
    (inherit rust-partial-io-0.3)
    (name "rust-partial-io")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "partial-io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03iynvayh11a4mckhwflm5y1qmnkw5m3b20gzi1crpasndy3h8xx"))))
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-tokio-io" ,rust-tokio-io-0.1))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-tokio-core" ,rust-tokio-core-0.1))))
    (license license:bsd-3)))

(define-public rust-paste-1
  (package
    (name "rust-paste")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "paste" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hfikh0bds8hqn371l2wf039mp6b5wrmwrwg96jcs6lkjm6mrmn5"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/dtolnay/paste")
    (synopsis "Macros for all your token pasting needs")
    (description
     "This package provides macros for all your token pasting needs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-paste-0.1
  (package
    (inherit rust-paste-1)
    (name "rust-paste")
    (version "0.1.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "paste" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10587zrlmzhq66yhd0z36fzglf32m1nlhi9bxxm6dgl0gp3j1jj5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-paste-impl" ,rust-paste-impl-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-paste-impl-0.1
  (package
    (name "rust-paste-impl")
    (version "0.1.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "paste-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dlqzk05cx74522s4iyhyzzhszig4n401pp6r1qg6zmr02r7snnr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/dtolnay/paste")
    (synopsis "Implementation detail of the paste crate")
    (description
     "Implementation detail of the paste crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-path-abs-0.5
  (package
    (name "rust-path-abs")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "path_abs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "131qi5j201caraqz9rwbzk4mybd9bcrryrhf63lr9gz0xmnqwszb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-std-prelude" ,rust-std-prelude-0.2)
        ("rust-stfu8" ,rust-stfu8-0.2))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.4)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempdir" ,rust-tempdir-0.3))))
    (home-page "https://github.com/vitiral/path_abs")
    (synopsis "Ergonomic paths and files in Rust")
    (description "This library provides ergonomic path and file operations to
Rust with reasonable performance.")
    (license (list license:expat license:asl2.0))))

(define-public rust-path-clean-0.1
  (package
    (name "rust-path-clean")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "path-clean" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1pcgqxw0mgg3ha5hi5xkjhyjf488bw5rw1g3qlr9awbq4szh3fpc"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/danreeves/path-clean")
    (synopsis "Rust implementation of cleanname or path.Clean")
    (description "This package provides a Rust implementation of cleanname or
path.Clean.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pathdiff-0.1
  (package
    (name "rust-pathdiff")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pathdiff" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0cfg3isnx6mf3wbi7rsg4nmvywby40sbcs589n20fgi09l4p1gx3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/Manishearth/pathdiff")
    (synopsis "Library for diffing paths to obtain relative paths")
    (description
     "Use diff_paths to construct a relative path from a provided base
directory path to the provided path.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pbkdf2-0.4
  (package
    (name "rust-pbkdf2")
    (version "0.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pbkdf2" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1g8cm3nwrsydazjc1gjs549hzafgxq8qb49gixrhl3qrd9calvi1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.12)
        ("rust-crypto-mac" ,rust-crypto-mac-0.8)
        ("rust-hmac" ,rust-hmac-0.8)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-core" ,rust-rand-core-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-subtle" ,rust-subtle-2))
       #:cargo-development-inputs
       (("rust-hmac" ,rust-hmac-0.8)
        ("rust-sha-1" ,rust-sha-1-0.9)
        ("rust-sha2" ,rust-sha2-0.9))))
    (home-page "https://github.com/RustCrypto/password-hashing")
    (synopsis "Generic implementation of PBKDF2")
    (description "This package contains a collection of password hashing
algorithms, otherwise known as password-based key derivation functions, written
in pure Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pbkdf2-0.3
  (package
    (inherit rust-pbkdf2-0.4)
    (name "rust-pbkdf2")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pbkdf2" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1na2fmmfcmksz4xk7m0ihl778501c1krx88dcylrand48f506v00"))))
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-crypto-mac" ,rust-crypto-mac-0.7)
        ("rust-hmac" ,rust-hmac-0.7)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-sha2" ,rust-sha2-0.8)
        ("rust-subtle" ,rust-subtle-1))
       #:cargo-development-inputs
       (("rust-hmac" ,rust-hmac-0.7)
        ("rust-sha-1" ,rust-sha-1-0.8)
        ("rust-sha2" ,rust-sha2-0.8))))))

(define-public rust-pcre2-0.2
  (package
    (name "rust-pcre2")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pcre2" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1c8sn70h72llf26sya9v26zmaamq350q57nwv6fl6fwhd4phzcw5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-pcre2-sys" ,rust-pcre2-sys-0.2)
        ("rust-thread-local" ,rust-thread-local-1))))
    (native-inputs
     `(("pcre2" ,pcre2)
       ("pkg-config" ,pkg-config)))
    (home-page "https://github.com/BurntSushi/rust-pcre2")
    (synopsis "High level wrapper library for PCRE2")
    (description
     "This package provides a high level wrapper library for PCRE2.")
    (license (list license:expat license:unlicense))))

(define-public rust-pcre2-sys-0.2
  (package
    (name "rust-pcre2-sys")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pcre2-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "08mp6yxrvadplwd0drdydzskvzapr6dri9fyy7xvhzn3krg0xhyy"))
       (modules '((guix build utils)))
       (snippet
        '(begin (delete-file-recursively "pcre2") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-cc" ,rust-cc-1))))
    (native-inputs
     `(("pcre2" ,pcre2)
       ("pkg-config" ,pkg-config)))
    (home-page
     "https://github.com/BurntSushi/rust-pcre2")
    (synopsis "Low level bindings to PCRE2")
    (description "Low level bindings to PCRE2.")
    (license (list license:expat license:unlicense))))

(define-public rust-pdcurses-sys-0.7
  (package
    (name "rust-pdcurses-sys")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pdcurses-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sqn552nz33bmd0d8lcx862lrbxg6fgk5djfblig2q7zjqkx4k88"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/ihalila/pdcurses-sys")
    (synopsis "FFI bindings for PDCurses")
    (description
     "This package provides FFI bindings for PDCurses implementation.")
    (license license:expat)))

(define-public rust-pear-0.1
  (package
    (name "rust-pear")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pear" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12mb00ick6y1slbxk6r4i8qxdbq8km3bs4pygjv94xwnvc9g482k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-pear-codegen" ,rust-pear-codegen-0.1))))
    (home-page "https://crates.io/crates/pear")
    (synopsis "Pear is a fruit")
    (description "This package provides a pear is a fruit.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pear-codegen-0.1
  (package
    (name "rust-pear-codegen")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pear_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jk8jxkgjd3pymldkckg2ligkpy4nnskgcj8qf3yzlf3zlvcihdz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15)
        ("rust-version-check" ,rust-version-check-0.9)
        ("rust-yansi" ,rust-yansi-0.5))))
    (home-page "https://crates.io/crates/pear_codegen")
    (synopsis "Codegen for pear")
    (description
     "This package provides a (codegen) pear is a fruit.")
    (license (list license:expat license:asl2.0))))

(define-public rust-peeking-take-while-0.1
  (package
    (name "rust-peeking-take-while")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "peeking_take_while" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "16bhqr6rdyrp12zv381cxaaqqd0pwysvm1q8h2ygihvypvfprc8r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/fitzgen/peeking_take_while")
    (synopsis "Provides the peeking_take_while iterator adaptor method")
    (description
      "Like @code{Iterator::take_while}, but calls the predicate on a peeked
value.  This allows you to use @code{Iterator::by_ref} and
@code{Iterator::take_while} together, and still get the first value for which
the @code{take_while} predicate returned false after dropping the @code{by_ref}.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-peg-0.6
  (package
    (name "rust-peg")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "peg" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "15rfp12dgsynplphp443zfw47m2d5snvdm6a25gz48dv2if8fxch"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-peg-macros" ,rust-peg-macros-0.6)
        ("rust-peg-runtime" ,rust-peg-runtime-0.6))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/kevinmehall/rust-peg")
    (synopsis "Simple Parsing Expression Grammar (PEG) parser generator")
    (description
     "PEG provides a simple Parsing Expression Grammar (PEG) parser generator
in Rust.")
    (license license:expat)))

(define-public rust-peg-0.5
  (package
    (inherit rust-peg-0.6)
    (name "rust-peg")
    (version "0.5.7")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "peg" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "11az3bs3ngvfip920xfr0zwblfkyg6cjgz1v9hmfsdnqw7fi5ps0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-quote" ,rust-quote-0.3))))))

(define-public rust-peg-macros-0.6
  (package
    (name "rust-peg-macros")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "peg-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0li8qrb8hyqr7v5mhrkym0xp7ijnbksqviqc2i3556cysdgick62"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-peg-runtime" ,rust-peg-runtime-0.6)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/kevinmehall/rust-peg")
    (synopsis "Procedural macros for rust-peg")
    (description
     "PEG provides a Parsing Expression Grammar.  This package provides
procedural macros for rust-peg.  To use rust-peg, see the peg package.")
    (license license:expat)))

(define-public rust-peg-runtime-0.6
  (package
    (name "rust-peg-runtime")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "peg-runtime" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0r583cq923v0narrpq73qmp780yg4pablzklhrwnr64xwsbjh6hc"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kevinmehall/rust-peg")
    (synopsis "Runtime support for rust-peg grammars")
    (description
     "PEG provides a Parsing Expression Grammar.  This package provides
runtime support for rust-peg grammars.  To use rust-peg, see the peg crate.")
    (license license:expat)))

(define-public rust-percent-encoding-2
  (package
    (name "rust-percent-encoding")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "percent-encoding" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0bp3zrsk3kr47fbpipyczidbbx4g54lzxdm77ni1i3qws10mdzfl"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/servo/rust-url/")
    (synopsis "Percent encoding and decoding")
    (description "This crate provides percent encoding and decoding.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-percent-encoding-1
  (package
    (inherit rust-percent-encoding-2)
    (name "rust-percent-encoding")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "percent-encoding" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0cgq08v1fvr6bs5fvy390cz830lq4fak8havdasdacxcw790s09i"))))))

(define-public rust-peresil-0.3
  (package
    (name "rust-peresil")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "peresil" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mwyw03yqp0yqdjf4a89vn86szxaksmxvgzv1j2nw69fsmp8hn7n"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/shepmaster/peresil")
    (synopsis "Simple and simplistic string parsing library")
    (description
     "This package provides a simple and simplistic string parsing library.")
    (license license:expat)))

(define-public rust-permutohedron-0.2
  (package
    (name "rust-permutohedron")
    (version "0.2.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "permutohedron" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0b1pzh48j86v46wxngch6k1kx9cdw3jr3lwa86gd6jd4bmxzz1xn"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/bluss/permutohedron")
    (synopsis "Generate permutations of sequences")
    (description
     "Generate permutations of sequences.  Either lexicographical order
permutations, or a minimal swaps permutation sequence implemented using Heap's
algorithm.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-pest-2
  (package
    (name "rust-pest")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pest" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "134686mwxm73asbiads53zfchqvvcrsrsyax2cghfcizmvg8ac4k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-ucd-trie" ,rust-ucd-trie-0.1))))
    (home-page "https://pest.rs/")
    (synopsis "The Elegant Parser")
    (description "The Elegant Parser.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pest-derive-2
  (package
    (name "rust-pest-derive")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pest_derive" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1l5jfa6ril71cw5nsiw0r45br54dd8cj2r1nc2d1wq6wb3jilgc3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-pest" ,rust-pest-2)
        ("rust-pest-generator" ,rust-pest-generator-2))))
    (home-page "https://pest.rs/")
    (synopsis "Pest's derive macro")
    (description "Pest's derive macro.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pest-generator-2
  (package
    (name "rust-pest-generator")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pest_generator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1h3z8jccki87mn7gppy4292s1ah98z4md998w5pd04jpkclwz7vv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-pest" ,rust-pest-2)
        ("rust-pest-meta" ,rust-pest-meta-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://pest.rs/")
    (synopsis "Pest code generator")
    (description "Pest code generator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pest-meta-2
  (package
    (name "rust-pest-meta")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pest_meta" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0iymvrh7lcfi8iarkgq0hwgarr00np3l4xg4bx42rmvgi6czshyz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-maplit" ,rust-maplit-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-sha-1" ,rust-sha-1-0.8))))
    (home-page "https://pest.rs")
    (synopsis "Pest meta language parser and validator")
    (description
     "Pest meta language parser and validator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-petgraph-0.5
  (package
    (name "rust-petgraph")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "petgraph" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dzxda6z17sfxly11m8ja3iargh73pw0s1sdgjyp0qp5dm51cza6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fixedbitset" ,rust-fixedbitset-0.2)
        ("rust-ordermap" ,rust-ordermap-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-defmac" ,rust-defmac-0.1)
        ("rust-itertools" ,rust-itertools-0.8)
        ("rust-odds" ,rust-odds-0.2)
        ("rust-rand" ,rust-rand-0.5))))
    (home-page "https://github.com/petgraph/petgraph")
    (synopsis "Graph data structure library")
    (description
     "Graph data structure library.  Provides graph types and graph
algorithms.")
    (license (list license:expat license:asl2.0))))

(define-public rust-petgraph-0.4
  (package
    (inherit rust-petgraph-0.5)
    (name "rust-petgraph")
    (version "0.4.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "petgraph" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kyfmca854s54jk26g2x1kjb04c3k7cjilaxyr0if8lhxv8mjdlw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fixedbitset" ,rust-fixedbitset-0.1)
        ("rust-odds" ,rust-odds-0.2)
        ("rust-ordermap" ,rust-ordermap-0.3)
        ("rust-quickcheck" ,rust-quickcheck-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-defmac" ,rust-defmac-0.1)
        ("rust-itertools" ,rust-itertools-0.7)
        ("rust-rand" ,rust-rand-0.4))
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'ignore-failing-test
           (lambda _
             (substitute* "tests/graph.rs"
               (("fn dot\\(\\) \\{" all)
                (string-append "#[ignore] " all))))))))))

(define-public rust-phf-0.8
  (package
    (name "rust-phf")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "phf" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "04pyv8bzqvw69rd5dynd5nb85py1hf7wa4ixyhrvdz1l5qin3yrx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-phf-shared" ,rust-phf-shared-0.8)
        ("rust-phf-macros" ,rust-phf-macros-0.8))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Runtime support for perfect hash function data structures")
    (description "This package provides runtime support for perfect hash
function data structures.")
    (license license:expat)))

(define-public rust-phf-0.7
  (package
    (name "rust-phf")
    (version "0.7.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "phf" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "066xwv4dr6056a9adlkarwp4n94kbpwngbmd47ngm3cfbyw49nmk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-phf-macros" ,rust-phf-macros-0.7)
        ("rust-phf-shared" ,rust-phf-shared-0.7))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Runtime support for perfect hash function data structures")
    (description
     "Runtime support for perfect hash function data structures.")
    (license license:expat)))

(define-public rust-phf-codegen-0.8
  (package
    (name "rust-phf-codegen")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "phf_codegen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "05d8w7aqqjb6039pfm6404gk5dlwrrf97kiy1n21212vb1hyxzyb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-phf-generator" ,rust-phf-generator-0.8)
        ("rust-phf-shared" ,rust-phf-shared-0.8))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Codegen library for PHF types")
    (description "Codegen library for PHF types.")
    (license license:expat)))

(define-public rust-phf-codegen-0.7
  (package
    (name "rust-phf-codegen")
    (version "0.7.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "phf-codegen" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0zjiblicfm0nrmr2xxrs6pnf6zz2394wgch6dcbd8jijkq98agmh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-phf-generator" ,rust-phf-generator-0.7)
        ("rust-phf-shared" ,rust-phf-shared-0.7))))
    (home-page
     "https://github.com/sfackler/rust-phf")
    (synopsis "Codegen library for PHF types")
    (description "Codegen library for PHF types.")
    (license license:expat)))

(define-public rust-phf-generator-0.8
  (package
    (name "rust-phf-generator")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "phf_generator" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09i5338d1kixq6a60fcayz6awgxjlxcfw9ic5f02abbgr067ydhp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-phf-shared" ,rust-phf-shared-0.8))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "PHF generation logic")
    (description "PHF generation logic.")
    (license license:expat)))

(define-public rust-phf-generator-0.7
  (package
    (name "rust-phf-generator")
    (version "0.7.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "phf_generator" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0qi62gxk3x3whrmw5c4i71406icqk11qmpgln438p6qm7k4lqdh9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-phf-shared" ,rust-phf-shared-0.7)
        ("rust-rand" ,rust-rand-0.6))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "PHF generation logic")
    (description "PHF generation logic")
    (license license:expat)))

(define-public rust-phf-macros-0.8
  (package
    (name "rust-phf-macros")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "phf_macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "170qm6yqn6b9mjlwb2xmm3iad9d5nzwgfawfwy7zr7s2zwcdwvvz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-phf-generator" ,rust-phf-generator-0.8)
        ("rust-phf-shared" ,rust-phf-shared-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Macros to generate types in the phf crate")
    (description
     "This package contains macros to generate types in the phf crate.")
    (license license:expat)))

(define-public rust-phf-macros-0.7
  (package
    (name "rust-phf-macros")
    (version "0.7.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "phf_macros" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0dzylcy14ksy60h265l433j9ra8xhg8xlq3pd5qk658m6f1mxd5x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Depends on features not in Rust's stable release channel.
       #:cargo-inputs
       (("rust-phf-generator" ,rust-phf-generator-0.7)
        ("rust-phf-shared" ,rust-phf-shared-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))
       #:cargo-development-inputs
       (("rust-compiletest-rs" ,rust-compiletest-rs-0.3))))
    (home-page
     "https://github.com/sfackler/rust-phf")
    (synopsis
     "Macros to generate types in the phf crate")
    (description
     "Macros to generate types in the phf crate.")
    (license license:expat)))

(define-public rust-phf-shared-0.8
  (package
    (name "rust-phf-shared")
    (version "0.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "phf_shared" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1xssnqrrcn0nr9ayqrnm8xm37ac4xvwcx8pax7jxss7yxawzh360"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-siphasher" ,rust-siphasher-0.3)
        ("rust-unicase" ,rust-unicase-2))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Support code shared by PHF libraries")
    (description
     "This package provides support code shared by PHF libraries.")
    (license license:expat)))

(define-public rust-phf-shared-0.7
  (package
    (name "rust-phf-shared")
    (version "0.7.24")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "phf-shared" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18371fla0vsj7d6d5rlfb747xbr2in11ar9vgv5qna72bnhp2kr3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-siphasher" ,rust-siphasher-0.2)
        ("rust-unicase" ,rust-unicase-1))))
    (home-page "https://github.com/sfackler/rust-phf")
    (synopsis "Support code shared by PHF libraries")
    (description
     "Support code shared by PHF libraries.")
    (license license:expat)))

(define-public rust-pico-sys-0.0
  (package
    (name "rust-pico-sys")
    (version "0.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pico-sys" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1q5pg0ms6szz6b5h26h4k40zb76zbwwjgyigac4wly9qngdj4yl5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/reem/rust-pico-sys")
    (synopsis "Bindings to the PicoHTTPParser")
    (description
     "This package provides bindings to the PicoHTTPParser.")
    (license license:expat)))

(define-public rust-pin-project-1
  (package
    (name "rust-pin-project")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19qw2nm2kk38v9j16nsm8j3fkh0g8pjq0k4cplx7i2f4q8vj5k4w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-pin-project-internal" ,rust-pin-project-internal-1))
       #:cargo-development-inputs
       (("rust-pin-project-auxiliary-macro"
         ,rust-pin-project-auxiliary-macro-0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/taiki-e/pin-project")
    (synopsis "Crate for safe and ergonomic pin-projection")
    (description
     "This package provides a crate for safe and ergonomic pin-projection.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pin-project-0.4
  (package
    (inherit rust-pin-project-1)
    (name "rust-pin-project")
    (version "0.4.22")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05wwxy46j9z27ibbiisjqk0rivf0z00h4al1f92mwjp9pz6sdqqj"))))
    (arguments
     `(#:tests? #f ; XXX: Fix-me.
       #:cargo-inputs
       (("rust-pin-project-internal" ,rust-pin-project-internal-0.4))))))

(define-public rust-pin-project-auxiliary-macro-0.0
  (package
    (name "rust-pin-project-auxiliary-macro")
    (version "0.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project-auxiliary-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fk48gab989xxmw466yp4mvqwfkkx9ckqzmjlfyk2hnzavqwvkxj"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/pin-project")
    (synopsis "Internal test tool of the pin-project crate")
    (description
     "This package is an internal test tool of the @code{pin-project} crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pin-project-internal-1
  (package
    (name "rust-pin-project-internal")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project-internal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pwy3m32scf3ypjb9ai151lmaa27vyj06lc64i28l0r31fzx5s7q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/taiki-e/pin-project")
    (synopsis "Implementation detail of the @code{pin-project} crate")
    (description
     "This package is an implementation detail of the @code{pin-project}
crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pin-project-internal-0.4
  (package
    (inherit rust-pin-project-internal-1)
    (name "rust-pin-project-internal")
    (version "0.4.22")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project-internal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xxac6f3ip45zqbfcmmk748ywjw9sbavz1fcswvqgn3rrx2zs3va"))))
    (arguments
     `(#:tests? #f ; XXX: Fix-me.
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-pin-project-lite-0.2
  (package
    (name "rust-pin-project-lite")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09x8chns8apal89pndqdrr0c2nv8jw6nmi8hl38acjbc6sprg5j3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/taiki-e/pin-project-lite")
    (synopsis "Lightweight version of pin-project")
    (description "This package provides a lightweight version of pin-project
written with declarative macros.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pin-project-lite-0.1
  (package
    (inherit rust-pin-project-lite-0.2)
    (name "rust-pin-project-lite")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pin-project-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0srgdb3vkx7ppcww1qr7a67c7n84y01lq35j9g44z4h1z8x145y9"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-pin-utils-0.1
  (package
    (name "rust-pin-utils")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pin-utils" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "117ir7vslsl2z1a7qzhws4pd01cg2d3338c47swjyvqv2n60v1wb"))))
    (build-system cargo-build-system)
    (home-page "https://docs.rs/pin-utils")
    (synopsis "Utilities for pinning")
    (description "This crate provides utilities for pinning values on the stack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-pkg-config-0.3
  (package
    (name "rust-pkg-config")
    (version "0.3.19")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pkg-config" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "0k4860955riciibxr8bhnklp79jydp4xfylwdn5v9kj96hxlac9q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'hardcode-pkg-config-loation
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "src/lib.rs"
               (("\"pkg-config\"")
                (string-append "\"" (assoc-ref inputs "pkg-config")
                               "/bin/pkg-config\"")))
             #t)))))
    (native-inputs
     `(("pkg-config" ,pkg-config)))
    (home-page "https://github.com/rust-lang/pkg-config-rs")
    (synopsis "Library to run the pkg-config system tool")
    (description
     "A library to run the pkg-config system tool at build time in order to be
used in Cargo build scripts.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-plain-0.2
  (package
    (name "rust-plain")
    (version "0.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "plain" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "19n1xbxb4wa7w891268bzf6cbwq4qvdb86bik1z129qb0xnnnndl"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/randomites/plain")
    (synopsis "Rust library that allows reinterpreting data safely")
    (description "This package provides a small Rust library that allows users
 to reinterpret data of certain types safely.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-plist-1
  (package
    (name "rust-plist")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "plist" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zb7k48x1zf1dhqavs37qm24fxi98qb978xv2nzjkkp4x2a6scvv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.12)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-line-wrap" ,rust-line-wrap-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-xml-rs" ,rust-xml-rs-0.8))))
    (home-page "https://github.com/ebarnard/rust-plist/")
    (synopsis "Rusty plist parser")
    (description
     "This package provides a Rusty plist parser.  It supports Serde
serialization.")
    (license license:expat)))

(define-public rust-plist-0.4
  (package
    (inherit rust-plist-1)
    (name "rust-plist")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "plist" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zqnxc5i4y6mj119vr0lzpb5j67vffpx2phhgh711533bw3ryajz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-line-wrap" ,rust-line-wrap-0.1)
        ("rust-base64" ,rust-base64-0.10)
        ("rust-xml-rs" ,rust-xml-rs-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-byteorder" ,rust-byteorder-1))))))

(define-public rust-plotters-0.2
  (package
    (name "rust-plotters")
    (version "0.2.12")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "plotters" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ssycy9an23vs9hq098c7kl1dvp5ych20d994lhsw9vx4kdbhfsf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-gif" ,rust-gif-0.10)
        ("rust-piston-window" ,rust-piston-window-0.105)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-image" ,rust-image-0.22)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-web-sys" ,rust-web-sys-0.3)
        ("rust-font-kit" ,rust-font-kit-0.4)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-palette" ,rust-palette-0.5)
        ("rust-cairo-rs" ,rust-cairo-rs-0.7)
        ("rust-rusttype" ,rust-rusttype-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/38/plotters")
    (synopsis "Rust drawing library focus on data plotting")
    (description
     "This package provides a Rust drawing library focus on data plotting for
both WASM and native applications")
    (license license:expat)))

(define-public rust-plugin-0.2
  (package
    (name "rust-plugin")
    (version "0.2.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "plugin" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1q7nghkpvxxr168y2jnzh3w7qc9vfrby9n7ygy3xpj0bj71hsshs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-typemap" ,rust-typemap-0.3))
       #:cargo-development-inputs
       (("rust-void" ,rust-void-1))))
    (home-page "https://github.com/reem/rust-plugin")
    (synopsis "Lazily evaluated, order-independent plugins for extensible types")
    (description
     "Lazily evaluated, order-independent plugins for extensible types.")
    (license license:expat)))

(define-public rust-pmutil-0.5
  (package
    (name "rust-pmutil")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pmutil" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0170zgziivri4qsch682pga3qq3z4wpr4wngzr5f9jyc97ayb51q"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/kdy1/rust-pmutil")
    (synopsis "Utils for proc-macro")
    (description "This package provides utils for proc-macro.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-pnacl-build-helper-1
  (package
    (name "rust-pnacl-build-helper")
    (version "1.4.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "pnacl-build-helper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "145hxz3m3sg8mm9sfqqqaarnna43v65l6whwswrvcvy0fzp17gnz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-tempdir" ,rust-tempdir-0.3)
        ("rust-walkdir" ,rust-walkdir-1))))
    (home-page "https://github.com/DiamondLovesYou/cargo-pnacl-helper")
    (synopsis
     "Build script helper for building PNaCl/NaCl C/CXX libraries from source")
    (description
     "Build script helper for building PNaCl/NaCl C/CXX libraries from source")
    (license license:mpl2.0)))

(define-public rust-pocket-resources-0.3
  (package
    (name "rust-pocket-resources")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pocket-resources" version))
        (file-name (string-append name "-" version ".crate"))
        (sha256
         (base32
          "1n2i5vmi8fdbw89wm5nz1ws1z9f1qax911p6ksg4scmdg23z6df1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tomaka/pocket-resources")
    (synopsis "Include resources in your applications")
    (description "This crate allows you to include resources in your
applications.")
    (license license:expat)))

(define-public rust-podio-0.1
  (package
    (name "rust-podio")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "podio" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06bzjxrl0h8rp5860n51dlr1g143grg2jmx4g6y1mdn2ignyz2xi"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mvdnes/podio.git")
    (synopsis "Additional trait to read and write Plain Old Data")
    (description
     "Additional trait for Read and Write to read and write Plain Old Data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-polling-2
  (package
    (name "rust-polling")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "polling" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r5xm3f6qs84ibg09nw1cz78r883521l3jaiakj35ri959mvr9x2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-wepoll-sys" ,rust-wepoll-sys-3)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3))))
    (home-page "https://github.com/stjepang/polling")
    (synopsis "Portable interface to epoll, kqueue, event ports, and wepoll")
    (description
     "This package provides a portable interface to @code{epoll},
@code{kqueue}, @code{event ports}, and @code{wepoll}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-polyval-0.4
  (package
    (name "rust-polyval")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "polyval" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1p0765j30qxr50zh74aflafx540xkxqb7pv8kw7fvcssnm1039fr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-universal-hash" ,rust-universal-hash-0.4)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-criterion-cycles-per-byte"
         ,rust-criterion-cycles-per-byte-0.1)
        ("rust-hex-literal" ,rust-hex-literal-0.1))))
    (home-page "https://github.com/RustCrypto/universal-hashes")
    (synopsis "GHASH-like universal hash")
    (description "POLYVAL is a GHASH-like universal hash over GF(2^128) useful
for constructing a Message Authentication Code (MAC).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-polyval-0.3
  (package
    (inherit rust-polyval-0.4)
    (name "rust-polyval")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "polyval" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256 (base32 "04m2wf4pk6gglvl12fj7ylc2iqhxmzqj46rds6zy73cpk0a39hvy"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-universal-hash" ,rust-universal-hash-0.3)
        ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-pom-3
  (package
    (name "rust-pom")
    (version "3.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "pom" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1v14c2p1irblagnljkw4n0f1w5r8mbybzycz0j1f5y79h0kikqh7"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/J-F-Liu/pom")
    (synopsis "PEG parser combinators using operator overloading without macros")
    (description "This package provides a PEG parser combinators using operator
overloading without macros in Rust.")
    (license license:expat)))

(define-public rust-portpicker-0.1
  (package
    (name "rust-portpicker")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "portpicker" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fgb5pdayxy5nlx1lh60r7gx7wx45zza802w8hwhkq3gq42psjav"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-rand" ,rust-rand-0.6))))
    (home-page "https://github.com/Dentosal/portpicker-rs")
    (synopsis "Pick a free unused port")
    (description
     "This crate provides picks a free port, that is unused on both TCP and
UDP.")
    (license license:unlicense)))

(define-public rust-postgres-0.15
  (package
    (name "rust-postgres")
    (version "0.15.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "postgres" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1id6jb56jack7kxivpp3rnjjmkmymmxqadf0h0smgbsixy8dwp8i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.4)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-native-tls" ,rust-native-tls-0.1)
        ("rust-openssl" ,rust-openssl-0.9)
        ("rust-postgres-protocol" ,rust-postgres-protocol-0.3)
        ("rust-postgres-shared" ,rust-postgres-shared-0.4)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-security-framework" ,rust-security-framework-0.1)
        ("rust-socket2" ,rust-socket2-0.3))))
    (home-page "https://github.com/sfackler/rust-postgres")
    (synopsis "Native, synchronous PostgreSQL client")
    (description
     "This package provides a native, synchronous PostgreSQL client.")
    (license license:expat)))

(define-public rust-postgres-protocol-0.3
  (package
    (name "rust-postgres-protocol")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "postgres-protocol" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04kkznbhwspfn0hdja3jsv37l6g5gz7a625z8yra325zamjfd1r4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.6)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.1)
        ("rust-generic-array" ,rust-generic-array-0.9)
        ("rust-hmac" ,rust-hmac-0.5)
        ("rust-md5" ,rust-md5-0.3)
        ("rust-memchr" ,rust-memchr-1)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-sha2" ,rust-sha2-0.7)
        ("rust-stringprep" ,rust-stringprep-0.1))))
    (home-page "https://github.com/sfackler/rust-postgres")
    (synopsis "Low level Postgres protocol APIs")
    (description
     "This package provides low level Postgres protocol APIs.")
    