# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchSummary(object):
    """
    A Patch for a DB system or DB Home.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized,
    talk to an administrator. If you're an administrator who needs to write policies to give users access,
    see `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    #: A constant which can be used with the last_action property of a PatchSummary.
    #: This constant has a value of "APPLY"
    LAST_ACTION_APPLY = "APPLY"

    #: A constant which can be used with the last_action property of a PatchSummary.
    #: This constant has a value of "PRECHECK"
    LAST_ACTION_PRECHECK = "PRECHECK"

    #: A constant which can be used with the available_actions property of a PatchSummary.
    #: This constant has a value of "APPLY"
    AVAILABLE_ACTIONS_APPLY = "APPLY"

    #: A constant which can be used with the available_actions property of a PatchSummary.
    #: This constant has a value of "PRECHECK"
    AVAILABLE_ACTIONS_PRECHECK = "PRECHECK"

    #: A constant which can be used with the lifecycle_state property of a PatchSummary.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a PatchSummary.
    #: This constant has a value of "SUCCESS"
    LIFECYCLE_STATE_SUCCESS = "SUCCESS"

    #: A constant which can be used with the lifecycle_state property of a PatchSummary.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a PatchSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PatchSummary.
        :type id: str

        :param description:
            The value to assign to the description property of this PatchSummary.
        :type description: str

        :param last_action:
            The value to assign to the last_action property of this PatchSummary.
            Allowed values for this property are: "APPLY", "PRECHECK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type last_action: str

        :param available_actions:
            The value to assign to the available_actions property of this PatchSummary.
            Allowed values for items in this list are: "APPLY", "PRECHECK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type available_actions: list[str]

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PatchSummary.
        :type lifecycle_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PatchSummary.
            Allowed values for this property are: "AVAILABLE", "SUCCESS", "IN_PROGRESS", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_released:
            The value to assign to the time_released property of this PatchSummary.
        :type time_released: datetime

        :param version:
            The value to assign to the version property of this PatchSummary.
        :type version: str

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'last_action': 'str',
            'available_actions': 'list[str]',
            'lifecycle_details': 'str',
            'lifecycle_state': 'str',
            'time_released': 'datetime',
            'version': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'last_action': 'lastAction',
            'available_actions': 'availableActions',
            'lifecycle_details': 'lifecycleDetails',
            'lifecycle_state': 'lifecycleState',
            'time_released': 'timeReleased',
            'version': 'version'
        }

        self._id = None
        self._description = None
        self._last_action = None
        self._available_actions = None
        self._lifecycle_details = None
        self._lifecycle_state = None
        self._time_released = None
        self._version = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PatchSummary.
        The `OCID`__ of the patch.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this PatchSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PatchSummary.
        The `OCID`__ of the patch.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this PatchSummary.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        **[Required]** Gets the description of this PatchSummary.
        The text describing this patch package.


        :return: The description of this PatchSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PatchSummary.
        The text describing this patch package.


        :param description: The description of this PatchSummary.
        :type: str
        """
        self._description = description

    @property
    def last_action(self):
        """
        Gets the last_action of this PatchSummary.
        Action that is currently being performed or was completed last.

        Allowed values for this property are: "APPLY", "PRECHECK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The last_action of this PatchSummary.
        :rtype: str
        """
        return self._last_action

    @last_action.setter
    def last_action(self, last_action):
        """
        Sets the last_action of this PatchSummary.
        Action that is currently being performed or was completed last.


        :param last_action: The last_action of this PatchSummary.
        :type: str
        """
        allowed_values = ["APPLY", "PRECHECK"]
        if not value_allowed_none_or_none_sentinel(last_action, allowed_values):
            last_action = 'UNKNOWN_ENUM_VALUE'
        self._last_action = last_action

    @property
    def available_actions(self):
        """
        Gets the available_actions of this PatchSummary.
        Actions that can possibly be performed using this patch.

        Allowed values for items in this list are: "APPLY", "PRECHECK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The available_actions of this PatchSummary.
        :rtype: list[str]
        """
        return self._available_actions

    @available_actions.setter
    def available_actions(self, available_actions):
        """
        Sets the available_actions of this PatchSummary.
        Actions that can possibly be performed using this patch.


        :param available_actions: The available_actions of this PatchSummary.
        :type: list[str]
        """
        allowed_values = ["APPLY", "PRECHECK"]
        if available_actions:
            available_actions[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in available_actions]
        self._available_actions = available_actions

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PatchSummary.
        A descriptive text associated with the lifecycleState.
        Typically can contain additional displayable text.


        :return: The lifecycle_details of this PatchSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PatchSummary.
        A descriptive text associated with the lifecycleState.
        Typically can contain additional displayable text.


        :param lifecycle_details: The lifecycle_details of this PatchSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this PatchSummary.
        The current state of the patch as a result of lastAction.

        Allowed values for this property are: "AVAILABLE", "SUCCESS", "IN_PROGRESS", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this PatchSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PatchSummary.
        The current state of the patch as a result of lastAction.


        :param lifecycle_state: The lifecycle_state of this PatchSummary.
        :type: str
        """
        allowed_values = ["AVAILABLE", "SUCCESS", "IN_PROGRESS", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_released(self):
        """
        **[Required]** Gets the time_released of this PatchSummary.
        The date and time that the patch was released.


        :return: The time_released of this PatchSummary.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this PatchSummary.
        The date and time that the patch was released.


        :param time_released: The time_released of this PatchSummary.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def version(self):
        """
        **[Required]** Gets the version of this PatchSummary.
        The version of this patch package.


        :return: The version of this PatchSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this PatchSummary.
        The version of this patch package.


        :param version: The version of this PatchSummary.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
