# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentLoggingSource(object):
    """
    Logging source object.
    """

    #: A constant which can be used with the source_type property of a UnifiedAgentLoggingSource.
    #: This constant has a value of "LOG_TAIL"
    SOURCE_TYPE_LOG_TAIL = "LOG_TAIL"

    #: A constant which can be used with the source_type property of a UnifiedAgentLoggingSource.
    #: This constant has a value of "WINDOWS_EVENT_LOG"
    SOURCE_TYPE_WINDOWS_EVENT_LOG = "WINDOWS_EVENT_LOG"

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentLoggingSource object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.logging.models.UnifiedAgentWindowsEventSource`
        * :class:`~oci.logging.models.UnifiedAgentTailLogSource`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentLoggingSource.
        :type name: str

        :param source_type:
            The value to assign to the source_type property of this UnifiedAgentLoggingSource.
            Allowed values for this property are: "LOG_TAIL", "WINDOWS_EVENT_LOG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source_type: str

        """
        self.swagger_types = {
            'name': 'str',
            'source_type': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'source_type': 'sourceType'
        }

        self._name = None
        self._source_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['sourceType']

        if type == 'WINDOWS_EVENT_LOG':
            return 'UnifiedAgentWindowsEventSource'

        if type == 'LOG_TAIL':
            return 'UnifiedAgentTailLogSource'
        else:
            return 'UnifiedAgentLoggingSource'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this UnifiedAgentLoggingSource.
        unique name for the source


        :return: The name of this UnifiedAgentLoggingSource.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UnifiedAgentLoggingSource.
        unique name for the source


        :param name: The name of this UnifiedAgentLoggingSource.
        :type: str
        """
        self._name = name

    @property
    def source_type(self):
        """
        **[Required]** Gets the source_type of this UnifiedAgentLoggingSource.
        Unified schema logging source type.

        Allowed values for this property are: "LOG_TAIL", "WINDOWS_EVENT_LOG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source_type of this UnifiedAgentLoggingSource.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type):
        """
        Sets the source_type of this UnifiedAgentLoggingSource.
        Unified schema logging source type.


        :param source_type: The source_type of this UnifiedAgentLoggingSource.
        :type: str
        """
        allowed_values = ["LOG_TAIL", "WINDOWS_EVENT_LOG"]
        if not value_allowed_none_or_none_sentinel(source_type, allowed_values):
            source_type = 'UNKNOWN_ENUM_VALUE'
        self._source_type = source_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
