# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateVolumeGroupDetails(object):
    """
    UpdateVolumeGroupDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateVolumeGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateVolumeGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this UpdateVolumeGroupDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateVolumeGroupDetails.
        :type freeform_tags: dict(str, str)

        :param volume_ids:
            The value to assign to the volume_ids property of this UpdateVolumeGroupDetails.
        :type volume_ids: list[str]

        :param volume_group_replicas:
            The value to assign to the volume_group_replicas property of this UpdateVolumeGroupDetails.
        :type volume_group_replicas: list[oci.core.models.VolumeGroupReplicaDetails]

        """
        self.swagger_types = {
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'volume_ids': 'list[str]',
            'volume_group_replicas': 'list[VolumeGroupReplicaDetails]'
        }

        self.attribute_map = {
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'volume_ids': 'volumeIds',
            'volume_group_replicas': 'volumeGroupReplicas'
        }

        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._volume_ids = None
        self._volume_group_replicas = None

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateVolumeGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateVolumeGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateVolumeGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateVolumeGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateVolumeGroupDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateVolumeGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateVolumeGroupDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateVolumeGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateVolumeGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateVolumeGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateVolumeGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateVolumeGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def volume_ids(self):
        """
        Gets the volume_ids of this UpdateVolumeGroupDetails.
        OCIDs for the volumes in this volume group.


        :return: The volume_ids of this UpdateVolumeGroupDetails.
        :rtype: list[str]
        """
        return self._volume_ids

    @volume_ids.setter
    def volume_ids(self, volume_ids):
        """
        Sets the volume_ids of this UpdateVolumeGroupDetails.
        OCIDs for the volumes in this volume group.


        :param volume_ids: The volume_ids of this UpdateVolumeGroupDetails.
        :type: list[str]
        """
        self._volume_ids = volume_ids

    @property
    def volume_group_replicas(self):
        """
        Gets the volume_group_replicas of this UpdateVolumeGroupDetails.
        The list of volume group replicas that this volume group will be updated to have
        in the specified destination availability domains.


        :return: The volume_group_replicas of this UpdateVolumeGroupDetails.
        :rtype: list[oci.core.models.VolumeGroupReplicaDetails]
        """
        return self._volume_group_replicas

    @volume_group_replicas.setter
    def volume_group_replicas(self, volume_group_replicas):
        """
        Sets the volume_group_replicas of this UpdateVolumeGroupDetails.
        The list of volume group replicas that this volume group will be updated to have
        in the specified destination availability domains.


        :param volume_group_replicas: The volume_group_replicas of this UpdateVolumeGroupDetails.
        :type: list[oci.core.models.VolumeGroupReplicaDetails]
        """
        self._volume_group_replicas = volume_group_replicas

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
