# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelSummary(object):
    """
    Metadata about the model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ModelSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ModelSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ModelSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ModelSummary.
        :type compartment_id: str

        :param model_type:
            The value to assign to the model_type property of this ModelSummary.
        :type model_type: str

        :param model_version:
            The value to assign to the model_version property of this ModelSummary.
        :type model_version: str

        :param project_id:
            The value to assign to the project_id property of this ModelSummary.
        :type project_id: str

        :param time_created:
            The value to assign to the time_created property of this ModelSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ModelSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ModelSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ModelSummary.
        :type lifecycle_details: str

        :param precision:
            The value to assign to the precision property of this ModelSummary.
        :type precision: float

        :param training_dataset:
            The value to assign to the training_dataset property of this ModelSummary.
        :type training_dataset: oci.ai_vision.models.Dataset

        :param testing_dataset:
            The value to assign to the testing_dataset property of this ModelSummary.
        :type testing_dataset: oci.ai_vision.models.Dataset

        :param validation_dataset:
            The value to assign to the validation_dataset property of this ModelSummary.
        :type validation_dataset: oci.ai_vision.models.Dataset

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ModelSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ModelSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ModelSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'model_type': 'str',
            'model_version': 'str',
            'project_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'precision': 'float',
            'training_dataset': 'Dataset',
            'testing_dataset': 'Dataset',
            'validation_dataset': 'Dataset',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'model_type': 'modelType',
            'model_version': 'modelVersion',
            'project_id': 'projectId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'precision': 'precision',
            'training_dataset': 'trainingDataset',
            'testing_dataset': 'testingDataset',
            'validation_dataset': 'validationDataset',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._model_type = None
        self._model_version = None
        self._project_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._precision = None
        self._training_dataset = None
        self._testing_dataset = None
        self._validation_dataset = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ModelSummary.
        Unique identifier that is immutable after creation.


        :return: The id of this ModelSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ModelSummary.
        Unique identifier that is immutable after creation.


        :param id: The id of this ModelSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ModelSummary.
        Human-friendly name for the model, which can be changed.


        :return: The display_name of this ModelSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ModelSummary.
        Human-friendly name for the model, which can be changed.


        :param display_name: The display_name of this ModelSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ModelSummary.
        Optional description of the model.


        :return: The description of this ModelSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ModelSummary.
        Optional description of the model.


        :param description: The description of this ModelSummary.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ModelSummary.
        Compartment identifier.


        :return: The compartment_id of this ModelSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ModelSummary.
        Compartment identifier.


        :param compartment_id: The compartment_id of this ModelSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def model_type(self):
        """
        **[Required]** Gets the model_type of this ModelSummary.
        What type of Vision model this is.


        :return: The model_type of this ModelSummary.
        :rtype: str
        """
        return self._model_type

    @model_type.setter
    def model_type(self, model_type):
        """
        Sets the model_type of this ModelSummary.
        What type of Vision model this is.


        :param model_type: The model_type of this ModelSummary.
        :type: str
        """
        self._model_type = model_type

    @property
    def model_version(self):
        """
        **[Required]** Gets the model_version of this ModelSummary.
        The version of the model.


        :return: The model_version of this ModelSummary.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this ModelSummary.
        The version of the model.


        :param model_version: The model_version of this ModelSummary.
        :type: str
        """
        self._model_version = model_version

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this ModelSummary.
        The `OCID`__ of the project which contains the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this ModelSummary.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this ModelSummary.
        The `OCID`__ of the project which contains the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this ModelSummary.
        :type: str
        """
        self._project_id = project_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ModelSummary.
        When the model was created, as an RFC3339 datetime string.


        :return: The time_created of this ModelSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ModelSummary.
        When the model was created, as an RFC3339 datetime string.


        :param time_created: The time_created of this ModelSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ModelSummary.
        When the model was modified, as an RFC3339 datetime string.


        :return: The time_updated of this ModelSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ModelSummary.
        When the model was modified, as an RFC3339 datetime string.


        :param time_updated: The time_updated of this ModelSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ModelSummary.
        The current state of the model.


        :return: The lifecycle_state of this ModelSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ModelSummary.
        The current state of the model.


        :param lifecycle_state: The lifecycle_state of this ModelSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ModelSummary.
        A message describing the current state in more detail which can provide actionable information if training failed.


        :return: The lifecycle_details of this ModelSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ModelSummary.
        A message describing the current state in more detail which can provide actionable information if training failed.


        :param lifecycle_details: The lifecycle_details of this ModelSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def precision(self):
        """
        Gets the precision of this ModelSummary.
        Precision of the trained model.


        :return: The precision of this ModelSummary.
        :rtype: float
        """
        return self._precision

    @precision.setter
    def precision(self, precision):
        """
        Sets the precision of this ModelSummary.
        Precision of the trained model.


        :param precision: The precision of this ModelSummary.
        :type: float
        """
        self._precision = precision

    @property
    def training_dataset(self):
        """
        Gets the training_dataset of this ModelSummary.

        :return: The training_dataset of this ModelSummary.
        :rtype: oci.ai_vision.models.Dataset
        """
        return self._training_dataset

    @training_dataset.setter
    def training_dataset(self, training_dataset):
        """
        Sets the training_dataset of this ModelSummary.

        :param training_dataset: The training_dataset of this ModelSummary.
        :type: oci.ai_vision.models.Dataset
        """
        self._training_dataset = training_dataset

    @property
    def testing_dataset(self):
        """
        Gets the testing_dataset of this ModelSummary.

        :return: The testing_dataset of this ModelSummary.
        :rtype: oci.ai_vision.models.Dataset
        """
        return self._testing_dataset

    @testing_dataset.setter
    def testing_dataset(self, testing_dataset):
        """
        Sets the testing_dataset of this ModelSummary.

        :param testing_dataset: The testing_dataset of this ModelSummary.
        :type: oci.ai_vision.models.Dataset
        """
        self._testing_dataset = testing_dataset

    @property
    def validation_dataset(self):
        """
        Gets the validation_dataset of this ModelSummary.

        :return: The validation_dataset of this ModelSummary.
        :rtype: oci.ai_vision.models.Dataset
        """
        return self._validation_dataset

    @validation_dataset.setter
    def validation_dataset(self, validation_dataset):
        """
        Sets the validation_dataset of this ModelSummary.

        :param validation_dataset: The validation_dataset of this ModelSummary.
        :type: oci.ai_vision.models.Dataset
        """
        self._validation_dataset = validation_dataset

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ModelSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ModelSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ModelSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ModelSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ModelSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ModelSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ModelSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ModelSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ModelSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ModelSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ModelSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ModelSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
