/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>
#import "GRTTreeDataSource.h"
#import "MTableView.h"

namespace wb {
  class WBContextUI;
};

namespace mforms
{
  class View;
};

@class MCanvasViewer;
@class GRTTreeDataSource;
@class GRTListDataSource;


@interface WBModelSidebarController : NSObject<GRTDragDelegate, NSOutlineViewDelegate>
{
  IBOutlet NSTabViewItem *historyTab;
  IBOutlet NSTabViewItem *userTypesTab;

  IBOutlet NSOutlineView *catalogOutline;

  IBOutlet GRTTreeDataSource *catalogDS;
  
  IBOutlet NSTableView *propertiesTable;

  wb::WBContextUI *_wbui;
  mforms::View *_udtlist;
  mforms::View *_history;
}

- (IBAction)activateCatalogItem:(id)sender;

- (void)setupWithWBContextUI:(wb::WBContextUI*)wbui;
- (void)reuseShareableDataSourcesFrom:(WBModelSidebarController*)sidebar;

- (void)updateForSelectionChange;

- (void)refresh;
- (void)refreshCatalogTree;

- (void)invalidate;

// Access for backend callbacks.
- (NSOutlineView*) catalogOutline;
- (GRTTreeDataSource*) catalogDS;
@end
