/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

//This file contains definition of abstract class that is responsible
//for data management. Descendants of the class are used to hide
//any data source specific functionality


#ifndef _DATA_H_
#define _DATA_H_

struct _COLUMNDATA;
typedef _COLUMNDATA *PCOLUMNDATA;

class CData
{
public:
	//virtual destructor
	virtual ~CData() {};
	// Invalidate buffers
	virtual	HRESULT SetMoveInfo( HRESULT hr ) = 0;
	//@cmember Move relative
	virtual HRESULT MovePending(LONG lRows, BOOL bSaveCurrentPosition ) = 0;
	//@cmember Skip relative
	virtual HRESULT Skip(LONG lRows, BOOL bSaveCurrentPosition) 
		{ return MovePending( lRows, bSaveCurrentPosition ); }
	//@cmember Move relative
	virtual HRESULT GetFetchedData(LONG lRow, DWORD *pdwBmk) = 0;
	//@cmember Move to first row
	virtual HRESULT MoveFirst() = 0;
	//@cmember Move to last row
	virtual HRESULT MoveLast() = 0;
	//@cmember Move to specified bookmark
	virtual HRESULT MoveBookmark(ULONG* pulBookmark) = 0;

	//@cmember Find row from current position
	virtual HRESULT Find(ULONG icol, PCOLUMNDATA pDst/*void* pvValue*/,	DBCOMPAREOP	CompareOp, DBTYPE dbType, bool bForward) = 0;

	//@cmember Return the number of rows in the table	
	virtual HRESULT GetRowCnt(DWORD* pdwRows) = 0;
	//@cmember Get relative position (by percentage) of the row in table
	virtual HRESULT GetPercentage(ULONG* pulBookmark, double *pdfPPos) = 0;
	//@cmember Get bookmark for current row
	virtual HRESULT GetBookmark(ULONG *pulBookmark) = 0;
	//@cmember Retrieve number of columns
	virtual HRESULT GetColumnCnt(DWORD* pdwCount) = 0;
	//@cmember Retrieve column information
	virtual HRESULT GetColumnInfo(DWORD dwCol, DBCOLUMNINFO* pInfo) = 0;
	
	//@cmember Fetch row data
	virtual HRESULT GetRow(ULONG* ulOffset, BYTE* pbProvRow) = 0;

	//@cmember Update the current rows values
	virtual HRESULT UpdateRow(ULONG* pulBookmark, ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR	pAccessor, BYTE* pbProvRowOld) = 0;
	//@cmember Insert new row
	virtual HRESULT InsertRow(ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR pAccessor ) = 0;
	//@cmember Remove row with the bmk
	virtual HRESULT DeleteRow(ULONG* pulBookmark) = 0;
	//@cmember ULONGs in a bookmark
	virtual ULONG bookmarks(void) { return 1; }
};


#endif