/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#include "hfiles.h"
#include "headers.h"
#include "Errors.h"


void ClearError()
{
	SetErrorInfo(0, NULL);
}


HRESULT Error(HRESULT hrError, DWORD dwError, const char *pszText)
{
	HRESULT hr;
	IErrorInfo*		pErrorInfo = NULL;
	IErrorRecords*	pErrorRecords = NULL;

	//Check if there is error already
	GetErrorInfo(0, &pErrorInfo);
	if (pErrorInfo == NULL)
	{
		//Create error object 
		hr = CoCreateInstance
				(
				CLSID_EXTENDEDERRORINFO,
				NULL,
				CLSCTX_INPROC_SERVER,
				IID_IErrorInfo,
				(void**)&pErrorInfo
				);

		if (hr != S_OK)
			return hr;
	}

	//Query interface
	hr = pErrorInfo->QueryInterface
			(
			IID_IErrorRecords,
			(void**)&pErrorRecords
			);

	if (hr != S_OK)
		return hr;

	//Set up parameters
	VARIANTARG varg;
	VariantInit(&varg);
	DISPPARAMS dispparams = {&varg, NULL, 1, 0};

	varg.vt = VT_BSTR;
	varg.bstrVal = SysAllocString(L"Test message"/*pszText*/);

	//Add new record to error object
	ERRORINFO Info;
	Info.hrError	= hrError;
	Info.dwMinor	= dwError;
	Info.dispid		= 0;
	memcpy(&Info.clsid, &GUID_NULL, sizeof(GUID));
	memcpy(&Info.iid, &IID_ICommand, sizeof(GUID));

	hr = pErrorRecords->AddErrorRecord(&Info, dwError, &dispparams, NULL, 0);
	if (hr != S_OK)
		return hr;

	//Set error
	hr = SetErrorInfo(0, pErrorInfo);
	if (hr != S_OK)
		return hr;

	BSTR bstr = NULL;
	hr = pErrorInfo->GetDescription(&bstr);

	//Release all
	VariantClear(&varg);
	pErrorRecords->Release();
	pErrorInfo->Release();
	return hrError;
}


// Code ----------------------------------------------------------------------

// CError::CError --------------------------------------------------
//
// @mfunc Constructor for this class
//
// @rdesc NONE
//
CError::CError(void)
{
    CLEAR_CONSTRUCT( CError );
    
	// Increment global object count.
    OBJECT_CONSTRUCTED();
}


// CError::~CError -------------------------------------------------
//
// @mfunc Destructor for this class
//
// @rdesc NONE
//
CError:: ~CError(void)
{
    // Free contained interfaces
	delete m_pIErrorLookup;
    // Decrement global object count.
    OBJECT_DESTRUCTED();

    return;
}


// CError::QueryInterface -----------------------------------------------
//
// @mfunc Returns a pointer to a specified interface. Callers use
// QueryInterface to determine which interfaces the called object
// supports.
//
// @rdesc HRESULT indicating the status of the method
//      @flag S_OK          | Interface is supported and ppvObject is set.
//      @flag E_NOINTERFACE | Interface is not supported by the object
//      @flag E_INVALIDARG  | One or more arguments are invalid.
//
STDMETHODIMP CError::QueryInterface
    (
    REFIID riid,        //@parm IN | Interface ID of the interface being queried for.
    LPVOID * ppv        //@parm OUT | Pointer to interface that was instantiated
    )
{
    // Is the pointer bad?
    if (ppv == NULL)
        return E_INVALIDARG;

    //  Place NULL in *ppv in case of failure
    *ppv = NULL;

    //  This is the non-delegating IUnknown implementation
    if (riid == IID_IUnknown)
        *ppv = (LPVOID) this;
    else if (riid == IID_IErrorLookup)
        *ppv = (LPVOID) m_pIErrorLookup;

    if (*ppv == NULL)
		return E_NOINTERFACE;

    //  If we're going to return an interface, AddRef it first
    ((LPUNKNOWN) *ppv)->AddRef();
    return S_OK;
}

// CError::AddRef -------------------------------------------------------
//
// @mfunc Increments a persistence count for the object
//
// @rdesc Current reference count
//
STDMETHODIMP_( ULONG ) CError::AddRef
     (
     void
     )
{
    return ++m_cRef;
}


// CError::Release ------------------------------------------------------
//
// @mfunc Decrements a persistence count for the object and if
// persistence count is 0, the object destroys itself.
//
// @rdesc Current reference count
//
STDMETHODIMP_( ULONG ) CError::Release
     (
     void
     )
{
    if (!--m_cRef)
    {
        delete this;
        return 0;
    }

    return m_cRef;
}


STDMETHODIMP CImpIErrorLookup::GetErrorDescription 
				(
				HRESULT		hrError,
				DWORD       dwLookupID,
				DISPPARAMS* pdispparams,
				LCID        lcid,
				BSTR*       pbstrSource,
				BSTR*       pbstrDescription
				)
{
	INTERFACE_METHOD_START( "ErrorLookup::GetErrorDescription " );

	if (pbstrSource == NULL || pbstrDescription == NULL)
		return E_INVALIDARG;

	*pbstrSource = SysAllocString(L"OLEDB Provider");
	*pbstrDescription = SysAllocString(L"Test error description");

	return S_OK;

	INTERFACE_METHOD_END();
}


STDMETHODIMP CImpIErrorLookup::GetHelpInfo
				(
				HRESULT		hrError,
				DWORD		dwLookupID,
				LCID        lcid,
				BSTR*       pbstrHelpFile,
				DWORD*      pdwHelpContext
				)
{
	INTERFACE_METHOD_START( "IErrorLookup::GetHelpInfo" );

	if (pbstrHelpFile == NULL || pdwHelpContext == NULL)
		return E_INVALIDARG;

	*pbstrHelpFile = NULL;
	*pdwHelpContext = 0;

	return S_OK;

	INTERFACE_METHOD_END();
}

STDMETHODIMP CImpIErrorLookup::ReleaseErrors
				(
				const DWORD	dwDynamicErrorID
				)
{
	INTERFACE_METHOD_START( "IErrorLookup::ReleaseErrors" );

	return S_OK;
	
	INTERFACE_METHOD_END();
}