/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

///////////////////////////////////////////////
// CBufferHolder
///////////////////////////////////////////////

#include "hfiles.h"
#include "headers.h"
#include "bufhold.h"

CBufferHolder::CBufferHolder( int base ) 
{ 
	CLEAR_CONSTRUCT( CBufferHolder );
	if( base > 1024 )
		base = 1024;
	m_nMaxElemsBase = base;	// Base to enlarge
	m_holder = new CBuffer*[ m_nMaxElemsBase ];
	if( m_holder )
		m_nMaxElems		= m_nMaxElemsBase;	// Current size
}


CBufferHolder::~CBufferHolder() 
{
	if( m_holder )
	{
		//for( int i = 0; i < m_nMaxElems; i++ )
		for( int i = 0; i < m_uiFirstFree; i++ )
			if( m_holder[ i ] != NULL )
				delete m_holder[ i ]; 
		delete m_holder;
	}

	if( m_currentRow.m_pszBuf != NULL )
		delete m_currentRow.m_pszBuf;

	if( m_lastRow.m_pszBuf != NULL )
		delete m_lastRow.m_pszBuf;
}


// Get elem at position
HRESULT CBufferHolder::At(int i, CBuffer** ppElem ) 
{
	if( ppElem == NULL )
		return E_INVALIDARG;
	if( m_holder == NULL || i >= m_uiFirstFree )
	{
		*ppElem = NULL;
		return S_FALSE;;
	}
	else
	{
		*ppElem = m_holder[ i ];
		return ( *ppElem != NULL ) ? S_OK : S_FALSE;
	}
}


// Get maximum element number
HRESULT CBufferHolder::GetMaxNumber( int* puiMaxNumber )
{
	 if( puiMaxNumber == NULL )
		 return E_INVALIDARG;
	 *puiMaxNumber = m_uiFirstFree;
	 return S_OK;
}

// Get first free slot
HRESULT CBufferHolder::GetFreeSlotNumber( CBuffer** ppBuffer, int* pnSlot )
{
	// Check args
	if( pnSlot == NULL || ppBuffer == NULL )
		return E_INVALIDARG;

	// set up out parameters for the case if an error appear
	*ppBuffer = NULL;
	
	if( m_uiFirstFree >= m_nMaxElems )
	{
		CBuffer** holder = new CBuffer*[ m_nMaxElems + m_nMaxElemsBase ];
		if( holder == NULL )
			return E_OUTOFMEMORY;
		memcpy( holder, m_holder, m_nMaxElems * sizeof( CBuffer* ) );
		m_nMaxElems += m_nMaxElemsBase;
		delete m_holder;
		m_holder = holder;
	}

	m_holder[ m_uiFirstFree ] = new CBuffer;
	if( m_holder[ m_uiFirstFree ] == NULL )
		return E_OUTOFMEMORY;
	
	*ppBuffer = m_holder[ m_uiFirstFree ];
	*pnSlot = m_uiFirstFree;
	
	m_uiFirstFree++;

	return S_OK;
}
	

//Release slot
HRESULT CBufferHolder::ReleaseSlot(int slot) 
{
	CBuffer* pElem;
	if( At( slot, &pElem ) != S_OK )
		return E_FAIL;

	m_holder[ slot ] = NULL;

	return S_OK;
}