/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */


#ifdef SWSOFT_LIB

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include "libver.h"
#include <stdlib.h>
#include <stdio.h>
#include "mysql_version.h"

extern void my_init(void);

#define MYSQLD_LIBNAME "mysqld.dll"
#define SWSOFT_LIB_STRICT

static HINSTANCE g_hInst = NULL;
static HANDLE g_hEngineMainThread = NULL;
static HANDLE g_hInstances = NULL;

int mysql_applic_setport(int use_port)
{
	if( use_port > 0 )
	{	
		char buf[ 128 ];
		sprintf( buf, "MYSQL_TCP_PORT=%d", use_port ); // set / update
		return _putenv( buf );
	}
	else
		return _putenv( "MYSQL_TCP_PORT=" ); // just remove
}

int mysql_applic_getport()
{
	char* env = getenv( "MYSQL_TCP_PORT" ); // get
	return env ? atoi( env ) : 0;
}


int mysql_applic_addref_instance()
{
	const char* pszName = "MYSQL_TCP_PORT";
	BYTE* pContents;
	int iInstances = 0;
	BOOL bNew = FALSE;

	if( mysql_applic_getport() )
		return -1; // already run
		
	if( !g_hInstances )
	{
		g_hInstances = OpenFileMapping( FILE_MAP_ALL_ACCESS, FALSE, pszName ); // try to open
		if( !g_hInstances )
		{
			g_hInstances = CreateFileMapping( INVALID_HANDLE_VALUE, NULL, PAGE_READWRITE, 0, 2+sizeof(int), pszName ); // try to create otherwise
			bNew = TRUE;
			if( !g_hInstances )
				return -2;
		}
	}

	pContents = (BYTE *) MapViewOfFile( g_hInstances, FILE_MAP_ALL_ACCESS, 0, 0, 0 ); // map view
	if( !pContents )
		return -3;

	if( bNew )
		*(int*)pContents = 1; // reset if new
	else
		(*(int*)pContents)++; // update file

	iInstances = *(int*)pContents; // get number of instances run

	UnmapViewOfFile( pContents ); // unmap file

	return mysql_applic_setport( MYSQL_PORT + iInstances ); // set specific port
}

int mysql_applic_release_instance()
{
	BYTE* pContents;

	if( !g_hInstances )
		return -1;

	pContents = (BYTE *) MapViewOfFile( g_hInstances, FILE_MAP_ALL_ACCESS, 0, 0, 0 ); // map view
	if( !pContents )
		return -2;

	if( *(int*)pContents == mysql_applic_getport() ) // not for any!
		(*(int*)pContents)--; // update file

	UnmapViewOfFile( pContents ); // unmap file

	CloseHandle( g_hInstances );

	g_hInstances = NULL;

	mysql_applic_setport(0);

	return 0;
}


static DWORD WINAPI MySqlLibMainThreadFunc(LPVOID lpParameter)
{
	int (* mysql_server_librun)();
	
	mysql_server_librun = ( int (*)() ) GetProcAddress( g_hInst, "mysql_server_librun" );
	if( !mysql_server_librun )
	{
		DWORD err = GetLastError();
		return err;
	}

	return (* mysql_server_librun) ();
}

int mysql_server_init()
{
	DWORD dwDummy;

#ifdef SWSOFT_LIB_STRICT
	BOOL bAdded;
#endif

	if( g_hEngineMainThread )
		return 0; // already inited

#ifdef SWSOFT_LIB_STRICT
	bAdded = ! mysql_applic_addref_instance();
#endif

	if( !g_hInst )
		g_hInst = LoadLibrary( MYSQLD_LIBNAME );
	if( !g_hInst )
		goto err;

	g_hEngineMainThread = CreateThread(NULL, 0, MySqlLibMainThreadFunc, NULL, 0, &dwDummy );
	if( !g_hEngineMainThread )
		goto err;

	return 0;

err:
#ifdef SWSOFT_LIB_STRICT
	if( bAdded )
		mysql_applic_release_instance();
#endif

	my_init();

	return -1;
}

int mysql_server_end()
{
	char buf[64];
	HANDLE hEventShutdown;

	if( !GetEnvironmentVariable( "MySqlShutdown", buf, 63 ) )
		return -1;

	hEventShutdown = (HANDLE) atol( buf );

	if( !SetEvent(hEventShutdown) )
		return -2;

	WaitForSingleObject( g_hEngineMainThread, INFINITE );
	g_hEngineMainThread = NULL;

	if( g_hInst )
	{
		FreeLibrary( g_hInst );
		g_hInst = NULL;
	}

#ifdef SWSOFT_LIB_STRICT
	mysql_applic_release_instance();
#endif
	
	return 0;
}


#endif