/* Copyright (C) 2000 MySQL AB & MySQL Finland AB & TCX DataKonsult AB
   
   This file was taken from MySQL 3.23.11 sources and modified for
   use in Colibri.SQL by SWsoft. Changes are (C) 2000, 2001, SWsoft.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA */

/*
** TRANSACT.C - This is the ODBC sample driver code for
** processing transactions.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/


#include "myodbc.h"

//	SQLC transaction control functions.

SQLRETURN SQL_API SQLTransact(SQLHENV henv,SQLHDBC hdbc,SQLUSMALLINT fType)
{
#ifndef SWSOFT
  return SQL_SUCCESS;
#else

	int error = SQL_SUCCESS;
	DBC FAR * dbc = (DBC FAR*) hdbc;
	
	if( setupdlg_db_type() != SETUPDLG_BTRIEVE )
		return SQL_SUCCESS;

	if (fType!= SQL_COMMIT && fType!=SQL_ROLLBACK)
	{
		//DBUG_RETURN(set_dbc_error(hdbc,"S1012","Invalid transaction operation code",4000));
		return set_dbc_error(hdbc,"S1012","Invalid transaction operation code",4000);
	}
	switch (fType)
	{
	case SQL_COMMIT:
			error=mysql_transact_commit(&dbc->mysql);
			break;
	case SQL_ROLLBACK:
			error=mysql_transact_rollback(&dbc->mysql);
			break;

	}
	return error;
#endif
}
