/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"

// Code ----------------------------------------------------------------------


// IRowsetInfo specific methods

// CImpIRowsetInfo::GetReferencedRowset ----------------------------------------------------
//
// @mfunc Returns an interface pointer to the rowset to which the bookmark
// applies
//
// @rdesc HRESULT
//		@flag E_INVALIDARG		| ppReferencedRowset was NULL
//		@flag DB_E_BADORDINAL	| iOrdinal was greater than number of columns in rowset
//      @flag DB_E_NOTAREFERENCECOLUMN | This rowset does not support bookmarks
//
STDMETHODIMP CImpIRowsetInfo::GetReferencedRowset
    (
    ULONG		iOrdinal,			//@parm IN	| Bookmark Column
    REFIID		riid,				//@parm IN	| ID of the interface pointer to return
	IUnknown **	ppReferencedRowset	//@parm OUT | IRowset Interface Pointer
    )
{
	INTERFACE_METHOD_START("IRowsetInfo::GetReferencedRowset");

	HRESULT hr;

 	if( ppReferencedRowset )
		*ppReferencedRowset = NULL;

	// Check Arguments
	if( ppReferencedRowset == NULL )
		return E_INVALIDARG;

	// The oridinal was greater than the number of columns that we have.
	if (iOrdinal >= m_pObj->m_cCols)
		return DB_E_BADORDINAL;

	// if iOrdinal corresponds to Bookmark Column
	if (iOrdinal == 0)
	{
		hr = m_pObj->m_pUnkOuter->QueryInterface (riid,(void**)ppReferencedRowset);
		if FAILED(hr)
			return E_NOINTERFACE;
		else
			return S_OK;
	}
	else
		return DB_E_NOTAREFERENCECOLUMN;

	INTERFACE_METHOD_END();
}



// CImpIRowsetInfo::GetProperties ----------------------------------------------------
//
// @mfunc Returns current settings of all properties supported by the rowset
//
// @rdesc HRESULT
//      @flag S_OK          | The method succeeded
//      @flag E_INVALIDARG  | pcProperties or prgProperties was NULL
//      @flag E_OUTOFMEMORY | Out of memory
//
STDMETHODIMP CImpIRowsetInfo::GetProperties
    (
    const ULONG         cPropertySets,		//@parm IN | # of property sets
    const DBPROPIDSET	rgPropertySets[],	//@parm IN | Array of DBPROPIDSET
    ULONG*              pcProperties,		//@parm OUT | count of properties returned
    DBPROPSET**			prgProperties		//@parm OUT | property information returned
    )
{
	INTERFACE_METHOD_START("IRowsetInfo::GetProperties");

	assert( m_pObj );
    assert( m_pObj->m_pUtilProp );

	// Check Arguments
	HRESULT hr = m_pObj->m_pUtilProp->GetPropertiesArgChk(PROPSET_ROWSET, cPropertySets, 
								rgPropertySets, pcProperties, prgProperties);
	if ( FAILED(hr) )
		return hr;

    // just pass this call on to the utility object that manages our properties
    return m_pObj->m_pUtilProp->GetProperties( PROPSET_ROWSET, cPropertySets, rgPropertySets,
                pcProperties, prgProperties );

	INTERFACE_METHOD_END();
}



// CImpIRowsetInfo::GetSpecification ---------------------------------------
//
// @mfunc Returns the interface pointer of the object that created the rowset
//
// @rdesc HRESULT
//      @flag S_OK          | Method Succeeded
//      @flag E_INVALIDARG  | Invalid parameters were specified
//
STDMETHODIMP CImpIRowsetInfo::GetSpecification
    (
    REFIID   riid,              //@parm IN | Interface ID of the interface being queried for.
    IUnknown **ppSpecification  //@parm OUT | Pointer to interface that instantiated this object
    )
{
	INTERFACE_METHOD_START("IRowsetInfo::GetSpecification");

	HRESULT hr=S_FALSE;

    if (NULL == ppSpecification)
        return E_INVALIDARG;

    // we do not have an interface pointer on the object that created this rowset, yet.
    *ppSpecification = NULL;

	if (m_pObj->m_pCreator)
		hr = m_pObj->m_pCreator->QueryInterface (riid,(void**)ppSpecification);

	return hr;

	INTERFACE_METHOD_END();
}


