$NetBSD: patch-printing_backend_cups__helper.cc,v 1.10 2026/01/19 16:14:17 kikadf Exp $

* Part of patchset to build chromium on NetBSD
* Based on OpenBSD's chromium patches, and
  pkgsrc's qt5-qtwebengine patches

--- printing/backend/cups_helper.cc.orig	2026-01-07 00:50:30.000000000 +0000
+++ printing/backend/cups_helper.cc
@@ -8,7 +8,7 @@
 #include "base/time/time.h"
 #include "build/build_config.h"
 
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
 #include <cups/ppd.h>
 #include <stddef.h>
 #include <stdio.h>
@@ -38,11 +38,11 @@
 #include "url/gurl.h"
 #endif  // BUILDFLAG(IS_LINUX)
 
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
 #include "printing/backend/cups_weak_functions.h"
 #endif
 
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
 using base::EqualsCaseInsensitiveASCII;
 #endif  // BUILDFLAG(IS_LINUX)
 
@@ -55,7 +55,7 @@ namespace {
 // able to start and respond on all systems within this duration.
 constexpr base::TimeDelta kCupsTimeout = base::Seconds(5);
 
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
 // CUPS default max copies value (parsed from kCupsMaxCopies PPD attribute).
 constexpr int32_t kDefaultMaxCopies = 9999;
 constexpr char kCupsMaxCopies[] = "cupsMaxCopies";
@@ -761,7 +761,7 @@ const int kDefaultIPPServerPort = 631;
 
 }  // namespace
 
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
 // Helper wrapper around http_t structure, with connection and cleanup
 // functionality.
 HttpConnectionCUPS::HttpConnectionCUPS(const GURL& print_server_url,
@@ -966,7 +966,7 @@ ScopedHttpPtr HttpConnect2(const char* h
                            int blocking,
                            int msec,
                            int* cancel) {
-#if BUILDFLAG(IS_LINUX)
+#if BUILDFLAG(IS_LINUX) || BUILDFLAG(IS_BSD)
   ScopedHttpPtr http;
   if (httpConnect2) {
     http.reset(httpConnect2(host, port,
