untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEuw6NAI/fUirbbPUt3WKyoNeyz/Iz9dvDK+fzK1k7X4XeS44XTJ4+LsNRZu/XrYl0GbqT90DbTCdcRn+f0egSQU=

OpenBSD 6.1 errata 001, May 2, 2017:

dhcpd(8) unconditionally echoed client identifier. Add parameter
"echo-client-id" to allow this behaviour to be turned off.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 001_dhcpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install dhcpd:
    cd /usr/src/usr.sbin/dhcpd
    make obj
    make
    make install

Index: usr.sbin/dhcpd/conflex.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/conflex.c,v
retrieving revision 1.18
diff -u -p -r1.18 conflex.c
--- usr.sbin/dhcpd/conflex.c	12 Apr 2017 19:12:01 -0000	1.18
+++ usr.sbin/dhcpd/conflex.c	20 Apr 2017 14:00:17 -0000
@@ -311,6 +311,7 @@ static const struct keywords {
 	{ "dynamic-bootp",		TOK_DYNAMIC_BOOTP },
 	{ "dynamic-bootp-lease-cutoff",	TOK_DYNAMIC_BOOTP_LEASE_CUTOFF },
 	{ "dynamic-bootp-lease-length",	TOK_DYNAMIC_BOOTP_LEASE_LENGTH },
+	{ "echo-client-id",		TOK_ECHO_CLIENT_ID },
 	{ "ends",			TOK_ENDS },
 	{ "ethernet",			TOK_ETHERNET },
 	{ "filename",			TOK_FILENAME },
Index: usr.sbin/dhcpd/confpars.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/confpars.c,v
retrieving revision 1.32
diff -u -p -r1.32 confpars.c
--- usr.sbin/dhcpd/confpars.c	12 Apr 2017 19:12:01 -0000	1.32
+++ usr.sbin/dhcpd/confpars.c	20 Apr 2017 13:42:11 -0000
@@ -82,6 +82,7 @@ readconf(void)
 	root_group.allow_bootp = 1;
 	root_group.allow_booting = 1;
 	root_group.authoritative = 1;
+	root_group.echo_client_id = 1;
 
 	if ((cfile = fopen(path_dhcpd_conf, "r")) == NULL)
 		fatal("Can't open %s", path_dhcpd_conf);
@@ -317,6 +318,10 @@ parse_statement(FILE *cfile, struct grou
 
 	case TOK_ALWAYS_REPLY_RFC1048:
 		group->always_reply_rfc1048 = parse_boolean(cfile);
+		break;
+
+	case TOK_ECHO_CLIENT_ID:
+		group->echo_client_id = parse_boolean(cfile);
 		break;
 
 	case TOK_USE_HOST_DECL_NAMES:
Index: usr.sbin/dhcpd/dhcp.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/dhcp.c,v
retrieving revision 1.55
diff -u -p -r1.55 dhcp.c
--- usr.sbin/dhcpd/dhcp.c	13 Feb 2017 23:04:05 -0000	1.55
+++ usr.sbin/dhcpd/dhcp.c	20 Apr 2017 14:21:20 -0000
@@ -708,7 +708,7 @@ ack_lease(struct packet *packet, struct 
 	struct lease_state *state;
 	time_t lease_time, offered_lease_time, max_lease_time, default_lease_time;
 	struct class *vendor_class, *user_class;
-	int ulafdr, i;
+	int ulafdr, echo_client_id, i;
 
 	/* If we're already acking this lease, don't do it again. */
 	if (lease->state) {
@@ -1239,8 +1239,16 @@ ack_lease(struct packet *packet, struct 
 	memset(&state->options[i], 0, sizeof(state->options[i]));
 
 	/* Echo back the client-identifier as RFC 6842 mandates. */
+	if (lease->host)
+		echo_client_id = lease->host->group->echo_client_id;
+	else if (user_class)
+		echo_client_id = user_class->group->echo_client_id;
+	else if (vendor_class)
+		echo_client_id = vendor_class->group->echo_client_id;
+	else
+		echo_client_id = lease->subnet->group->echo_client_id;
 	i = DHO_DHCP_CLIENT_IDENTIFIER;
-	if (lease->client_identifier) {
+	if (lease->client_identifier && echo_client_id) {
 		state->options[i] = new_tree_cache("dhcp-client-identifier");
 		state->options[i]->flags = TC_TEMPORARY;
 		state->options[i]->value = lease->client_identifier;
Index: usr.sbin/dhcpd/dhcpd.conf.5
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/dhcpd.conf.5,v
retrieving revision 1.18
diff -u -p -r1.18 dhcpd.conf.5
--- usr.sbin/dhcpd/dhcpd.conf.5	4 Feb 2017 22:21:57 -0000	1.18
+++ usr.sbin/dhcpd/dhcpd.conf.5	20 Apr 2017 14:36:38 -0000
@@ -919,6 +919,23 @@ Supplying a value for the
 option is equivalent to using the
 .Ic server-identifier
 statement.
+.Pp
+The
+.Ic echo-client-id
+statement
+.Pp
+.D1 Ic echo-client-id Ar flag ;
+.Pp
+is used to enable or disable RFC 6842 compliant behavior.
+If the
+.Ic echo-client-id
+statement is present and has a
+value of true or on, and a DHCP DISCOVER or REQUEST is received which contains
+the client identifier option (Option code 61), the server will copy the option
+into its response (DHCP ACK or NAK) per RFC 6842.
+In other words if the client sends the option it will receive it back.
+By default, this flag is on
+and client identifiers will be echoed back to the client.
 .Sh REFERENCE: OPTION STATEMENTS
 DHCP option statements are documented in the
 .Xr dhcp-options 5
Index: usr.sbin/dhcpd/dhcpd.h
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/dhcpd.h,v
retrieving revision 1.63
diff -u -p -r1.63 dhcpd.h
--- usr.sbin/dhcpd/dhcpd.h	18 Apr 2017 13:59:09 -0000	1.63
+++ usr.sbin/dhcpd/dhcpd.h	20 Apr 2017 13:26:31 -0000
@@ -223,6 +223,7 @@ struct group {
 	int use_lease_addr_for_default_route;
 	int authoritative;
 	int always_reply_rfc1048;
+	int echo_client_id;
 
 	struct tree_cache *options[256];
 };
Index: usr.sbin/dhcpd/dhctoken.h
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/dhctoken.h,v
retrieving revision 1.7
diff -u -p -r1.7 dhctoken.h
--- usr.sbin/dhcpd/dhctoken.h	5 Dec 2013 22:31:35 -0000	1.7
+++ usr.sbin/dhcpd/dhctoken.h	20 Apr 2017 13:25:43 -0000
@@ -91,6 +91,7 @@
 #define TOK_TOKEN_NOT			334
 #define TOK_ALWAYS_REPLY_RFC1048	335
 #define TOK_IPSEC_TUNNEL		336
+#define TOK_ECHO_CLIENT_ID		337
 
 #define is_identifier(x)	((x) >= TOK_FIRST_TOKEN &&	\
 				 (x) != TOK_STRING &&	\
