#!/bin/bash

patch_mk()
{
   echo -n "  checking file '$1'..."

   # remove the temporary file if it exists
   if [ -f $1.stub ]; then
      rm $1.stub
   fi

   # if the file to be patched exists...
   if [ -f $1 ]; then
      # create a new temporary file with the changes
      sed -e '/^LDFLAGS=.*-L$(LIBHOME)\/stubs\//n' -e '/^LDFLAGS=/s/-L$(LIBHOME)[[:space:]]\?/-L$(LIBHOME) -L$(LIBHOME)\/stubs\/ /' -e '/^[[:blank:]]$(CC).*-L$(LIBHOME)\/stubs\//n' -e '/^[[:blank:]]$(CC)/s/-L$(LIBHOME)[[:space:]]\+/-L$(LIBHOME) -L$(LIBHOME)\/stubs\/ /' -e '/^LDFLAGS=.*$(LDPATHFLAG)$(LIBHOME)\/stubs\//n' -e '/^LDFLAGS=/s/$(LDPATHFLAG)$(LIBHOME)[[:space:]]\?/$(LDPATHFLAG)$(LIBHOME) $(LDPATHFLAG)$(LIBHOME)\/stubs\/ /' -e '/^[[:blank:]]$(CC).*$(LDPATHFLAG)$(LIBHOME)\/stubs\//n' -e '/^[[:blank:]]$(CC)/s/$(LDPATHFLAG)$(LIBHOME)[[:space:]]\+/$(LDPATHFLAG)$(LIBHOME) $(LDPATHFLAG)$(LIBHOME)\/stubs\/ /' $1 > $1.stub

      # if the sed command actually changed some lines...
      if ! diff -q $1 $1.stub 2>&1 >/dev/null; then
         mv $1 $1.nostub
         mv $1.stub $1
         echo -n "patched."
      else
         rm $1.stub
         echo -n "OK."
      fi
   fi
   echo
}

OH=$ORACLE_HOME
RELINK=$OH/bin/relink

if [ -z $OH ]; then
   echo "ERROR:  ORACLE_HOME is not set in the environment!"
   exit -1
elif [ ! -d $OH ]; then
   echo "ERROR:  ORACLE_HOME is set to an invalid directory!"
   exit -1
fi

if [ ! -f $RELINK ]; then
   echo "ERROR:  $ORACLE_HOME/bin/relink not found."
   exit -1
fi

cd $OH

echo -n "Setting up patch files..."
if [ ! -f lib/stubs/libc.so.tmp ]; then
   echo "ERROR:  $ORACLE_HOME/lib/stubs/libc.so.tmp not found."
   echo "        Make sure the stub library patch was extracted properly."
   exit -1
fi
sed -e "s%__OH__%$ORACLE_HOME%g" lib/stubs/libc.so.tmp > lib/stubs/libc.so

cp -p bin/genclntsh bin/genclntsh.stub
sed -e '/^LD=.*-L${ORACLE_HOME}\/lib\/stubs\//n' -e '/^LD=/s/-L${ORACLE_HOME}\/lib[[:space:]]\?/-L${ORACLE_HOME}\/lib -L${ORACLE_HOME}\/lib\/stubs\/ /' -e '/^LD=.*$(LDPATHFLAG)${ORACLE_HOME}\/lib\/stubs\//n' -e '/^LD=/s/$(LDPATHFLAG)${ORACLE_HOME}\/lib[[:space:]]\?/$(LDPATHFLAG)${ORACLE_HOME}\/lib $(LDPATHFLAG)${ORACLE_HOME}\/lib\/stubs\/ /' bin/genclntsh > bin/genclntsh.stub
if ! diff -q bin/genclntsh bin/genclntsh.stub 2>&1 >/dev/null; then
   mv bin/genclntsh bin/genclntsh.nostub
   mv bin/genclntsh.stub bin/genclntsh
else
   rm bin/genclntsh.stub
fi
echo "done."

echo "Patching makefiles as necessary:"
prodlist=`find $OH -name "*.mk"`
for file in $prodlist; do
   patch_mk $file
done

echo -n "Rebuilding client shared library..."
$OH/bin/genclntsh >/dev/null
echo "done."

echo "Relinking executables:"
for mkfile in `find $OH -name "ins_*.mk"`; do
   dir=`dirname $mkfile`
   file=`basename $mkfile`
   pushd $dir >/dev/null
   echo -n "  running '$file'..."
   if [ $file != "ins_precomp.mk" ]; then
      make -i -f $file install >/dev/null 2>&1
   else
      make -i -f $file relink >/dev/null 2>&1
   fi
   echo "done."
   popd >/dev/null
done 
