#!/usr/local/bin/perl
#
# cafdOracle 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdOracle;
 
@ISA = (refDBI);
use strict;

use DBI;

sub NewConnection {
	my $class = shift;
	$class = ref($class) || $class;
	my $db = shift;

	my $dbh;

	my $dbdsn = $db->{dbidsn};

	unless ($dbdsn) {
		$dbdsn = "dbi:Oracle:" . $db->{connector}{externalname};
#		if ($db->{server}) {
#			$dbdsn .= ";host=" . $db->{server}{host_name} if ($db->{server}{host_name});
#			$dbdsn .= ";host=" . $db->{server}{host_address} unless ($db->{server}{host_name});
#		}
#		$dbdsn .= ";port=" . $db->{connector}{port} if ($db->{connector}{port});
	}

#	DBI->trace(2, "/tmp/cafeterra.dbi");

#	DBI->trace(5, "/tmp/cafdbi.trc");

#	print "cafdOracle $dbdsn using $db->{user}{username}, $db->{user}{password} \n";
	if (($db->{_ATTRS}{ORACLE_HOME}) && (-d $db->{_ATTRS}{ORACLE_HOME})) { $ENV{ORACLE_HOME} = $db->{_ATTRS}{ORACLE_HOME}; }
        my $drvAttrs = { AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} };
	eval {
		$dbh = DBI->connect($dbdsn, $db->{user}{username}, $db->{user}{password}, $drvAttrs); #$db->{_ATTRS});
	};

	die "cafOracle->connect : $@ " . DBI->errstr if ($@ || (! $dbh));

	$db->{dbidsn} = $dbdsn;
	my $self = { dbh => $dbh, db => $db, };

	bless $self, $class;
}

#sub connect { new(@_); }

sub describe {
	my $self = shift;
	my $tablename = shift;
	my $owner = shift;
	my $type = shift;

	my $query = cafQry->new();
	$query->query("SELECT col.COLUMN_NAME, col.DATA_TYPE,
			decode(col.data_precision, null, col.data_length, col.data_precision) COLUMN_SIZE,
			col.data_scale DECIMAL_DIGITS, col.column_id ORDINAL_POSITION, 
			decode(col.nullable, 'Y', 'yes', 'no') IS_NULLABLE, col.data_default COLUMN_DEF, com.comments REMARKS
			FROM all_tab_columns col, all_col_comments com
			WHERE col.table_name = upper(?)
			AND   col.owner = upper(?)
			AND   col.table_name = com.table_name   (+)
			AND   col.column_name = com.column_name (+)
			AND   col.owner = com.owner             (+)
			ORDER BY col.column_id");
	$query->bindvars([$tablename, $owner]);
	my $rows = $self->hexecfetchall($query);

	$query = cafQry->new();
	$query->query("SELECT
			1 PK, a.constraint_name index_name, a.column_name column_name, a.position column_position
			FROM  all_cons_columns a,  all_constraints  b
			WHERE a.constraint_name=b.constraint_name
				AND a.table_name=b.table_name
				AND b.constraint_type='P'
				AND a.table_name = upper(?)
				AND a.owner = upper(?)
				AND b.owner = upper(?)
				UNION
				SELECT
				0 PK, a.index_name, b.column_name column_name, b.column_position column_position
				FROM all_indexes a, all_ind_columns b
				WHERE a.table_name=b.table_name
				AND a.index_name=b.index_name
				AND a.uniqueness='UNIQUE'
				AND a.table_name = upper(?)
				AND a.owner = upper(?)
				and b.index_owner = upper(?)
				ORDER BY PK, index_name, column_position");

	$query->bindvars([$tablename, $owner, $owner, $tablename, $owner, $owner ]);
	my $pkrows = $self->hexecfetchall($query);

	my $i = -1;
	my @ret;
	my $index = "";
	foreach my $row (@$rows) {
		$ret[++$i] = {
			externalname => $row->{COLUMN_NAME},
			name         => $row->{COLUMN_NAME},
			datatypeid   => $row->{DATA_TYPE},
			datalength   => $row->{COLUMN_SIZE},
			datascale    => $row->{DECIMAL_DIGITS},
			fieldorder   => $row->{ORDINAL_POSITION} * 10,
			nullable     => $row->{IS_NULLABLE},
			defaultvalue => $row->{COLUMN_DEF},
			Remarks      => $row->{REMARKS},
		};
		foreach my $pk (@$pkrows) {
			$index = $pk->{index_name} if (! $index);
			last if ($pk->{index_name} ne $index);
			if ($pk->{column_name}, $ret[$i]->{column_name}) {
				$ret[$i]->{keyposition} = $ret[$i]->{column_position}; last;
			}
		}
	}
	return \@ret;
}

sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}" unless ($col->{datatypeid} eq "SQL_TIMESTAMP");
	$col->{dataformat} = "YYYY/MM/DD HH24:MI:SS" unless ($col->{dataformat});

	return ("decode(:c_$col->{name}, NULL, NULL , '', NULL, to_date(:c_$col->{name}, '$col->{dataformat}'))");
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{externalname} unless ($col->{datatypeid} eq "SQL_TIMESTAMP");
	$col->{dataformat} = "YYYY/MM/DD HH24:MI:SS" unless ($col->{dataformat});

	return ("decode($col->{externalname}, NULL, NULL, to_char($col->{externalname}, '$col->{dataformat}'))");
}

sub __generateselect {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#select statement generated by $class\n\nSELECT ";
	my $sep = "";
	my $where = "";
	my $chunk;
	my $wsep = "WHERE ";
	my $qlen = 0;
	my $wlen = 0;

#	print "<BR> select from ", ref($self) || $self;
	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep" . $self->generatedatetochar($col) . " \@$col->{name}";
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\tfrom $container->{externalname}\n\t$where";
}

1;
